/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.widgets;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import java.awt.Color;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.runelite.api.Client;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotActivityTimer {
    private static final Logger log = LoggerFactory.getLogger(SlotActivityTimer.class);
    private static final String BUY_SPACER = "          ";
    private static final String SELL_SPACER = "          ";
    private static final int FONT_ID = 495;
    private transient Widget slotWidget;
    private transient Widget slotStateWidget;
    private transient String slotStateString;
    private transient FlippingPlugin plugin;
    private transient Client client;
    private int slotIndex;
    private Instant lastUpdate;
    public Instant tradeStartTime;
    public OfferEvent currentOffer;
    public boolean offerOccurredAtUnknownTime;

    public SlotActivityTimer(FlippingPlugin plugin, Client client, int slotIndex) {
        this.plugin = plugin;
        this.client = client;
        this.slotIndex = slotIndex;
    }

    public void setWidget(Widget slotWidget) {
        this.slotWidget = slotWidget;
        this.slotStateWidget = slotWidget.getChild(16);
        this.slotStateString = this.slotStateWidget.getText();
    }

    public void reset() {
        this.currentOffer = null;
        this.lastUpdate = null;
        this.tradeStartTime = null;
        this.offerOccurredAtUnknownTime = true;
    }

    public void setCurrentOffer(OfferEvent offer) {
        if (offer.isBeforeLogin()) {
            this.offerOccurredAtUnknownTime = true;
            return;
        }
        this.offerOccurredAtUnknownTime = false;
        this.currentOffer = offer;
        this.lastUpdate = Instant.now();
        if (this.currentOffer.isStartOfOffer()) {
            this.tradeStartTime = Instant.now();
        }
    }

    public void updateTimerDisplay() {
        if (this.slotWidget == null) {
            return;
        }
        if (this.slotWidget.isHidden() || this.plugin.getCurrentlyLoggedInAccount() == null || this.currentOffer == null || this.offerOccurredAtUnknownTime || this.tradeStartTime == null) {
            this.slotStateWidget.setFontId(496);
            this.slotStateWidget.setXTextAlignment(1);
            return;
        }
        Widget offerSlot = this.client.getWidget(465, 5).getStaticChildren()[this.slotIndex + 1];
        if (offerSlot == null) {
            return;
        }
        this.slotWidget = offerSlot;
        this.slotStateWidget = this.slotWidget.getChild(16);
        this.slotStateString = this.slotStateWidget.getText();
        if (!this.isSlotFilled()) {
            this.slotStateWidget.setText("Empty");
            this.slotStateWidget.setFontId(496);
            this.slotStateWidget.setXTextAlignment(1);
            return;
        }
        this.setText(this.createFormattedTimeString());
        this.slotStateWidget.setFontId(495);
        this.slotStateWidget.setXTextAlignment(0);
    }

    private void setText(String timeString) {
        Color timeColor;
        Color stateTextColor;
        String spacer;
        GrandExchangeOffer[] offers = this.client.getGrandExchangeOffers();
        GrandExchangeOffer clientOffer = offers[this.slotIndex];
        if (clientOffer.getState() == GrandExchangeOfferState.BOUGHT || clientOffer.getState() == GrandExchangeOfferState.BUYING || clientOffer.getState() == GrandExchangeOfferState.CANCELLED_BUY) {
            this.slotStateString = "Buy";
            spacer = "          ";
            stateTextColor = this.plugin.getConfig().slotTimerBuyColor();
        } else {
            this.slotStateString = "Sell";
            spacer = "          ";
            stateTextColor = this.plugin.getConfig().slotTimerSellColor();
        }
        Color color = timeColor = this.isSlotStagnant() ? CustomColors.OUTDATED_COLOR : Color.WHITE;
        if (clientOffer.getState() == GrandExchangeOfferState.CANCELLED_BUY || clientOffer.getState() == GrandExchangeOfferState.CANCELLED_SELL || clientOffer.getState() == GrandExchangeOfferState.BOUGHT || clientOffer.getState() == GrandExchangeOfferState.SOLD) {
            timeColor = new Color(0, 180, 0);
        }
        if (timeString.length() > 9) {
            timeString = "   --:--:--";
        }
        this.slotStateWidget.setText("  <html>" + ColorUtil.wrapWithColorTag((String)this.slotStateString, (Color)stateTextColor) + spacer + ColorUtil.wrapWithColorTag((String)timeString, (Color)timeColor) + "</html>");
    }

    public void resetToDefault() {
        try {
            if (!this.isSlotFilled()) {
                this.slotStateWidget.setText("Empty");
            } else if (this.currentOffer.isBuy()) {
                this.slotStateWidget.setText("Buy");
            } else if (!this.currentOffer.isBuy()) {
                this.slotStateWidget.setText("Sell");
            }
            this.slotStateWidget.setFontId(496);
            this.slotStateWidget.setXTextAlignment(1);
        }
        catch (NullPointerException e) {
            log.info("npe when resetting slot visuals. This is ok");
        }
    }

    private boolean isSlotFilled() {
        GrandExchangeOffer[] offers = this.client.getGrandExchangeOffers();
        return offers[this.slotIndex].getItemId() != 0;
    }

    private boolean isSlotStagnant() {
        return this.lastUpdate.isBefore(Instant.now().minus(this.plugin.getConfig().tradeStagnationTime(), ChronoUnit.MINUTES));
    }

    public String createFormattedTimeString() {
        if (this.currentOffer == null || this.tradeStartTime == null || this.lastUpdate == null || this.offerOccurredAtUnknownTime) {
            return null;
        }
        if (this.currentOffer.isComplete()) {
            return TimeFormatters.formatDuration(this.tradeStartTime, this.lastUpdate);
        }
        return TimeFormatters.formatDuration(this.lastUpdate, Instant.now());
    }

    public Widget getSlotWidget() {
        return this.slotWidget;
    }

    public void setPlugin(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

