/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.widgets;

import com.flippingutilities.ui.uiutilities.Icons;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public class OfferEditor {
    private final Client client;
    private Widget bottomText;
    private Widget nonWikiText;
    private Widget wikiText;

    public OfferEditor(Widget parent, Client client) {
        this.client = client;
        if (parent == null) {
            return;
        }
        this.bottomText = parent.createChild(-1, 4);
        this.nonWikiText = parent.createChild(-1, 4);
        this.wikiText = parent.createChild(-1, 4);
        this.prepareTextWidget(this.nonWikiText, 0, 0, 5, 10);
        this.prepareTextWidget(this.wikiText, 0, 0, 20, 10);
        this.prepareTextWidget(this.bottomText, 1, 2, 5, 0);
    }

    private void prepareTextWidget(Widget widget, int xAlignment, int yMode, int yOffset, int xOffset) {
        widget.setTextColor(0x800000);
        widget.setFontId(1443);
        widget.setYPositionMode(yMode);
        widget.setOriginalX(xOffset);
        widget.setOriginalY(yOffset);
        widget.setOriginalHeight(20);
        widget.setXTextAlignment(xAlignment);
        widget.setWidthMode(1);
        widget.setHasListener(true);
        widget.setOnMouseRepeatListener(new Object[]{ev -> widget.setTextColor(0xFFFFFF)});
        widget.setOnMouseLeaveListener(new Object[]{ev -> widget.setTextColor(0x800000)});
        widget.revalidate();
    }

    public void showQuantityWidgets(int quantity) {
        this.bottomText.setText("OR click this to use the price editor hotkeys for more flexibility!");
        this.bottomText.setAction(1, "pic");
        this.bottomText.setOnOpListener(new Object[]{ev -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, Icons.QUANTITY_EDITOR_PIC))});
        this.nonWikiText.setText("set to remaining GE limit: " + quantity);
        this.nonWikiText.setAction(1, "Set quantity");
        this.nonWikiText.setOnOpListener(new Object[]{ev -> {
            this.client.getWidget(0xA2002A).setText(quantity + "*");
            this.client.setVarcStrValue(359, String.valueOf(quantity));
        }});
    }

    public void showInstaSellPrices(int instaSellPrice, int wikiInstaSellPrice) {
        this.bottomText.setText("OR click this to use the price editor hotkeys for more flexibility!");
        this.bottomText.setAction(1, "pic");
        this.bottomText.setOnOpListener(new Object[]{ev -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, Icons.PRICE_EDITOR_PIC))});
        if (instaSellPrice != 0) {
            this.nonWikiText.setText("set to your insta sell: " + String.format("%,d", instaSellPrice) + " gp");
            this.nonWikiText.setAction(0, "Set price");
            this.nonWikiText.setOnOpListener(new Object[]{ev -> {
                this.client.getWidget(0xA2002A).setText(instaSellPrice + "*");
                this.client.setVarcStrValue(359, String.valueOf(instaSellPrice));
            }});
        } else {
            this.nonWikiText.setText("no sell tracked");
        }
        if (wikiInstaSellPrice != 0) {
            this.wikiText.setText("set to wiki insta sell: " + String.format("%,d", wikiInstaSellPrice) + " gp");
            this.wikiText.setAction(1, "Set wiki price");
            this.wikiText.setOnOpListener(new Object[]{ev -> {
                this.client.getWidget(0xA2002A).setText(wikiInstaSellPrice + "*");
                this.client.setVarcStrValue(359, String.valueOf(wikiInstaSellPrice));
            }});
        } else {
            this.wikiText.setText("No wiki data");
        }
    }

    public void showInstaBuyPrices(int instaBuyPrice, int wikiInstaBuyPrice) {
        this.bottomText.setText("OR click this to use the price editor hotkeys for more flexibility!");
        this.bottomText.setAction(1, "pic");
        this.bottomText.setOnOpListener(new Object[]{ev -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, Icons.PRICE_EDITOR_PIC))});
        if (instaBuyPrice != 0) {
            this.nonWikiText.setText("set to your insta buy: " + String.format("%,d", instaBuyPrice) + " gp");
            this.nonWikiText.setAction(0, "Set price");
            this.nonWikiText.setOnOpListener(new Object[]{ev -> {
                this.client.getWidget(0xA2002A).setText(instaBuyPrice + "*");
                this.client.setVarcStrValue(359, String.valueOf(instaBuyPrice));
            }});
        } else {
            this.nonWikiText.setText("no buy tracked");
        }
        if (wikiInstaBuyPrice != 0) {
            this.wikiText.setText("set to wiki insta buy: " + String.format("%,d", wikiInstaBuyPrice) + " gp");
            this.wikiText.setAction(1, "Set wiki price");
            this.wikiText.setOnOpListener(new Object[]{ev -> {
                this.client.getWidget(0xA2002A).setText(wikiInstaBuyPrice + "*");
                this.client.setVarcStrValue(359, String.valueOf(wikiInstaBuyPrice));
            }});
        } else {
            this.wikiText.setText("No wiki data");
        }
    }
}

