/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.uiutilities;

import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIUtilities {
    private static final Logger log = LoggerFactory.getLogger(UIUtilities.class);
    private static final NumberFormat PRECISE_DECIMAL_FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final NumberFormat DECIMAL_FORMATTER = new DecimalFormat("#,###.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public static Color gradiatePercentage(float percentage, int gradientMax) {
        if ((double)percentage < (double)gradientMax * 0.5) {
            return percentage <= 0.0f ? CustomColors.TOMATO : ColorUtil.colorLerp((Color)CustomColors.TOMATO, (Color)ColorScheme.GRAND_EXCHANGE_ALCH, (double)(percentage / (float)gradientMax * 2.0f));
        }
        return percentage >= (float)gradientMax ? ColorScheme.GRAND_EXCHANGE_PRICE : ColorUtil.colorLerp((Color)ColorScheme.GRAND_EXCHANGE_ALCH, (Color)ColorScheme.GRAND_EXCHANGE_PRICE, (double)((double)(percentage / (float)gradientMax) * 0.5));
    }

    public static synchronized String quantityToRSDecimalStack(long quantity, boolean precise) {
        if (Long.toString(quantity).length() <= 4) {
            return QuantityFormatter.formatNumber((long)quantity);
        }
        long power = (long)Math.log10(quantity);
        NumberFormat format = precise && power >= 6L ? PRECISE_DECIMAL_FORMATTER : DECIMAL_FORMATTER;
        return format.format((double)quantity / Math.pow(10.0, Long.divideUnsigned(power, 3L) * 3L)) + (new String[]{"", "K", "M", "B", "T"})[(int)(power / 3L)];
    }

    public static JDialog createModalFromPanel(Component parent, JComponent panel) {
        JDialog modal = new JDialog();
        modal.add(panel);
        modal.setLocationRelativeTo(parent);
        return modal;
    }

    public static JPanel stackPanelsVertically(List<JPanel> panels, int gap) {
        JPanel mainPanel = new JPanel();
        UIUtilities.stackPanelsVertically(panels, mainPanel, gap);
        return mainPanel;
    }

    public static void stackPanelsVertically(List<JPanel> panels, JPanel mainPanel, int vGap) {
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        int index = 0;
        for (JPanel panel : panels) {
            if (index == 0) {
                mainPanel.add(panel);
                ++index;
                continue;
            }
            mainPanel.add(Box.createVerticalStrut(vGap));
            mainPanel.add(panel);
        }
    }

    public static String colorText(String s, Color color) {
        return String.format("<span style='color:%s;'>%s</span>", ColorUtil.colorToHexCode((Color)color), s);
    }

    public static void recolorLabel(JLabel label, Color c) {
        label.setText("<html>" + UIUtilities.colorText(label.getText(), c) + "</html>");
    }

    public static String buildWikiLink(int itemId) {
        return "https://prices.runescape.wiki/osrs/item/" + itemId;
    }

    public static String buildOurWebsiteLink(int itemId) {
        return "https://prices.osrs.cloud/item/" + itemId + "?utm_source=plugin";
    }

    public static IconTextField createSearchBar(final ScheduledExecutorService executor, final Consumer<IconTextField> onSearch) {
        final Future[] runningRequest = new Future[]{null};
        final IconTextField searchBar = new IconTextField();
        searchBar.setIcon(IconTextField.Icon.SEARCH);
        searchBar.setPreferredSize(new Dimension(205, 32));
        searchBar.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        searchBar.setHoverBackgroundColor(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        searchBar.setMinimumSize(new Dimension(0, 35));
        searchBar.addActionListener(e -> executor.execute(() -> onSearch.accept(searchBar)));
        searchBar.addClearListener(() -> onSearch.accept(searchBar));
        searchBar.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (runningRequest[0] != null) {
                    runningRequest[0].cancel(false);
                }
                runningRequest[0] = executor.schedule(() -> onSearch.accept(searchBar), 250L, TimeUnit.MILLISECONDS);
            }
        });
        return searchBar;
    }

    public static void makeLabelUnderlined(JLabel label) {
        Font font = label.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        label.setFont(font.deriveFont(attributes));
    }

    public static JToggleButton createToggleButton() {
        JToggleButton toggleButton = new JToggleButton(Icons.TOGGLE_OFF);
        toggleButton.setSelectedIcon(Icons.TOGGLE_ON);
        SwingUtil.removeButtonDecorations((AbstractButton)toggleButton);
        SwingUtil.addModalTooltip((AbstractButton)toggleButton, (String)"Turn off", (String)"Turn on");
        return toggleButton;
    }

    public static void addPopupOnHover(final JComponent component, final JPopupMenu popup, final boolean above) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Point location = component.getLocationOnScreen();
                int y = above ? location.y - popup.getHeight() : location.y + component.getHeight();
                popup.setLocation(location.x, y);
                popup.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                popup.setVisible(false);
            }
        });
    }

    public static JLabel createIcon(final ImageIcon base, final ImageIcon hover, final String url, String tooltip) {
        final JLabel iconLabel = new JLabel(base);
        iconLabel.setToolTipText(tooltip);
        iconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkBrowser.browse((String)url);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                iconLabel.setIcon(hover);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                iconLabel.setIcon(base);
            }
        });
        return iconLabel;
    }

    public static String maybePluralize(String word, int count) {
        if (count > 1) {
            return word + "s";
        }
        return word;
    }

    public static String truncateText(String text, int length) {
        String ellipses = "...";
        if (length <= ellipses.length()) {
            return text;
        }
        if (text.length() <= length) {
            return text;
        }
        return text.substring(0, length - ellipses.length()) + ellipses;
    }
}

