/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.uiutilities;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimeFormatters {
    public static ImmutableMap<Object, Object> stringToTimeUnit = ImmutableMap.builder().put((Object)"h", (Object)1).put((Object)"d", (Object)24).put((Object)"w", (Object)168).put((Object)"m", (Object)720).put((Object)"y", (Object)8760).build();

    public static String formatDuration(Duration duration) {
        long seconds = duration.toMillis() / 1000L;
        return String.format("%02d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    public static String formatDuration(Instant fromInstant) {
        return TimeFormatters.formatDuration(Duration.between(fromInstant, Instant.now()));
    }

    public static String formatDuration(Instant startInstant, Instant endInstant) {
        return TimeFormatters.formatDuration(Duration.between(startInstant, endInstant));
    }

    public static String formatDurationTruncated(Instant fromInstant) {
        if (fromInstant != null) {
            long timeAgo;
            long toInstant = Instant.now().getEpochSecond();
            String result = timeAgo + ((timeAgo = toInstant - fromInstant.getEpochSecond()) == 1L ? " second" : " seconds");
            if (timeAgo >= 60L) {
                long timeAgoMinutes;
                result = timeAgoMinutes + ((timeAgoMinutes = timeAgo / 60L) == 1L ? " minute" : " minutes");
                if (timeAgoMinutes >= 60L) {
                    int timeAgoHours;
                    result = timeAgoHours + ((timeAgoHours = (int)(timeAgoMinutes / 60L)) == 1 ? " hour" : " hours");
                    if (timeAgoHours > 24) {
                        int timeAgoDays;
                        result = timeAgoDays + ((timeAgoDays = timeAgoHours / 24) == 1 ? " day" : " days");
                    }
                }
            }
            return result;
        }
        return "";
    }

    public static String formatTime(Instant time, boolean twelveHourFormat, boolean includeDate) {
        Object pattern = "";
        if (includeDate) {
            pattern = "dd MMM ";
        }
        pattern = twelveHourFormat ? (String)pattern + "hh:mm a" : (String)pattern + "HH:mm";
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern((String)pattern).withZone(ZoneId.systemDefault());
        return timeFormatter.format(time);
    }

    public static String formatInstantToDate(Instant time) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm a").withZone(ZoneId.systemDefault());
        return timeFormatter.format(time);
    }
}

