/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.uiutilities;

import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.SlotInfo;
import com.flippingutilities.utilities.SlotPredictedState;
import com.flippingutilities.utilities.WikiItemMargins;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickLookPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(QuickLookPanel.class);
    JLabel wikiInstaBuy = new JLabel("", 4);
    JLabel wikiInstaSell = new JLabel("", 4);
    JLabel wikiInstaBuyAge = new JLabel("", 4);
    JLabel wikiInstaSellAge = new JLabel("", 4);
    JLabel offerCompetitivenessText = new JLabel("", 0);
    JLabel toMakeOfferCompetitiveTest = new JLabel("", 0);

    public QuickLookPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 15, 10, 15));
        this.offerCompetitivenessText.setFont(FontManager.getRunescapeBoldFont());
        this.toMakeOfferCompetitiveTest.setFont(FontManager.getRunescapeSmallFont());
        this.toMakeOfferCompetitiveTest.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.wikiInstaBuy.setForeground(Color.WHITE);
        this.wikiInstaSell.setForeground(Color.WHITE);
        JLabel title = new JLabel("Quick Look", 0);
        title.setFont(new Font("Whitney", 3, 12));
        JLabel wikiInstaBuyDesc = new JLabel("Wiki Insta Buy", 2);
        JLabel wikiInstaSellDesc = new JLabel("Wiki Insta Sell", 2);
        JLabel wikiInstaBuyAgeDesc = new JLabel("Wiki Insta Buy Age", 2);
        JLabel wikiInstaSellAgeDesc = new JLabel("Wiki Insta Sell Age", 2);
        wikiInstaBuyAgeDesc.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.wikiInstaBuyAge.setBorder(new EmptyBorder(5, 0, 0, 0));
        Arrays.asList(wikiInstaBuyDesc, wikiInstaSellDesc, wikiInstaBuyAgeDesc, wikiInstaSellAgeDesc, this.wikiInstaBuy, this.wikiInstaSell, this.wikiInstaBuyAge, this.wikiInstaSellAge).forEach(l -> l.setFont(FontManager.getRunescapeSmallFont()));
        JPanel wikiPanel = new JPanel((LayoutManager)new DynamicGridLayout(4, 2, 10, 2));
        wikiPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        wikiPanel.add(wikiInstaBuyDesc);
        wikiPanel.add(this.wikiInstaBuy);
        wikiPanel.add(wikiInstaSellDesc);
        wikiPanel.add(this.wikiInstaSell);
        wikiPanel.add(wikiInstaBuyAgeDesc);
        wikiPanel.add(this.wikiInstaBuyAge);
        wikiPanel.add(wikiInstaSellAgeDesc);
        wikiPanel.add(this.wikiInstaSellAge);
        JPanel summaryPanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1));
        summaryPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        summaryPanel.add(this.offerCompetitivenessText);
        summaryPanel.add(this.toMakeOfferCompetitiveTest);
        this.add((Component)title, "North");
        this.add((Component)wikiPanel, "Center");
        this.add((Component)summaryPanel, "South");
    }

    public void updateDetails(SlotInfo slot, WikiItemMargins wikiItemInfo) {
        Arrays.asList(this.wikiInstaBuy, this.wikiInstaSell, this.wikiInstaBuyAge, this.wikiInstaSellAge).forEach(l -> l.setForeground(Color.WHITE));
        if (wikiItemInfo == null || slot == null) {
            Arrays.asList(this.wikiInstaBuy, this.wikiInstaSell, this.wikiInstaBuyAge, this.wikiInstaSellAge).forEach(l -> l.setText("No data"));
            return;
        }
        HashMap<Integer, JLabel> wikiMarginToLabel = new HashMap<Integer, JLabel>();
        wikiMarginToLabel.put(wikiItemInfo.getHigh(), this.wikiInstaBuy);
        wikiMarginToLabel.put(wikiItemInfo.getLow(), this.wikiInstaSell);
        this.wikiInstaBuyAge.setText(wikiItemInfo.getHighTime() == 0L ? "No data" : TimeFormatters.formatDuration(Instant.ofEpochSecond(wikiItemInfo.getHighTime())));
        this.wikiInstaSellAge.setText(wikiItemInfo.getLowTime() == 0L ? "No data" : TimeFormatters.formatDuration(Instant.ofEpochSecond(wikiItemInfo.getLowTime())));
        this.wikiInstaBuy.setText((String)(wikiItemInfo.getHigh() == 0 ? "No data" : QuantityFormatter.formatNumber((long)wikiItemInfo.getHigh()) + " gp"));
        this.wikiInstaSell.setText((String)(wikiItemInfo.getLow() == 0 ? "No data" : QuantityFormatter.formatNumber((long)wikiItemInfo.getLow()) + " gp"));
        this.toMakeOfferCompetitiveTest.setText("");
        this.offerCompetitivenessText.setText("");
        int max = Math.max(wikiItemInfo.getHigh(), wikiItemInfo.getLow());
        int min = Math.min(wikiItemInfo.getHigh(), wikiItemInfo.getLow());
        if (slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.BETTER_THAN_WIKI) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(max), ColorScheme.GRAND_EXCHANGE_PRICE);
            this.offerCompetitivenessText.setText(String.format("<html> buy offer is ultra competitive: %s &gt= %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)max), ColorScheme.GRAND_EXCHANGE_PRICE)));
        } else if (slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.IN_RANGE) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(min), CustomColors.IN_RANGE);
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(max), ColorScheme.GRAND_EXCHANGE_PRICE);
            this.offerCompetitivenessText.setText(String.format("<html> buy offer is competitive: %s &lt= %s &lt %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)min), CustomColors.IN_RANGE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)max), ColorScheme.GRAND_EXCHANGE_PRICE)));
        } else if (slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.OUT_OF_RANGE) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(min), CustomColors.TOMATO);
            this.offerCompetitivenessText.setText(String.format("<html> buy offer is not competitive: %s &lt %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)min), CustomColors.TOMATO)));
            this.toMakeOfferCompetitiveTest.setText(String.format("<html> set price to &gt= %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)min), CustomColors.TOMATO)));
        } else if (!slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.BETTER_THAN_WIKI) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(min), ColorScheme.GRAND_EXCHANGE_PRICE);
            this.offerCompetitivenessText.setText(String.format("<html> sell offer is ultra competitive: %s &lt= %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)min), ColorScheme.GRAND_EXCHANGE_PRICE)));
        } else if (!slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.IN_RANGE) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(min), ColorScheme.GRAND_EXCHANGE_PRICE);
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(max), CustomColors.IN_RANGE);
            this.offerCompetitivenessText.setText(String.format("<html> sell offer is competitive: %s &lt %s &lt= %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)min), ColorScheme.GRAND_EXCHANGE_PRICE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)max), CustomColors.IN_RANGE)));
        } else if (!slot.isBuyOffer() && slot.getPredictedState() == SlotPredictedState.OUT_OF_RANGE) {
            UIUtilities.recolorLabel((JLabel)wikiMarginToLabel.get(max), CustomColors.TOMATO);
            this.offerCompetitivenessText.setText(String.format("<html> sell offer is not competitive: %s &gt %s</html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)slot.getOfferPrice()), Color.WHITE), UIUtilities.colorText(QuantityFormatter.formatNumber((long)max), CustomColors.TOMATO)));
            this.toMakeOfferCompetitiveTest.setText(String.format("<html> set price to &lt= %s </html>", UIUtilities.colorText(QuantityFormatter.formatNumber((long)max), CustomColors.TOMATO)));
        }
    }
}

