/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.uiutilities;

import com.flippingutilities.ui.uiutilities.Icons;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paginator
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(Paginator.class);
    private int pageNumber = 1;
    private int totalPages;
    private JLabel statusText;
    private JLabel arrowRight;
    private JLabel arrowLeft;
    Runnable onPageChange;
    private int pageSize = 20;

    public Paginator(Runnable onPageChange) {
        this.onPageChange = onPageChange;
        this.statusText = new JLabel("Page 1 of 1", 0);
        this.statusText.setFont(FontManager.getRunescapeBoldFont());
        this.arrowLeft = new JLabel(Icons.ARROW_LEFT);
        this.arrowRight = new JLabel(Icons.ARROW_RIGHT);
        this.arrowRight.setForeground(Color.blue);
        this.setLayout(new FlowLayout());
        this.add(this.arrowLeft);
        this.add(this.statusText);
        this.add(this.arrowRight);
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.arrowLeft.addMouseListener(this.onMouse(false));
        this.arrowRight.addMouseListener(this.onMouse(true));
    }

    public void updateTotalPages(int numItems) {
        this.totalPages = numItems <= this.pageSize ? 1 : (int)Math.ceil((float)numItems / (float)this.pageSize);
        this.statusText.setText(String.format("Page %d of %d", this.pageNumber, this.totalPages));
    }

    private MouseAdapter onMouse(final boolean isIncrease) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (isIncrease) {
                    if (Paginator.this.pageNumber < Paginator.this.totalPages) {
                        ++Paginator.this.pageNumber;
                        try {
                            Paginator.this.onPageChange.run();
                        }
                        catch (Exception exc) {
                            log.info("couldn't increase page number cause callback failed");
                            --Paginator.this.pageNumber;
                        }
                    }
                } else if (Paginator.this.pageNumber > 1) {
                    --Paginator.this.pageNumber;
                    try {
                        Paginator.this.onPageChange.run();
                    }
                    catch (Exception exc) {
                        log.info("couldn't decrease page number cause callback failed");
                        ++Paginator.this.pageNumber;
                    }
                }
                Paginator.this.statusText.setText(String.format("Page %d of %d", Paginator.this.pageNumber, Paginator.this.totalPages));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (isIncrease) {
                    Paginator.this.arrowRight.setIcon(Icons.ARROW_RIGHT_HOVER);
                } else {
                    Paginator.this.arrowLeft.setIcon(Icons.ARROW_LEFT_HOVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (isIncrease) {
                    Paginator.this.arrowRight.setIcon(Icons.ARROW_RIGHT);
                } else {
                    Paginator.this.arrowLeft.setIcon(Icons.ARROW_LEFT);
                }
            }
        };
    }

    public <T> List<T> getCurrentPageItems(List<T> items) {
        ArrayList<T> pageItems = new ArrayList<T>();
        int startIndex = (this.pageNumber - 1) * this.pageSize;
        int endIndex = Math.min(startIndex + this.pageSize, items.size());
        for (int i = startIndex; i < endIndex; ++i) {
            pageItems.add(items.get(i));
        }
        return pageItems;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public JLabel getStatusText() {
        return this.statusText;
    }

    public void setArrowRight(JLabel arrowRight) {
        this.arrowRight = arrowRight;
    }

    public void setArrowLeft(JLabel arrowLeft) {
        this.arrowLeft = arrowLeft;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

