/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.uiutilities;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastTabGroup
extends MaterialTabGroup {
    private static final Logger log = LoggerFactory.getLogger(FastTabGroup.class);
    private final JPanel display;
    private final List<MaterialTab> tabs = new ArrayList<MaterialTab>();
    private String lastSelectedTab;
    private JComponent currentlySelectedTab;
    private boolean currentlyShowingView = false;

    public FastTabGroup(JPanel display) {
        this.display = display;
        this.display.setLayout(new CardLayout());
        this.setLayout(new FlowLayout(1, 8, 0));
    }

    public void addTab(MaterialTab tab) {
        this.tabs.add(tab);
        this.display.add((Component)tab.getContent(), tab.getText());
        this.add((Component)tab, "North");
    }

    public void addView(JPanel panel, String name) {
        this.display.add((Component)panel, name);
    }

    public boolean select(MaterialTab selectedTab) {
        if (!selectedTab.select()) {
            return false;
        }
        this.currentlyShowingView = false;
        this.lastSelectedTab = selectedTab.getText();
        this.currentlySelectedTab = selectedTab.getContent();
        CardLayout cardLayout = (CardLayout)this.display.getLayout();
        cardLayout.show(this.display, selectedTab.getText());
        for (MaterialTab tab : this.tabs) {
            if (tab.equals(selectedTab)) continue;
            tab.unselect();
        }
        return true;
    }

    public void unselectAll() {
        this.tabs.forEach(tab -> tab.unselect());
    }

    public void showView(String name) {
        this.currentlyShowingView = true;
        this.unselectAll();
        CardLayout cardLayout = (CardLayout)this.display.getLayout();
        cardLayout.show(this.display, name);
    }

    public void revertToSafeDisplay() {
        if (this.currentlyShowingView) {
            this.selectPreviouslySelectedTab();
        }
    }

    public void selectPreviouslySelectedTab() {
        for (MaterialTab tab : this.tabs) {
            if (!tab.getText().equals(this.lastSelectedTab)) continue;
            this.select(tab);
            break;
        }
    }

    public String getLastSelectedTab() {
        return this.lastSelectedTab;
    }

    public JComponent getCurrentlySelectedTab() {
        return this.currentlySelectedTab;
    }
}

