/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.recipes;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.statistics.recipes.RecipeFlipGroupPanel;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.Paginator;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeGroupContainerPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(RecipeGroupContainerPanel.class);
    private JPanel recipeGroupContainer;
    private List<RecipeFlipGroupPanel> activePanels = new ArrayList<RecipeFlipGroupPanel>();
    private Paginator paginator;
    private FlippingPlugin plugin;

    public RecipeGroupContainerPanel(FlippingPlugin flippingPlugin) {
        this.plugin = flippingPlugin;
        this.recipeGroupContainer = this.createRecipeGroupContainer();
        this.paginator = this.createPaginator();
        JScrollPane scrollPane = this.createScrollPane(this.recipeGroupContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.paginator, "South");
    }

    public void resetPaginator() {
        this.paginator.setPageNumber(1);
    }

    public void rebuild(List<RecipeFlipGroup> recipeFlipGroups) {
        this.activePanels.clear();
        this.recipeGroupContainer.removeAll();
        this.paginator.updateTotalPages(recipeFlipGroups.size());
        if (!recipeFlipGroups.isEmpty()) {
            List<RecipeFlipGroup> itemsOnCurrentPage = this.paginator.getCurrentPageItems(recipeFlipGroups);
            List<JPanel> newPanels = itemsOnCurrentPage.stream().map(rfg -> new RecipeFlipGroupPanel(this.plugin, (RecipeFlipGroup)rfg)).collect(Collectors.toList());
            UIUtilities.stackPanelsVertically(newPanels, this.recipeGroupContainer, 5);
            this.activePanels.addAll(newPanels);
        } else {
            this.recipeGroupContainer.add(this.createHelpPanel());
        }
    }

    public void showPanel(JPanel panel) {
        this.activePanels.clear();
        this.recipeGroupContainer.removeAll();
        this.recipeGroupContainer.add(panel);
    }

    private JPanel createHelpPanel() {
        JLabel picDesc = new JLabel("<html><body width='220' style='text-align:center;'>Create a recipe flip by going to an offer for an item and clicking on the recipe flip button.<br><br> ", 0);
        picDesc.setFont(new Font("Whitney", 0, 15));
        picDesc.setIcon(Icons.RECIPE_HELP);
        picDesc.setBorder(new EmptyBorder(20, 5, 0, 0));
        picDesc.setHorizontalTextPosition(0);
        picDesc.setVerticalTextPosition(1);
        JLabel additionalInfoLabel = new JLabel("<html><body width='220' style='text-align:center;'>This button will only be there if that item has a recipe associated with it</b>.<br><br> ", 0);
        additionalInfoLabel.setFont(new Font("Whitney", 0, 10));
        JLabel contactUsLabel = new JLabel("<html><body width='220' style='text-align:center;'>If a recipe is missing, contact us on discord and we will add it!", 0);
        contactUsLabel.setFont(new Font("Whitney", 2, 10));
        JPanel helpPanel = new JPanel((LayoutManager)new DynamicGridLayout(3, 1));
        helpPanel.setAlignmentX(0.5f);
        helpPanel.add(picDesc);
        helpPanel.add(additionalInfoLabel);
        helpPanel.add(contactUsLabel);
        return helpPanel;
    }

    private JPanel createRecipeGroupContainer() {
        JPanel statItemPanelsContainer = new JPanel();
        statItemPanelsContainer.setLayout(new BoxLayout(statItemPanelsContainer, 1));
        return statItemPanelsContainer;
    }

    private JScrollPane createScrollPane(JPanel recipeGroupContainer) {
        JPanel statItemPanelsContainerWrapper = new JPanel(new BorderLayout());
        statItemPanelsContainerWrapper.setBorder(new EmptyBorder(0, 0, 0, 3));
        statItemPanelsContainerWrapper.add((Component)recipeGroupContainer, "North");
        JScrollPane scrollPane = new JScrollPane(statItemPanelsContainerWrapper);
        scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(2, 0));
        return scrollPane;
    }

    private Paginator createPaginator() {
        this.paginator = new Paginator(() -> SwingUtilities.invokeLater(() -> {
            StatsPanel statsPanel = this.plugin.getStatPanel();
            Instant rebuildStart = Instant.now();
            this.rebuild(statsPanel.getRecipeFlipGroupsToDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView()));
            this.revalidate();
            this.repaint();
            log.debug("page change took {}", (Object)Duration.between(rebuildStart, Instant.now()).toMillis());
        }));
        this.paginator.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.paginator.setBorder(new MatteBorder(1, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR.darker()));
        return this.paginator;
    }

    public void updateTimeDisplay() {
        this.activePanels.forEach(RecipeFlipGroupPanel::updateTimeLabels);
    }
}

