/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.recipes;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Recipe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeFlipPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(RecipeFlipPanel.class);
    private JLabel timeDisplay;
    private RecipeFlip recipeFlip;
    private FlippingPlugin plugin;
    private Recipe recipe;
    private RecipeFlipGroup recipeFlipGroup;

    public RecipeFlipPanel(RecipeFlipGroup recipeFlipGroup, RecipeFlip recipeFlip, Recipe recipe, FlippingPlugin plugin) {
        this.recipeFlipGroup = recipeFlipGroup;
        this.recipeFlip = recipeFlip;
        this.plugin = plugin;
        this.recipe = recipe;
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.timeDisplay = this.createTimeDisplay(recipeFlip);
        this.add((Component)this.createTitlePanel(), "North");
        this.add((Component)this.createProfitPanel(), "Center");
        this.add((Component)this.createDetailsPanel(), "South");
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout((LayoutManager)new DynamicGridLayout(2, 1));
        titlePanel.setBackground(CustomColors.DARK_GRAY);
        String recipeQuantity = QuantityFormatter.formatNumber((long)this.recipeFlip.getRecipeCountMade(this.recipe));
        JLabel quantityLabel = new JLabel(recipeQuantity + "x");
        quantityLabel.setFont(FontManager.getRunescapeSmallFont());
        JPanel quantityAndTimePanel = new JPanel();
        quantityAndTimePanel.setBackground(CustomColors.DARK_GRAY);
        quantityAndTimePanel.add(quantityLabel);
        quantityAndTimePanel.add(this.timeDisplay);
        String recipeDisplayName = UIUtilities.truncateText(this.recipe.getName(), 40);
        JLabel itemNameAndActionLabel = new JLabel(recipeDisplayName, 0);
        itemNameAndActionLabel.setFont(FontManager.getRunescapeSmallFont());
        itemNameAndActionLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        titlePanel.add(itemNameAndActionLabel);
        titlePanel.add(quantityAndTimePanel);
        return titlePanel;
    }

    private JLabel createTimeDisplay(RecipeFlip recipeFlip) {
        JLabel timeDisplay = new JLabel("(" + TimeFormatters.formatDurationTruncated(recipeFlip.getTimeOfCreation()) + " ago)", 0);
        timeDisplay.setFont(FontManager.getRunescapeSmallFont());
        return timeDisplay;
    }

    private JPanel createComponentGroupPanel(Map<Integer, Map<String, PartialOffer>> partialOffers, boolean outputs) {
        JLabel titleLabel = new JLabel(outputs ? "OUTPUTS" : "INPUTS", 0);
        titleLabel.setFont(new Font("Whitney", 0, 10));
        titleLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        boolean userAddedCoinsThatWereNotInRecipe = this.recipeFlip.getCoinCost() > 0L && !partialOffers.containsKey(995);
        int rowSizeForUserAddedCoins = userAddedCoinsThatWereNotInRecipe ? 1 : 0;
        JPanel componentGroupPanel = new JPanel((LayoutManager)new DynamicGridLayout(1 + partialOffers.size() + rowSizeForUserAddedCoins, 1));
        componentGroupPanel.setBackground(CustomColors.DARK_GRAY);
        componentGroupPanel.add(titleLabel);
        if (userAddedCoinsThatWereNotInRecipe) {
            componentGroupPanel.add(this.createComponentPanel("Coins", this.recipeFlip.getCoinCost(), 1L));
        }
        partialOffers.forEach((itemId, partialOfferMap) -> {
            long avgPrice;
            long quantity;
            String itemName;
            if (itemId == 995) {
                itemName = "Coins";
                quantity = this.recipeFlip.getCoinCost();
                avgPrice = 1L;
            } else {
                ArrayList partialOfferList = new ArrayList(partialOfferMap.values());
                itemName = ((PartialOffer)partialOfferList.get((int)0)).offer.getItemName();
                quantity = partialOfferList.stream().mapToInt(po -> po.amountConsumed).sum();
                avgPrice = partialOfferList.stream().mapToLong(po -> po.getOffer().getPrice() * po.amountConsumed).sum() / quantity;
            }
            componentGroupPanel.add(this.createComponentPanel(itemName, quantity, avgPrice));
        });
        return componentGroupPanel;
    }

    private JPanel createComponentPanel(String itemName, long quantity, long avgPrice) {
        if (quantity == 0L) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(CustomColors.DARK_GRAY);
            JLabel label = new JLabel("Corrupted recipe flip (delete it)", 0);
            label.setFont(FontManager.getRunescapeSmallFont());
            label.setForeground(CustomColors.TOMATO);
            panel.add((Component)label, "Center");
            return panel;
        }
        JLabel itemNameLabel = new JLabel(itemName, 0);
        itemNameLabel.setFont(FontManager.getRunescapeSmallFont());
        JPanel quantityPanel = new JPanel(new BorderLayout());
        quantityPanel.setBackground(CustomColors.DARK_GRAY);
        JLabel quantityLabel = new JLabel("Quantity", 0);
        quantityLabel.setFont(FontManager.getRunescapeSmallFont());
        JLabel quantityValueLabel = new JLabel(QuantityFormatter.formatNumber((long)quantity));
        quantityValueLabel.setFont(FontManager.getRunescapeSmallFont());
        quantityPanel.add((Component)quantityLabel, "West");
        quantityPanel.add((Component)quantityValueLabel, "East");
        JPanel pricePanel = new JPanel(new BorderLayout());
        pricePanel.setBackground(CustomColors.DARK_GRAY);
        JLabel priceLabel = new JLabel("Avg Price", 0);
        priceLabel.setFont(FontManager.getRunescapeSmallFont());
        JLabel priceValueLabel = new JLabel((String)(itemName.equals("Coins") ? "N/A" : QuantityFormatter.formatNumber((long)avgPrice) + " gp"));
        priceValueLabel.setFont(FontManager.getRunescapeSmallFont());
        pricePanel.add((Component)priceLabel, "West");
        pricePanel.add((Component)priceValueLabel, "East");
        JPanel itemPanel = new JPanel((LayoutManager)new DynamicGridLayout(3, 1));
        itemPanel.setBackground(CustomColors.DARK_GRAY);
        itemPanel.add(itemNameLabel);
        itemPanel.add(quantityPanel);
        itemPanel.add(pricePanel);
        return itemPanel;
    }

    private JPanel createDetailsPanel() {
        JPanel inputPanel = this.createComponentGroupPanel(this.recipeFlip.getInputs(), false);
        JPanel outputPanel = this.createComponentGroupPanel(this.recipeFlip.getOutputs(), true);
        final JPanel inputsAndOutputsPanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1));
        inputsAndOutputsPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        inputsAndOutputsPanel.setBackground(CustomColors.DARK_GRAY);
        inputsAndOutputsPanel.setVisible(false);
        inputsAndOutputsPanel.add(inputPanel);
        inputsAndOutputsPanel.add(outputPanel);
        final JLabel expandDetailsLabel = new JLabel("Expand Details", 0);
        final Color c = expandDetailsLabel.getForeground();
        expandDetailsLabel.setFont(FontManager.getRunescapeSmallFont());
        Font font = new Font(expandDetailsLabel.getFont().getName(), 2, expandDetailsLabel.getFont().getSize());
        expandDetailsLabel.setFont(font);
        UIUtilities.makeLabelUnderlined(expandDetailsLabel);
        expandDetailsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                inputsAndOutputsPanel.setVisible(!inputsAndOutputsPanel.isVisible());
                expandDetailsLabel.setText(inputsAndOutputsPanel.isVisible() ? "Collapse Details" : "Expand Details");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                expandDetailsLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                expandDetailsLabel.setForeground(c);
            }
        });
        JPanel expandDetailsPanel = new JPanel(new BorderLayout());
        expandDetailsPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
        expandDetailsPanel.setBackground(CustomColors.DARK_GRAY);
        expandDetailsPanel.add((Component)expandDetailsLabel, "Center");
        expandDetailsPanel.add((Component)this.createDeleteIcon(), "West");
        JPanel detailsPanel = new JPanel(new BorderLayout());
        detailsPanel.setBackground(CustomColors.DARK_GRAY);
        detailsPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        detailsPanel.add((Component)expandDetailsPanel, "North");
        detailsPanel.add((Component)inputsAndOutputsPanel, "Center");
        return detailsPanel;
    }

    private JLabel createDeleteIcon() {
        final JLabel deleteIcon = new JLabel(Icons.TRASH_CAN_OFF);
        deleteIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RecipeFlipPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    JOptionPane.showMessageDialog(null, "You cannot delete recipe flips in the Accountwide view");
                    return;
                }
                int result = JOptionPane.showOptionDialog(deleteIcon, "Are you sure you want to delete this recipe flip?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    RecipeFlipPanel.this.recipeFlipGroup.deleteFlip(RecipeFlipPanel.this.recipeFlip);
                    RecipeFlipPanel.this.plugin.setUpdateSinceLastRecipeFlipGroupAccountWideBuild(true);
                    RecipeFlipPanel.this.plugin.markAccountTradesAsHavingChanged(RecipeFlipPanel.this.plugin.getAccountCurrentlyViewed());
                    RecipeFlipPanel.this.plugin.getStatPanel().rebuildItemsDisplay(RecipeFlipPanel.this.plugin.viewItemsForCurrentView());
                    RecipeFlipPanel.this.plugin.getStatPanel().rebuildRecipesDisplay(RecipeFlipPanel.this.plugin.viewRecipeFlipGroupsForCurrentView());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteIcon.setIcon(Icons.TRASH_CAN_ON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteIcon.setIcon(Icons.TRASH_CAN_OFF);
            }
        });
        return deleteIcon;
    }

    private JPanel createProfitPanel() {
        long quantity = this.recipeFlip.getRecipeCountMade(this.recipe);
        if (quantity == 0L) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(CustomColors.DARK_GRAY);
            JLabel label = new JLabel("Mismatched recipe flip (delete it)", 0);
            label.setFont(FontManager.getRunescapeSmallFont());
            label.setForeground(CustomColors.TOMATO);
            panel.add((Component)label, "Center");
            return panel;
        }
        long profit = this.recipeFlip.getProfit();
        long profitEach = profit / quantity;
        String profitString = UIUtilities.quantityToRSDecimalStack(profit, true) + " gp";
        String profitEachString = quantity == 1L ? "" : " (" + UIUtilities.quantityToRSDecimalStack(profitEach, false) + " gp ea)";
        String profitDescription = profit < 0L ? "Loss" : "Profit:";
        JLabel profitValLabel = new JLabel(profitString + profitEachString);
        profitValLabel.setFont(FontManager.getRunescapeSmallFont());
        JLabel profitDescriptionLabel = new JLabel(profitDescription);
        profitDescriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        profitDescriptionLabel.setForeground(profit >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        JPanel profitPanel = new JPanel(new BorderLayout());
        profitPanel.setBackground(CustomColors.DARK_GRAY);
        profitPanel.add((Component)profitDescriptionLabel, "West");
        profitPanel.add((Component)profitValLabel, "East");
        return profitPanel;
    }

    public void updateTimeLabels() {
        this.timeDisplay.setText("(" + TimeFormatters.formatDurationTruncated(this.recipeFlip.getTimeOfCreation()) + " ago)");
    }
}

