/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.recipes;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.statistics.recipes.RecipeFlipPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.Paginator;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Recipe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class RecipeFlipGroupPanel
extends JPanel {
    private FlippingPlugin plugin;
    private RecipeFlipGroup recipeFlipGroup;
    private StatsPanel statsPanel;
    private JLabel recipeProfitAndQuantityLabel = new JLabel();
    private JPanel itemIconTitlePanel = new JPanel(new BorderLayout());
    private JLabel totalProfitValLabel = new JLabel("", 4);
    private JLabel profitEachValLabel = new JLabel("", 4);
    private JLabel quantityFlipped = new JLabel("", 4);
    private JLabel roiValLabel = new JLabel("", 4);
    private List<RecipeFlipPanel> recipeFlipPanels;
    private Paginator recipeFlipPaginator;
    private JPanel recipeFlipsBackgroundPanel = this.createRecipeFlipsBackgroundPanel();

    RecipeFlipGroupPanel(FlippingPlugin plugin, RecipeFlipGroup recipeFlipGroup) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        this.plugin = plugin;
        this.recipeFlipGroup = recipeFlipGroup;
        this.statsPanel = plugin.getStatPanel();
        List<RecipeFlip> flips = recipeFlipGroup.getFlipsInInterval(this.statsPanel.getStartOfInterval());
        this.recipeFlipPaginator = this.createPaginator(() -> this.updateBackgroundPanel(flips));
        this.recipeFlipPaginator.updateTotalPages(flips.size());
        this.recipeFlipPanels = this.createRecipeFlipPanels(flips);
        this.putPanelsOnBackgroundPanel(new ArrayList<JPanel>(this.recipeFlipPanels), this.recipeFlipsBackgroundPanel, this.recipeFlipPaginator);
        JLabel[] descriptionLabels = new JLabel[]{new JLabel("Total Profit: "), new JLabel("Avg. Profit ea: "), new JLabel("Avg. ROI: "), new JLabel("Recipes Made: ")};
        JLabel[] valueLabels = new JLabel[]{this.totalProfitValLabel, this.profitEachValLabel, this.roiValLabel, this.quantityFlipped};
        JPanel subInfoPanel = this.createSubInfoPanel(descriptionLabels, valueLabels);
        JPanel tradeHistoryPanel = this.createTradeHistoryPanel(this.recipeFlipsBackgroundPanel);
        JPanel subInfoAndHistoryContainer = this.createSubInfoAndHistoryContainer(subInfoPanel, tradeHistoryPanel);
        JPanel titlePanel = this.createTitlePanel(this.createIconPanel(plugin.getItemManager()), this.createNameAndProfitPanel(), this.createCollapseIcon(), subInfoAndHistoryContainer);
        this.updateLabels(flips);
        this.add((Component)titlePanel, "North");
        this.add((Component)subInfoAndHistoryContainer, "Center");
    }

    private JPanel createSubInfoAndHistoryContainer(JPanel subInfoPanel, JPanel tradeHistoryPanel) {
        JPanel subInfoAndHistoryContainer = new JPanel(new BorderLayout());
        subInfoAndHistoryContainer.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        subInfoAndHistoryContainer.add((Component)subInfoPanel, "Center");
        subInfoAndHistoryContainer.add((Component)tradeHistoryPanel, "South");
        subInfoAndHistoryContainer.setVisible(false);
        return subInfoAndHistoryContainer;
    }

    private JPanel createRecipeFlipsBackgroundPanel() {
        JPanel recipeFlipsBackgroundPanel = new JPanel();
        recipeFlipsBackgroundPanel.setVisible(false);
        return recipeFlipsBackgroundPanel;
    }

    private Paginator createPaginator(Runnable runnable) {
        Paginator paginator = new Paginator(runnable);
        paginator.setPageSize(10);
        paginator.setBackground(CustomColors.DARK_GRAY);
        paginator.getStatusText().setFont(FontManager.getRunescapeSmallFont());
        paginator.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        return paginator;
    }

    private void putPanelsOnBackgroundPanel(List<JPanel> panels, JPanel backgroundPanel, Paginator paginator) {
        ArrayList<JPanel> panelsAndPaginator = new ArrayList<JPanel>();
        JPanel paginatorWrapper = new JPanel();
        paginatorWrapper.add(paginator);
        panelsAndPaginator.add(paginatorWrapper);
        panelsAndPaginator.addAll(panels);
        backgroundPanel.removeAll();
        UIUtilities.stackPanelsVertically(panelsAndPaginator, backgroundPanel, 2);
        if (panels.isEmpty()) {
            JPanel labelWrapper = new JPanel();
            JLabel noDataLabel = new JLabel("Nothing here...", 0);
            noDataLabel.setForeground(CustomColors.TOMATO);
            noDataLabel.setFont(new Font("Whitney", 0, 10));
            labelWrapper.add(noDataLabel);
            backgroundPanel.add(labelWrapper);
        }
        this.repaint();
        this.revalidate();
    }

    private List<RecipeFlipPanel> createRecipeFlipPanels(List<RecipeFlip> recipeFlips) {
        ArrayList<RecipeFlip> flipsCopy = new ArrayList<RecipeFlip>(recipeFlips);
        Collections.reverse(flipsCopy);
        List<RecipeFlip> flipsOnCurrentPage = this.recipeFlipPaginator.getCurrentPageItems(flipsCopy);
        return flipsOnCurrentPage.stream().map(rf -> new RecipeFlipPanel(this.recipeFlipGroup, (RecipeFlip)rf, this.recipeFlipGroup.getRecipe(), this.plugin)).collect(Collectors.toList());
    }

    private void updateBackgroundPanel(List<RecipeFlip> flips) {
        this.recipeFlipPanels = this.createRecipeFlipPanels(flips);
        this.putPanelsOnBackgroundPanel(new ArrayList<JPanel>(this.recipeFlipPanels), this.recipeFlipsBackgroundPanel, this.recipeFlipPaginator);
    }

    private JPanel createTitlePanel(JPanel itemIconPanel, final JPanel nameAndProfitPanel, final JLabel collapseIcon, final JPanel subInfoAndHistoryContainer) {
        final JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(CustomColors.DARK_GRAY);
        titlePanel.setBorder(new EmptyBorder(5, 4, 5, 4));
        titlePanel.add((Component)itemIconPanel, "West");
        titlePanel.add((Component)nameAndProfitPanel, "Center");
        titlePanel.add((Component)collapseIcon, "East");
        titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (subInfoAndHistoryContainer.isVisible()) {
                        collapseIcon.setIcon(Icons.CLOSE_ICON);
                        subInfoAndHistoryContainer.setVisible(false);
                    } else {
                        collapseIcon.setIcon(Icons.OPEN_ICON);
                        subInfoAndHistoryContainer.setVisible(true);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                titlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                nameAndProfitPanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                for (Component component : nameAndProfitPanel.getComponents()) {
                    component.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                }
                RecipeFlipGroupPanel.this.itemIconTitlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                titlePanel.setBackground(CustomColors.DARK_GRAY);
                nameAndProfitPanel.setBackground(CustomColors.DARK_GRAY);
                for (Component component : nameAndProfitPanel.getComponents()) {
                    component.setBackground(CustomColors.DARK_GRAY);
                }
                RecipeFlipGroupPanel.this.itemIconTitlePanel.setBackground(CustomColors.DARK_GRAY);
            }
        });
        return titlePanel;
    }

    private JPanel createSubInfoPanel(JLabel[] descriptionLabels, JLabel[] valueLabels) {
        JPanel subInfoContainer = new JPanel();
        subInfoContainer.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        subInfoContainer.setLayout((LayoutManager)new DynamicGridLayout(valueLabels.length, descriptionLabels.length));
        subInfoContainer.setBorder(new EmptyBorder(10, 6, 6, 6));
        for (int i = 0; i < descriptionLabels.length; ++i) {
            JLabel textLabel = descriptionLabels[i];
            JLabel valLabel = valueLabels[i];
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)textLabel, "West");
            panel.add((Component)valLabel, "East");
            panel.setBorder(new EmptyBorder(4, 2, 4, 2));
            panel.setBackground(CustomColors.DARK_GRAY_LIGHTER);
            textLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
            textLabel.setFont(FontManager.getRunescapeSmallFont());
            valLabel.setFont(FontManager.getRunescapeSmallFont());
            subInfoContainer.add(panel);
        }
        return subInfoContainer;
    }

    private JPanel createTradeHistoryPanel(final JPanel recipeFlipsBackgroundPanel) {
        final JPanel recipeFlipHistoryTitlePanel = new JPanel(new BorderLayout());
        recipeFlipHistoryTitlePanel.setBackground(CustomColors.DARK_GRAY);
        recipeFlipHistoryTitlePanel.setBorder(new EmptyBorder(4, 0, 4, 0));
        final JLabel collapseTradeHistoryIconLabel = new JLabel(Icons.OPEN_ICON);
        JLabel recipeFlipHistoryTitleLabel = new JLabel("View Recipe Flips", 0);
        recipeFlipHistoryTitleLabel.setFont(new Font("Whitney", 2, 10));
        recipeFlipHistoryTitlePanel.add((Component)recipeFlipHistoryTitleLabel, "Center");
        recipeFlipHistoryTitlePanel.add((Component)collapseTradeHistoryIconLabel, "East");
        recipeFlipHistoryTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (recipeFlipsBackgroundPanel.isVisible()) {
                        recipeFlipsBackgroundPanel.setVisible(false);
                        collapseTradeHistoryIconLabel.setIcon(Icons.CLOSE_ICON);
                    } else {
                        recipeFlipsBackgroundPanel.setVisible(true);
                        collapseTradeHistoryIconLabel.setIcon(Icons.OPEN_ICON);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                recipeFlipHistoryTitlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                recipeFlipHistoryTitlePanel.setBackground(CustomColors.DARK_GRAY);
            }
        });
        JPanel tradeHistoryPanel = new JPanel(new BorderLayout());
        tradeHistoryPanel.add((Component)recipeFlipHistoryTitlePanel, "North");
        tradeHistoryPanel.add((Component)recipeFlipsBackgroundPanel, "Center");
        return tradeHistoryPanel;
    }

    private JPanel createIconPanel(ItemManager itemManager) {
        final JLabel deleteLabel = new JLabel(Icons.DELETE_ICON);
        deleteLabel.setPreferredSize(new Dimension(24, 24));
        deleteLabel.setVisible(false);
        final JLabel itemLabel = new JLabel(Icons.CONSTRUCTION);
        this.itemIconTitlePanel.add((Component)itemLabel, "West");
        this.itemIconTitlePanel.add((Component)deleteLabel, "East");
        this.itemIconTitlePanel.setBackground(CustomColors.DARK_GRAY);
        this.itemIconTitlePanel.setBorder(new EmptyBorder(5, 2, 0, 5));
        this.itemIconTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (RecipeFlipGroupPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    JOptionPane.showMessageDialog(null, "You cannot delete recipe flips in the Accountwide view");
                    return;
                }
                int result = JOptionPane.showOptionDialog(RecipeFlipGroupPanel.this.itemIconTitlePanel, "Are you sure you want to delete this recipe's flips from this time interval?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    RecipeFlipGroupPanel.this.deletePanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                itemLabel.setVisible(false);
                deleteLabel.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                itemLabel.setVisible(true);
                deleteLabel.setVisible(false);
            }
        });
        return this.itemIconTitlePanel;
    }

    private JPanel createNameAndProfitPanel() {
        JPanel nameAndProfitPanel = new JPanel(new BorderLayout());
        nameAndProfitPanel.setBackground(CustomColors.DARK_GRAY);
        JLabel itemNameLabel = new JLabel(this.recipeFlipGroup.getRecipe().getName());
        nameAndProfitPanel.add((Component)itemNameLabel, "North");
        nameAndProfitPanel.add((Component)this.recipeProfitAndQuantityLabel, "South");
        nameAndProfitPanel.setPreferredSize(new Dimension(0, 0));
        return nameAndProfitPanel;
    }

    private JLabel createCollapseIcon() {
        JLabel collapseIconLabel = new JLabel();
        collapseIconLabel.setIcon(Icons.OPEN_ICON);
        collapseIconLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        return collapseIconLabel;
    }

    public void updateLabels(List<RecipeFlip> recipeFlips) {
        this.quantityFlipped.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        Recipe recipe = this.recipeFlipGroup.getRecipe();
        int recipesMade = recipeFlips.stream().mapToInt(rf -> rf.getRecipeCountMade(recipe)).sum();
        long revenue = recipeFlips.stream().mapToLong(RecipeFlip::getRevenue).sum();
        long expense = recipeFlips.stream().mapToLong(RecipeFlip::getExpense).sum();
        long profit = revenue - expense;
        this.updateTitleLabels(profit, recipesMade);
        this.updateFlippingLabels(expense, revenue, recipesMade);
        this.updateTimeLabels();
    }

    private void updateTitleLabels(long profitFromFlips, long numItemsFlipped) {
        String totalProfitString = (profitFromFlips >= 0L ? "+" : "") + UIUtilities.quantityToRSDecimalStack(profitFromFlips, true) + " gp";
        totalProfitString = totalProfitString + " (x " + QuantityFormatter.formatNumber((long)numItemsFlipped) + ")";
        this.recipeProfitAndQuantityLabel.setText(totalProfitString);
        this.recipeProfitAndQuantityLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.recipeProfitAndQuantityLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.recipeProfitAndQuantityLabel.setFont(FontManager.getRunescapeSmallFont());
    }

    private void updateFlippingLabels(long flippingExpense, long flippingRevenue, int itemsFlipped) {
        long profitFromFlips = flippingRevenue - flippingExpense;
        this.totalProfitValLabel.setText(UIUtilities.quantityToRSDecimalStack(profitFromFlips, true) + " gp");
        this.totalProfitValLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.totalProfitValLabel.setToolTipText(QuantityFormatter.formatNumber((long)profitFromFlips) + " gp");
        String profitEach = UIUtilities.quantityToRSDecimalStack(itemsFlipped > 0 ? profitFromFlips / (long)itemsFlipped : 0L, true) + " gp/ea";
        this.profitEachValLabel.setText(profitEach);
        this.profitEachValLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.profitEachValLabel.setToolTipText(QuantityFormatter.formatNumber((long)(itemsFlipped > 0 ? profitFromFlips / (long)itemsFlipped : 0L)) + " gp/ea");
        this.quantityFlipped.setText(QuantityFormatter.formatNumber((long)itemsFlipped) + " Items");
        float roi = (float)flippingExpense > 0.0f ? (float)profitFromFlips / (float)flippingExpense * 100.0f : 0.0f;
        this.roiValLabel.setText(String.format("%.2f", Float.valueOf(roi)) + "%");
        this.roiValLabel.setForeground(UIUtilities.gradiatePercentage(roi, this.plugin.getConfig().roiGradientMax()));
        this.roiValLabel.setToolTipText("<html>Return on investment:<br>Percentage of profit relative to gp invested</html>");
    }

    public void updateTimeLabels() {
        this.recipeFlipPanels.forEach(RecipeFlipPanel::updateTimeLabels);
    }

    private void deletePanel() {
        this.statsPanel.deleteRecipeFlipGroupPanel(this);
    }

    public RecipeFlipGroup getRecipeFlipGroup() {
        return this.recipeFlipGroup;
    }
}

