/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.items;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.ui.MasterPanel;
import com.flippingutilities.ui.recipeflips.RecipeFlipCreationPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class OfferPanel
extends JPanel {
    private final JLabel timeDisplay;
    private final OfferEvent offer;
    private final FlippingPlugin plugin;
    private final FlippingItem item;
    private boolean plainMode;
    private JLabel offerDescriptionLabel;

    public OfferPanel(FlippingPlugin plugin, FlippingItem item, OfferEvent offer, boolean plainMode) {
        this.setLayout(new BorderLayout());
        this.offer = offer;
        this.plugin = plugin;
        this.item = item;
        this.plainMode = plainMode;
        this.timeDisplay = this.createTimeDisplayLabel();
        this.offerDescriptionLabel = this.createOfferDescriptionLabel();
        this.add((Component)this.createTitlePanel(this.offerDescriptionLabel, this.timeDisplay), "North");
        this.add((Component)this.createBodyPanel(), "Center");
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(this.createBorder(false));
    }

    public void updateTimeDisplay() {
        if (this.offer.isComplete()) {
            this.timeDisplay.setText("(" + TimeFormatters.formatDurationTruncated(this.offer.getTime()) + " ago)");
        } else {
            this.timeDisplay.setText(TimeFormatters.formatDurationTruncated(this.offer.getTime()) + " ago");
        }
    }

    private JPanel createTitlePanel(JLabel offerDescription, JLabel timeDisplay) {
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        titlePanel.setBackground(CustomColors.DARK_GRAY);
        if (!this.offer.isComplete()) {
            titlePanel.setBorder(new EmptyBorder(5, 0, 2, 0));
            titlePanel.setLayout((LayoutManager)new DynamicGridLayout(2, 1));
        }
        titlePanel.add(offerDescription);
        titlePanel.add(timeDisplay);
        return titlePanel;
    }

    private JLabel createTimeDisplayLabel() {
        JLabel timeDisplay = new JLabel("", 0);
        timeDisplay.setBackground(CustomColors.DARK_GRAY);
        timeDisplay.setOpaque(true);
        timeDisplay.setFont(FontManager.getRunescapeSmallFont());
        timeDisplay.setForeground(this.offer.isBuy() ? CustomColors.OUTDATED_COLOR : ColorScheme.GRAND_EXCHANGE_PRICE);
        if (!this.offer.isComplete()) {
            timeDisplay.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        }
        if (this.offer.isComplete()) {
            timeDisplay.setText("(" + TimeFormatters.formatDurationTruncated(this.offer.getTime()) + " ago)");
        } else {
            timeDisplay.setText(TimeFormatters.formatDurationTruncated(this.offer.getTime()) + " ago");
        }
        return timeDisplay;
    }

    private JLabel createOfferDescriptionLabel() {
        JLabel offerDescriptionLabel = new JLabel("", 0);
        offerDescriptionLabel.setBackground(CustomColors.DARK_GRAY);
        offerDescriptionLabel.setOpaque(true);
        offerDescriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        if (!this.offer.isComplete()) {
            offerDescriptionLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
            offerDescriptionLabel.setText(QuantityFormatter.formatNumber((long)this.offer.getCurrentQuantityInTrade()) + " " + this.getOfferDescription() + " (ongoing)");
        } else {
            offerDescriptionLabel.setForeground(this.offer.isBuy() ? CustomColors.OUTDATED_COLOR : ColorScheme.GRAND_EXCHANGE_PRICE);
            offerDescriptionLabel.setText(QuantityFormatter.formatNumber((long)this.offer.getCurrentQuantityInTrade()) + " " + this.getOfferDescription());
        }
        return offerDescriptionLabel;
    }

    private JPanel createBodyPanel() {
        JPanel body = new JPanel((LayoutManager)new DynamicGridLayout(3, 0, 0, 2));
        body.setBackground(CustomColors.DARK_GRAY);
        body.setBorder(new EmptyBorder(0, 2, 1, 2));
        JLabel priceLabel = new JLabel("Price:");
        JLabel priceVal = new JLabel(QuantityFormatter.formatNumber((long)this.offer.getPrice()) + " gp", 4);
        JLabel totalPriceLabel = new JLabel("Total:");
        JLabel totalPriceVal = new JLabel(QuantityFormatter.formatNumber((long)(this.offer.getPrice() * this.offer.getCurrentQuantityInTrade())) + " gp", 4);
        JLabel[] descriptions = new JLabel[]{priceLabel, totalPriceLabel};
        JLabel[] vals = new JLabel[]{priceVal, totalPriceVal};
        for (int i = 0; i < descriptions.length; ++i) {
            JLabel descriptionLabel = descriptions[i];
            JLabel valLabel = vals[i];
            descriptionLabel.setFont(FontManager.getRunescapeSmallFont());
            descriptionLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            valLabel.setFont(FontManager.getRunescapeSmallFont());
            valLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            JPanel infoPanel = new JPanel(new BorderLayout());
            infoPanel.setBackground(CustomColors.DARK_GRAY);
            infoPanel.add((Component)descriptionLabel, "West");
            infoPanel.add((Component)valLabel, "East");
            body.add(infoPanel);
        }
        if (!this.plainMode) {
            body.add(this.createIconPanel());
        }
        return body;
    }

    private JPanel createIconPanel() {
        boolean hasRecipe;
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.setBackground(CustomColors.DARK_GRAY);
        boolean bl = hasRecipe = !this.plugin.getApplicableRecipes(this.offer.getItemId(), this.offer.isBuy()).isEmpty();
        if (hasRecipe && this.offer.isComplete()) {
            JLabel deleteIcon = this.createDeleteIcon();
            deleteIcon.setBorder(new EmptyBorder(0, 5, 0, 0));
            iconPanel.add((Component)this.createRecipeFlipIcon(), "East");
            iconPanel.add((Component)deleteIcon, "West");
        } else {
            iconPanel.add((Component)this.createDeleteIcon(), "Center");
        }
        return iconPanel;
    }

    private JComponent createRecipeFlipIcon() {
        PartialOffer po = this.plugin.getOfferIdToPartialOffer(this.item.getItemId()).get(this.offer.getUuid());
        if (po != null && po.amountConsumed == this.offer.getCurrentQuantityInTrade()) {
            JLabel recipeFlipLabel = new JLabel("Fully consumed");
            recipeFlipLabel.setFont(new Font("Whitney", 0, 10));
            recipeFlipLabel.setForeground(CustomColors.TOMATO);
            return recipeFlipLabel;
        }
        JButton recipeFlipButton = new JButton("Recipe Flip +");
        recipeFlipButton.setToolTipText("<html>A recipe flip is when you combine several items into one to sell it, <br>or break apart an item into parts to sell them. <br>If that's what you did with this offer, click me!</html>");
        recipeFlipButton.setFocusPainted(false);
        recipeFlipButton.setFont(new Font("Whitney", 0, 10));
        recipeFlipButton.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        recipeFlipButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OfferPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    JOptionPane.showMessageDialog(null, "You cannot create recipe flips in the Accountwide view");
                    return;
                }
                MasterPanel m = OfferPanel.this.plugin.getMasterPanel();
                RecipeFlipCreationPanel recipeFlipCreationPanel = new RecipeFlipCreationPanel(OfferPanel.this.plugin, OfferPanel.this.offer);
                JDialog recipeFlipCreationModal = UIUtilities.createModalFromPanel((Component)((Object)m), recipeFlipCreationPanel);
                recipeFlipCreationPanel.setModal(recipeFlipCreationModal);
                recipeFlipCreationModal.pack();
                recipeFlipCreationModal.setLocation(Math.max(20, m.getLocationOnScreen().x - recipeFlipCreationModal.getWidth() - 10), Math.max(m.getLocationOnScreen().y - recipeFlipCreationModal.getHeight() / 2, 0) + 100);
                recipeFlipCreationModal.setVisible(true);
            }
        });
        return recipeFlipButton;
    }

    private JLabel createDeleteIcon() {
        final JLabel deleteIcon = new JLabel(Icons.TRASH_CAN_OFF);
        deleteIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OfferPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    JOptionPane.showMessageDialog(null, "You cannot delete offers in the Accountwide view");
                    return;
                }
                int result = JOptionPane.showOptionDialog(deleteIcon, "Are you sure you want to delete this offer?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    OfferPanel.this.plugin.deleteOffers(new ArrayList<OfferEvent>(Arrays.asList(OfferPanel.this.offer)), OfferPanel.this.item);
                    OfferPanel.this.plugin.getStatPanel().rebuildItemsDisplay(OfferPanel.this.plugin.viewItemsForCurrentView());
                    OfferPanel.this.plugin.getStatPanel().rebuildRecipesDisplay(OfferPanel.this.plugin.viewRecipeFlipGroupsForCurrentView());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteIcon.setIcon(Icons.TRASH_CAN_ON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteIcon.setIcon(Icons.TRASH_CAN_OFF);
            }
        });
        return deleteIcon;
    }

    private String getOfferDescription() {
        if (this.offer.isBuy() && this.offer.isMarginCheck()) {
            return "Insta Bought";
        }
        if (this.offer.isBuy() && !this.offer.isMarginCheck()) {
            return "Bought";
        }
        if (!this.offer.isBuy() && this.offer.isMarginCheck()) {
            return "Insta Sold";
        }
        if (!this.offer.isBuy() && !this.offer.isMarginCheck()) {
            return "Sold";
        }
        return "";
    }

    public void setSelected(boolean selected) {
        this.setBorder(this.createBorder(selected));
    }

    private Border createBorder(boolean selected) {
        Color outerBorderColor = selected ? ColorScheme.GRAND_EXCHANGE_PRICE.darker() : ColorScheme.DARKER_GRAY_COLOR.darker();
        return new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, outerBorderColor), new EmptyBorder(1, 3, 3, 3));
    }

    public int getHackySize() {
        int timeDisplayWidth = this.timeDisplay.getText().length() * 8 + 5;
        int gapBetweenDescAndTimeDisplays = 10;
        int descriptionDisplayWidth = this.offerDescriptionLabel.getText().length() * 6 + 5;
        return timeDisplayWidth + gapBetweenDescAndTimeDisplays + descriptionDisplayWidth;
    }
}

