/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.items;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.Flip;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.statistics.items.FlipPanel;
import com.flippingutilities.ui.statistics.items.OfferPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.Paginator;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlippingItemPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(FlippingItemPanel.class);
    private FlippingPlugin plugin;
    private FlippingItem item;
    private StatsPanel statsPanel;
    private JLabel itemProfitAndQuantityLabel = new JLabel();
    private JPanel itemIconTitlePanel = new JPanel(new BorderLayout());
    private JLabel totalProfitValLabel = new JLabel("", 4);
    private JLabel profitEachValLabel = new JLabel("", 4);
    private JLabel quantityFlipped = new JLabel("", 4);
    private JLabel roiValLabel = new JLabel("", 4);
    private JLabel avgBuyPriceValLabel = new JLabel("", 4);
    private JLabel avgSellPriceValLabel = new JLabel("", 4);
    private JLabel quantityBoughtLabel = new JLabel("", 4);
    private JLabel quantitySoldLabel = new JLabel("", 4);
    private List<FlipPanel> flipPanels = new ArrayList<FlipPanel>();
    private List<OfferPanel> offerPanels = new ArrayList<OfferPanel>();
    private Paginator flipPaginator;
    private Paginator offerPaginator;
    private JPanel offersBackgroundPanel = new JPanel();
    private JPanel flipsBackgroundPanel = new JPanel();

    FlippingItemPanel(FlippingPlugin plugin, FlippingItem item) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        this.plugin = plugin;
        this.item = item;
        this.statsPanel = plugin.getStatPanel();
        ArrayList<OfferEvent> offers = item.getIntervalHistory(this.statsPanel.getStartOfInterval());
        Map<String, PartialOffer> offerIdToPartialOffer = plugin.getOfferIdToPartialOffer(item.getItemId());
        List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(offers, offerIdToPartialOffer);
        List<Flip> flips = FlippingItem.getFlips(adjustedOffers);
        this.flipPaginator = this.createPaginator(() -> this.buildAllFlipsPanel(flips));
        this.offerPaginator = this.createPaginator(() -> this.buildAllOffersPanels(offers));
        this.offerPaginator.updateTotalPages(offers.size());
        this.flipPaginator.updateTotalPages(flips.size());
        this.buildAllFlipsPanel(flips);
        this.buildAllOffersPanels(offers);
        JLabel[] descriptionLabels = new JLabel[]{new JLabel("Total Profit: "), new JLabel("Avg. Profit ea: "), new JLabel("Avg. ROI: "), new JLabel("Quantity Flipped: "), new JLabel(" "), new JLabel("Quantity Bought: "), new JLabel("Quantity Sold: "), new JLabel("Avg. Buy Price: "), new JLabel("Avg. Sell Price: ")};
        JLabel[] valueLabels = new JLabel[]{this.totalProfitValLabel, this.profitEachValLabel, this.roiValLabel, this.quantityFlipped, new JLabel(" "), this.quantityBoughtLabel, this.quantitySoldLabel, this.avgBuyPriceValLabel, this.avgSellPriceValLabel};
        JPanel subInfoPanel = this.createSubInfoPanel(descriptionLabels, valueLabels);
        JPanel tradeHistoryPanel = this.createTradeHistoryPanel(this.offersBackgroundPanel, this.flipsBackgroundPanel);
        JPanel subInfoAndHistoryContainer = this.createSubInfoAndHistoryContainer(subInfoPanel, tradeHistoryPanel);
        JPanel titlePanel = this.createTitlePanel(this.createIconPanel(plugin.getItemManager()), this.createNameAndProfitPanel(), this.createCollapseIcon(), subInfoAndHistoryContainer);
        this.updateLabels(offers, adjustedOffers);
        this.add((Component)titlePanel, "North");
        this.add((Component)subInfoAndHistoryContainer, "Center");
    }

    private JPanel createSubInfoAndHistoryContainer(JPanel subInfoPanel, JPanel tradeHistoryPanel) {
        JPanel subInfoAndHistoryContainer = new JPanel(new BorderLayout());
        subInfoAndHistoryContainer.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        subInfoAndHistoryContainer.add((Component)subInfoPanel, "Center");
        subInfoAndHistoryContainer.add((Component)tradeHistoryPanel, "South");
        subInfoAndHistoryContainer.setVisible(this.statsPanel.getExpandedItems().contains(this.item.getItemName()));
        return subInfoAndHistoryContainer;
    }

    private Paginator createPaginator(Runnable runnable) {
        Paginator paginator = new Paginator(runnable);
        paginator.setPageSize(10);
        paginator.setBackground(CustomColors.DARK_GRAY);
        paginator.getStatusText().setFont(FontManager.getRunescapeSmallFont());
        paginator.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        return paginator;
    }

    private void putPanelsOnBackgroundPanel(List<JPanel> panels, JPanel backgroundPanel, Paginator paginator) {
        ArrayList<JPanel> panelsAndPaginator = new ArrayList<JPanel>();
        JPanel paginatorWrapper = new JPanel();
        paginatorWrapper.add(paginator);
        panelsAndPaginator.add(paginatorWrapper);
        panelsAndPaginator.addAll(panels);
        backgroundPanel.removeAll();
        UIUtilities.stackPanelsVertically(panelsAndPaginator, backgroundPanel, 2);
        if (panels.isEmpty()) {
            JPanel labelWrapper = new JPanel();
            JLabel noDataLabel = new JLabel("Nothing here...", 0);
            noDataLabel.setForeground(CustomColors.TOMATO);
            noDataLabel.setFont(new Font("Whitney", 0, 10));
            labelWrapper.add(noDataLabel);
            backgroundPanel.add(labelWrapper);
        }
        this.repaint();
        this.revalidate();
    }

    private void buildAllOffersPanels(List<OfferEvent> offers) {
        ArrayList<OfferEvent> reversedHistory = new ArrayList<OfferEvent>(offers);
        Collections.reverse(reversedHistory);
        List<OfferEvent> offersOnCurrentPage = this.offerPaginator.getCurrentPageItems(reversedHistory);
        this.offerPanels = offersOnCurrentPage.stream().map(offerEvent -> new OfferPanel(this.plugin, this.item, (OfferEvent)offerEvent, false)).collect(Collectors.toList());
        this.putPanelsOnBackgroundPanel(new ArrayList<JPanel>(this.offerPanels), this.offersBackgroundPanel, this.offerPaginator);
    }

    private void buildAllFlipsPanel(List<Flip> flips) {
        ArrayList<Flip> flipsCopy = new ArrayList<Flip>(flips);
        Collections.reverse(flipsCopy);
        List<Flip> flipsOnCurrentPage = this.flipPaginator.getCurrentPageItems(flipsCopy);
        this.flipPanels = flipsOnCurrentPage.stream().map(FlipPanel::new).collect(Collectors.toList());
        this.putPanelsOnBackgroundPanel(new ArrayList<JPanel>(this.flipPanels), this.flipsBackgroundPanel, this.flipPaginator);
    }

    private JPanel createTitlePanel(JPanel itemIconPanel, final JPanel nameAndProfitPanel, final JLabel collapseIcon, final JPanel subInfoAndHistoryContainer) {
        final JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(CustomColors.DARK_GRAY);
        titlePanel.setBorder(new EmptyBorder(5, 4, 5, 4));
        titlePanel.add((Component)itemIconPanel, "West");
        titlePanel.add((Component)nameAndProfitPanel, "Center");
        titlePanel.add((Component)collapseIcon, "East");
        titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (subInfoAndHistoryContainer.isVisible()) {
                        collapseIcon.setIcon(Icons.CLOSE_ICON);
                        subInfoAndHistoryContainer.setVisible(false);
                        FlippingItemPanel.this.statsPanel.getExpandedItems().remove(FlippingItemPanel.this.item.getItemName());
                    } else {
                        collapseIcon.setIcon(Icons.OPEN_ICON);
                        subInfoAndHistoryContainer.setVisible(true);
                        FlippingItemPanel.this.statsPanel.getExpandedItems().add(FlippingItemPanel.this.item.getItemName());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                titlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                nameAndProfitPanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                for (Component component : nameAndProfitPanel.getComponents()) {
                    component.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                }
                FlippingItemPanel.this.itemIconTitlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                titlePanel.setBackground(CustomColors.DARK_GRAY);
                nameAndProfitPanel.setBackground(CustomColors.DARK_GRAY);
                for (Component component : nameAndProfitPanel.getComponents()) {
                    component.setBackground(CustomColors.DARK_GRAY);
                }
                FlippingItemPanel.this.itemIconTitlePanel.setBackground(CustomColors.DARK_GRAY);
            }
        });
        return titlePanel;
    }

    private JPanel createSubInfoPanel(JLabel[] descriptionLabels, JLabel[] valueLabels) {
        JPanel subInfoContainer = new JPanel();
        subInfoContainer.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        subInfoContainer.setLayout((LayoutManager)new DynamicGridLayout(valueLabels.length, descriptionLabels.length));
        subInfoContainer.setBorder(new EmptyBorder(10, 6, 6, 6));
        for (int i = 0; i < descriptionLabels.length; ++i) {
            JLabel textLabel = descriptionLabels[i];
            JLabel valLabel = valueLabels[i];
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)textLabel, "West");
            panel.add((Component)valLabel, "East");
            panel.setBorder(new EmptyBorder(4, 2, 4, 2));
            panel.setBackground(CustomColors.DARK_GRAY_LIGHTER);
            textLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
            textLabel.setFont(FontManager.getRunescapeSmallFont());
            valLabel.setFont(FontManager.getRunescapeSmallFont());
            subInfoContainer.add(panel);
        }
        return subInfoContainer;
    }

    private JPanel createTradeHistoryPanel(JPanel offersPanel, JPanel flipsPanel) {
        boolean shouldExpandTradeHistory = this.statsPanel.getExpandedTradeHistories().contains(this.item.getItemName());
        boolean shouldSelectOffersTab = this.statsPanel.getItemsWithOffersTabSelected().contains(this.item.getItemId());
        final JPanel tradeHistoryTitlePanel = new JPanel(new BorderLayout());
        tradeHistoryTitlePanel.setBackground(CustomColors.DARK_GRAY);
        tradeHistoryTitlePanel.setBorder(new EmptyBorder(4, 0, 4, 0));
        final JPanel mainDisplay = new JPanel();
        final MaterialTabGroup tabGroup = new MaterialTabGroup(mainDisplay);
        MaterialTab offersTab = new MaterialTab("Offers", tabGroup, (JComponent)offersPanel);
        offersTab.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FlippingItemPanel.this.statsPanel.getItemsWithOffersTabSelected().add(FlippingItemPanel.this.item.getItemId());
            }
        });
        MaterialTab flipsTab = new MaterialTab("Flips", tabGroup, (JComponent)flipsPanel);
        flipsTab.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FlippingItemPanel.this.statsPanel.getItemsWithOffersTabSelected().remove(FlippingItemPanel.this.item.getItemId());
            }
        });
        tabGroup.setBorder((Border)new EmptyBorder(5, 0, 7, 0));
        tabGroup.addTab(offersTab);
        tabGroup.addTab(flipsTab);
        tabGroup.select(shouldSelectOffersTab ? offersTab : flipsTab);
        mainDisplay.setVisible(shouldExpandTradeHistory);
        tabGroup.setVisible(shouldExpandTradeHistory);
        final JLabel collapseTradeHistoryIconLabel = new JLabel(shouldExpandTradeHistory ? Icons.OPEN_ICON : Icons.CLOSE_ICON);
        JLabel tradeHistoryTitleLabel = new JLabel("View Trade History", 0);
        tradeHistoryTitleLabel.setFont(new Font("Whitney", 2, 10));
        tradeHistoryTitlePanel.add((Component)tradeHistoryTitleLabel, "Center");
        tradeHistoryTitlePanel.add((Component)collapseTradeHistoryIconLabel, "East");
        tradeHistoryTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (tabGroup.isVisible()) {
                        tabGroup.setVisible(false);
                        mainDisplay.setVisible(false);
                        collapseTradeHistoryIconLabel.setIcon(Icons.CLOSE_ICON);
                        FlippingItemPanel.this.statsPanel.getExpandedTradeHistories().remove(FlippingItemPanel.this.item.getItemName());
                    } else {
                        tabGroup.setVisible(true);
                        mainDisplay.setVisible(true);
                        collapseTradeHistoryIconLabel.setIcon(Icons.OPEN_ICON);
                        FlippingItemPanel.this.statsPanel.getExpandedTradeHistories().add(FlippingItemPanel.this.item.getItemName());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                tradeHistoryTitlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                tradeHistoryTitlePanel.setBackground(CustomColors.DARK_GRAY);
            }
        });
        JPanel tradeHistoryBody = new JPanel(new BorderLayout());
        tradeHistoryBody.add((Component)tabGroup, "North");
        tradeHistoryBody.add((Component)mainDisplay, "Center");
        tradeHistoryBody.setBackground(CustomColors.DARK_GRAY);
        JPanel tradeHistoryPanel = new JPanel(new BorderLayout());
        tradeHistoryPanel.add((Component)tradeHistoryTitlePanel, "North");
        tradeHistoryPanel.add((Component)tradeHistoryBody, "Center");
        return tradeHistoryPanel;
    }

    private JPanel createIconPanel(ItemManager itemManager) {
        final JLabel deleteLabel = new JLabel(Icons.DELETE_ICON);
        deleteLabel.setPreferredSize(new Dimension(24, 24));
        deleteLabel.setVisible(false);
        AsyncBufferedImage itemImage = itemManager.getImage(this.item.getItemId());
        final JLabel itemLabel = new JLabel();
        Runnable resize = () -> {
            BufferedImage subIcon = itemImage.getSubimage(0, 0, 32, 32);
            ImageIcon itemIcon = new ImageIcon(subIcon.getScaledInstance(24, 24, 4));
            itemLabel.setIcon(itemIcon);
        };
        itemImage.onLoaded(resize);
        resize.run();
        this.itemIconTitlePanel.add((Component)itemLabel, "West");
        this.itemIconTitlePanel.add((Component)deleteLabel, "East");
        this.itemIconTitlePanel.setBackground(CustomColors.DARK_GRAY);
        this.itemIconTitlePanel.setBorder(new EmptyBorder(5, 2, 0, 5));
        this.itemIconTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FlippingItemPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    JOptionPane.showMessageDialog(null, "You cannot delete offers in the Accountwide view");
                    return;
                }
                int result = JOptionPane.showOptionDialog(FlippingItemPanel.this.itemIconTitlePanel, "Are you sure you want to delete this item's offers from this time interval?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    FlippingItemPanel.this.deletePanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                itemLabel.setVisible(false);
                deleteLabel.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                itemLabel.setVisible(true);
                deleteLabel.setVisible(false);
            }
        });
        return this.itemIconTitlePanel;
    }

    private JPanel createNameAndProfitPanel() {
        JPanel nameAndProfitPanel = new JPanel(new BorderLayout());
        nameAndProfitPanel.setBackground(CustomColors.DARK_GRAY);
        JLabel itemNameLabel = new JLabel(this.item.getItemName());
        nameAndProfitPanel.add((Component)itemNameLabel, "North");
        nameAndProfitPanel.add((Component)this.itemProfitAndQuantityLabel, "South");
        nameAndProfitPanel.setPreferredSize(new Dimension(0, 0));
        return nameAndProfitPanel;
    }

    private JLabel createCollapseIcon() {
        JLabel collapseIconLabel = new JLabel();
        collapseIconLabel.setIcon(this.statsPanel.getExpandedItems().contains(this.item.getItemName()) ? Icons.OPEN_ICON : Icons.CLOSE_ICON);
        collapseIconLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        return collapseIconLabel;
    }

    public void updateLabels(List<OfferEvent> offers, List<OfferEvent> adjustedOffers) {
        this.quantityFlipped.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.avgBuyPriceValLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.avgSellPriceValLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.quantityBoughtLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.quantitySoldLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        long totalItemsBought = 0L;
        long totalItemsSold = 0L;
        for (OfferEvent offer : offers) {
            if (offer.isBuy()) {
                totalItemsBought += (long)offer.getCurrentQuantityInTrade();
                continue;
            }
            totalItemsSold += (long)offer.getCurrentQuantityInTrade();
        }
        int itemCountFlipped = FlippingItem.countFlipQuantity(adjustedOffers);
        long revenueFromFlippedItems = FlippingItem.getValueOfMatchedOffers(adjustedOffers, false);
        long expenseFromFlippedItems = FlippingItem.getValueOfMatchedOffers(adjustedOffers, true);
        long totalRevenue = FlippingItem.getTotalRevenueOrExpense(offers, false);
        long totalExpense = FlippingItem.getTotalRevenueOrExpense(offers, true);
        long profit = revenueFromFlippedItems - expenseFromFlippedItems;
        this.updateTitleLabels(profit, itemCountFlipped);
        this.updateFlippingLabels(expenseFromFlippedItems, revenueFromFlippedItems, itemCountFlipped);
        this.updateGeneralLabels(totalRevenue, totalExpense, totalItemsBought, totalItemsSold);
        this.updateTimeLabels();
    }

    private void updateTitleLabels(long profitFromFlips, long numItemsFlipped) {
        String totalProfitString = (profitFromFlips >= 0L ? "+" : "") + UIUtilities.quantityToRSDecimalStack(profitFromFlips, true) + " gp";
        totalProfitString = totalProfitString + " (x " + QuantityFormatter.formatNumber((long)numItemsFlipped) + ")";
        this.itemProfitAndQuantityLabel.setText(totalProfitString);
        this.itemProfitAndQuantityLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.itemProfitAndQuantityLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.itemProfitAndQuantityLabel.setFont(FontManager.getRunescapeSmallFont());
    }

    private void updateFlippingLabels(long flippingExpense, long flippingRevenue, int itemsFlipped) {
        long profitFromFlips = flippingRevenue - flippingExpense;
        this.totalProfitValLabel.setText(UIUtilities.quantityToRSDecimalStack(profitFromFlips, true) + " gp");
        this.totalProfitValLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.totalProfitValLabel.setToolTipText(QuantityFormatter.formatNumber((long)profitFromFlips) + " gp");
        String profitEach = UIUtilities.quantityToRSDecimalStack(itemsFlipped > 0 ? profitFromFlips / (long)itemsFlipped : 0L, true) + " gp/ea";
        this.profitEachValLabel.setText(profitEach);
        this.profitEachValLabel.setForeground(profitFromFlips >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.profitEachValLabel.setToolTipText(QuantityFormatter.formatNumber((long)(itemsFlipped > 0 ? profitFromFlips / (long)itemsFlipped : 0L)) + " gp/ea");
        this.quantityFlipped.setText(QuantityFormatter.formatNumber((long)itemsFlipped) + " Items");
        float roi = (float)flippingExpense > 0.0f ? (float)profitFromFlips / (float)flippingExpense * 100.0f : 0.0f;
        this.roiValLabel.setText(String.format("%.2f", Float.valueOf(roi)) + "%");
        this.roiValLabel.setForeground(UIUtilities.gradiatePercentage(roi, this.plugin.getConfig().roiGradientMax()));
        this.roiValLabel.setToolTipText("<html>Return on investment:<br>Percentage of profit relative to gp invested</html>");
    }

    private void updateGeneralLabels(long totalRevenue, long totalExpense, long numBuys, long numSells) {
        this.avgBuyPriceValLabel.setText(QuantityFormatter.formatNumber((long)((int)numBuys > 0 ? totalExpense / numBuys : 0L)) + " gp");
        this.avgSellPriceValLabel.setText(QuantityFormatter.formatNumber((long)((int)numSells > 0 ? totalRevenue / numSells : 0L)) + " gp");
        this.quantityBoughtLabel.setText("" + numBuys);
        this.quantitySoldLabel.setText("" + numSells);
    }

    public void updateTimeLabels() {
        this.flipPanels.forEach(FlipPanel::updateTitleAndTimeDisplay);
        this.offerPanels.forEach(OfferPanel::updateTimeDisplay);
    }

    private void deletePanel() {
        this.statsPanel.deleteItemPanel(this);
    }

    public FlippingItem getItem() {
        return this.item;
    }
}

