/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.items;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.statistics.items.FlippingItemPanel;
import com.flippingutilities.ui.uiutilities.Paginator;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlippingItemContainerPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(FlippingItemContainerPanel.class);
    private JPanel flippingItemPanelsContainer;
    private List<FlippingItemPanel> activePanels = new ArrayList<FlippingItemPanel>();
    private Paginator paginator;
    private FlippingPlugin plugin;

    public FlippingItemContainerPanel(FlippingPlugin flippingPlugin) {
        this.plugin = flippingPlugin;
        this.flippingItemPanelsContainer = this.createStatItemsPanelContainer();
        this.paginator = this.createPaginator();
        JScrollPane scrollPane = this.createScrollPane(this.flippingItemPanelsContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.paginator, "South");
    }

    public void resetPaginator() {
        this.paginator.setPageNumber(1);
    }

    public void rebuild(List<FlippingItem> flippingItems) {
        this.activePanels.clear();
        this.flippingItemPanelsContainer.removeAll();
        this.paginator.updateTotalPages(flippingItems.size());
        if (!flippingItems.isEmpty()) {
            List<FlippingItem> itemsOnCurrentPage = this.paginator.getCurrentPageItems(flippingItems);
            List<JPanel> newPanels = itemsOnCurrentPage.stream().map(item -> new FlippingItemPanel(this.plugin, (FlippingItem)item)).collect(Collectors.toList());
            UIUtilities.stackPanelsVertically(newPanels, this.flippingItemPanelsContainer, 5);
            this.activePanels.addAll(newPanels);
        } else {
            this.flippingItemPanelsContainer.add(this.createHelpLabel());
        }
    }

    public void showPanel(JPanel panel) {
        this.activePanels.clear();
        this.flippingItemPanelsContainer.removeAll();
        this.flippingItemPanelsContainer.add(panel);
    }

    private JLabel createHelpLabel() {
        JLabel helpLabel = new JLabel("<html><body width='220' style='text-align:center;'>Make some trades to see your item history here!");
        helpLabel.setFont(new Font("Whitney", 0, 15));
        helpLabel.setBorder(new EmptyBorder(40, 5, 0, 0));
        helpLabel.setAlignmentX(0.5f);
        return helpLabel;
    }

    private JPanel createStatItemsPanelContainer() {
        JPanel statItemPanelsContainer = new JPanel();
        statItemPanelsContainer.setLayout(new BoxLayout(statItemPanelsContainer, 1));
        return statItemPanelsContainer;
    }

    private JScrollPane createScrollPane(JPanel statItemPanelsContainer) {
        JPanel statItemPanelsContainerWrapper = new JPanel(new BorderLayout());
        statItemPanelsContainerWrapper.setBorder(new EmptyBorder(0, 0, 0, 3));
        statItemPanelsContainerWrapper.add((Component)statItemPanelsContainer, "North");
        JScrollPane scrollPane = new JScrollPane(statItemPanelsContainerWrapper);
        scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(2, 0));
        return scrollPane;
    }

    private Paginator createPaginator() {
        this.paginator = new Paginator(() -> SwingUtilities.invokeLater(() -> {
            StatsPanel statsPanel = this.plugin.getStatPanel();
            Instant rebuildStart = Instant.now();
            this.rebuild(statsPanel.getItemsToDisplay(this.plugin.viewItemsForCurrentView()));
            this.revalidate();
            this.repaint();
            log.debug("page change took {}", (Object)Duration.between(rebuildStart, Instant.now()).toMillis());
        }));
        this.paginator.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.paginator.setBorder(new MatteBorder(1, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR.darker()));
        return this.paginator;
    }

    public void updateTimeDisplay() {
        this.activePanels.forEach(FlippingItemPanel::updateTimeLabels);
    }
}

