/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics.items;

import com.flippingutilities.model.Flip;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class FlipPanel
extends JPanel {
    JLabel title = new JLabel("", 0);
    private Flip flip;

    FlipPanel(Flip flip) {
        JLabel[] labelList;
        this.flip = flip;
        this.setLayout(new BorderLayout());
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        int profitEach = flip.getSellPrice() - flip.getBuyPrice();
        int profitTotal = profitEach * flip.getQuantity();
        this.title.setOpaque(true);
        this.title.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.title.setFont(FontManager.getRunescapeSmallFont());
        this.title.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.updateTitleAndTimeDisplay();
        JLabel buyPriceText = new JLabel("Buy Price:");
        JLabel sellPriceText = new JLabel("Sell Price:");
        JLabel profitText = new JLabel(profitTotal >= 0 ? "Profit: " : "Loss: ");
        JLabel buyPriceVal = new JLabel(QuantityFormatter.formatNumber((long)flip.getBuyPrice()) + " gp", 4);
        JLabel sellPriceVal = new JLabel(QuantityFormatter.formatNumber((long)flip.getSellPrice()) + " gp", 4);
        String profitString = UIUtilities.quantityToRSDecimalStack(profitTotal, true) + " gp" + (String)(flip.getQuantity() <= 1 ? "" : " (" + UIUtilities.quantityToRSDecimalStack(profitEach, false) + " gp ea)");
        JLabel profitVal = new JLabel(profitString);
        for (JLabel label : labelList = new JLabel[]{buyPriceText, buyPriceVal, sellPriceText, sellPriceVal, profitText, profitVal}) {
            label.setFont(FontManager.getRunescapeSmallFont());
            label.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        profitText.setForeground(profitTotal >= 0 ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        profitVal.setForeground(profitTotal >= 0 ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        JPanel buyPricePanel = new JPanel(new BorderLayout());
        buyPricePanel.setBackground(CustomColors.DARK_GRAY);
        JPanel sellPricePanel = new JPanel(new BorderLayout());
        sellPricePanel.setBackground(CustomColors.DARK_GRAY);
        JPanel profitPanel = new JPanel(new BorderLayout());
        profitPanel.setBackground(CustomColors.DARK_GRAY);
        buyPricePanel.add((Component)buyPriceText, "West");
        buyPricePanel.add((Component)buyPriceVal, "East");
        sellPricePanel.add((Component)sellPriceText, "West");
        sellPricePanel.add((Component)sellPriceVal, "East");
        profitPanel.add((Component)profitText, "West");
        profitPanel.add((Component)profitVal, "East");
        JPanel infoContainer = new JPanel((LayoutManager)new DynamicGridLayout(3, 2, 0, 2));
        infoContainer.setBackground(CustomColors.DARK_GRAY);
        infoContainer.add(buyPricePanel);
        infoContainer.add(sellPricePanel);
        infoContainer.add(profitPanel);
        infoContainer.setBorder(new EmptyBorder(0, 2, 1, 2));
        this.add((Component)this.title, "North");
        this.add((Component)infoContainer, "Center");
    }

    public void updateTitleAndTimeDisplay() {
        if (this.flip.isMarginCheck()) {
            this.title.setText("Margin Checked (" + TimeFormatters.formatDurationTruncated(this.flip.getTime()) + " ago)");
            this.title.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        } else if (this.flip.isOngoing()) {
            this.title.setText(QuantityFormatter.formatNumber((long)this.flip.getQuantity()) + " Flipped (ongoing)");
            this.title.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        } else {
            this.title.setText(QuantityFormatter.formatNumber((long)this.flip.getQuantity()) + " Flipped (" + TimeFormatters.formatDurationTruncated(this.flip.getTime()) + " ago)");
            this.title.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        }
    }
}

