/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.statistics;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.statistics.items.FlippingItemContainerPanel;
import com.flippingutilities.ui.statistics.items.FlippingItemPanel;
import com.flippingutilities.ui.statistics.recipes.RecipeFlipGroupPanel;
import com.flippingutilities.ui.statistics.recipes.RecipeGroupContainerPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.FastTabGroup;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.SORT;
import com.flippingutilities.utilities.Searchable;
import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.StyleContext;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(StatsPanel.class);
    private static final String[] TIME_INTERVAL_STRINGS = new String[]{"-1h (Past Hour)", "-4h (Past 4 Hours)", "-12h (Past 12 Hours)", "-1d (Past Day)", "-1w (Past Week)", "-1m (Past Month)", "Session", "All"};
    private static final Dimension ICON_SIZE = new Dimension(16, 16);
    private FlippingPlugin plugin;
    private JPanel subInfoPanel;
    private JComboBox<String> timeIntervalDropdown = this.createTimeIntervalDropdown();
    private JLabel totalProfitVal = new JLabel();
    private final JLabel hourlyProfitText = new JLabel("Hourly Profit: ");
    private final JLabel roiText = new JLabel("ROI: ");
    private final JLabel totalFlipsText = new JLabel("Total Flips Made: ");
    private final JLabel taxPaidText = new JLabel("Tax paid: ");
    private final JLabel sessionTimeText = new JLabel("Session Time: ");
    private final JLabel[] textLabelArray = new JLabel[]{this.hourlyProfitText, this.roiText, this.totalFlipsText, this.taxPaidText, this.sessionTimeText};
    private final JLabel hourlyProfitVal = new JLabel("", 4);
    private final JLabel roiVal = new JLabel("", 4);
    private final JLabel totalFlipsVal = new JLabel("", 4);
    private final JLabel taxPaidVal = new JLabel("", 4);
    private final JLabel sessionTimeVal = new JLabel("", 4);
    private final JLabel[] valLabelArray = new JLabel[]{this.hourlyProfitVal, this.roiVal, this.totalFlipsVal, this.taxPaidVal, this.sessionTimeVal};
    private final JPanel hourlyProfitPanel = new JPanel(new BorderLayout());
    private final JPanel roiPanel = new JPanel(new BorderLayout());
    private final JPanel totalFlipsPanel = new JPanel(new BorderLayout());
    private final JPanel taxPaidPanel = new JPanel(new BorderLayout());
    private final JPanel sessionTimePanel = new JPanel(new BorderLayout());
    private final JPanel[] subInfoPanelArray = new JPanel[]{this.hourlyProfitPanel, this.roiPanel, this.totalFlipsPanel, this.taxPaidPanel, this.sessionTimePanel};
    private Instant startOfInterval;
    private String startOfIntervalName = "Session";
    private SORT selectedSort = SORT.TIME;
    private Set<String> expandedItems = new HashSet<String>();
    private Set<String> expandedTradeHistories = new HashSet<String>();
    private Set<Integer> itemsWithOffersTabSelected = new HashSet<Integer>();
    private boolean currentlySearching;
    private IconTextField searchBar;
    private FlippingItemContainerPanel flippingItemContainerPanel;
    private RecipeGroupContainerPanel recipeGroupContainerPanel;

    public StatsPanel(FlippingPlugin plugin) {
        super(false);
        this.plugin = plugin;
        this.startOfInterval = plugin.viewStartOfSessionForCurrentView();
        this.prepareLabels();
        this.searchBar = this.createSearchBar();
        this.flippingItemContainerPanel = new FlippingItemContainerPanel(plugin);
        this.recipeGroupContainerPanel = new RecipeGroupContainerPanel(plugin);
        JPanel mainDisplay = new JPanel();
        FastTabGroup tabGroup = this.createTabGroup(mainDisplay, this.flippingItemContainerPanel, this.recipeGroupContainerPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTopPanel(this.searchBar), "North");
        this.add((Component)this.createTabGroupContainer(tabGroup, mainDisplay), "Center");
        this.setBorder(new EmptyBorder(5, 7, 0, 7));
    }

    private JPanel createTabGroupContainer(FastTabGroup tabGroup, JPanel mainDisplay) {
        JPanel tabGroupContainer = new JPanel(new BorderLayout());
        JPanel tabGroupPanel = new JPanel(new BorderLayout());
        tabGroupPanel.add((Component)((Object)tabGroup), "Center");
        tabGroupPanel.add((Component)this.createSortIcon(), "East");
        tabGroupContainer.add((Component)tabGroupPanel, "North");
        tabGroupContainer.add((Component)mainDisplay, "Center");
        return tabGroupContainer;
    }

    private JLabel createSortIcon() {
        final JLabel sortIcon = new JLabel(Icons.SORT);
        sortIcon.setBorder(new EmptyBorder(0, 0, 0, 15));
        sortIcon.setToolTipText("Use this to sort the list!");
        final JPopupMenu popupMenu = new JPopupMenu("Sort");
        ButtonGroup group = new ButtonGroup();
        Stream.of(SORT.values()).forEach(sortEnum -> {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(sortEnum.name().replace("_", " "));
            menuItem.setFont(new Font("Whitney", 0, 12));
            group.add(menuItem);
            if (sortEnum == SORT.TIME) {
                menuItem.setSelected(true);
            }
            menuItem.addItemListener(i -> {
                if (i.getStateChange() == 1) {
                    this.selectedSort = sortEnum;
                    this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
                    this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
                }
            });
            popupMenu.add(menuItem);
        });
        sortIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    popupMenu.show(sortIcon, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                sortIcon.setIcon(Icons.SORT_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                sortIcon.setIcon(Icons.SORT);
            }
        });
        return sortIcon;
    }

    private FastTabGroup createTabGroup(JPanel mainDisplay, FlippingItemContainerPanel statItemTabPanel, RecipeGroupContainerPanel recipeTabPanel) {
        FastTabGroup tabGroup = new FastTabGroup(mainDisplay);
        tabGroup.setBorder(new EmptyBorder(0, 31, 0, 0));
        MaterialTab statItemTab = new MaterialTab("Items", (MaterialTabGroup)tabGroup, (JComponent)statItemTabPanel);
        MaterialTab RecipeTab = new MaterialTab("Recipes", (MaterialTabGroup)tabGroup, (JComponent)recipeTabPanel);
        tabGroup.addTab(statItemTab);
        tabGroup.addTab(RecipeTab);
        tabGroup.select(statItemTab);
        return tabGroup;
    }

    public void resetPaginators() {
        this.flippingItemContainerPanel.resetPaginator();
        this.recipeGroupContainerPanel.resetPaginator();
    }

    public void rebuildItemsDisplay(List<FlippingItem> flippingItems) {
        SwingUtilities.invokeLater(() -> {
            List<FlippingItem> itemsToDisplay = this.getItemsToDisplay(flippingItems);
            this.flippingItemContainerPanel.rebuild(itemsToDisplay);
            this.updateCumulativeDisplays(itemsToDisplay, this.getRecipeFlipGroupsToDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView()));
            if (itemsToDisplay.isEmpty() && this.currentlySearching) {
                this.flippingItemContainerPanel.showPanel(this.createEmptySearchPanel());
            }
            this.revalidate();
            this.repaint();
        });
    }

    public void rebuildRecipesDisplay(List<RecipeFlipGroup> recipeFlipGroups) {
        SwingUtilities.invokeLater(() -> {
            List<RecipeFlipGroup> recipeFlipGroupsToDisplay = this.getRecipeFlipGroupsToDisplay(recipeFlipGroups);
            this.recipeGroupContainerPanel.rebuild(recipeFlipGroupsToDisplay);
            this.updateCumulativeDisplays(this.getItemsToDisplay(this.plugin.viewItemsForCurrentView()), recipeFlipGroupsToDisplay);
            if (recipeFlipGroupsToDisplay.isEmpty() && this.currentlySearching) {
                this.recipeGroupContainerPanel.showPanel(this.createEmptySearchPanel());
            }
            this.revalidate();
            this.repaint();
        });
    }

    private JPanel createEmptySearchPanel() {
        JPanel emptySearchPanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1));
        emptySearchPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        String lookup = this.searchBar.getText().toLowerCase();
        JLabel searchLabel = new JLabel(String.format("<html><body style='text-align: center'>The search for <br> <b><u>%s</u></b> <br> yielded no results :(</html>", lookup), 0);
        searchLabel.setFont(new Font("Whitney", 0, 12));
        searchLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        emptySearchPanel.add(searchLabel);
        emptySearchPanel.add(new JLabel(Icons.GNOME_CHILD));
        return emptySearchPanel;
    }

    private void updateSearch(IconTextField searchBar) {
        String lookup = searchBar.getText().toLowerCase();
        if (Strings.isNullOrEmpty((String)lookup)) {
            searchBar.setIcon(IconTextField.Icon.SEARCH);
            this.currentlySearching = false;
            this.flippingItemContainerPanel.resetPaginator();
            this.recipeGroupContainerPanel.resetPaginator();
            this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
            this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
            return;
        }
        this.currentlySearching = true;
        this.flippingItemContainerPanel.resetPaginator();
        this.recipeGroupContainerPanel.resetPaginator();
        this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
        this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
    }

    private <T extends Searchable> List<T> getSearchResults(List<T> objs, String lookup) {
        return objs.stream().filter(obj -> obj.getNameForSearch().toLowerCase().contains(lookup) && obj.isInInterval(this.startOfInterval)).collect(Collectors.toList());
    }

    private <T extends Searchable> List<T> getResultsForCurrentSearchQuery(List<T> objs) {
        String lookup = this.searchBar.getText().toLowerCase();
        if (this.currentlySearching && !Strings.isNullOrEmpty((String)lookup)) {
            return this.getSearchResults(objs, lookup);
        }
        return objs;
    }

    public List<FlippingItem> getItemsToDisplay(List<FlippingItem> items) {
        return this.plugin.sortItems(this.getResultsForCurrentSearchQuery(this.getObjsInInterval(items)), this.selectedSort, this.startOfInterval);
    }

    public List<RecipeFlipGroup> getRecipeFlipGroupsToDisplay(List<RecipeFlipGroup> recipeFlipGroups) {
        return this.plugin.sortRecipeFlipGroups(this.getResultsForCurrentSearchQuery(this.getObjsInInterval(recipeFlipGroups)), this.selectedSort, this.startOfInterval);
    }

    private IconTextField createSearchBar() {
        IconTextField searchBar = UIUtilities.createSearchBar(this.plugin.getExecutor(), this::updateSearch);
        searchBar.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        return searchBar;
    }

    private JComboBox createTimeIntervalDropdown() {
        JComboBox<String> timeIntervalDropdown = new JComboBox<String>(TIME_INTERVAL_STRINGS);
        timeIntervalDropdown.setRenderer((ListCellRenderer<String>)new ComboBoxListRenderer());
        timeIntervalDropdown.setEditable(true);
        timeIntervalDropdown.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        timeIntervalDropdown.setBackground(CustomColors.DARK_GRAY_LIGHTER);
        timeIntervalDropdown.setSelectedItem("Session");
        timeIntervalDropdown.setToolTipText("Specify the time span you would like to see the statistics of");
        timeIntervalDropdown.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                ItemListener[] itemListeners;
                String interval = (String)event.getItem();
                if (interval == null) {
                    return;
                }
                String justTheInterval = interval.split(" \\(")[0];
                for (ItemListener listener : itemListeners = timeIntervalDropdown.getItemListeners()) {
                    timeIntervalDropdown.removeItemListener(listener);
                }
                timeIntervalDropdown.setSelectedItem(justTheInterval);
                for (ItemListener itemListener : itemListeners) {
                    timeIntervalDropdown.addItemListener(itemListener);
                }
                this.setTimeInterval(justTheInterval);
            }
        });
        return timeIntervalDropdown;
    }

    public void updateCumulativeDisplays(List<FlippingItem> tradesList, List<RecipeFlipGroup> recipeFlipGroups) {
        if (!Objects.equals(this.timeIntervalDropdown.getSelectedItem(), "Session")) {
            this.subInfoPanel.remove(this.sessionTimePanel);
            this.subInfoPanel.remove(this.hourlyProfitPanel);
        } else {
            this.subInfoPanel.add(this.sessionTimePanel);
            this.subInfoPanel.add(this.hourlyProfitPanel);
        }
        long totalProfit = 0L;
        long totalExpenses = 0L;
        long totalFlips = 0L;
        long taxPaid = 0L;
        for (FlippingItem item : tradesList) {
            Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer(item.getItemId());
            ArrayList<OfferEvent> intervalHistory = item.getIntervalHistory(this.startOfInterval);
            if (intervalHistory.isEmpty()) continue;
            List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(intervalHistory, offerIdToPartialOffer);
            taxPaid += adjustedOffers.stream().mapToLong(OfferEvent::getTaxPaid).sum();
            totalProfit += FlippingItem.getProfit(adjustedOffers);
            totalExpenses += FlippingItem.getValueOfMatchedOffers(adjustedOffers, true);
            totalFlips += (long)FlippingItem.getFlips(adjustedOffers).size();
        }
        for (RecipeFlipGroup recipeFlipGroup : recipeFlipGroups) {
            List<RecipeFlip> recipeFlips = recipeFlipGroup.getFlipsInInterval(this.startOfInterval);
            if (recipeFlips.isEmpty()) continue;
            taxPaid += recipeFlips.stream().mapToLong(RecipeFlip::getTaxPaid).sum();
            totalProfit += recipeFlips.stream().mapToLong(RecipeFlip::getProfit).sum();
            totalExpenses += recipeFlips.stream().mapToLong(RecipeFlip::getExpense).sum();
            totalFlips += (long)recipeFlips.size();
        }
        this.updateTotalProfitDisplay(totalProfit);
        if (Objects.equals(this.timeIntervalDropdown.getSelectedItem(), "Session")) {
            Duration accumulatedTime = this.plugin.viewAccumulatedTimeForCurrentView();
            this.updateSessionTimeDisplay(accumulatedTime);
            this.updateHourlyProfitDisplay(totalProfit, accumulatedTime);
        }
        this.updateRoiDisplay(totalProfit, totalExpenses);
        this.updateTotalFlipsDisplay(totalFlips);
        this.updateTaxPaidDisplay(taxPaid);
    }

    private void updateTotalProfitDisplay(long totalProfit) {
        if (this.plugin.viewItemsForCurrentView() == null) {
            this.totalProfitVal.setText("0");
            this.totalProfitVal.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            this.totalProfitVal.setToolTipText("Total Profit: 0 gp");
            return;
        }
        this.totalProfitVal.setText((totalProfit >= 0L ? "" : "-") + UIUtilities.quantityToRSDecimalStack(Math.abs(totalProfit), true) + " gp");
        this.totalProfitVal.setToolTipText("Total Profit: " + QuantityFormatter.formatNumber((long)totalProfit) + " gp");
        if (totalProfit < 0L) {
            this.totalProfitVal.setForeground(CustomColors.OUTDATED_COLOR);
        } else if (totalProfit <= 100000L) {
            this.totalProfitVal.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        } else if (totalProfit <= 10000000L) {
            this.totalProfitVal.setForeground(CustomColors.OFF_WHITE);
        } else {
            this.totalProfitVal.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        }
    }

    private void updateHourlyProfitDisplay(long totalProfit, Duration accumulatedTime) {
        double divisor = (double)(accumulatedTime.toMillis() / 1000L) * 1.0 / 3600.0;
        String profitString = divisor != 0.0 ? UIUtilities.quantityToRSDecimalStack((long)((double)totalProfit / divisor), true) : "0";
        this.hourlyProfitVal.setText(profitString + " gp/hr");
        this.hourlyProfitVal.setForeground(totalProfit >= 0L ? ColorScheme.GRAND_EXCHANGE_PRICE : CustomColors.OUTDATED_COLOR);
        this.hourlyProfitPanel.setToolTipText("Hourly profit as determined by the session time");
    }

    private void updateRoiDisplay(long totalProfit, long totalExpenses) {
        float roi = (float)totalProfit / (float)totalExpenses * 100.0f;
        if (totalExpenses == 0L) {
            this.roiVal.setText("0.00%");
            this.roiVal.setForeground(CustomColors.TOMATO);
            return;
        }
        this.roiVal.setText(String.format("%.2f", Float.valueOf((float)totalProfit / (float)totalExpenses * 100.0f)) + "%");
        this.roiVal.setForeground(UIUtilities.gradiatePercentage(roi, this.plugin.getConfig().roiGradientMax()));
        this.roiPanel.setToolTipText("<html>Return on investment:<br>Percentage of profit relative to gp invested</html>");
    }

    private void updateTotalFlipsDisplay(long totalFlips) {
        this.totalFlipsVal.setText(QuantityFormatter.formatNumber((long)totalFlips));
        this.totalFlipsVal.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.totalFlipsPanel.setToolTipText("<html>Total amount of flips completed<br>Does not count margin checks</html>");
    }

    private void updateTaxPaidDisplay(long taxPaid) {
        String taxPaidText = UIUtilities.quantityToRSDecimalStack(taxPaid, true) + " gp";
        this.taxPaidVal.setText(taxPaidText);
        this.taxPaidVal.setToolTipText("Tax paid after its implementation");
        this.taxPaidVal.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.taxPaidPanel.setToolTipText("<html>Tax paid after its implementation</html>");
    }

    public void updateTimeDisplay() {
        this.flippingItemContainerPanel.updateTimeDisplay();
        this.recipeGroupContainerPanel.updateTimeDisplay();
    }

    public void updateSessionTimeDisplay(Duration accumulatedTime) {
        this.sessionTimeVal.setText(TimeFormatters.formatDuration(accumulatedTime));
    }

    public void deleteItemPanel(FlippingItemPanel itemPanel) {
        FlippingItem item = itemPanel.getItem();
        this.plugin.deleteOffers(item.getIntervalHistory(this.startOfInterval), item);
        this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
        this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
    }

    public void deleteRecipeFlipGroupPanel(RecipeFlipGroupPanel recipeFlipGroupPanel) {
        recipeFlipGroupPanel.getRecipeFlipGroup().deleteFlips(this.startOfInterval);
        this.plugin.setUpdateSinceLastRecipeFlipGroupAccountWideBuild(true);
        this.plugin.markAccountTradesAsHavingChanged(this.plugin.getAccountCurrentlyViewed());
        this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
        this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
    }

    public void setTimeInterval(String selectedInterval) {
        if (selectedInterval == null) {
            return;
        }
        Instant timeNow = Instant.now();
        if (selectedInterval.equals("Session")) {
            this.startOfInterval = this.plugin.viewStartOfSessionForCurrentView();
            this.startOfIntervalName = "Session";
        } else if (selectedInterval.equals("All")) {
            this.startOfInterval = Instant.EPOCH;
            this.startOfIntervalName = "All";
        } else {
            if (selectedInterval.length() < 3) {
                JOptionPane.showMessageDialog(this.timeIntervalDropdown, "Invalid input. Valid input is a negative whole number followed by an abbreviated unit of time. For example,-123h or -2d or -55w or -2m or -1y are valid inputs.", "Invalid Input", 0);
                return;
            }
            String timeUnitString = String.valueOf(selectedInterval.charAt(selectedInterval.length() - 1));
            if (!TimeFormatters.stringToTimeUnit.containsKey((Object)timeUnitString)) {
                JOptionPane.showMessageDialog(this.timeIntervalDropdown, "Invalid input. Valid input is a negative whole number followed by an abbreviated unit of time. For example,-123h or -2d or -55w or -2m or -1y are valid inputs.", "Invalid Input", 0);
                return;
            }
            try {
                int amountToSubtract = Integer.parseInt(selectedInterval.substring(1, selectedInterval.length() - 1)) * (Integer)TimeFormatters.stringToTimeUnit.get((Object)timeUnitString);
                this.startOfInterval = timeNow.minus(amountToSubtract, ChronoUnit.HOURS);
                this.startOfIntervalName = selectedInterval;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.timeIntervalDropdown, "Invalid input. Valid input is a negative whole number followed by an abbreviated unit of time. For example,-123h or -2d or -55w or -2m or -1y are valid inputs.", "Invalid Input", 0);
                return;
            }
        }
        this.flippingItemContainerPanel.resetPaginator();
        this.recipeGroupContainerPanel.resetPaginator();
        this.rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
        this.rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
    }

    private void updateSubInfoFont() {
        for (int i = 0; i < this.textLabelArray.length; ++i) {
            this.textLabelArray[i].setFont(this.plugin.getFont());
            this.valLabelArray[i].setFont(this.plugin.getFont());
        }
    }

    private <T extends Searchable> List<T> getObjsInInterval(List<T> objs) {
        return objs.stream().filter(obj -> obj.isInInterval(this.startOfInterval)).collect(Collectors.toList());
    }

    private JLabel createResetButton() {
        final JLabel resetIcon = new JLabel(Icons.TRASH_ICON_OFF);
        resetIcon.setBorder(new EmptyBorder(0, 12, 0, 0));
        resetIcon.setPreferredSize(Icons.ICON_SIZE);
        resetIcon.setToolTipText("Reset Statistics");
        resetIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int result;
                if (SwingUtilities.isLeftMouseButton(e) && (result = JOptionPane.showOptionDialog(resetIcon, "<html>Are you sure you want to reset the statistics?<br>This only resets the statistics within the currently selected time interval</html>", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No")) == 0) {
                    StatsPanel.this.plugin.deleteOffers(StatsPanel.this.startOfInterval);
                    StatsPanel.this.rebuildItemsDisplay(StatsPanel.this.plugin.viewItemsForCurrentView());
                    StatsPanel.this.rebuildRecipesDisplay(StatsPanel.this.plugin.viewRecipeFlipGroupsForCurrentView());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                resetIcon.setIcon(Icons.TRASH_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                resetIcon.setIcon(Icons.TRASH_ICON_OFF);
            }
        });
        return resetIcon;
    }

    private JLabel createDownloadButton() {
        final StatsPanel parent = this;
        final JLabel downloadIcon = new JLabel(Icons.DONWLOAD_ICON_OFF);
        downloadIcon.setBorder(new EmptyBorder(0, 12, 0, 0));
        downloadIcon.setPreferredSize(Icons.ICON_SIZE);
        downloadIcon.setToolTipText("Export to CSV");
        downloadIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JFileChooser f = new JFileChooser();
                f.setFileSelectionMode(1);
                f.showSaveDialog(parent);
                File selectedDirectory = f.getSelectedFile();
                if (selectedDirectory == null) {
                    return;
                }
                log.info("exporting to csv in folder {}", (Object)f.getSelectedFile());
                try {
                    StatsPanel.this.plugin.exportToCsv(f.getSelectedFile(), StatsPanel.this.startOfInterval, StatsPanel.this.startOfIntervalName);
                    JOptionPane.showMessageDialog(parent, String.format("Successfully saved csv file to %s/%s.csv", f.getSelectedFile().toString(), StatsPanel.this.plugin.getAccountCurrentlyViewed()), "Successfully saved CSV!", 1);
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(parent, String.format("Could not save CSV file. Error: %s", exc.toString()), "Could not save csv file", 0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                downloadIcon.setIcon(Icons.DOWNLOAD_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                downloadIcon.setIcon(Icons.DONWLOAD_ICON_OFF);
            }
        });
        return downloadIcon;
    }

    private JPanel createTopPanel(IconTextField searchBar) {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel searchAndDownloadPanel = new JPanel(new BorderLayout());
        searchAndDownloadPanel.add((Component)searchBar, "Center");
        searchAndDownloadPanel.add((Component)this.createResetButton(), "East");
        searchAndDownloadPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel timeIntervalDropdownAndResetPanel = new JPanel(new BorderLayout());
        timeIntervalDropdownAndResetPanel.add(this.timeIntervalDropdown, "Center");
        timeIntervalDropdownAndResetPanel.add((Component)this.createDownloadButton(), "East");
        topPanel.add((Component)timeIntervalDropdownAndResetPanel, "North");
        topPanel.add((Component)searchAndDownloadPanel, "Center");
        topPanel.add((Component)this.createProfitAndSubInfoContainer(), "South");
        topPanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return topPanel;
    }

    private void prepareLabels() {
        Arrays.stream(this.textLabelArray).forEach(l -> l.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH));
        this.sessionTimeVal.setText(TimeFormatters.formatDuration(this.plugin.viewAccumulatedTimeForCurrentView()));
        this.sessionTimeVal.setPreferredSize(new Dimension(200, 0));
        this.sessionTimeVal.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        this.totalProfitVal.setFont(StyleContext.getDefaultStyleContext().getFont(FontManager.getRunescapeBoldFont().getName(), 0, 28));
        this.totalProfitVal.setHorizontalAlignment(0);
        this.totalProfitVal.setToolTipText("");
        this.updateSubInfoFont();
    }

    private JPanel createTotalProfitPanel(final JPanel subInfoPanel) {
        JLabel profitText = new JLabel("Total Profit: ", 0);
        profitText.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        profitText.setFont(FontManager.getRunescapeBoldFont());
        final JLabel arrowIcon = new JLabel(Icons.OPEN_ICON);
        arrowIcon.setPreferredSize(ICON_SIZE);
        JLabel padLabel = new JLabel();
        padLabel.setPreferredSize(ICON_SIZE);
        final JPanel profitTextAndVal = new JPanel(new BorderLayout());
        profitTextAndVal.setBackground(CustomColors.DARK_GRAY);
        profitTextAndVal.setBorder(new EmptyBorder(5, 0, 3, 0));
        profitTextAndVal.add((Component)this.totalProfitVal, "Center");
        profitTextAndVal.add((Component)profitText, "North");
        final JPanel totalProfitPanel = new JPanel(new BorderLayout());
        totalProfitPanel.setBackground(CustomColors.DARK_GRAY);
        totalProfitPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(7, 0, 7, 0)));
        totalProfitPanel.add((Component)profitTextAndVal, "Center");
        totalProfitPanel.add((Component)arrowIcon, "East");
        totalProfitPanel.add((Component)padLabel, "West");
        MouseAdapter collapseOnClick = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (subInfoPanel.isVisible()) {
                        arrowIcon.setIcon(Icons.CLOSE_ICON);
                        subInfoPanel.setVisible(false);
                        totalProfitPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(7, 0, 7, 0)));
                    } else {
                        arrowIcon.setIcon(Icons.OPEN_ICON);
                        subInfoPanel.setVisible(true);
                        totalProfitPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(7, 0, 7, 0)));
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                totalProfitPanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                profitTextAndVal.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                totalProfitPanel.setBackground(CustomColors.DARK_GRAY);
                profitTextAndVal.setBackground(CustomColors.DARK_GRAY);
            }
        };
        totalProfitPanel.addMouseListener(collapseOnClick);
        this.totalProfitVal.addMouseListener(collapseOnClick);
        return totalProfitPanel;
    }

    private JPanel createSubInfoPanel() {
        JPanel subInfoPanel = new JPanel();
        subInfoPanel.setLayout((LayoutManager)new DynamicGridLayout(this.subInfoPanelArray.length, 1));
        for (JPanel panel : this.subInfoPanelArray) {
            panel.setBorder(new EmptyBorder(4, 2, 4, 2));
            panel.setBackground(CustomColors.DARK_GRAY);
            if (panel == this.hourlyProfitPanel || panel == this.sessionTimePanel) continue;
            subInfoPanel.add(panel);
        }
        for (int i = 0; i < this.subInfoPanelArray.length; ++i) {
            this.subInfoPanelArray[i].add((Component)this.textLabelArray[i], "West");
            this.subInfoPanelArray[i].add((Component)this.valLabelArray[i], "East");
        }
        subInfoPanel.setBackground(CustomColors.DARK_GRAY);
        subInfoPanel.setBorder(new EmptyBorder(9, 5, 5, 5));
        subInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 2, 2, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(2, 5, 5, 5)));
        return subInfoPanel;
    }

    private JPanel createProfitAndSubInfoContainer() {
        this.subInfoPanel = this.createSubInfoPanel();
        JPanel profitAndSubInfoContainer = new JPanel(new BorderLayout());
        profitAndSubInfoContainer.add((Component)this.createTotalProfitPanel(this.subInfoPanel), "North");
        profitAndSubInfoContainer.add((Component)this.subInfoPanel, "South");
        profitAndSubInfoContainer.setBorder(new EmptyBorder(5, 0, 5, 0));
        return profitAndSubInfoContainer;
    }

    public Instant getStartOfInterval() {
        return this.startOfInterval;
    }

    public String getStartOfIntervalName() {
        return this.startOfIntervalName;
    }

    public SORT getSelectedSort() {
        return this.selectedSort;
    }

    public Set<String> getExpandedItems() {
        return this.expandedItems;
    }

    public Set<String> getExpandedTradeHistories() {
        return this.expandedTradeHistories;
    }

    public Set<Integer> getItemsWithOffersTabSelected() {
        return this.itemsWithOffersTabSelected;
    }
}

