/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.slots;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.slots.SlotPanel;
import com.flippingutilities.ui.uiutilities.QuickLookPanel;
import com.flippingutilities.utilities.WikiRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SlotsPanel.class);
    FlippingPlugin plugin;
    private List<SlotPanel> slotPanels;
    private ItemManager itemManager;
    JLabel statusText = new JLabel();
    JPopupMenu popup = new JPopupMenu();
    QuickLookPanel quickLookPanel = new QuickLookPanel();

    public SlotsPanel(FlippingPlugin plugin, ItemManager im) {
        this.popup.add(this.quickLookPanel);
        this.plugin = plugin;
        this.itemManager = im;
        this.setLayout(new BoxLayout(this, 1));
        this.slotPanels = new ArrayList<SlotPanel>();
        JPanel slotPanelsContainer = new JPanel();
        slotPanelsContainer.setLayout(new BoxLayout(slotPanelsContainer, 1));
        for (int i = 0; i < 8; ++i) {
            Component verticalGap = Box.createVerticalStrut(10);
            SlotPanel slotPanel = new SlotPanel(plugin, verticalGap, this.popup, this.quickLookPanel);
            this.slotPanels.add(slotPanel);
            slotPanelsContainer.add(slotPanel);
            slotPanelsContainer.add(verticalGap);
        }
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(new EmptyBorder(10, 10, 10, 10));
        wrapper.add((Component)slotPanelsContainer, "North");
        JScrollPane jScrollPane = new JScrollPane(wrapper);
        jScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(5, 0));
        this.statusText.setAlignmentX(0.5f);
        this.statusText.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.statusText.setFont(FontManager.getRunescapeSmallFont());
        this.statusText.setText("No currently active slots");
        this.add((Component)this.statusText, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void updateTimerDisplays(int slotIndex, String timeString) {
        this.slotPanels.get(slotIndex).updateTimer(timeString);
    }

    public void onWikiRequest(WikiRequest wikiRequest) {
        for (SlotPanel slotPanel : this.slotPanels) {
            slotPanel.onWikiRequest(wikiRequest);
        }
    }

    public void update(OfferEvent newOfferEvent) {
        int slot = newOfferEvent.getSlot();
        SlotPanel slotPanel = this.slotPanels.get(slot);
        if (slotPanel.shouldNotUpdate(newOfferEvent)) {
            return;
        }
        slotPanel.offerEvent = newOfferEvent;
        if (newOfferEvent.isCausedByEmptySlot()) {
            slotPanel.reset();
        } else if (slotPanel.itemId == newOfferEvent.getItemId()) {
            slotPanel.update(null, null, newOfferEvent);
        } else {
            ItemComposition itemComposition = this.itemManager.getItemComposition(newOfferEvent.getItemId());
            boolean shouldStack = itemComposition.isStackable() || newOfferEvent.getTotalQuantityInTrade() > 1;
            AsyncBufferedImage itemImage = this.itemManager.getImage(newOfferEvent.getItemId(), newOfferEvent.getTotalQuantityInTrade(), shouldStack);
            String itemName = itemComposition.getName();
            slotPanel.update((BufferedImage)itemImage, itemName, newOfferEvent);
        }
        boolean activeSlots = this.slotPanels.stream().anyMatch(s -> s.itemId != 0);
        this.statusText.setVisible(!activeSlots);
    }
}

