/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.slots;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.QuickLookPanel;
import com.flippingutilities.utilities.SlotInfo;
import com.flippingutilities.utilities.SlotPredictedState;
import com.flippingutilities.utilities.WikiItemMargins;
import com.flippingutilities.utilities.WikiRequest;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ThinProgressBar;
import net.runelite.client.util.QuantityFormatter;

public class SlotPanel
extends JPanel {
    public int itemId;
    public OfferEvent offerEvent;
    private ThinProgressBar progressBar = new ThinProgressBar();
    private JLabel itemName = new JLabel();
    private JLabel itemIcon = new JLabel();
    private JLabel price = new JLabel();
    private JLabel state = new JLabel();
    private JLabel action = new JLabel();
    private JLabel timer = new JLabel();
    private Component verticalGap;
    WikiRequest wikiRequest;
    List<JPanel> panelsToColor;
    boolean hasDrawnStatus = false;
    JPopupMenu popup;
    QuickLookPanel quickLookPanel;
    FlippingPlugin plugin;

    public SlotPanel(FlippingPlugin plugin, Component verticalGap, final JPopupMenu popup, QuickLookPanel quickLookPanel) {
        this.plugin = plugin;
        this.popup = popup;
        this.verticalGap = verticalGap;
        this.quickLookPanel = quickLookPanel;
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(10, 10, 0, 10)));
        this.price.setHorizontalAlignment(0);
        this.price.setFont(FontManager.getRunescapeSmallFont());
        this.price.setBorder(new EmptyBorder(0, 16, 0, 0));
        this.state.setFont(FontManager.getRunescapeSmallFont());
        this.action.setFont(FontManager.getRunescapeBoldFont());
        this.action.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        this.timer.setFont(FontManager.getRunescapeSmallFont());
        this.progressBar.setForeground(CustomColors.DARK_GRAY);
        this.progressBar.setMaximumValue(100);
        this.progressBar.setValue(0);
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        this.progressBar.setMinimumSize(new Dimension(0, 10));
        this.progressBar.setPreferredSize(new Dimension(0, 10));
        this.progressBar.setSize(new Dimension(0, 10));
        this.progressBar.setBorder((Border)new CompoundBorder(new MatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(0, 23, 0, 23)));
        this.add((Component)this.itemIcon, "West");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        topPanel.setBackground(CustomColors.DARK_GRAY);
        topPanel.add((Component)this.action, "West");
        topPanel.add((Component)this.timer, "East");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(CustomColors.DARK_GRAY);
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(this.itemName);
        centerPanel.add(Box.createVerticalStrut(3));
        centerPanel.add(this.state);
        this.add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EmptyBorder(10, 5, 5, 5));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBackground(CustomColors.DARK_GRAY);
        bottomPanel.add((Component)this.progressBar);
        bottomPanel.add(Box.createVerticalStrut(10));
        JPanel priceAndMagnifyingGlassPanel = new JPanel(new BorderLayout());
        priceAndMagnifyingGlassPanel.setBackground(CustomColors.DARK_GRAY);
        final JLabel magnifyingGlassIcon = new JLabel(Icons.MAGNIFYING_GLASS);
        magnifyingGlassIcon.setVisible(false);
        magnifyingGlassIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SlotPanel.this.updateQuickLookPanel();
                magnifyingGlassIcon.setIcon(Icons.MAGNIFYING_GLASS_HOVER);
                Point location = magnifyingGlassIcon.getLocationOnScreen();
                int y = location.y - popup.getHeight();
                popup.setLocation(location.x, y);
                popup.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                magnifyingGlassIcon.setIcon(Icons.MAGNIFYING_GLASS);
                popup.setVisible(false);
            }
        });
        priceAndMagnifyingGlassPanel.add((Component)this.price, "Center");
        priceAndMagnifyingGlassPanel.add((Component)magnifyingGlassIcon, "East");
        bottomPanel.add(priceAndMagnifyingGlassPanel);
        this.add((Component)bottomPanel, "South");
        this.panelsToColor = Arrays.asList(topPanel, centerPanel, bottomPanel, priceAndMagnifyingGlassPanel);
        plugin.getApiAuthHandler().subscribeToPremiumChecking(magnifyingGlassIcon::setVisible);
    }

    public void updateTimer(String timeString) {
        if (this.offerEvent == null || this.offerEvent.isCausedByEmptySlot() || timeString == null) {
            this.timer.setText("");
            return;
        }
        this.timer.setText(timeString);
    }

    public boolean shouldNotUpdate(OfferEvent newOfferEvent) {
        return this.offerEvent != null && this.offerEvent.isDuplicate(newOfferEvent);
    }

    public void onWikiRequest(WikiRequest wikiRequest) {
        this.wikiRequest = wikiRequest;
        this.drawSlotStatus();
    }

    public void updateQuickLookPanel() {
        if (this.offerEvent == null || this.offerEvent.isCausedByEmptySlot() || this.wikiRequest == null) {
            this.quickLookPanel.updateDetails(null, null);
            return;
        }
        WikiItemMargins margins = this.wikiRequest.getData().get(this.offerEvent.getItemId());
        if (margins == null) {
            this.quickLookPanel.updateDetails(null, null);
            return;
        }
        SlotPredictedState predictedState = SlotPredictedState.getPredictedState(this.offerEvent.isBuy(), this.offerEvent.getListedPrice(), margins.getLow(), margins.getHigh());
        SlotInfo slotInfo = new SlotInfo(this.offerEvent.getSlot(), predictedState, this.offerEvent.getItemId(), this.offerEvent.getListedPrice(), this.offerEvent.isBuy());
        this.quickLookPanel.updateDetails(slotInfo, margins);
    }

    public void drawSlotStatus() {
        if (!this.plugin.getApiAuthHandler().isPremium()) {
            return;
        }
        if (this.offerEvent == null || this.offerEvent.isCausedByEmptySlot() || this.wikiRequest == null) {
            return;
        }
        WikiItemMargins margins = this.wikiRequest.getData().get(this.offerEvent.getItemId());
        if (margins == null) {
            return;
        }
        SlotPredictedState predictedState = SlotPredictedState.getPredictedState(this.offerEvent.isBuy(), this.offerEvent.getListedPrice(), margins.getLow(), margins.getHigh());
        if (predictedState == SlotPredictedState.IN_RANGE) {
            this.setColor(CustomColors.IN_RANGE_SLOTS_TAB);
        } else if (predictedState == SlotPredictedState.OUT_OF_RANGE) {
            this.setColor(CustomColors.OUT_OF_RANGE_SLOTS_TAB);
        } else if (predictedState == SlotPredictedState.BETTER_THAN_WIKI) {
            this.setColor(CustomColors.BETTER_THAN_WIKI_SLOTS_TAB);
        }
        this.hasDrawnStatus = true;
    }

    public void reset() {
        this.setVisible(false);
        this.verticalGap.setVisible(false);
        this.itemId = 0;
        this.itemIcon.setIcon(null);
        this.itemName.setText("");
        this.progressBar.setMaximumValue(0);
        this.progressBar.setValue(100);
        this.progressBar.setForeground(CustomColors.DARK_GRAY);
        this.progressBar.setBackground(CustomColors.DARK_GRAY);
        this.setColor(CustomColors.DARK_GRAY);
        this.hasDrawnStatus = false;
    }

    private void setColor(Color color) {
        this.setBackground(color);
        this.panelsToColor.forEach(p -> p.setBackground(color));
    }

    public void update(BufferedImage itemImage, String name, OfferEvent newOfferEvent) {
        this.setVisible(true);
        this.verticalGap.setVisible(true);
        this.itemId = newOfferEvent.getItemId();
        if (name != null) {
            this.itemName.setText(name);
        }
        if (itemImage != null) {
            this.itemIcon.setIcon(new ImageIcon(itemImage));
        }
        String stateText = QuantityFormatter.quantityToRSDecimalStack((int)newOfferEvent.getCurrentQuantityInTrade()) + " / " + QuantityFormatter.quantityToRSDecimalStack((int)newOfferEvent.getTotalQuantityInTrade());
        this.action.setText(newOfferEvent.isBuy() ? "Buy" : "Sell");
        this.state.setText(stateText);
        this.price.setText(QuantityFormatter.formatNumber((long)newOfferEvent.getListedPrice()) + " coins");
        this.progressBar.setMaximumValue(newOfferEvent.getTotalQuantityInTrade());
        this.progressBar.setValue(newOfferEvent.getCurrentQuantityInTrade());
        if (newOfferEvent.isCancelled()) {
            this.progressBar.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        } else if (newOfferEvent.isComplete()) {
            this.progressBar.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        } else {
            this.progressBar.setForeground(ColorScheme.PROGRESS_INPROGRESS_COLOR);
        }
        if (!this.hasDrawnStatus) {
            this.drawSlotStatus();
        }
    }
}

