/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.settings;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.ui.uiutilities.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class SettingsPanel
extends JPanel {
    int ACCOUNT_LABEL_HEIGHT = 45;
    FlippingPlugin plugin;
    JPanel accountSelectionPanel;
    JPanel settingsBasePanel;
    List<JLabel> accountLabels = new ArrayList<JLabel>();
    JLabel selectedAccountLabel;

    public SettingsPanel(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.accountSelectionPanel = this.accountSelectionPanel();
        JScrollPane accountScroller = new JScrollPane(this.accountSelectionPanel);
        this.settingsBasePanel = new JPanel();
        this.settingsBasePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.add((Component)accountScroller, "West");
        this.add((Component)new JScrollPane(this.settingsBasePanel), "Center");
    }

    private JPanel accountSelectionPanel() {
        JPanel accountSelectionPanel = new JPanel();
        accountSelectionPanel.setLayout(new BoxLayout(accountSelectionPanel, 1));
        accountSelectionPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        return accountSelectionPanel;
    }

    private JLabel accountLabel(String name) {
        final JLabel accountLabel = new JLabel(Icons.GNOME_CHILD, 2);
        accountLabel.setOpaque(true);
        accountLabel.setMaximumSize(new Dimension(170, this.ACCOUNT_LABEL_HEIGHT));
        accountLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        accountLabel.setText(name);
        accountLabel.setFont(FontManager.getRunescapeBoldFont());
        accountLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SettingsPanel.this.setSelectedAccountLabel(accountLabel);
                SettingsPanel.this.revalidate();
                SettingsPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                accountLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
                accountLabel.setSize(accountLabel.getWidth(), SettingsPanel.this.ACCOUNT_LABEL_HEIGHT + 10);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (accountLabel != SettingsPanel.this.selectedAccountLabel) {
                    accountLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                    accountLabel.setSize(accountLabel.getWidth(), SettingsPanel.this.ACCOUNT_LABEL_HEIGHT);
                }
            }
        });
        return accountLabel;
    }

    public void rebuild() {
        this.accountSelectionPanel.removeAll();
        this.settingsBasePanel.removeAll();
        this.accountLabels.clear();
        HashSet<String> accountsWithHistory = new HashSet<String>(this.plugin.getCurrentDisplayNames());
        for (String name : accountsWithHistory) {
            JLabel accountLabel = this.accountLabel(name);
            this.accountLabels.add(accountLabel);
            this.accountSelectionPanel.add(accountLabel);
            this.accountSelectionPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        }
        if (!this.accountLabels.isEmpty()) {
            this.setSelectedAccountLabel(this.accountLabels.get(0));
        }
        this.repaint();
        this.revalidate();
    }

    private void setSelectedAccountLabel(JLabel accountLabel) {
        this.selectedAccountLabel = accountLabel;
        accountLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        for (JLabel label : this.accountLabels) {
            if (label == accountLabel) continue;
            label.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        this.settingsBasePanel.removeAll();
        this.settingsBasePanel.add(this.optionsPanel(accountLabel.getText()));
    }

    private JLabel accountDeleteButton() {
        final JLabel deleteButton = new JLabel(Icons.DELETE_BUTTON);
        deleteButton.setToolTipText("Deletes the file that stores all of this account's trades. This cannotbe undone!");
        deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String selectedAccountName = SettingsPanel.this.selectedAccountLabel.getText();
                if (selectedAccountName.equals(SettingsPanel.this.plugin.getCurrentlyLoggedInAccount())) {
                    JOptionPane.showMessageDialog(null, "You cannot delete a currently logged in account", "Alert", 0);
                } else {
                    int result = JOptionPane.showOptionDialog(deleteButton, "Are you sure you want to delete this account?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                    if (result == 0) {
                        SettingsPanel.this.plugin.deleteAccount(selectedAccountName);
                        SettingsPanel.this.rebuild();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteButton.setIcon(Icons.HIGHLIGHT_DELETE_BUTTON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteButton.setIcon(Icons.DELETE_BUTTON);
            }
        });
        return deleteButton;
    }

    private JPanel optionsPanel(String name) {
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel title = new JLabel("currently viewing " + name, 0);
        title.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        title.setFont(new Font("Roboto", 3, 10));
        title.setBorder(new EmptyBorder(0, 0, 10, 0));
        JLabel deleteButton = this.accountDeleteButton();
        JPanel optionBody = new JPanel();
        optionBody.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        basePanel.add((Component)title, "North");
        basePanel.add((Component)optionBody, "Center");
        basePanel.add((Component)deleteButton, "South");
        return basePanel;
    }
}

