/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.recipeflips;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.ui.recipeflips.RecipeItemHeaderPanel;
import com.flippingutilities.ui.statistics.items.OfferPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Recipe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeOfferSelectionPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(RecipeOfferSelectionPanel.class);
    FlippingPlugin plugin;
    OfferEvent sourceOffer;
    Map<Integer, Map<String, PartialOffer>> selectedOffers;
    JButton finishButton = new JButton("Combine!");
    JLabel profitNumberLabel = new JLabel("+0");
    JSpinner coinOffset = new JSpinner();
    Recipe recipe;
    Map<Integer, RecipeItemHeaderPanel> idToHeader;
    List<JSpinner> numberPickers = new ArrayList<JSpinner>();

    public RecipeOfferSelectionPanel(FlippingPlugin plugin, OfferEvent sourceOffer, Recipe recipe) {
        this.plugin = plugin;
        this.sourceOffer = sourceOffer;
        this.recipe = recipe;
        Map<Integer, Optional<FlippingItem>> itemsInRecipe = plugin.getItemsInRecipe(recipe);
        this.selectedOffers = this.initSelectedOffers(itemsInRecipe);
        this.idToHeader = this.createRecipeItemHeaderPanel(this.selectedOffers);
        this.setBackground(Color.BLACK);
        this.setLayout(new BorderLayout());
        Map<Integer, List<PartialOffer>> itemIdToPartialOffers = this.createItemIdToPartialOffers(itemsInRecipe, plugin.getStatPanel().getStartOfInterval());
        this.add((Component)this.createTitle(), "North");
        this.add((Component)this.createBody(itemIdToPartialOffers), "Center");
        this.add((Component)this.createBottomPanel(itemIdToPartialOffers), "South");
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
    }

    private Map<Integer, Map<String, PartialOffer>> initSelectedOffers(Map<Integer, Optional<FlippingItem>> itemsInRecipe) {
        this.selectedOffers = new HashMap<Integer, Map<String, PartialOffer>>();
        itemsInRecipe.keySet().forEach(id -> this.selectedOffers.put((Integer)id, new HashMap()));
        return this.selectedOffers;
    }

    private JPanel createBody(Map<Integer, List<PartialOffer>> itemIdToPartialOffers) {
        Set<Integer> allIds = this.selectedOffers.keySet();
        JPanel bodyPanel = new JPanel();
        bodyPanel.setBackground(Color.BLACK);
        bodyPanel.setLayout((LayoutManager)new DynamicGridLayout(2, allIds.size() + 1, 10, 5));
        this.addHeaderPanelRow(bodyPanel);
        this.addOfferPanelRow(bodyPanel, itemIdToPartialOffers);
        return bodyPanel;
    }

    private JComponent createOffersPanel(int itemId, List<PartialOffer> partialOffers, RecipeItemHeaderPanel headerPanel, int targetSelectionValue) {
        JPanel offersPanel = new JPanel();
        offersPanel.setBackground(Color.BLACK);
        if (partialOffers.size() > 0) {
            return this.createOffersScrollPane(partialOffers, headerPanel, targetSelectionValue, offersPanel);
        }
        if (itemId == 995) {
            JLabel coinsLabel = new JLabel("coins automatically accounted for");
            coinsLabel.setForeground(Color.GREEN);
            offersPanel.add(coinsLabel);
        } else {
            String type = this.sourceOffer.isBuy() ? "sell" : "buy";
            JLabel noTradesLabel = new JLabel(String.format("No recorded %s for this item", type));
            noTradesLabel.setForeground(Color.RED);
            offersPanel.add(noTradesLabel);
        }
        headerPanel.setForeground(CustomColors.TOMATO);
        return offersPanel;
    }

    private JScrollPane createOffersScrollPane(List<PartialOffer> partialOffers, RecipeItemHeaderPanel headerPanel, int targetSelectionValue, JPanel offersPanel) {
        offersPanel.setLayout(new BoxLayout(offersPanel, 1));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(Color.BLACK);
        wrapper.add((Component)offersPanel, "North");
        JScrollPane scrollPane = new JScrollPane(wrapper);
        scrollPane.setBackground(Color.BLACK);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(2, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        int maxHackySize = 0;
        for (int i = 0; i < partialOffers.size(); ++i) {
            PartialOffer partialOffer = partialOffers.get(i);
            OfferPanel offerPanel = new OfferPanel(this.plugin, null, partialOffer.getOffer(), true);
            int actualQuantityInOffer = partialOffer.getOffer().getCurrentQuantityInTrade() - partialOffer.amountConsumed;
            int amountToSelect = Math.min(actualQuantityInOffer, targetSelectionValue);
            targetSelectionValue -= amountToSelect;
            int numPickerSize = 40 + String.valueOf(actualQuantityInOffer).length() * 10;
            maxHackySize = Math.max(maxHackySize, offerPanel.getHackySize() + numPickerSize);
            JPanel offerPanelWithPicker = this.createOfferPanelWithPicker(offerPanel, headerPanel, partialOffer, amountToSelect);
            offersPanel.add(offerPanelWithPicker);
            if (i < Math.min(partialOffers.size(), 10) - 1) {
                offersPanel.add(Box.createVerticalStrut(4));
            }
            int scrollPaneHeight = Math.min(350, partialOffers.size() * 65 + 40);
            scrollPane.setPreferredSize(new Dimension(maxHackySize, scrollPaneHeight));
            this.setDisplaysAndStateBasedOnSelection(amountToSelect, partialOffer.getOffer(), offerPanel, headerPanel);
        }
        return scrollPane;
    }

    private JPanel createOfferPanelWithPicker(OfferPanel offerPanel, RecipeItemHeaderPanel headerPanel, PartialOffer partialOffer, int amountToSelect) {
        JPanel offerPanelWithPicker = new JPanel(new BorderLayout());
        offerPanelWithPicker.setBackground(Color.BLACK);
        JSpinner numberPicker = new JSpinner(new SpinnerNumberModel(amountToSelect, 0, partialOffer.getOffer().getCurrentQuantityInTrade() - partialOffer.amountConsumed, 1));
        numberPicker.setForeground(CustomColors.CHEESE);
        numberPicker.setSize(new Dimension(0, 70));
        numberPicker.addChangeListener(e -> this.numberPickerHandler(e, partialOffer.getOffer(), offerPanel, headerPanel));
        this.numberPickers.add(numberPicker);
        offerPanelWithPicker.add((Component)numberPicker, "West");
        offerPanelWithPicker.add((Component)offerPanel, "Center");
        if (partialOffer.amountConsumed > 0) {
            boolean completelyConsumed = partialOffer.amountConsumed == partialOffer.getOffer().getCurrentQuantityInTrade();
            JPanel alreadyUsedPanel = new JPanel();
            alreadyUsedPanel.setBackground(Color.BLACK);
            JLabel alreadyUsedLabel = new JLabel(String.format("<html><body width='150' style='text-align:center;'> %d/%d items in this offer already used in other recipe flips</body></html>", partialOffer.amountConsumed, partialOffer.getOffer().getCurrentQuantityInTrade()), 0);
            alreadyUsedLabel.setFont(new Font("Whitney", 0, 10));
            alreadyUsedLabel.setForeground(completelyConsumed ? CustomColors.TOMATO.darker() : CustomColors.CHEESE.darker());
            alreadyUsedPanel.add(alreadyUsedLabel);
            offerPanelWithPicker.add((Component)alreadyUsedPanel, "South");
        }
        return offerPanelWithPicker;
    }

    private Map<Integer, RecipeItemHeaderPanel> createRecipeItemHeaderPanel(Map<Integer, Map<String, PartialOffer>> selectedOffers) {
        Set<Integer> allIds = selectedOffers.keySet();
        HashMap<Integer, RecipeItemHeaderPanel> idToIconLabel = new HashMap<Integer, RecipeItemHeaderPanel>();
        allIds.forEach(id -> {
            AsyncBufferedImage itemImage = this.plugin.getItemManager().getImage(id.intValue());
            idToIconLabel.put((Integer)id, new RecipeItemHeaderPanel(itemImage));
        });
        return idToIconLabel;
    }

    private void addHeaderPanelRow(JPanel bodyPanel) {
        this.recipe.getInputIds().forEach(itemId -> {
            JPanel headerPanel = this.idToHeader.get(itemId);
            bodyPanel.add(headerPanel);
        });
        bodyPanel.add(new JLabel(Icons.RIGHT_ARROW_LARGE));
        this.recipe.getOutputIds().forEach(itemId -> {
            JPanel headerPanel = this.idToHeader.get(itemId);
            bodyPanel.add(headerPanel);
        });
    }

    private Map<Integer, List<PartialOffer>> createItemIdToPartialOffers(Map<Integer, Optional<FlippingItem>> itemIdToItem, Instant startOfInterval) {
        HashMap<Integer, List<PartialOffer>> itemIdToPartialOffers = new HashMap<Integer, List<PartialOffer>>();
        itemIdToItem.forEach((itemId, item) -> {
            List partialOffers = item.map(fitem -> {
                Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer((int)itemId);
                ArrayList<OfferEvent> offers = itemId.intValue() == this.sourceOffer.getItemId() ? new ArrayList<OfferEvent>(Arrays.asList(this.sourceOffer)) : fitem.getIntervalHistory(startOfInterval);
                Collections.reverse(offers);
                return offers.stream().filter(o -> o.isBuy() == this.recipe.isInput((int)itemId) && o.isComplete()).map(o -> {
                    if (offerIdToPartialOffer.containsKey(o.getUuid())) {
                        return (PartialOffer)offerIdToPartialOffer.get(o.getUuid());
                    }
                    return new PartialOffer((OfferEvent)o, 0);
                }).collect(Collectors.toList());
            }).orElse(new ArrayList());
            itemIdToPartialOffers.put((Integer)itemId, partialOffers);
        });
        return itemIdToPartialOffers;
    }

    private void addOfferPanelRow(JPanel bodyPanel, Map<Integer, List<PartialOffer>> itemIdToPartialOffers) {
        Map<Integer, Integer> targetValues = this.plugin.getTargetValuesForMaxRecipeCount(this.recipe, itemIdToPartialOffers, true);
        this.recipe.getInputIds().forEach(id -> this.addOfferPanel(bodyPanel, (int)id, itemIdToPartialOffers, targetValues));
        JPanel emptyPanel = new JPanel();
        emptyPanel.setBackground(Color.BLACK);
        bodyPanel.add(emptyPanel);
        this.recipe.getOutputIds().forEach(id -> this.addOfferPanel(bodyPanel, (int)id, itemIdToPartialOffers, targetValues));
        this.handleItemsHittingTargetConsumptionValues();
    }

    private void addOfferPanel(JPanel bodyPanel, int itemId, Map<Integer, List<PartialOffer>> itemIdToPartialOffers, Map<Integer, Integer> targetValues) {
        int targetValue = targetValues.get(itemId);
        List<PartialOffer> partialOffers = itemIdToPartialOffers.get(itemId);
        RecipeItemHeaderPanel recipeItemHeaderPanel = this.idToHeader.get(itemId);
        recipeItemHeaderPanel.setTargetValueDisplay(targetValue);
        if (itemId == 995) {
            recipeItemHeaderPanel.setConsumedAmountDisplay(targetValue);
        }
        bodyPanel.add(this.createOffersPanel(itemId, partialOffers, recipeItemHeaderPanel, targetValue));
    }

    private void numberPickerHandler(ChangeEvent e, OfferEvent offer, OfferPanel offerPanel, RecipeItemHeaderPanel headerPanel) {
        JSpinner numberPicker = (JSpinner)e.getSource();
        int numberPickerValue = (Integer)numberPicker.getValue();
        this.setDisplaysAndStateBasedOnSelection(numberPickerValue, offer, offerPanel, headerPanel);
        this.handleItemsHittingTargetConsumptionValues();
    }

    private void setDisplaysAndStateBasedOnSelection(int numberPickerValue, OfferEvent offer, OfferPanel offerPanel, RecipeItemHeaderPanel headerPanel) {
        int itemId = offer.getItemId();
        offerPanel.setSelected(numberPickerValue > 0);
        Map<String, PartialOffer> selectedOffersForThisItem = this.selectedOffers.get(itemId);
        if (selectedOffersForThisItem.containsKey(offer.getUuid())) {
            selectedOffersForThisItem.get((Object)offer.getUuid()).amountConsumed = numberPickerValue;
        } else {
            selectedOffersForThisItem.put(offer.getUuid(), new PartialOffer(offer, numberPickerValue));
        }
        int totalConsumedAmount = selectedOffersForThisItem.values().stream().mapToInt(o -> o.amountConsumed).sum();
        headerPanel.setConsumedAmountDisplay(totalConsumedAmount);
    }

    private void handleItemsHittingTargetConsumptionValues() {
        Map<Integer, List<PartialOffer>> idToPartialOffersSelected = this.selectedOffers.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((Integer)e.getKey(), new ArrayList(((Map)e.getValue()).values()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Integer, Integer> idToTargetValues = this.plugin.getTargetValuesForMaxRecipeCount(this.recipe, idToPartialOffersSelected, false);
        AtomicBoolean allMatchTargetValues = new AtomicBoolean(true);
        this.selectedOffers.forEach((itemId, partialOfferMap) -> {
            RecipeItemHeaderPanel itemHeaderPanel = this.idToHeader.get(itemId);
            int amountConsumed = partialOfferMap.values().stream().mapToInt(o -> o.amountConsumed).sum();
            int targetConsumedAmount = (Integer)idToTargetValues.get(itemId);
            itemHeaderPanel.setTargetValueDisplay(targetConsumedAmount);
            if (itemId == 995) {
                itemHeaderPanel.setConsumedAmountDisplay(targetConsumedAmount);
            }
            if (amountConsumed == targetConsumedAmount && targetConsumedAmount != 0 || itemId == 995) {
                itemHeaderPanel.setConsumedAmountDisplayColor(ColorScheme.GRAND_EXCHANGE_PRICE);
            } else {
                allMatchTargetValues.set(false);
                itemHeaderPanel.setConsumedAmountDisplayColor(CustomColors.CHEESE);
            }
        });
        if (allMatchTargetValues.get()) {
            this.finishButton.setEnabled(true);
            this.finishButton.setForeground(Color.GREEN);
            long profit = Math.round(this.calculateProfit()) - (Integer)this.coinOffset.getValue();
            String prefix = profit < 0L ? "" : "+";
            this.profitNumberLabel.setText(prefix + QuantityFormatter.formatNumber((long)profit) + " gp");
            this.profitNumberLabel.setForeground(profit < 0L ? Color.RED : Color.GREEN);
        } else {
            this.finishButton.setEnabled(false);
            this.finishButton.setForeground(Color.GRAY);
            this.profitNumberLabel.setText("+0");
            this.profitNumberLabel.setForeground(CustomColors.CHEESE);
        }
    }

    private JPanel createBottomPanel(Map<Integer, List<PartialOffer>> itemIdToPartialOffers) {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBackground(Color.BLACK);
        JLabel coinOffsetLabel = new JLabel("Unaccounted for GP used in recipe: ");
        coinOffsetLabel.setBackground(Color.BLACK);
        coinOffsetLabel.setFont(new Font("Whitney", 0, 14));
        coinOffsetLabel.setAlignmentX(0.5f);
        coinOffsetLabel.setBorder(new EmptyBorder(10, 30, 5, 60));
        this.coinOffset.setFont(new Font("Whitney", 0, 14));
        this.coinOffset.setAlignmentX(0.5f);
        this.coinOffset.setBorder(new EmptyBorder(10, 30, 5, 60));
        this.coinOffset.addChangeListener(e -> this.handleItemsHittingTargetConsumptionValues());
        JPanel coinOffsetPanel = new JPanel();
        coinOffsetPanel.setBackground(Color.BLACK);
        coinOffsetPanel.add(coinOffsetLabel);
        coinOffsetPanel.add(this.coinOffset);
        bottomPanel.add(coinOffsetPanel);
        int itemsThatCanMakeZeroRecipes = (int)this.plugin.getItemIdToMaxRecipesThatCanBeMade(this.recipe, itemIdToPartialOffers, true).entrySet().stream().filter(e -> (Integer)e.getValue() == 0).count();
        if (itemsThatCanMakeZeroRecipes > 0) {
            JLabel missingItemsLabel = new JLabel("No recipe flip can be made as some items don't have enough trades", 0);
            missingItemsLabel.setForeground(CustomColors.TOMATO);
            missingItemsLabel.setAlignmentX(0.5f);
            missingItemsLabel.setFont(new Font("Whitney", 0, 16));
            missingItemsLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
            bottomPanel.add(missingItemsLabel);
        }
        this.profitNumberLabel.setFont(new Font("Whitney", 0, 16));
        this.profitNumberLabel.setAlignmentX(0.5f);
        this.profitNumberLabel.setBorder(new EmptyBorder(10, 0, 5, 0));
        this.finishButton.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.finishButton.setAlignmentX(0.5f);
        this.finishButton.setFont(new Font("Whitney", 0, 16));
        this.finishButton.setFocusPainted(false);
        this.finishButton.addActionListener(e -> {
            try {
                this.coinOffset.commitEdit();
            }
            catch (ParseException ex) {
                log.info("Failed to parse coin offset", (Throwable)ex);
            }
            int coinOffsetValue = (Integer)this.coinOffset.getValue();
            RecipeFlip recipeFlip = new RecipeFlip(this.recipe, this.selectedOffers, this.getCoinsCost() + (long)coinOffsetValue);
            this.plugin.addRecipeFlip(recipeFlip, this.recipe);
            this.plugin.getStatPanel().rebuildRecipesDisplay(this.plugin.viewRecipeFlipGroupsForCurrentView());
            this.plugin.getStatPanel().rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
            this.numberPickers.forEach(picker -> picker.setEnabled(false));
            bottomPanel.removeAll();
            JLabel successLabel = new JLabel("Success! This flip will now show up in the Recipes tab", 0);
            successLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
            successLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            successLabel.setFont(new Font("Whitney", 0, 16));
            successLabel.setAlignmentX(0.5f);
            bottomPanel.add(successLabel);
            this.revalidate();
            this.repaint();
        });
        bottomPanel.add(this.profitNumberLabel);
        bottomPanel.add(this.finishButton);
        return bottomPanel;
    }

    private JPanel createTitle() {
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(5, 0, 25, 0));
        titlePanel.setBackground(Color.BLACK);
        JLabel title = new JLabel(this.recipe.getName(), 0);
        title.setBorder(new EmptyBorder(0, 0, 20, 0));
        title.setFont(new Font("Whitney", 0, 20));
        JPanel intervalPanel = new JPanel();
        intervalPanel.setBackground(Color.BLACK);
        String intervalName = this.plugin.getStatPanel().getStartOfIntervalName();
        JLabel intervalDescLabel = new JLabel("You are looking at offers from the interval: ");
        intervalDescLabel.setFont(new Font("Whitney", 0, 14));
        JLabel intervalNameLabel = new JLabel(intervalName);
        intervalNameLabel.setFont(new Font("Whitney", 0, 16));
        intervalNameLabel.setForeground(CustomColors.CHEESE);
        UIUtilities.makeLabelUnderlined(intervalNameLabel);
        intervalPanel.add(intervalDescLabel);
        intervalPanel.add(intervalNameLabel);
        JLabel desc = new JLabel("Only completed offers show up here", 0);
        desc.setForeground(CustomColors.CHEESE);
        desc.setFont(new Font("Whitney", 0, 12));
        titlePanel.add((Component)title, "North");
        titlePanel.add((Component)intervalPanel, "Center");
        titlePanel.add((Component)desc, "South");
        return titlePanel;
    }

    private long calculateProfit() {
        return RecipeFlip.calculateProfit(this.selectedOffers) - this.getCoinsCost();
    }

    private long getCoinsCost() {
        Map<Integer, List<PartialOffer>> idToPartialOffersSelected = this.selectedOffers.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((Integer)e.getKey(), new ArrayList(((Map)e.getValue()).values()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Integer, Integer> idToTargetValues = this.plugin.getTargetValuesForMaxRecipeCount(this.recipe, idToPartialOffersSelected, false);
        if (idToTargetValues.containsKey(995)) {
            return idToTargetValues.get(995).intValue();
        }
        return 0L;
    }
}

