/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.recipeflips;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.MasterPanel;
import com.flippingutilities.ui.recipeflips.RecipeOfferSelectionPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Recipe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.AsyncBufferedImage;

public class RecipeFlipCreationPanel
extends JPanel {
    static boolean offerSelectionPanelOpen = false;
    FlippingPlugin plugin;
    OfferEvent sourceOffer;
    JDialog modal;

    public RecipeFlipCreationPanel(FlippingPlugin plugin, OfferEvent sourceOffer) {
        this.plugin = plugin;
        this.sourceOffer = sourceOffer;
        List<Recipe> recipes = plugin.getApplicableRecipes(sourceOffer.getItemId(), sourceOffer.isBuy());
        recipes.sort(Comparator.comparing(r -> r.getIds().size()));
        Collections.reverse(recipes);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.createTitlePanel(recipes), "North");
        this.add((Component)this.createRecipeScrollPane(recipes), "Center");
    }

    private JScrollPane createRecipeScrollPane(List<Recipe> recipes) {
        JPanel recipePanelContainer = new JPanel((LayoutManager)new DynamicGridLayout(recipes.size(), 1, 0, 3));
        recipes.forEach(r -> recipePanelContainer.add(this.createRecipePanel((Recipe)r)));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(Color.BLACK);
        wrapper.add((Component)recipePanelContainer, "North");
        JScrollPane scrollPane = new JScrollPane(wrapper);
        scrollPane.setBackground(Color.BLACK);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(2, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(45 * (recipes.get(0).getIds().size() + 1), Math.min(500, 75 * recipes.size())));
        return scrollPane;
    }

    private JPanel createRecipePanel(final Recipe recipe) {
        final JPanel recipePanel = new JPanel(new BorderLayout());
        recipePanel.setBorder(new EmptyBorder(5, 0, 8, 0));
        recipePanel.setBackground(Color.BLACK);
        recipePanel.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, CustomColors.DARK_GRAY), new EmptyBorder(5, 0, 8, 0)));
        final JPanel recipeIconPanel = new JPanel();
        recipeIconPanel.setBackground(Color.BLACK);
        recipePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (offerSelectionPanelOpen) {
                    JOptionPane.showMessageDialog(null, "You must close the other recipe creation menu before opening another one");
                    return;
                }
                RecipeFlipCreationPanel.this.modal.dispose();
                MasterPanel m = RecipeFlipCreationPanel.this.plugin.getMasterPanel();
                RecipeOfferSelectionPanel recipeOfferSelectionPanel = new RecipeOfferSelectionPanel(RecipeFlipCreationPanel.this.plugin, RecipeFlipCreationPanel.this.sourceOffer, recipe);
                offerSelectionPanelOpen = true;
                final JDialog recipeOfferSelectionModal = UIUtilities.createModalFromPanel((Component)((Object)m), recipeOfferSelectionPanel);
                recipeOfferSelectionModal.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        recipeOfferSelectionModal.dispose();
                        offerSelectionPanelOpen = false;
                    }
                });
                recipeOfferSelectionModal.pack();
                recipeOfferSelectionModal.setLocation(Math.max(20, m.getLocationOnScreen().x - recipeOfferSelectionModal.getWidth() - 10), Math.max(m.getLocationOnScreen().y - recipeOfferSelectionModal.getHeight() / 2, 0) + 100);
                recipeOfferSelectionModal.setVisible(true);
                RecipeFlipCreationPanel.this.revalidate();
                RecipeFlipCreationPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                recipePanel.setBackground(Color.DARK_GRAY);
                recipeIconPanel.setBackground(Color.DARK_GRAY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                recipePanel.setBackground(Color.BLACK);
                recipeIconPanel.setBackground(Color.BLACK);
            }
        });
        recipe.getInputIds().forEach(id -> {
            AsyncBufferedImage itemImage = this.plugin.getItemManager().getImage(id.intValue());
            JLabel iconLabel = new JLabel();
            itemImage.addTo(iconLabel);
            recipeIconPanel.add(iconLabel);
        });
        recipeIconPanel.add(new JLabel(Icons.RIGHT_ARROW_LARGE));
        recipe.getOutputIds().forEach(id -> {
            AsyncBufferedImage itemImage = this.plugin.getItemManager().getImage(id.intValue());
            JLabel iconLabel = new JLabel();
            itemImage.addTo(iconLabel);
            recipeIconPanel.add(iconLabel);
        });
        JLabel recipeNameLabel = new JLabel(recipe.getName(), 0);
        recipeNameLabel.setFont(new Font("Whitney", 0, 12));
        recipeNameLabel.setBorder(new EmptyBorder(3, 0, 0, 0));
        recipePanel.add((Component)recipeIconPanel, "Center");
        recipePanel.add((Component)recipeNameLabel, "South");
        return recipePanel;
    }

    private JPanel createTitlePanel(List<Recipe> recipes) {
        JLabel titleLabel = new JLabel("Select a Recipe", 0);
        titleLabel.setFont(new Font("Whitney", 0, 16));
        JLabel numRecipesLabel = new JLabel(String.format("Showing %d %s for %s %s", recipes.size(), UIUtilities.maybePluralize("recipe", recipes.size()), this.sourceOffer.isBuy() ? "buying" : "selling", this.sourceOffer.getItemName()), 0);
        numRecipesLabel.setFont(new Font("Whitney", 2, 10));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)numRecipesLabel, "South");
        return titlePanel;
    }

    public void setModal(JDialog modal) {
        this.modal = modal;
    }
}

