/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.offereditor;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.Option;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.utilities.InvalidOptionException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(OptionPanel.class);
    private FlippingPlugin plugin;
    private Option option;
    private JLabel resultingValueLabel;
    private JLabel dotIcon;
    private boolean isHighlighted;
    private Icon lastIcon;

    public OptionPanel(Option option, FlippingPlugin plugin) {
        this.option = option;
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(new EmptyBorder(5, 0, 5, 5));
        this.resultingValueLabel = new JLabel("", 0);
        this.resultingValueLabel.setFont(FontManager.getRunescapeSmallFont());
        this.dotIcon = this.createDotIcon();
        this.add((Component)this.resultingValueLabel, "South");
        this.add((Component)this.createBodyPanel(), "Center");
        this.add((Component)this.dotIcon, "West");
        this.setResultingValue();
    }

    public JPanel createBodyPanel() {
        JPanel body = new JPanel();
        body.setBackground(CustomColors.DARK_GRAY);
        JTextField keyInputField = new JTextField(2);
        keyInputField.setText(this.option.getKey());
        keyInputField.addActionListener(e -> {
            this.plugin.markAccountTradesAsHavingChanged("Accountwide");
            this.option.setKey(keyInputField.getText());
            this.setResultingValue();
        });
        keyInputField.setToolTipText("Press enter after inputting a key to save your changes");
        JComboBox<String> propertiesSelector = new JComboBox<String>(this.option.isQuantityOption() ? Option.QUANTITY_OPTIONS : Option.PRICE_OPTIONS);
        propertiesSelector.setPreferredSize(new Dimension(88, 25));
        propertiesSelector.setSelectedItem(this.option.getProperty());
        propertiesSelector.addActionListener(e -> {
            if (propertiesSelector.getSelectedItem() != null) {
                this.plugin.markAccountTradesAsHavingChanged("Accountwide");
                this.option.setProperty((String)propertiesSelector.getSelectedItem());
                this.setResultingValue();
            }
        });
        JTextField optionalEditor = new JTextField(5);
        optionalEditor.setText(this.option.getModifier());
        optionalEditor.addActionListener(e -> {
            this.plugin.markAccountTradesAsHavingChanged("Accountwide");
            this.option.setModifier(optionalEditor.getText());
            this.setResultingValue();
        });
        optionalEditor.setToolTipText("press enter after inputting something to save your changes");
        body.add(keyInputField);
        body.add(propertiesSelector);
        body.add(optionalEditor);
        return body;
    }

    private String createResultingValueText(int resultingValue) {
        String keyText = String.format("<span style='color:%s;'>%s</span>", ColorUtil.colorToHexCode((Color)ColorScheme.GRAND_EXCHANGE_ALCH), this.option.getKey());
        String typeText = this.option.isQuantityOption() ? "quantity" : "price";
        String value = NumberFormat.getInstance(Locale.getDefault()).format(resultingValue);
        String valueText = String.format("<span style='color:%s;'>%s</span>", ColorUtil.colorToHexCode((Color)ColorScheme.GRAND_EXCHANGE_PRICE), value);
        return String.format("<html><body width='170' style='text-align:center;'>Press %s to set %s to %s</body></html>", keyText, typeText, valueText);
    }

    private JLabel createDotIcon() {
        this.dotIcon = new JLabel(Icons.GRAY_DOT);
        this.lastIcon = this.dotIcon.getIcon();
        this.dotIcon.setBorder(new EmptyBorder(8, 12, 0, 0));
        this.dotIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OptionPanel.this.dotIcon.getIcon().equals(Icons.DELETE_ICON)) {
                    OptionPanel.this.plugin.getFlippingPanel().getOfferEditorContainerPanel().deleteOption(OptionPanel.this.option);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OptionPanel.this.lastIcon = OptionPanel.this.dotIcon.getIcon();
                OptionPanel.this.dotIcon.setIcon(Icons.DELETE_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OptionPanel.this.dotIcon.setIcon(OptionPanel.this.lastIcon);
            }
        });
        return this.dotIcon;
    }

    private void setResultingValue() {
        this.plugin.getClientThread().invokeLater(() -> {
            String errorMessage = null;
            int val = 0;
            try {
                val = this.plugin.calculateOptionValue(this.option);
            }
            catch (InvalidOptionException e) {
                errorMessage = e.getMessage();
            }
            String finalErrorMessage = errorMessage;
            int finalVal = val;
            SwingUtilities.invokeLater(() -> {
                this.dotIcon.setIcon(Icons.GRAY_DOT);
                if (finalErrorMessage != null) {
                    this.showError(finalErrorMessage);
                } else {
                    this.resultingValueLabel.setText(this.createResultingValueText(finalVal));
                }
                this.revalidate();
                this.repaint();
            });
        });
    }

    private void showError(String msg) {
        String color = ColorUtil.colorToHexCode((Color)CustomColors.TOMATO);
        this.resultingValueLabel.setText(String.format("<html><body width='170'style='text-align:center;color:%s'>%s</body></html>", color, msg));
        this.dotIcon.setIcon(Icons.RED_DOT);
    }

    public void highlight() {
        this.isHighlighted = true;
        this.dotIcon.setIcon(Icons.GREEN_DOT);
    }

    public void deHighlight() {
        if (this.isHighlighted) {
            this.dotIcon.setIcon(Icons.GRAY_DOT);
            this.isHighlighted = false;
        }
    }

    public Option getOption() {
        return this.option;
    }
}

