/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.offereditor;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.Option;
import com.flippingutilities.ui.offereditor.OptionPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;

public abstract class AbstractOfferEditorPanel
extends JPanel {
    JPanel optionsContainer;
    FlippingPlugin plugin;
    List<OptionPanel> optionPanels = new ArrayList<OptionPanel>();
    JPanel descriptionPanel;

    public abstract List<Option> getOptions();

    public abstract void addOptionPanel();

    public abstract void onTemplateClicked();

    public AbstractOfferEditorPanel(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBackground(CustomColors.DARK_GRAY);
        this.setBorder(new EmptyBorder(5, 0, 10, 0));
        this.optionsContainer = new JPanel();
        this.optionsContainer.setLayout(new BoxLayout(this.optionsContainer, 1));
        this.optionsContainer.setBackground(CustomColors.DARK_GRAY);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.createTitlePanel(), "North");
        wrapper.add((Component)this.optionsContainer, "Center");
        this.add((Component)wrapper, "North");
        this.rebuild(this.getOptions());
    }

    private JPanel createTitlePanel() {
        this.descriptionPanel = new JPanel();
        this.descriptionPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.descriptionPanel.setBackground(CustomColors.DARK_GRAY);
        JLabel keyDescriptionLabel = new JLabel("<html><u>Key</u></html>", 0);
        keyDescriptionLabel.setToolTipText("<html>The key you can press to trigger the option.<br> Make sure to hit enter after editing a key so that your changes are saved</html>");
        keyDescriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        JLabel propertyDescriptionLabel = new JLabel("<html><u>Property</u></html>", 0);
        propertyDescriptionLabel.setToolTipText("The property an option's value is dependent on");
        propertyDescriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        propertyDescriptionLabel.setBorder(new EmptyBorder(0, 25, 0, 25));
        JLabel modifierDescriptionLabel = new JLabel("<html><u>Modifier</u></html>", 0);
        modifierDescriptionLabel.setToolTipText("<html>Any of these symbols +,-,*, followed by a positive whole number.<br> Examples: +0, +10, -5, *2. Make sure to hit enter after editing a modifier to save your changes</html>");
        modifierDescriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        this.descriptionPanel.add(keyDescriptionLabel);
        this.descriptionPanel.add(propertyDescriptionLabel);
        this.descriptionPanel.add(modifierDescriptionLabel);
        return this.descriptionPanel;
    }

    public void highlightPressedOption(String key) {
        boolean alreadyHighlightedOne = false;
        for (OptionPanel panel : this.optionPanels) {
            String keyInOption = panel.getOption().getKey();
            if (key.equals(keyInOption) && !alreadyHighlightedOne) {
                panel.highlight();
                alreadyHighlightedOne = true;
                continue;
            }
            panel.deHighlight();
        }
    }

    public void deleteOption(Option option) {
        this.plugin.getDataHandler().getAccountWideData().getOptions().remove(option);
        this.rebuild(this.getOptions());
    }

    public void rebuild(List<Option> options) {
        SwingUtilities.invokeLater(() -> {
            this.optionsContainer.removeAll();
            if (options.isEmpty()) {
                this.descriptionPanel.setVisible(false);
                this.optionsContainer.add(this.createWelcomePanel());
            } else {
                this.descriptionPanel.setVisible(true);
            }
            this.optionPanels.clear();
            for (Option option : options) {
                OptionPanel newPanel = new OptionPanel(option, this.plugin);
                this.optionPanels.add(newPanel);
                this.optionsContainer.add(newPanel);
            }
            this.revalidate();
            this.repaint();
        });
    }

    private JPanel createWelcomePanel() {
        JPanel welcomePanel = new JPanel(new BorderLayout());
        welcomePanel.setBackground(CustomColors.DARK_GRAY);
        welcomePanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        String text = "<html><div style=width:200;text-align: center;>Click the plus icon above to create an option<br><br>or<br><br>get started quickly with multiple default options by pressing the button below!</div></html>";
        JLabel descriptionText = new JLabel(text, 0);
        descriptionText.setFont(FontManager.getRunescapeSmallFont());
        final JLabel templateButton = new JLabel(Icons.TEMPLATE);
        templateButton.setBorder(new EmptyBorder(15, 0, 0, 0));
        templateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractOfferEditorPanel.this.onTemplateClicked();
                AbstractOfferEditorPanel.this.rebuild(AbstractOfferEditorPanel.this.getOptions());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                templateButton.setIcon(Icons.TEMPLATE_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                templateButton.setIcon(Icons.TEMPLATE);
            }
        });
        welcomePanel.add((Component)descriptionText, "North");
        welcomePanel.add((Component)templateButton, "Center");
        return welcomePanel;
    }
}

