/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.login;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.ui.login.LoggedInPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.components.IconTextField;

public class LoginPanel
extends JPanel {
    FlippingPlugin plugin;
    Runnable onViewChange;
    public boolean showingLoggedInView;
    Instant timeOfLastSuccessfulRequest;
    boolean errorWhenSendingSlotRequest;
    boolean notSendingRequestDueToNoChange;
    LoggedInPanel loggedInPanel;

    public LoginPanel(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.loggedInPanel = new LoggedInPanel(plugin, this::showLoggedOutView);
        plugin.getApiAuthHandler().subscribeToLogin(this::showLoggedInView);
        plugin.getApiAuthHandler().subscribeToPremiumChecking(isPremium -> this.loggedInPanel.showPremiumFeaturesHealth((boolean)isPremium));
        this.add(this.createLoggedOutPanel());
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::checkHealth, 5L, 1L, TimeUnit.SECONDS);
    }

    public void addOnViewChange(Runnable r) {
        this.onViewChange = r;
    }

    private void checkHealth() {
        if (!this.showingLoggedInView) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.plugin.getCurrentlyLoggedInAccount() == null) {
                this.timeOfLastSuccessfulRequest = null;
                this.loggedInPanel.setSlotFeatureHealthText("Inactive (not logged in)");
            } else if (!this.plugin.getApiAuthHandler().canCommunicateWithApi(this.plugin.getCurrentlyLoggedInAccount())) {
                this.loggedInPanel.setSlotFeatureHealthText("Inactive (not registered yet)");
            } else if (this.timeOfLastSuccessfulRequest == null) {
                this.loggedInPanel.setSlotFeatureHealthText("Active (starting up)");
            } else if (this.notSendingRequestDueToNoChange) {
                this.loggedInPanel.setSlotFeatureHealthText("Active (no slot change detected)");
            } else if (this.errorWhenSendingSlotRequest) {
                this.loggedInPanel.setSlotFeatureHealthText("Inactive (error on slot update)");
            } else {
                long diff = Instant.now().getEpochSecond() - this.timeOfLastSuccessfulRequest.getEpochSecond();
                this.loggedInPanel.setSlotFeatureHealthText(String.format("Active (%ds since last update)", diff));
            }
        });
    }

    public void onSlotRequest(int success) {
        if (success == 0) {
            this.notSendingRequestDueToNoChange = true;
        } else if (success == 1) {
            this.timeOfLastSuccessfulRequest = Instant.now();
            this.errorWhenSendingSlotRequest = false;
            this.notSendingRequestDueToNoChange = false;
        } else {
            this.errorWhenSendingSlotRequest = true;
            this.notSendingRequestDueToNoChange = false;
        }
    }

    public void showLoggedInView() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.add(this.loggedInPanel);
            this.revalidate();
            this.repaint();
            if (this.onViewChange != null) {
                this.onViewChange.run();
            }
            this.showingLoggedInView = true;
        });
    }

    public void showLoggedOutView() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.add(this.createLoggedOutPanel());
            this.revalidate();
            this.repaint();
            if (this.onViewChange != null) {
                this.onViewChange.run();
            }
        });
    }

    private JPanel createLoggedOutPanel() {
        JPanel loggedOutPanel = new JPanel(new BorderLayout());
        loggedOutPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        loggedOutPanel.setBorder(new EmptyBorder(20, 40, 20, 25));
        loggedOutPanel.add((Component)this.createFeaturesPanel(), "West");
        loggedOutPanel.add((Component)this.createTokenPanel(), "Center");
        loggedOutPanel.add((Component)this.createLoginInstructionsPanel(), "East");
        return loggedOutPanel;
    }

    private JPanel createFeaturesPanel() {
        JPanel featuresPanel = new JPanel(new BorderLayout());
        featuresPanel.setBorder(new EmptyBorder(0, 0, 0, 20));
        JLabel flashIcon = new JLabel(Icons.FLASH, 0);
        JLabel headingText = new JLabel("<html>LOGIN TO...</html>");
        headingText.setFont(new Font("Whitney", 1, 14));
        headingText.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        headingText.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel featuresListPanel = new JPanel((LayoutManager)new DynamicGridLayout(4, 0, 0, 0));
        JPanel firstFeaturePanel = new JPanel(new FlowLayout(0));
        JLabel firstFeatureDesc = new JLabel(String.format("<html><div WIDTH=%d>%s</div></html>", 180, "Get discord DMs when offers complete or you are undercut, even when logged out of rs!"));
        firstFeatureDesc.setFont(new Font("Whitney", 0, 12));
        firstFeatureDesc.setForeground(CustomColors.SOFT_ALCH);
        firstFeaturePanel.add(firstFeatureDesc);
        JPanel secondFeaturePanel = new JPanel(new FlowLayout(0));
        JLabel secondFeatureDesc = new JLabel(String.format("<html><div WIDTH=%d>%s</div></html>", 180, "View the current state of your offers on discord!"));
        secondFeatureDesc.setFont(new Font("Whitney", 0, 12));
        secondFeatureDesc.setForeground(CustomColors.SOFT_ALCH);
        secondFeaturePanel.add(secondFeatureDesc);
        JLabel bottomText = new JLabel("<html>More features are in development!</html>");
        bottomText.setFont(new Font("Whitney", 3, 10));
        bottomText.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        bottomText.setBorder(new EmptyBorder(25, 0, 0, 0));
        featuresListPanel.add(headingText);
        featuresListPanel.add(firstFeaturePanel);
        featuresListPanel.add(secondFeaturePanel);
        featuresListPanel.add(bottomText);
        featuresPanel.add((Component)flashIcon, "North");
        featuresPanel.add((Component)featuresListPanel, "South");
        return featuresPanel;
    }

    private JPanel createLoginInstructionsPanel() {
        JPanel instructionsPanel = new JPanel(new BorderLayout());
        instructionsPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        JLabel keyIcon = new JLabel(Icons.KEY, 0);
        JLabel headingText = new JLabel("<html>GETTING A TOKEN</html>");
        headingText.setFont(new Font("Whitney", 1, 14));
        headingText.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        headingText.setBorder(new EmptyBorder(0, 0, 7, 0));
        JPanel firstStepPanel = new JPanel(new FlowLayout(0));
        JLabel firstStepNumber = new JLabel("<html>1. </html>");
        firstStepNumber.setFont(new Font("Whitney", 1, 14));
        firstStepNumber.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel firstStepDesc = new JLabel("Join our discord", 2);
        firstStepDesc.setFont(new Font("Whitney", 0, 12));
        firstStepDesc.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        firstStepPanel.add(firstStepNumber);
        firstStepPanel.add(firstStepDesc);
        firstStepPanel.add(UIUtilities.createIcon(Icons.DISCORD_CHEESE, Icons.DISCORD_ICON_ON, "https://discord.gg/GDqVgMH26s", "Click to go to Flipping Utilities discord!"));
        JPanel secondStepPanel = new JPanel(new FlowLayout(0));
        JLabel secondStepDesc = new JLabel("Type /login in the bot channel");
        secondStepDesc.setFont(new Font("Whitney", 0, 12));
        secondStepDesc.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel secondStepNumber = new JLabel("<html>2. </html>");
        secondStepNumber.setFont(new Font("Whitney", 1, 14));
        secondStepNumber.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        secondStepPanel.add(secondStepNumber);
        secondStepPanel.add(secondStepDesc);
        JPanel thirdStepPanel = new JPanel(new FlowLayout(0));
        JLabel thirdStepNumber = new JLabel("<html>3. </html>");
        thirdStepNumber.setFont(new Font("Whitney", 1, 14));
        thirdStepNumber.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel thirdStepDesc = new JLabel("Enter the token here");
        thirdStepDesc.setFont(new Font("Whitney", 0, 12));
        thirdStepDesc.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        thirdStepPanel.add(thirdStepNumber);
        thirdStepPanel.add(thirdStepDesc);
        JLabel bottomText = new JLabel("<html>You will only have to do this once</html>");
        bottomText.setFont(new Font("Whitney", 3, 10));
        bottomText.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        bottomText.setBorder(new EmptyBorder(33, 0, 0, 0));
        JPanel stepsPanel = new JPanel((LayoutManager)new DynamicGridLayout(5, 0, 0, 0));
        stepsPanel.add(headingText);
        stepsPanel.add(firstStepPanel);
        stepsPanel.add(secondStepPanel);
        stepsPanel.add(thirdStepPanel);
        stepsPanel.add(bottomText);
        instructionsPanel.add((Component)keyIcon, "North");
        instructionsPanel.add((Component)stepsPanel, "South");
        return instructionsPanel;
    }

    private JPanel createTokenPanel() {
        JPanel tokenPanel = new JPanel(new BorderLayout());
        tokenPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        tokenPanel.setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 1, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(0, 30, 0, 30)));
        JPanel header = new JPanel();
        header.setForeground(CustomColors.CHEESE);
        JLabel fuIcon = new JLabel(Icons.FU_ICON, 0);
        header.add(fuIcon);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        middlePanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        final IconTextField tokenField = new IconTextField();
        tokenField.setBackground(CustomColors.DARK_GRAY);
        tokenField.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()), BorderFactory.createEmptyBorder(10, 0, 10, 0)));
        tokenField.setPreferredSize(new Dimension(170, 40));
        JLabel tokenFieldDescriptor = new JLabel("TOKEN", 2);
        tokenFieldDescriptor.setFont(new Font("Whitney", 1, 12));
        tokenFieldDescriptor.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        tokenFieldDescriptor.setBorder(new EmptyBorder(0, 0, 5, 0));
        middlePanel.add((Component)tokenFieldDescriptor, "North");
        middlePanel.add((Component)tokenField, "Center");
        JPanel loginButtonWrapper = new JPanel();
        loginButtonWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        final JLabel loginButton = new JLabel("Login", 0);
        loginButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, ColorScheme.GRAND_EXCHANGE_PRICE.darker()), new EmptyBorder(10, 20, 10, 20)));
        loginButton.setFont(new Font("Whitney", 1, 12));
        loginButton.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE);
        loginButton.setOpaque(true);
        loginButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int result = JOptionPane.showOptionDialog(loginButton, "Logging into flipping utilities will submit GE transactions and your IP address\nto flipping utilities, a 3rd party not controlled or verified by the RuneLite developers", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    LoginPanel.this.plugin.getApiAuthHandler().loginWithToken(tokenField.getText().trim()).exceptionally(exception -> {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(loginButton, "Authentication error, contact us on discord for help!", "Authentication error \ud83d\ude14", 0));
                        return null;
                    });
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                loginButton.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE.brighter());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                loginButton.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE);
            }
        });
        loginButtonWrapper.add(loginButton);
        tokenPanel.add((Component)header, "North");
        tokenPanel.add((Component)middlePanel, "Center");
        tokenPanel.add((Component)loginButtonWrapper, "South");
        return tokenPanel;
    }
}

