/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.login;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.LinkBrowser;

public class LoggedInPanel
extends JPanel {
    FlippingPlugin plugin;
    Runnable showLoggedOutPanel;
    JLabel slotFeatureHealthLabel = new JLabel("Inactive (not logged in)");

    public LoggedInPanel(FlippingPlugin plugin, Runnable showLoggedOutPanel) {
        this.plugin = plugin;
        this.showLoggedOutPanel = showLoggedOutPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add((Component)this.createTitle(), "North");
        this.add((Component)this.createSignOutButton(), "South");
    }

    private JLabel createTitle() {
        JLabel headerLabel = new JLabel("Status", 0);
        headerLabel.setFont(new Font("Whitney", 1, 16));
        headerLabel.setForeground(CustomColors.CHEESE);
        return headerLabel;
    }

    private JPanel createResubPanel() {
        JPanel resubPanel = new JPanel();
        resubPanel.setLayout(new BoxLayout(resubPanel, 1));
        resubPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        JLabel notPremium = new JLabel(String.format("<html><div style=\"text-align:center\" WIDTH=%d>%s</div></html>", 180, "You are not premium anymore, resub to gain access to premium features"), 0);
        notPremium.setFont(new Font("Whitney", 0, 12));
        notPremium.setForeground(CustomColors.TOMATO);
        final JLabel link = new JLabel("<html>https://upgrade.chat/flipping-utilities</html>", 0);
        link.setFont(new Font("Whitney", 0, 12));
        link.setForeground(Color.WHITE);
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LinkBrowser.browse((String)"https://upgrade.chat/flipping-utilities");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                link.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                link.setForeground(Color.WHITE);
            }
        });
        resubPanel.add(notPremium);
        resubPanel.add(Box.createVerticalStrut(10));
        resubPanel.add(link);
        return resubPanel;
    }

    private JPanel createPremiumFeaturesPanel() {
        JPanel healthPanel = new JPanel();
        healthPanel.setLayout(new BoxLayout(healthPanel, 1));
        healthPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        JPanel slotSendingHealthPanel = new JPanel(new BorderLayout());
        JLabel slotFeatureHealthRight = new JLabel("Slot sending feature: ");
        slotFeatureHealthRight.setFont(new Font("Whitney", 0, 10));
        slotFeatureHealthRight.setForeground(CustomColors.CHEESE);
        this.slotFeatureHealthLabel.setFont(new Font("Whitney", 2, 10));
        slotSendingHealthPanel.add((Component)slotFeatureHealthRight, "West");
        slotSendingHealthPanel.add((Component)this.slotFeatureHealthLabel, "East");
        healthPanel.add(slotSendingHealthPanel);
        healthPanel.add(this.createSlotEnhancementTogglePanel());
        return healthPanel;
    }

    private JPanel createSignOutButton() {
        JPanel signoutButtonWrapper = new JPanel();
        final JLabel signOutButton = new JLabel("Sign Out", 0);
        signOutButton.setBorder(new EmptyBorder(10, 10, 10, 10));
        signOutButton.setFont(new Font("Whitney", 1, 12));
        signOutButton.setBackground(CustomColors.TOMATO);
        signOutButton.setOpaque(true);
        final Runnable r = this.showLoggedOutPanel;
        signOutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int result = JOptionPane.showOptionDialog(signOutButton, "Signing out will require you to re-enter the token\ngiven to you by the Flopper discord bot", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    LoggedInPanel.this.plugin.getDataHandler().getAccountWideData().setJwt(null);
                    LoggedInPanel.this.plugin.getDataHandler().markDataAsHavingChanged("Accountwide");
                    LoggedInPanel.this.plugin.getApiAuthHandler().setPremium(false);
                    LoggedInPanel.this.plugin.getApiAuthHandler().setHasValidJWT(false);
                    r.run();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                signOutButton.setBackground(CustomColors.TOMATO.brighter());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                signOutButton.setBackground(CustomColors.TOMATO);
            }
        });
        signoutButtonWrapper.add(signOutButton);
        return signoutButtonWrapper;
    }

    public void showPremiumFeaturesHealth(boolean isPremium) {
        SwingUtilities.invokeLater(() -> {
            if (isPremium) {
                this.removeAll();
                this.add((Component)this.createTitle(), "North");
                this.add((Component)this.createSignOutButton(), "South");
                this.add((Component)this.createPremiumFeaturesPanel(), "Center");
            } else {
                this.removeAll();
                this.add((Component)this.createTitle(), "North");
                this.add((Component)this.createSignOutButton(), "South");
                this.add((Component)this.createResubPanel(), "Center");
            }
            this.revalidate();
            this.repaint();
        });
    }

    private JPanel createSlotEnhancementTogglePanel() {
        JLabel toggleLabel = new JLabel("Slot enhancement");
        toggleLabel.setFont(new Font("Whitney", 0, 10));
        toggleLabel.setForeground(CustomColors.CHEESE);
        JToggleButton toggleButton = UIUtilities.createToggleButton();
        toggleButton.setSelected(this.plugin.shouldEnhanceSlots());
        toggleButton.addItemListener(i -> this.plugin.toggleEnhancedSlots(toggleButton.isSelected()));
        JPanel toggleSlotEnhancementPanel = new JPanel(new BorderLayout());
        toggleSlotEnhancementPanel.add((Component)toggleLabel, "West");
        toggleSlotEnhancementPanel.add((Component)toggleButton, "East");
        return toggleSlotEnhancementPanel;
    }

    public void setSlotFeatureHealthText(String text) {
        this.slotFeatureHealthLabel.setText(text);
    }
}

