/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.gehistorytab;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.gehistorytab.GeHistoryTabOfferPanel;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeHistoryTabPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(GeHistoryTabPanel.class);
    public JPanel geHistoryTabOffersPanel;
    public JLabel statusTextLabel;
    public Set<Integer> selectedOfferIds;
    public Set<Integer> highlightedPanels;
    public List<OfferEvent> offersFromHistoryTab;
    public JButton addOffersButton;
    public Widget[] geHistoryTabWidgets;
    public List<GeHistoryTabOfferPanel> offerPanels;
    public List<List<OfferEvent>> matchingOffers;
    FlippingPlugin plugin;
    private static final int ORIGINAL_WIDGET_COLOR = 16750623;

    public GeHistoryTabPanel(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.offerPanels = new ArrayList<GeHistoryTabOfferPanel>();
        this.geHistoryTabOffersPanel = new JPanel();
        this.selectedOfferIds = new HashSet<Integer>();
        this.highlightedPanels = new HashSet<Integer>();
        this.geHistoryTabOffersPanel.setBorder(new EmptyBorder(5, 6, 0, 6));
        this.geHistoryTabOffersPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTitlePanel(), "North");
        this.add((Component)this.createOfferContainer(), "Center");
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        titlePanel.setBorder(new EmptyBorder(5, 5, 10, 5));
        JLabel titleText = new JLabel("Grand Exchange History", 0);
        titleText.setFont(new Font("Verdana", 1, 15));
        JPanel statusPanel = new JPanel(new BorderLayout(0, 5));
        statusPanel.setBorder(new EmptyBorder(7, 0, 0, 0));
        statusPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.statusTextLabel = new JLabel("0 items selected", 0);
        this.statusTextLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.statusTextLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.statusTextLabel.setFont(FontManager.getRunescapeBoldFont());
        this.addOffersButton = new JButton("Add selected offers");
        this.addOffersButton.setFont(FontManager.getRunescapeBoldFont());
        this.addOffersButton.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.addOffersButton.setFocusPainted(false);
        this.addOffersButton.setVisible(false);
        this.addOffersButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    GeHistoryTabPanel.this.addSelectedOffers();
                }
            }
        });
        statusPanel.add((Component)this.addOffersButton, "Center");
        statusPanel.add((Component)this.statusTextLabel, "North");
        titlePanel.add((Component)titleText, "Center");
        titlePanel.add((Component)statusPanel, "South");
        return titlePanel;
    }

    private void addSelectedOffers() {
        List<OfferEvent> selectedOffers = this.selectedOfferIds.stream().map(idx -> this.offersFromHistoryTab.get((int)idx)).collect(Collectors.toList());
        this.highlightedPanels.addAll(this.selectedOfferIds);
        this.plugin.addSelectedGeTabOffers(selectedOffers);
        this.matchingOffers = this.offersFromHistoryTab.stream().map(o -> this.plugin.findOfferMatches((OfferEvent)o, 5)).collect(Collectors.toList());
        this.rebuild(this.offersFromHistoryTab, this.matchingOffers, this.geHistoryTabWidgets, true);
    }

    private JPanel createOfferContainer() {
        JPanel geHistoryTabOfferContainer = new JPanel(new BorderLayout());
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.geHistoryTabOffersPanel, "North");
        JScrollPane scrollWrapper = new JScrollPane(wrapper);
        scrollWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(5, 0));
        scrollWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(0, 0, 0, 0));
        geHistoryTabOfferContainer.add((Component)scrollWrapper, "Center");
        geHistoryTabOfferContainer.setBorder(new EmptyBorder(5, 0, 0, 0));
        geHistoryTabOfferContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        return geHistoryTabOfferContainer;
    }

    private void onCheckBoxChange(int offerId, boolean selected) {
        int offset = offerId * 6;
        if (selected) {
            this.selectedOfferIds.add(offerId);
            this.geHistoryTabWidgets[offset + 2].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
            this.geHistoryTabWidgets[offset + 3].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
            this.geHistoryTabWidgets[offset + 5].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
        } else if (this.selectedOfferIds.contains(offerId)) {
            this.selectedOfferIds.remove(offerId);
            this.geHistoryTabWidgets[offset + 2].setTextColor(16750623);
            this.geHistoryTabWidgets[offset + 3].setTextColor(16750623);
            this.geHistoryTabWidgets[offset + 5].setTextColor(16750623);
        }
        this.statusTextLabel.setText(this.selectedOfferIds.size() + " items selected");
        this.addOffersButton.setVisible(this.selectedOfferIds.size() > 0);
    }

    public void rebuild(List<OfferEvent> offers, List<List<OfferEvent>> matchingOffers, Widget[] widgets, boolean keepHighlightedPanels) {
        SwingUtilities.invokeLater(() -> {
            Instant rebuildStart = Instant.now();
            this.offersFromHistoryTab = offers;
            this.matchingOffers = matchingOffers;
            this.geHistoryTabWidgets = widgets;
            this.selectedOfferIds.clear();
            if (!keepHighlightedPanels) {
                this.highlightedPanels.clear();
            }
            this.offerPanels.clear();
            this.addOffersButton.setVisible(false);
            this.statusTextLabel.setText("0 items selected");
            this.geHistoryTabOffersPanel.removeAll();
            for (int i = 0; i < offers.size(); ++i) {
                this.offerPanels.add(new GeHistoryTabOfferPanel((OfferEvent)offers.get(i), (List)matchingOffers.get(i), i, this::onCheckBoxChange, this.geHistoryTabWidgets));
            }
            UIUtilities.stackPanelsVertically(this.offerPanels, this.geHistoryTabOffersPanel, 4);
            this.highlightedPanels.forEach(idx -> this.offerPanels.get((int)idx).setAdded());
            this.revalidate();
            this.repaint();
        });
    }
}

