/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.gehistorytab;

import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.gehistorytab.MatchingOffersPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;

public class GeHistoryTabOfferPanel
extends JPanel {
    private int offerId;
    private Widget[] geHistoryTabWidgets;
    private static final int ORIGINAL_WIDGET_COLOR = 16750623;
    private JCheckBox checkBox;
    private JPanel checkBoxPanel;

    public GeHistoryTabOfferPanel(OfferEvent offer, List<OfferEvent> matchingOffers, int offerId, BiConsumer<Integer, Boolean> onCheckBoxChangeCallback, Widget[] geHistoryTabWidgets) {
        this.offerId = offerId;
        this.geHistoryTabWidgets = geHistoryTabWidgets;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.checkBoxPanel = new JPanel(new BorderLayout());
        this.checkBoxPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.checkBox = new JCheckBox();
        this.checkBox.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.checkBox.setFocusPainted(false);
        this.checkBoxPanel.add((Component)this.checkBox, "Center");
        this.checkBox.addItemListener(itemEvent -> {
            onCheckBoxChangeCallback.accept(offerId, itemEvent.getStateChange() == 1);
            this.lightCorrespondingWidgets(itemEvent.getStateChange() == 1);
        });
        this.add((Component)this.checkBoxPanel, "West");
        this.add((Component)this.createInfoPanel(offer, matchingOffers), "Center");
    }

    public JPanel createInfoPanel(OfferEvent offer, List<OfferEvent> matchingOffers) {
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(new EmptyBorder(3, 6, 3, 3));
        infoPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel itemNameLabel = new JLabel(offer.getItemName(), 0);
        itemNameLabel.setFont(FontManager.getRunescapeBoldFont());
        itemNameLabel.setForeground(Color.WHITE);
        itemNameLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel offerDetailsPanel = new JPanel((LayoutManager)new DynamicGridLayout(3, 1, 0, 0));
        JPanel statePanel = new JPanel(new BorderLayout());
        JLabel leftStateLabel = new JLabel("State:");
        JLabel rightStateLabel = new JLabel(offer.getState() == GrandExchangeOfferState.BOUGHT ? "Bought" : "Sold");
        statePanel.add((Component)leftStateLabel, "West");
        statePanel.add((Component)rightStateLabel, "East");
        statePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel quantityPanel = new JPanel(new BorderLayout());
        JLabel leftQuantityLabel = new JLabel("Quantity:");
        JLabel rightQuantityLabel = new JLabel(NumberFormat.getIntegerInstance().format(offer.getCurrentQuantityInTrade()));
        quantityPanel.add((Component)leftQuantityLabel, "West");
        quantityPanel.add((Component)rightQuantityLabel, "East");
        quantityPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel pricePanel = new JPanel(new BorderLayout());
        JLabel leftPriceLabel = new JLabel("Price Ea:");
        JLabel rightPriceLabel = new JLabel(NumberFormat.getIntegerInstance().format(offer.getPrice()));
        pricePanel.add((Component)leftPriceLabel, "West");
        pricePanel.add((Component)rightPriceLabel, "East");
        pricePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        offerDetailsPanel.add(statePanel);
        offerDetailsPanel.add(quantityPanel);
        offerDetailsPanel.add(pricePanel);
        infoPanel.add((Component)itemNameLabel, "North");
        infoPanel.add((Component)offerDetailsPanel, "Center");
        infoPanel.add((Component)new MatchingOffersPanel(matchingOffers), "South");
        return infoPanel;
    }

    public void setAdded() {
        this.checkBox.setEnabled(false);
        this.checkBox.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.checkBoxPanel.setBackground(ColorScheme.GRAND_EXCHANGE_PRICE);
    }

    private void lightCorrespondingWidgets(boolean shouldLight) {
        int offset = this.offerId * 6;
        if (shouldLight) {
            this.geHistoryTabWidgets[offset + 2].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
            this.geHistoryTabWidgets[offset + 3].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
            this.geHistoryTabWidgets[offset + 5].setTextColor(ColorScheme.GRAND_EXCHANGE_PRICE.getRGB());
        } else {
            this.geHistoryTabWidgets[offset + 2].setTextColor(16750623);
            this.geHistoryTabWidgets[offset + 3].setTextColor(16750623);
            this.geHistoryTabWidgets[offset + 5].setTextColor(16750623);
        }
    }
}

