/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.flipping;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.flipping.FlippingItemPanel;
import com.flippingutilities.ui.offereditor.OfferEditorContainerPanel;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.Paginator;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Constants;
import com.flippingutilities.utilities.WikiRequestWrapper;
import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlippingPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(FlippingPanel.class);
    private static final String WELCOME_PANEL = "WELCOME_PANEL";
    private static final String ITEMS_PANEL = "ITEMS_PANEL";
    private final FlippingPlugin plugin;
    private final ItemManager itemManager;
    public final CardLayout cardLayout = new CardLayout();
    private final JPanel flippingItemsPanel = new JPanel();
    public final JPanel flippingItemContainer = new JPanel(this.cardLayout);
    private ArrayList<FlippingItemPanel> activePanels = new ArrayList();
    private boolean itemHighlighted = false;
    private Paginator paginator;
    private OfferEditorContainerPanel offerEditorContainerPanel;
    private IconTextField searchBar;
    private boolean currentlySearching;
    private boolean favoriteSelected;

    public FlippingPanel(FlippingPlugin plugin) {
        super(false);
        this.plugin = plugin;
        this.itemManager = plugin.getItemManager();
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.flippingItemsPanel.setLayout(new BoxLayout(this.flippingItemsPanel, 1));
        this.flippingItemsPanel.setBorder(new EmptyBorder(0, 8, 0, 7));
        this.flippingItemsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.flippingItemsPanel, "North");
        JScrollPane scrollPane = new JScrollPane(wrapper);
        scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(2, 0));
        JPanel welcomeWrapper = new JPanel(new BorderLayout());
        welcomeWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        PluginErrorPanel welcomePanel = new PluginErrorPanel();
        welcomeWrapper.add((Component)welcomePanel, "North");
        welcomePanel.setContent("Flipping Utilities", "Make offers for items to show up!");
        this.flippingItemContainer.add((Component)scrollPane, ITEMS_PANEL);
        this.flippingItemContainer.add((Component)welcomeWrapper, WELCOME_PANEL);
        this.searchBar = UIUtilities.createSearchBar(plugin.getExecutor(), sBar -> plugin.getClientThread().invoke(() -> this.updateSearch((IconTextField)sBar)));
        this.searchBar.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARKER_GRAY_COLOR.darker()));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(0, 8, 2, 10));
        topPanel.add((Component)this.searchBar, "Center");
        topPanel.add((Component)this.createFavoriteButton(), "East");
        this.paginator = new Paginator(() -> this.rebuild(plugin.viewItemsForCurrentView()));
        this.paginator.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.paginator.setBorder(new MatteBorder(1, 0, 0, 2, ColorScheme.DARK_GRAY_COLOR.darker()));
        this.paginator.setPageSize(10);
        this.cardLayout.show(this.flippingItemContainer, WELCOME_PANEL);
        this.add((Component)topPanel, "North");
        this.add((Component)this.flippingItemContainer, "Center");
        this.add((Component)this.paginator, "South");
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
    }

    public void rebuild(List<FlippingItem> flippingItems) {
        SwingUtilities.invokeLater(() -> {
            this.activePanels.forEach(p -> p.popup.setVisible(false));
            this.activePanels.clear();
            this.flippingItemsPanel.removeAll();
            if (flippingItems == null) {
                this.cardLayout.show(this.flippingItemContainer, WELCOME_PANEL);
                return;
            }
            int vGap = 8;
            this.cardLayout.show(this.flippingItemContainer, ITEMS_PANEL);
            List<FlippingItem> itemsToDisplay = this.getItemsToDisplay(flippingItems);
            List itemsThatShouldHavePanels = itemsToDisplay.stream().filter(item -> item.getValidFlippingPanelItem()).collect(Collectors.toList());
            this.paginator.updateTotalPages(itemsThatShouldHavePanels.size());
            List itemsOnCurrentPage = this.paginator.getCurrentPageItems(itemsThatShouldHavePanels);
            List<JPanel> newPanels = itemsOnCurrentPage.stream().map(item -> new FlippingItemPanel(this.plugin, this.itemManager.getImage(item.getItemId()), (FlippingItem)item)).collect(Collectors.toList());
            this.flippingItemsPanel.add(Box.createVerticalStrut(vGap));
            UIUtilities.stackPanelsVertically(newPanels, this.flippingItemsPanel, vGap);
            this.flippingItemsPanel.add(Box.createVerticalStrut(vGap));
            this.activePanels.addAll(newPanels);
            if (this.isItemHighlighted()) {
                this.offerEditorContainerPanel = new OfferEditorContainerPanel(this.plugin);
                this.offerEditorContainerPanel.selectPriceEditor();
                this.flippingItemsPanel.add(this.offerEditorContainerPanel);
                this.flippingItemsPanel.add(Box.createVerticalStrut(vGap));
            }
            if (this.activePanels.isEmpty() && !this.itemHighlighted) {
                this.cardLayout.show(this.flippingItemContainer, WELCOME_PANEL);
            }
            this.revalidate();
            this.repaint();
        });
    }

    public void onNewOfferEventRebuild(OfferEvent offerEvent) {
        boolean newOfferEventAlreadyAtTop;
        boolean bl = newOfferEventAlreadyAtTop = this.activePanels.size() > 0 && this.activePanels.get(0).getFlippingItem().getItemId() == offerEvent.getItemId();
        if (newOfferEventAlreadyAtTop) {
            this.refreshPricesForFlippingItemPanel(offerEvent.getItemId());
            return;
        }
        if (!this.isItemHighlighted() && !this.currentlySearching) {
            this.rebuild(this.plugin.viewItemsForCurrentView());
        }
    }

    private List<FlippingItem> getItemsToDisplay(List<FlippingItem> tradeList) {
        List<FlippingItem> result = new ArrayList<FlippingItem>(tradeList);
        if (this.favoriteSelected && !this.isItemHighlighted()) {
            result = result.stream().filter(FlippingItem::isFavorite).collect(Collectors.toList());
        }
        result = this.getResultsForCurrentSearchQuery(result);
        this.sortByTime(result);
        return result;
    }

    private List<FlippingItem> getResultsForCurrentSearchQuery(List<FlippingItem> items) {
        String lookup = this.searchBar.getText().toLowerCase();
        if (!this.currentlySearching || Strings.isNullOrEmpty((String)lookup)) {
            return items;
        }
        Map<Integer, FlippingItem> currentFlippingItems = items.stream().collect(Collectors.toMap(f -> f.getItemId(), f -> f));
        ArrayList<FlippingItem> matchesInHistory = new ArrayList<FlippingItem>();
        ArrayList<FlippingItem> matchesNotInHistory = new ArrayList<FlippingItem>();
        for (ItemPrice itemInfo : this.itemManager.search(lookup)) {
            if (currentFlippingItems.containsKey(itemInfo.getId())) {
                FlippingItem flippingItem = currentFlippingItems.get(itemInfo.getId());
                flippingItem.setValidFlippingPanelItem(true);
                matchesInHistory.add(flippingItem);
                continue;
            }
            FlippingItem dummyFlippingItem = new FlippingItem(itemInfo.getId(), itemInfo.getName(), 0, Constants.DUMMY_ITEM);
            dummyFlippingItem.setValidFlippingPanelItem(true);
            matchesNotInHistory.add(dummyFlippingItem);
        }
        ArrayList<FlippingItem> allMatches = new ArrayList<FlippingItem>();
        allMatches.addAll(matchesInHistory);
        allMatches.addAll(matchesNotInHistory);
        return allMatches;
    }

    private void sortByTime(List<FlippingItem> items) {
        items.sort((item1, item2) -> {
            if (item1 == null || item2 == null) {
                return -1;
            }
            if (item1.getLatestActivityTime() == null || item2.getLatestActivityTime() == null) {
                return -1;
            }
            return item2.getLatestActivityTime().compareTo(item1.getLatestActivityTime());
        });
    }

    public void highlightItem(FlippingItem item) {
        SwingUtilities.invokeLater(() -> {
            this.paginator.setPageNumber(1);
            this.itemHighlighted = true;
            this.rebuild(Collections.singletonList(item));
        });
    }

    private JLabel createFavoriteButton() {
        final JLabel favoriteButton = new JLabel(Icons.SMALL_STAR_OFF_ICON);
        favoriteButton.setBorder(new EmptyBorder(0, 5, 0, 0));
        favoriteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FlippingPanel.this.favoriteSelected) {
                    favoriteButton.setIcon(Icons.SMALL_STAR_OFF_ICON);
                } else {
                    favoriteButton.setIcon(Icons.SMALL_STAR_ON_ICON);
                }
                FlippingPanel.this.favoriteSelected = !FlippingPanel.this.favoriteSelected;
                FlippingPanel.this.rebuild(FlippingPanel.this.plugin.viewItemsForCurrentView());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!FlippingPanel.this.favoriteSelected) {
                    favoriteButton.setIcon(Icons.SMALL_STAR_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (FlippingPanel.this.favoriteSelected) {
                    favoriteButton.setIcon(Icons.SMALL_STAR_ON_ICON);
                } else {
                    favoriteButton.setIcon(Icons.SMALL_STAR_OFF_ICON);
                }
            }
        });
        return favoriteButton;
    }

    public void dehighlightItem() {
        if (!this.itemHighlighted) {
            return;
        }
        this.itemHighlighted = false;
        this.rebuild(this.plugin.viewItemsForCurrentView());
    }

    public void updateTimerDisplays() {
        for (FlippingItemPanel activePanel : this.activePanels) {
            activePanel.updateTimerDisplays();
            activePanel.updateWikiTimeLabels();
        }
    }

    public void onWikiRequest(WikiRequestWrapper wikiRequestWrapper, Instant timeOfRequestCompletion) {
        this.activePanels.forEach(panel -> panel.onWikiRequest(wikiRequestWrapper, timeOfRequestCompletion));
    }

    private void updateSearch(IconTextField searchBar) {
        String lookup = searchBar.getText().toLowerCase();
        if (this.isItemHighlighted()) {
            this.currentlySearching = false;
            return;
        }
        if (Strings.isNullOrEmpty((String)lookup)) {
            this.paginator.setPageNumber(1);
            this.currentlySearching = false;
            this.rebuild(this.plugin.viewItemsForCurrentView());
            return;
        }
        searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.currentlySearching = true;
        this.paginator.setPageNumber(1);
        this.rebuild(this.plugin.viewItemsForCurrentView());
    }

    public void refreshPricesForFlippingItemPanel(int itemId) {
        for (FlippingItemPanel panel : this.activePanels) {
            if (panel.getFlippingItem().getItemId() != itemId) continue;
            panel.setValueLabels();
        }
    }

    public static String getWELCOME_PANEL() {
        return WELCOME_PANEL;
    }

    public boolean isItemHighlighted() {
        return this.itemHighlighted;
    }

    public void setItemHighlighted(boolean itemHighlighted) {
        this.itemHighlighted = itemHighlighted;
    }

    public Paginator getPaginator() {
        return this.paginator;
    }

    public OfferEditorContainerPanel getOfferEditorContainerPanel() {
        return this.offerEditorContainerPanel;
    }
}

