/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.flipping;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.jobs.WikiDataFetcherJob;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.Section;
import com.flippingutilities.ui.flipping.CustomizationPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.CustomFonts;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import com.flippingutilities.utilities.Constants;
import com.flippingutilities.utilities.GeTax;
import com.flippingutilities.utilities.WikiDataSource;
import com.flippingutilities.utilities.WikiItemMargins;
import com.flippingutilities.utilities.WikiRequestWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlippingItemPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(FlippingItemPanel.class);
    private static final String NUM_FORMAT = "%,d";
    private final FlippingItem flippingItem;
    private FlippingPlugin plugin;
    JLabel wikiBuyVal = new JLabel();
    JLabel wikiSellVal = new JLabel();
    JLabel wikiBuyTimeVal = new JLabel();
    JLabel wikiSellTimeVal = new JLabel();
    JLabel instaSellVal = new JLabel();
    JLabel instaBuyVal = new JLabel();
    JLabel latestBuyPriceVal = new JLabel();
    JLabel latestSellPriceVal = new JLabel();
    JLabel wikiProfitEachVal = new JLabel();
    JLabel wikiPotentialProfitVal = new JLabel();
    JLabel wikiRoiLabelVal = new JLabel();
    JLabel geLimitVal = new JLabel();
    JLabel marginCheckProfitEachVal = new JLabel();
    JLabel geRefreshCountdownLabel = new JLabel();
    JLabel wikiRequestCountDownTimer = new JLabel();
    JLabel geRefreshAtLabel = new JLabel();
    JLabel wikiBuyText = new JLabel("Wiki insta buy: ");
    JLabel wikiSellText = new JLabel("Wiki insta sell: ");
    JLabel wikiBuyTimeText = new JLabel("Wiki insta buy age: ");
    JLabel wikiSellTimeText = new JLabel("Wiki insta sell age: ");
    JLabel instaSellText = new JLabel("Last insta sell: ");
    JLabel instaBuyText = new JLabel("Last insta buy: ");
    JLabel latestBuyPriceText = new JLabel("Last buy price: ");
    JLabel latestSellPriceText = new JLabel("Last sell price: ");
    JLabel wikiProfitEachText = new JLabel("Wiki profit ea: ");
    JLabel marginCheckProfitEachText = new JLabel("MC profit ea: ");
    JLabel wikiPotentialProfitText = new JLabel("Potential profit: ");
    JLabel wikiRoiText = new JLabel("ROI:", 0);
    JLabel geLimitText = new JLabel("GE limit:", 0);
    JPanel itemInfo;
    JLabel searchCodeLabel;
    JLabel refreshIconLabel = new JLabel();
    WikiRequestWrapper wikiRequestWrapper;
    Instant timeOfRequestCompletion;
    JPopupMenu popup;

    FlippingItemPanel(FlippingPlugin plugin, AsyncBufferedImage itemImage, FlippingItem flippingItem) {
        this.flippingItem = flippingItem;
        this.plugin = plugin;
        flippingItem.validateGeProperties();
        this.setBackground(CustomColors.DARK_GRAY);
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, ColorScheme.DARKER_GRAY_COLOR.darker()), new EmptyBorder(10, 5, 0, 0)));
        this.setToolTipText("Flipped by " + flippingItem.getFlippedBy());
        this.styleDescriptionLabels();
        this.styleValueLabels();
        this.setValueLabels();
        this.updateTimerDisplays();
        JPanel titlePanel = this.createTitlePanel(this.createItemIcon(itemImage), this.createItemNameLabel(), this.createFavoriteIcon());
        this.itemInfo = this.createItemInfoPanel();
        this.add((Component)titlePanel, "North");
        this.add((Component)this.itemInfo, "Center");
        this.add((Component)this.createBottomPanel(), "South");
        if (!plugin.getConfig().verboseViewEnabled()) {
            this.collapse();
        }
        if (flippingItem.getExpand() != null) {
            if (flippingItem.getExpand().booleanValue()) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    private JPanel createItemInfoPanel() {
        JPanel itemInfo = new JPanel();
        itemInfo.setLayout(new BoxLayout(itemInfo, 1));
        itemInfo.setBackground(this.getBackground());
        itemInfo.setBorder(new EmptyBorder(20, 6, 8, 8));
        List<Section> sections = this.plugin.getDataHandler().viewAccountWideData().getSections();
        for (Section section : sections) {
            itemInfo.add(this.createSectionPanel(section));
            itemInfo.add(Box.createVerticalStrut(5));
        }
        return itemInfo;
    }

    private JPanel createSectionPanel(final Section section) {
        JPanel sectionPanel = new JPanel(new BorderLayout());
        sectionPanel.setBackground(this.getBackground());
        final JLabel arrowIconLabel = new JLabel(section.isDefaultExpanded() ? Icons.OPEN_ICON : Icons.CLOSE_ICON);
        arrowIconLabel.setVerticalAlignment(1);
        arrowIconLabel.setFont(FontManager.getRunescapeBoldFont());
        arrowIconLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        sectionPanel.add((Component)arrowIconLabel, "West");
        final JPanel sectionItemsPanel = new JPanel();
        sectionItemsPanel.setLayout(new BoxLayout(sectionItemsPanel, 1));
        sectionItemsPanel.setBackground(this.getBackground());
        if (!section.isDefaultExpanded()) {
            arrowIconLabel.setText(section.getName());
            sectionItemsPanel.setVisible(false);
        }
        sectionPanel.add((Component)sectionItemsPanel, "Center");
        arrowIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (sectionItemsPanel.isVisible()) {
                    sectionItemsPanel.setVisible(false);
                    arrowIconLabel.setIcon(Icons.CLOSE_ICON);
                    arrowIconLabel.setText(section.getName());
                } else {
                    sectionItemsPanel.setVisible(true);
                    arrowIconLabel.setIcon(Icons.OPEN_ICON);
                    arrowIconLabel.setText("");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
            }
        });
        ArrayList<String> labelsToShow = new ArrayList<String>();
        for (String labelName : section.getLabels().keySet()) {
            if (!section.getLabels().get(labelName).booleanValue()) continue;
            labelsToShow.add(labelName);
        }
        boolean isFirstInPair = true;
        for (String labelName : labelsToShow) {
            JPanel panel = this.createPanelForSectionLabel(labelName);
            if (isFirstInPair) {
                panel.setBorder(new EmptyBorder(6, 0, 3, 0));
            } else {
                panel.setBorder(new EmptyBorder(2, 0, 8, 0));
            }
            isFirstInPair = !isFirstInPair;
            sectionItemsPanel.add(panel);
        }
        return sectionPanel;
    }

    private JPanel createPanelForSectionLabel(String labelName) {
        JLabel valueLabel;
        JComponent descriptionLabel;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(this.getBackground());
        switch (labelName) {
            case "wiki buy price": {
                descriptionLabel = this.wikiBuyText;
                valueLabel = this.wikiBuyVal;
                break;
            }
            case "wiki sell price": {
                descriptionLabel = this.wikiSellText;
                valueLabel = this.wikiSellVal;
                break;
            }
            case "price check buy price": {
                JLabel instaSellPreTaxLabel = new JLabel("Pre tax");
                instaSellPreTaxLabel.setFont(new Font("Whitney", 2, 6));
                JPanel instaSellDescPanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1));
                instaSellDescPanel.setBackground(CustomColors.DARK_GRAY);
                instaSellDescPanel.add(this.instaSellText);
                instaSellDescPanel.add(instaSellPreTaxLabel);
                descriptionLabel = instaSellDescPanel;
                valueLabel = this.instaSellVal;
                break;
            }
            case "price check sell price": {
                descriptionLabel = this.instaBuyText;
                valueLabel = this.instaBuyVal;
                this.makePropertyPanelEditable(panel, this.instaBuyVal, this.instaBuyText);
                break;
            }
            case "latest buy price": {
                descriptionLabel = this.latestBuyPriceText;
                valueLabel = this.latestBuyPriceVal;
                this.makePropertyPanelEditable(panel, this.latestBuyPriceVal, this.latestBuyPriceText);
                break;
            }
            case "latest sell price": {
                JLabel preTaxLabel = new JLabel("Pre tax");
                preTaxLabel.setFont(new Font("Whitney", 2, 6));
                JPanel sellDescPanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1));
                sellDescPanel.setBackground(CustomColors.DARK_GRAY);
                sellDescPanel.add(this.latestSellPriceText);
                sellDescPanel.add(preTaxLabel);
                descriptionLabel = sellDescPanel;
                valueLabel = this.latestSellPriceVal;
                break;
            }
            case "profit each": {
                descriptionLabel = this.wikiProfitEachText;
                valueLabel = this.wikiProfitEachVal;
                break;
            }
            case "potential profit": {
                descriptionLabel = this.wikiPotentialProfitText;
                valueLabel = this.wikiPotentialProfitVal;
                break;
            }
            case "roi": {
                descriptionLabel = this.wikiRoiText;
                valueLabel = this.wikiRoiLabelVal;
                break;
            }
            case "remaining ge limit": {
                descriptionLabel = this.geLimitText;
                valueLabel = this.geLimitVal;
                break;
            }
            case "ge limit refresh timer": {
                return this.createGeTimerPanel();
            }
            case "margin check profit each": {
                descriptionLabel = this.marginCheckProfitEachText;
                valueLabel = this.marginCheckProfitEachVal;
                break;
            }
            default: {
                return new JPanel();
            }
        }
        panel.add((Component)descriptionLabel, "West");
        panel.add((Component)valueLabel, "East");
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBackground(CustomColors.DARK_GRAY);
        bottomPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        final JLabel searchIconLabel = new JLabel(Icons.SEARCH);
        searchIconLabel.setToolTipText("Click to search realtime prices for this item!");
        searchIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkBrowser.browse((String)UIUtilities.buildOurWebsiteLink(FlippingItemPanel.this.flippingItem.getItemId()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                searchIconLabel.setIcon(Icons.SEARCH_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                searchIconLabel.setIcon(Icons.SEARCH);
            }
        });
        final TextField searchCodeTextField = new TextField(10);
        final JPanel searchCodePanel = new JPanel();
        searchCodePanel.setBorder(new EmptyBorder(0, 0, 0, 4));
        searchCodePanel.setBackground(CustomColors.DARK_GRAY);
        searchCodePanel.setPreferredSize(new Dimension(0, 20));
        this.searchCodeLabel = new JLabel("<html> quick search code: " + UIUtilities.colorText(this.flippingItem.getFavoriteCode(), ColorScheme.GRAND_EXCHANGE_ALCH) + "</html>", 0);
        if (this.flippingItem.isFavorite()) {
            this.searchCodeLabel.setText("<html> quick search code: " + UIUtilities.colorText(this.flippingItem.getFavoriteCode(), ColorScheme.GRAND_EXCHANGE_PRICE) + "</html>");
        } else {
            this.searchCodeLabel.setText("<html> quick search code: " + UIUtilities.colorText("N/A", ColorScheme.GRAND_EXCHANGE_ALCH) + "</html>");
        }
        this.searchCodeLabel.setToolTipText("<html>If you have favorited this item, you can type the search code when you are <br>searching for items in the ge to populate your ge results with any item with this code</html>");
        this.searchCodeLabel.setFont(FontManager.getRunescapeSmallFont());
        searchCodePanel.add(this.searchCodeLabel);
        final boolean[] isHighlighted = new boolean[]{false};
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!FlippingItemPanel.this.flippingItem.isFavorite()) {
                    JOptionPane.showMessageDialog(FlippingItemPanel.this.searchCodeLabel, "<html>Item is not favorited.<br> Favorite the item to be able to use/edit the quick search code</html>");
                    return;
                }
                if (isHighlighted[0]) {
                    searchCodePanel.remove(searchCodeTextField);
                    searchCodePanel.add(FlippingItemPanel.this.searchCodeLabel);
                    isHighlighted[0] = false;
                } else {
                    searchCodePanel.remove(FlippingItemPanel.this.searchCodeLabel);
                    searchCodePanel.add(searchCodeTextField);
                    isHighlighted[0] = true;
                }
                FlippingItemPanel.this.repaint();
                FlippingItemPanel.this.revalidate();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                searchCodePanel.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                searchCodePanel.setBackground(FlippingItemPanel.this.getBackground());
            }
        };
        searchCodePanel.addMouseListener(l);
        this.searchCodeLabel.addMouseListener(l);
        searchCodeTextField.setBackground(ColorScheme.DARK_GRAY_COLOR);
        searchCodeTextField.setText(this.flippingItem.getFavoriteCode());
        searchCodeTextField.addActionListener(e -> {
            isHighlighted[0] = false;
            if (this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                this.plugin.setFavoriteCodeOnAllAccounts(this.flippingItem, searchCodeTextField.getText());
            } else {
                this.plugin.markAccountTradesAsHavingChanged(this.plugin.getAccountCurrentlyViewed());
            }
            this.flippingItem.setFavoriteCode(searchCodeTextField.getText());
            this.searchCodeLabel.setText("<html> quick search code: " + UIUtilities.colorText(this.flippingItem.getFavoriteCode(), ColorScheme.GRAND_EXCHANGE_ALCH) + "</html>");
            searchCodePanel.remove(searchCodeTextField);
            searchCodePanel.add(this.searchCodeLabel);
            this.repaint();
            this.revalidate();
        });
        JPanel refreshIconPanel = new JPanel();
        refreshIconPanel.setLayout(new BoxLayout(refreshIconPanel, 0));
        refreshIconPanel.setBackground(this.getBackground());
        this.refreshIconLabel.setIcon(Icons.REFRESH);
        this.refreshIconLabel.setDisabledIcon(Icons.REFRESH_HOVER);
        refreshIconPanel.add(this.refreshIconLabel);
        refreshIconPanel.add(Box.createHorizontalStrut(2));
        refreshIconPanel.add(this.wikiRequestCountDownTimer);
        bottomPanel.add((Component)refreshIconPanel, "West");
        bottomPanel.add((Component)searchIconLabel, "East");
        bottomPanel.add((Component)searchCodePanel, "Center");
        return bottomPanel;
    }

    private void makePropertyPanelEditable(final JPanel propertyPanel, final JLabel valueLabel, JLabel descriptionLabel) {
        final boolean[] isHighlighted = new boolean[]{false};
        final TextField textField = new TextField(10);
        textField.setBackground(ColorScheme.DARK_GRAY_COLOR);
        String currentText = valueLabel.getText();
        String textWithoutGp = currentText.substring(0, currentText.length() - 3);
        textField.setText(textWithoutGp);
        textField.addActionListener(e1 -> {
            isHighlighted[0] = false;
            try {
                int num = Integer.parseInt(textField.getText().replace(",", ""));
                if (num <= 0) {
                    JOptionPane.showMessageDialog(this, "You cannot input zero or a negative number");
                    return;
                }
                valueLabel.setText(String.format(NUM_FORMAT, num) + " gp");
                if (valueLabel == this.instaSellVal) {
                    OfferEvent dummyOffer = OfferEvent.dummyOffer(false, true, num, this.flippingItem.getItemId(), this.flippingItem.getItemName());
                    this.flippingItem.setLatestInstaSell(Optional.of(dummyOffer));
                } else if (valueLabel == this.instaBuyVal) {
                    OfferEvent dummyOffer = OfferEvent.dummyOffer(true, true, num, this.flippingItem.getItemId(), this.flippingItem.getItemName());
                    this.flippingItem.setLatestInstaBuy(Optional.of(dummyOffer));
                } else if (valueLabel == this.latestBuyPriceVal) {
                    OfferEvent dummyOffer = OfferEvent.dummyOffer(true, false, num, this.flippingItem.getItemId(), this.flippingItem.getItemName());
                    this.flippingItem.setLatestBuy(Optional.of(dummyOffer));
                } else {
                    OfferEvent dummyOffer = OfferEvent.dummyOffer(false, false, num, this.flippingItem.getItemId(), this.flippingItem.getItemName());
                    this.flippingItem.setLatestSell(Optional.of(dummyOffer));
                }
                this.setValueLabels();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "You need to input a number");
                return;
            }
            propertyPanel.remove(textField);
            propertyPanel.add((Component)valueLabel, "East");
            this.revalidate();
            this.repaint();
        });
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (isHighlighted[0]) {
                    isHighlighted[0] = false;
                    propertyPanel.remove(textField);
                    propertyPanel.add((Component)valueLabel, "East");
                } else {
                    isHighlighted[0] = true;
                    propertyPanel.remove(valueLabel);
                    propertyPanel.add((Component)textField, "East");
                }
                FlippingItemPanel.this.revalidate();
                FlippingItemPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                propertyPanel.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                propertyPanel.setBackground(CustomColors.DARK_GRAY);
            }
        };
        propertyPanel.addMouseListener(m);
        descriptionLabel.addMouseListener(m);
    }

    private JPanel createGeTimerPanel() {
        JPanel geRefreshTimePanel = new JPanel((LayoutManager)new DynamicGridLayout(2, 1, 0, 2));
        geRefreshTimePanel.setBorder(new EmptyBorder(8, 0, 5, 30));
        geRefreshTimePanel.setBackground(CustomColors.DARK_GRAY);
        geRefreshTimePanel.add(this.geRefreshCountdownLabel);
        geRefreshTimePanel.add(this.geRefreshAtLabel);
        return geRefreshTimePanel;
    }

    private void styleValueLabels() {
        Arrays.asList(this.latestBuyPriceVal, this.latestSellPriceVal, this.instaSellVal, this.instaBuyVal, this.wikiProfitEachVal, this.marginCheckProfitEachVal, this.wikiPotentialProfitVal, this.wikiRoiLabelVal, this.geLimitVal).forEach(label -> {
            label.setHorizontalAlignment(4);
            label.setFont(this.plugin.getFont());
        });
        this.instaSellVal.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        this.instaBuyVal.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        this.wikiProfitEachVal.setForeground(CustomColors.PROFIT_COLOR);
        this.marginCheckProfitEachVal.setForeground(CustomColors.SOFT_ALCH);
        this.wikiPotentialProfitVal.setForeground(CustomColors.PROFIT_COLOR);
        this.geRefreshCountdownLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.geRefreshCountdownLabel.setFont(FontManager.getRunescapeBoldFont());
        this.geRefreshCountdownLabel.setHorizontalAlignment(0);
        this.geRefreshCountdownLabel.setToolTipText("This is a timer displaying how much time is left before the GE limit refreshes for this item");
        this.geRefreshCountdownLabel.setBorder(new EmptyBorder(0, 0, 0, 20));
        this.geRefreshAtLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.geRefreshAtLabel.setFont(FontManager.getRunescapeSmallFont());
        this.geRefreshAtLabel.setHorizontalAlignment(0);
        this.geRefreshAtLabel.setToolTipText("This shows the local time when the ge limit will refresh");
        this.geRefreshAtLabel.setBorder(new EmptyBorder(0, 0, 0, 20));
        this.wikiRoiLabelVal.setToolTipText("<html>Return on investment:<br>Percentage of profit relative to gp invested</html>");
        this.wikiBuyVal.setFont(CustomFonts.SMALLER_RS_BOLD_FONT);
        this.wikiBuyVal.setForeground(Color.WHITE);
        this.wikiSellVal.setFont(CustomFonts.SMALLER_RS_BOLD_FONT);
        this.wikiSellVal.setForeground(Color.WHITE);
        this.wikiRequestCountDownTimer.setAlignmentY(1.0f);
        this.wikiRequestCountDownTimer.setFont(new Font("Serif", 0, 9));
        this.popup = new JPopupMenu();
        this.popup.add(this.createWikiHoverTimePanel());
        UIUtilities.addPopupOnHover(this.wikiBuyVal, this.popup, true);
        UIUtilities.addPopupOnHover(this.wikiSellVal, this.popup, true);
    }

    private void styleDescriptionLabels() {
        Arrays.asList(this.wikiBuyText, this.wikiSellText, this.latestBuyPriceText, this.latestSellPriceText, this.instaSellText, this.instaBuyText, this.wikiProfitEachText, this.marginCheckProfitEachText, this.wikiPotentialProfitText, this.geLimitText, this.wikiRoiText).forEach(label -> {
            label.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            label.setFont(this.plugin.getFont());
        });
        this.instaSellText.setToolTipText("This is the price you insta sold the item for (pre tax)");
        this.instaBuyText.setToolTipText("This is the price you insta bought the item for");
        this.latestBuyPriceText.setToolTipText("The last price you bought this item for");
        this.latestSellPriceText.setToolTipText("The last price you sold this item for (pre tax)");
        this.wikiProfitEachText.setToolTipText("The profit margin according to the wiki insta buy and insta sell prices, after tax");
        this.marginCheckProfitEachText.setToolTipText("The profit margin according to your last insta buy and insta sell price, after tax");
        this.wikiPotentialProfitText.setToolTipText("The potential profit according to the wiki profit margin and the item's limit");
        this.geLimitText.setToolTipText("Remaining ge limit");
        if (this.flippingItem.getTotalGELimit() <= 0) {
            this.geLimitText.setText("Bought:");
            this.geLimitText.setToolTipText("Item has unknown limit, so this just displays how many you have bought in a 4 hour window");
        }
    }

    private JPanel createTitlePanel(JLabel itemIcon, JLabel itemNameLabel, JLabel favoriteButton) {
        final CustomizationPanel customizationPanel = new CustomizationPanel(this.plugin);
        final JDialog customizationModal = UIUtilities.createModalFromPanel(this, customizationPanel);
        final JLabel customizeLabel = new JLabel("customize look", 0);
        final Color c = customizeLabel.getForeground();
        customizeLabel.setFont(FontManager.getRunescapeSmallFont());
        Font font = new Font(customizeLabel.getFont().getName(), 2, customizeLabel.getFont().getSize());
        customizeLabel.setFont(font);
        UIUtilities.makeLabelUnderlined(customizeLabel);
        customizeLabel.setHorizontalAlignment(0);
        customizeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                customizationPanel.rebuild(FlippingItemPanel.this.plugin.getDataHandler().viewAccountWideData().getSections());
                customizationModal.setVisible(true);
                customizationModal.pack();
                customizationModal.setLocation(FlippingItemPanel.this.getLocationOnScreen().x - customizationModal.getWidth() - 10, Math.max(FlippingItemPanel.this.getLocationOnScreen().y - customizationModal.getHeight() / 2, 0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                customizeLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                customizeLabel.setForeground(c);
            }
        });
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(this.getBackground());
        titlePanel.add((Component)itemIcon, "West");
        titlePanel.add((Component)itemNameLabel, "Center");
        titlePanel.add((Component)favoriteButton, "East");
        titlePanel.add((Component)customizeLabel, "South");
        return titlePanel;
    }

    private JLabel createItemIcon(AsyncBufferedImage itemImage) {
        final ImageIcon itemIcon = new ImageIcon((Image)itemImage);
        final JLabel itemIconLabel = new JLabel(itemIcon);
        itemIconLabel.setAlignmentX(0.0f);
        itemIconLabel.setPreferredSize(Icons.ICON_SIZE);
        itemIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FlippingItemPanel.this.flippingItem.setValidFlippingPanelItem(false);
                if (!FlippingItemPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    FlippingItemPanel.this.plugin.markAccountTradesAsHavingChanged(FlippingItemPanel.this.plugin.getAccountCurrentlyViewed());
                }
                FlippingItemPanel.this.plugin.getFlippingPanel().rebuild(FlippingItemPanel.this.plugin.viewItemsForCurrentView());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                itemIconLabel.setIcon(Icons.DELETE_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                itemIconLabel.setIcon(itemIcon);
            }
        });
        return itemIconLabel;
    }

    private JLabel createItemNameLabel() {
        final JLabel itemNameLabel = new JLabel(this.flippingItem.getItemName(), 0);
        itemNameLabel.setFont(FontManager.getRunescapeBoldFont());
        itemNameLabel.setPreferredSize(new Dimension(0, 0));
        itemNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FlippingItemPanel.this.isCollapsed()) {
                    FlippingItemPanel.this.expand();
                    FlippingItemPanel.this.flippingItem.setExpand(true);
                } else {
                    FlippingItemPanel.this.collapse();
                    FlippingItemPanel.this.flippingItem.setExpand(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (FlippingItemPanel.this.isCollapsed()) {
                    itemNameLabel.setText("Expand");
                } else {
                    itemNameLabel.setText("Collapse");
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                itemNameLabel.setText(FlippingItemPanel.this.flippingItem.getItemName());
            }
        });
        return itemNameLabel;
    }

    private JLabel createFavoriteIcon() {
        final JLabel favoriteIcon = new JLabel();
        favoriteIcon.setIcon(this.flippingItem.isFavorite() ? Icons.STAR_ON_ICON : Icons.STAR_OFF_ICON);
        favoriteIcon.setAlignmentX(1.0f);
        favoriteIcon.setPreferredSize(new Dimension(24, 24));
        favoriteIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                boolean wasDummyAndAccountwide;
                boolean wasDummy = false;
                if (Constants.DUMMY_ITEM.equals(FlippingItemPanel.this.flippingItem.getFlippedBy())) {
                    wasDummy = true;
                    FlippingItemPanel.this.plugin.addFavoritedItem(FlippingItemPanel.this.flippingItem);
                }
                if (FlippingItemPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
                    FlippingItemPanel.this.plugin.setFavoriteOnAllAccounts(FlippingItemPanel.this.flippingItem, !FlippingItemPanel.this.flippingItem.isFavorite());
                } else {
                    FlippingItemPanel.this.plugin.markAccountTradesAsHavingChanged(FlippingItemPanel.this.plugin.getAccountCurrentlyViewed());
                }
                boolean bl = wasDummyAndAccountwide = wasDummy && FlippingItemPanel.this.plugin.getAccountCurrentlyViewed().equals("Accountwide");
                if (!wasDummyAndAccountwide) {
                    FlippingItemPanel.this.flippingItem.setFavorite(!FlippingItemPanel.this.flippingItem.isFavorite());
                }
                favoriteIcon.setIcon(FlippingItemPanel.this.flippingItem.isFavorite() ? Icons.STAR_ON_ICON : Icons.STAR_OFF_ICON);
                if (FlippingItemPanel.this.flippingItem.isFavorite()) {
                    FlippingItemPanel.this.searchCodeLabel.setText("<html> quick search code: " + UIUtilities.colorText(FlippingItemPanel.this.flippingItem.getFavoriteCode(), ColorScheme.GRAND_EXCHANGE_PRICE) + "</html>");
                } else {
                    FlippingItemPanel.this.searchCodeLabel.setText("<html> quick search code: " + UIUtilities.colorText("N/A", ColorScheme.GRAND_EXCHANGE_ALCH) + "</html>");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!FlippingItemPanel.this.flippingItem.isFavorite()) {
                    favoriteIcon.setIcon(Icons.STAR_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!FlippingItemPanel.this.flippingItem.isFavorite()) {
                    favoriteIcon.setIcon(Icons.STAR_OFF_ICON);
                }
            }
        });
        return favoriteIcon;
    }

    public void expand() {
        if (this.isCollapsed()) {
            this.itemInfo.setVisible(true);
        }
    }

    public void collapse() {
        if (!this.isCollapsed()) {
            this.itemInfo.setVisible(false);
        }
    }

    public boolean isCollapsed() {
        return !this.itemInfo.isVisible();
    }

    public void setValueLabels() {
        Optional<OfferEvent> latestInstaBuy = this.flippingItem.getLatestInstaBuy();
        Optional<OfferEvent> latestInstaSell = this.flippingItem.getLatestInstaSell();
        Optional<OfferEvent> latestBuy = this.flippingItem.getLatestBuy();
        Optional<OfferEvent> latestSell = this.flippingItem.getLatestSell();
        Optional<Integer> profitEach = this.flippingItem.getCurrentProfitEach();
        Optional<Float> roi = this.flippingItem.getCurrentRoi();
        this.instaSellVal.setText((String)(latestInstaSell.isPresent() ? String.format(NUM_FORMAT, latestInstaSell.get().getPreTaxPrice()) + " gp" : "N/A"));
        this.instaBuyVal.setText((String)(latestInstaBuy.isPresent() ? String.format(NUM_FORMAT, latestInstaBuy.get().getPrice()) + " gp" : "N/A"));
        this.latestBuyPriceVal.setText((String)(latestBuy.isPresent() ? String.format(NUM_FORMAT, latestBuy.get().getPrice()) + " gp" : "N/A"));
        this.latestSellPriceVal.setText((String)(latestSell.isPresent() ? String.format(NUM_FORMAT, latestSell.get().getPreTaxPrice()) + " gp" : "N/A"));
        this.marginCheckProfitEachVal.setText((String)(profitEach.isPresent() ? QuantityFormatter.quantityToRSDecimalStack((int)profitEach.get()) + " gp" : "N/A"));
        this.wikiProfitEachVal.setText("N/A");
        this.wikiPotentialProfitVal.setText("N/A");
        this.wikiRoiLabelVal.setText("N/A");
        if (this.flippingItem.getTotalGELimit() > 0) {
            this.geLimitVal.setText(String.format(NUM_FORMAT, this.flippingItem.getRemainingGeLimit()));
        } else {
            this.geLimitVal.setText(String.format(NUM_FORMAT, this.flippingItem.getItemsBoughtThisLimitWindow()));
        }
        this.onWikiRequest(this.plugin.getLastWikiRequestWrapper(), this.plugin.getTimeOfLastWikiRequest());
    }

    public void updateTimerDisplays() {
        this.flippingItem.validateGeProperties();
        this.geRefreshCountdownLabel.setText(this.flippingItem.getGeLimitResetTime() == null ? TimeFormatters.formatDuration(Duration.ZERO) : TimeFormatters.formatDuration(Instant.now(), this.flippingItem.getGeLimitResetTime()));
        if (this.flippingItem.getTotalGELimit() > 0) {
            this.geLimitVal.setText(String.format(NUM_FORMAT, this.flippingItem.getRemainingGeLimit()));
        } else {
            this.geLimitVal.setText(String.format(NUM_FORMAT, this.flippingItem.getItemsBoughtThisLimitWindow()));
        }
        this.geRefreshAtLabel.setText(this.flippingItem.getGeLimitResetTime() == null ? "Now" : TimeFormatters.formatTime(this.flippingItem.getGeLimitResetTime(), true, false));
    }

    public void onWikiRequest(WikiRequestWrapper wr, Instant requestCompletionTime) {
        this.timeOfRequestCompletion = requestCompletionTime;
        this.wikiRequestWrapper = wr;
        if (this.wikiRequestWrapper == null) {
            this.wikiBuyVal.setText("N/A");
            this.wikiSellVal.setText("N/A");
            return;
        }
        if (this.wikiRequestWrapper.getWikiDataSource() == WikiDataSource.DMM) {
            this.wikiBuyText.setForeground(CustomColors.DMM);
            this.wikiSellText.setForeground(CustomColors.DMM);
        } else {
            this.wikiBuyText.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
            this.wikiSellText.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        }
        WikiItemMargins wikiItemInfo = this.wikiRequestWrapper.getWikiRequest().getData().get(this.flippingItem.getItemId());
        if (wikiItemInfo == null) {
            this.wikiBuyVal.setText("N/A");
            this.wikiSellVal.setText("N/A");
            return;
        }
        this.wikiBuyVal.setText((String)(wikiItemInfo.getHigh() == 0 ? "No data" : QuantityFormatter.formatNumber((long)wikiItemInfo.getHigh()) + " gp"));
        this.wikiSellVal.setText((String)(wikiItemInfo.getLow() == 0 ? "No data" : QuantityFormatter.formatNumber((long)wikiItemInfo.getLow()) + " gp"));
        if (wikiItemInfo.getHigh() != 0 && wikiItemInfo.getLow() != 0) {
            int geLimit;
            int profitEach = GeTax.getPostTaxPrice(wikiItemInfo.getHigh()) - wikiItemInfo.getLow();
            this.wikiProfitEachVal.setText(QuantityFormatter.quantityToRSDecimalStack((int)profitEach) + " gp");
            float roi = (float)profitEach / (float)wikiItemInfo.getLow() * 100.0f;
            this.wikiRoiLabelVal.setText(String.format("%.2f", Float.valueOf(roi)) + "%");
            this.wikiRoiLabelVal.setForeground(UIUtilities.gradiatePercentage(roi, this.plugin.getConfig().roiGradientMax()));
            int n = geLimit = this.plugin.getConfig().geLimitProfit() ? this.flippingItem.getRemainingGeLimit() : this.flippingItem.getTotalGELimit();
            if (this.flippingItem.getTotalGELimit() > 0) {
                int potentialProfit = profitEach * geLimit;
                this.wikiPotentialProfitVal.setText(QuantityFormatter.quantityToRSDecimalStack((int)potentialProfit) + " gp");
            }
        }
        this.updateWikiTimeLabels();
    }

    public void updateWikiTimeLabels() {
        WikiItemMargins wikiItemInfo;
        if (this.wikiRequestWrapper == null) {
            this.wikiBuyTimeVal.setText("Request not made yet");
            this.wikiSellTimeVal.setText("Request not made yet");
            this.wikiRequestCountDownTimer.setText("N/A");
            return;
        }
        if (this.timeOfRequestCompletion != null) {
            long secondsSinceLastRequestCompleted = Instant.now().getEpochSecond() - this.timeOfRequestCompletion.getEpochSecond();
            if (secondsSinceLastRequestCompleted >= (long)WikiDataFetcherJob.requestInterval) {
                this.wikiRequestCountDownTimer.setText("0");
                this.refreshIconLabel.setEnabled(true);
            } else {
                this.refreshIconLabel.setEnabled(false);
                this.wikiRequestCountDownTimer.setText(String.valueOf((long)WikiDataFetcherJob.requestInterval - secondsSinceLastRequestCompleted));
            }
        }
        if ((wikiItemInfo = this.wikiRequestWrapper.getWikiRequest().getData().get(this.flippingItem.getItemId())) == null) {
            return;
        }
        if (wikiItemInfo.getHighTime() == 0L) {
            this.wikiBuyTimeVal.setText("No data");
        } else {
            this.wikiBuyTimeVal.setText(TimeFormatters.formatDuration(Instant.ofEpochSecond(wikiItemInfo.getHighTime())));
        }
        if (wikiItemInfo.getLowTime() == 0L) {
            this.wikiBuyTimeVal.setText("No data");
        } else {
            this.wikiSellTimeVal.setText(TimeFormatters.formatDuration(Instant.ofEpochSecond(wikiItemInfo.getLowTime())));
        }
    }

    private JPanel createWikiHoverTimePanel() {
        this.wikiBuyTimeText.setFont(FontManager.getRunescapeSmallFont());
        this.wikiBuyTimeText.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.wikiSellTimeText.setFont(FontManager.getRunescapeSmallFont());
        this.wikiSellTimeText.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        this.wikiSellTimeVal.setFont(FontManager.getRunescapeSmallFont());
        this.wikiBuyTimeVal.setFont(FontManager.getRunescapeSmallFont());
        JPanel wikiTimePanel = new JPanel();
        wikiTimePanel.setLayout(new BoxLayout(wikiTimePanel, 1));
        wikiTimePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buyTimePanel = new JPanel(new BorderLayout());
        buyTimePanel.add((Component)this.wikiBuyTimeText, "West");
        buyTimePanel.add((Component)this.wikiBuyTimeVal, "East");
        JPanel sellTimePanel = new JPanel(new BorderLayout());
        sellTimePanel.add((Component)this.wikiSellTimeText, "West");
        sellTimePanel.add((Component)this.wikiSellTimeVal, "East");
        wikiTimePanel.add(buyTimePanel);
        wikiTimePanel.add(Box.createVerticalStrut(5));
        wikiTimePanel.add(sellTimePanel);
        return wikiTimePanel;
    }

    public FlippingItem getFlippingItem() {
        return this.flippingItem;
    }
}

