/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.flipping;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.Section;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizationPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CustomizationPanel.class);
    FlippingPlugin plugin;
    List<Section> sections;

    public CustomizationPanel(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.BLACK.darker());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    private JPanel createSectionPanel(Section section) {
        JPanel sectionPanel = new JPanel();
        sectionPanel.setBackground(Color.BLACK.darker());
        sectionPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        sectionPanel.setLayout(new BoxLayout(sectionPanel, 1));
        JLabel titleLabel = new JLabel("Section name: " + section.getName());
        titleLabel.setAlignmentX(0.5f);
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        JPanel makeSectionDefaultExpandedPanel = new JPanel(new FlowLayout());
        makeSectionDefaultExpandedPanel.setBackground(Color.BLACK.darker());
        JLabel shouldMakeSectionExpandedLabel = new JLabel("expand section by default");
        shouldMakeSectionExpandedLabel.setFont(new Font(FontManager.getRunescapeSmallFont().getName(), 2, FontManager.getRunescapeSmallFont().getSize()));
        JToggleButton toggleButton = UIUtilities.createToggleButton();
        toggleButton.setSelected(section.isDefaultExpanded());
        toggleButton.addItemListener(i -> {
            section.setDefaultExpanded(toggleButton.isSelected());
            this.onSectionChange();
        });
        makeSectionDefaultExpandedPanel.add(shouldMakeSectionExpandedLabel);
        makeSectionDefaultExpandedPanel.add(toggleButton);
        sectionPanel.add(titleLabel);
        sectionPanel.add(makeSectionDefaultExpandedPanel);
        sectionPanel.add(Box.createVerticalStrut(10));
        for (String labelName : Section.possibleLabels) {
            sectionPanel.add(this.createPanelForSectionLabel(section, labelName));
            sectionPanel.add(Box.createVerticalStrut(3));
        }
        return sectionPanel;
    }

    private boolean labelUsedInAnotherSection(Section section, String labelName) {
        for (Section otherSection : this.sections) {
            if (section == otherSection || !otherSection.isShowingLabel(labelName)) continue;
            return true;
        }
        return false;
    }

    private JPanel createPanelForSectionLabel(Section section, String labelName) {
        boolean labelUsedInOtherSection = this.labelUsedInAnotherSection(section, labelName);
        JPanel sectionLabelPanel = new JPanel(new BorderLayout());
        sectionLabelPanel.setBackground(Color.BLACK.darker());
        JLabel sectionLabel = new JLabel((String)(labelUsedInOtherSection ? labelName + " (disabled: used in other section)" : labelName));
        sectionLabel.setFont(FontManager.getRunescapeSmallFont());
        sectionLabel.setForeground(labelUsedInOtherSection ? ColorScheme.MEDIUM_GRAY_COLOR : Color.WHITE);
        JToggleButton sectionLabelToggle = UIUtilities.createToggleButton();
        sectionLabelToggle.setSelected(section.isShowingLabel(labelName));
        sectionLabelToggle.setEnabled(!labelUsedInOtherSection);
        sectionLabelToggle.setDisabledIcon(Icons.TOGGLE_OFF);
        sectionLabelToggle.addItemListener(i -> {
            section.showLabel(labelName, sectionLabelToggle.isSelected());
            this.onSectionChange();
        });
        sectionLabelPanel.add((Component)sectionLabel, "West");
        sectionLabelPanel.add((Component)sectionLabelToggle, "East");
        return sectionLabelPanel;
    }

    private void onSectionChange() {
        this.rebuild(this.sections);
        this.plugin.getFlippingPanel().rebuild(this.plugin.viewItemsForCurrentView());
        this.plugin.getDataHandler().markDataAsHavingChanged("Accountwide");
    }

    public void rebuild(List<Section> sections) {
        this.sections = sections;
        this.removeAll();
        sections.forEach(section -> this.add(this.createSectionPanel((Section)section)));
        this.revalidate();
        this.repaint();
    }
}

