/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.ui.flipping.FlippingPanel;
import com.flippingutilities.ui.login.LoginPanel;
import com.flippingutilities.ui.slots.SlotsPanel;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.uiutilities.CustomColors;
import com.flippingutilities.ui.uiutilities.FastTabGroup;
import com.flippingutilities.ui.uiutilities.Icons;
import com.flippingutilities.ui.uiutilities.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(MasterPanel.class);
    private JComboBox<String> accountSelector;
    private FlippingPlugin plugin;
    private FastTabGroup tabGroup;
    private JDialog loginModal;

    public MasterPanel(FlippingPlugin plugin, FlippingPanel flippingPanel, StatsPanel statPanel, SlotsPanel slotsPanel, LoginPanel loginPanel) {
        super(false);
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        JPanel mainDisplay = new JPanel();
        this.loginModal = UIUtilities.createModalFromPanel((Component)((Object)this), loginPanel);
        loginPanel.addOnViewChange(() -> {
            if (this.loginModal.isVisible()) {
                this.loginModal.pack();
                this.loginModal.setLocation(this.getLocationOnScreen().x - this.loginModal.getWidth() - 10, Math.max(this.getLocationOnScreen().y, 0) - this.loginModal.getHeight() / 2 + 100);
            }
        });
        this.loginModal.pack();
        this.accountSelector = this.accountSelector();
        this.tabGroup = this.tabSelector(mainDisplay, flippingPanel, statPanel, slotsPanel);
        JPanel header = this.createHeader(this.accountSelector, this.tabGroup, this.loginModal);
        header.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 4, 0, ColorScheme.DARKER_GRAY_COLOR.darker()), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
        this.add(header, "North");
        this.add(mainDisplay, "Center");
    }

    private JPanel createHeader(JComboBox accountSelector, MaterialTabGroup tabSelector, JDialog loginModal) {
        JPanel accountSelectorPanel = new JPanel(new BorderLayout());
        accountSelectorPanel.setBackground(CustomColors.DARK_GRAY);
        accountSelectorPanel.add((Component)accountSelector, "Center");
        accountSelectorPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel header = new JPanel(new BorderLayout());
        header.setBackground(CustomColors.DARK_GRAY);
        header.add((Component)accountSelectorPanel, "North");
        header.add((Component)this.createCommunityPanel(loginModal), "Center");
        header.add((Component)tabSelector, "South");
        header.setBorder(new EmptyBorder(0, 0, 3, 0));
        return header;
    }

    private JPanel createCommunityPanel(final JDialog loginModal) {
        JPanel communityPanel = new JPanel(new BorderLayout());
        communityPanel.setBackground(CustomColors.DARK_GRAY);
        communityPanel.setBorder(new EmptyBorder(7, 0, 0, 0));
        JPanel centerPanel = new JPanel();
        centerPanel.setBorder(new EmptyBorder(0, 0, 6, 43));
        JLabel githubIcon = UIUtilities.createIcon(Icons.GITHUB_ICON, Icons.GITHUB_ICON_ON, "https://github.com/Flipping-Utilities/rl-plugin", "Click to go to Flipping Utilities github");
        JLabel twitterIcon = UIUtilities.createIcon(Icons.TWITTER_ICON, Icons.TWITTER_ICON_ON, "https://twitter.com/flippingutils", "Click to go to Flipping Utilities twitter");
        JLabel discordIcon = UIUtilities.createIcon(Icons.DISCORD_ICON, Icons.DISCORD_ICON_ON, "https://discord.gg/GDqVgMH26s", "Click to go to Flipping Utilities discord");
        centerPanel.setBackground(CustomColors.DARK_GRAY);
        centerPanel.add(discordIcon);
        centerPanel.add(twitterIcon);
        centerPanel.add(githubIcon);
        communityPanel.add((Component)centerPanel, "Center");
        final MasterPanel m = this;
        final JLabel profileButton = new JLabel(Icons.USER);
        this.plugin.getApiAuthHandler().subscribeToLogin(() -> SwingUtilities.invokeLater(() -> {
            profileButton.setIcon(Icons.USER_LOGGED_IN);
            JPopupMenu profilePopup = new JPopupMenu();
            profilePopup.add(new JLabel("Click to open your profile page!"));
            UIUtilities.addPopupOnHover(profileButton, profilePopup, false);
        }));
        profileButton.setBorder(new EmptyBorder(0, 15, 10, 0));
        profileButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                loginModal.pack();
                loginModal.setLocation(m.getLocationOnScreen().x - loginModal.getWidth() - 10, Math.max(m.getLocationOnScreen().y - loginModal.getHeight() / 2, 0) + 100);
                loginModal.setVisible(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!MasterPanel.this.plugin.getApiAuthHandler().isHasValidJWT()) {
                    profileButton.setIcon(Icons.USER_HOVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageIcon icon = MasterPanel.this.plugin.getApiAuthHandler().isHasValidJWT() ? Icons.USER_LOGGED_IN : Icons.USER;
                profileButton.setIcon(icon);
            }
        });
        JPopupMenu profilePopup = new JPopupMenu();
        profilePopup.add(new JLabel("Click to login!"));
        UIUtilities.addPopupOnHover(profileButton, profilePopup, false);
        communityPanel.add((Component)profileButton, "West");
        return communityPanel;
    }

    private JComboBox accountSelector() {
        JComboBox viewSelectorDropdown = new JComboBox();
        viewSelectorDropdown.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        viewSelectorDropdown.setFocusable(false);
        viewSelectorDropdown.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        viewSelectorDropdown.setRenderer(new ComboBoxListRenderer());
        viewSelectorDropdown.setToolTipText("Select which of your account's trades list you want to view");
        viewSelectorDropdown.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                String selectedName = (String)event.getItem();
                this.plugin.changeView(selectedName);
            }
        });
        return viewSelectorDropdown;
    }

    private FastTabGroup tabSelector(JPanel mainDisplay, JPanel flippingPanel, JPanel statPanel, JPanel slotsPanel) {
        FastTabGroup tabGroup = new FastTabGroup(mainDisplay);
        MaterialTab flippingTab = new MaterialTab("flipping", (MaterialTabGroup)tabGroup, (JComponent)flippingPanel);
        MaterialTab statisticsTab = new MaterialTab("stats", (MaterialTabGroup)tabGroup, (JComponent)statPanel);
        MaterialTab slotsTab = new MaterialTab("slots", (MaterialTabGroup)tabGroup, (JComponent)slotsPanel);
        tabGroup.addTab(slotsTab);
        tabGroup.addTab(flippingTab);
        tabGroup.addTab(statisticsTab);
        tabGroup.select(flippingTab);
        return tabGroup;
    }

    public Set<String> getViewSelectorItems() {
        HashSet<String> items = new HashSet<String>();
        for (int i = 0; i < this.accountSelector.getItemCount(); ++i) {
            items.add(this.accountSelector.getItemAt(i));
        }
        return items;
    }

    public void addView(JPanel panel, String name) {
        this.tabGroup.addView(panel, name);
    }

    public void showView(String name) {
        this.tabGroup.showView(name);
    }

    public void selectPreviouslySelectedTab() {
        this.tabGroup.selectPreviouslySelectedTab();
    }

    public void revertToSafeDisplay() {
        this.tabGroup.revertToSafeDisplay();
    }

    public void setupAccSelectorDropdown(Set<String> currentAccounts) {
        this.accountSelector.addItem("Accountwide");
        currentAccounts.forEach(displayName -> this.accountSelector.addItem((String)displayName));
        if (currentAccounts.size() > 1) {
            this.accountSelector.setVisible(true);
        } else {
            this.accountSelector.setVisible(false);
        }
    }

    public void dispose() {
        this.loginModal.dispose();
    }

    public JComboBox<String> getAccountSelector() {
        return this.accountSelector;
    }
}

