/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.utilities.Recipe;
import com.flippingutilities.utilities.Searchable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RecipeFlipGroup
implements Searchable {
    private Recipe recipe;
    private List<RecipeFlip> recipeFlips = new ArrayList<RecipeFlip>();

    public RecipeFlipGroup(Recipe recipe) {
        this.recipe = recipe;
    }

    public RecipeFlipGroup clone() {
        return new RecipeFlipGroup(this.recipe, this.recipeFlips.stream().map(RecipeFlip::clone).collect(Collectors.toList()));
    }

    public RecipeFlipGroup merge(RecipeFlipGroup otherRecipeFlipGroup) {
        List<RecipeFlip> allRecipeFlips = this.recipeFlips;
        allRecipeFlips.addAll(otherRecipeFlipGroup.getRecipeFlips());
        allRecipeFlips.sort(Comparator.comparing(RecipeFlip::getTimeOfCreation));
        return new RecipeFlipGroup(this.recipe, allRecipeFlips);
    }

    public Instant getLatestActivityTime() {
        if (this.recipeFlips.isEmpty()) {
            return Instant.EPOCH;
        }
        return this.recipeFlips.get((int)(this.recipeFlips.size() - 1)).timeOfCreation;
    }

    public boolean isInGroup(int itemId) {
        return this.recipe.isInRecipe(itemId);
    }

    public Map<String, PartialOffer> getOfferIdToPartialOffer(int itemId) {
        HashMap<String, PartialOffer> offerIdToPartialOffer = new HashMap<String, PartialOffer>();
        for (RecipeFlip recipeFlip : this.recipeFlips) {
            List<PartialOffer> partialOffers = recipeFlip.getPartialOffers(itemId);
            partialOffers.forEach(po -> {
                String offerId = po.offer.getUuid();
                if (offerIdToPartialOffer.containsKey(offerId)) {
                    PartialOffer otherPartialOffer = (PartialOffer)offerIdToPartialOffer.get(offerId);
                    PartialOffer clonedPartialOffer = po.clone();
                    clonedPartialOffer.amountConsumed += otherPartialOffer.amountConsumed;
                    offerIdToPartialOffer.put(offerId, clonedPartialOffer);
                } else {
                    offerIdToPartialOffer.put(offerId, (PartialOffer)po);
                }
            });
        }
        return offerIdToPartialOffer;
    }

    public List<PartialOffer> getPartialOffers() {
        return this.recipeFlips.stream().flatMap(rf -> rf.getPartialOffers().stream()).collect(Collectors.toList());
    }

    public void addRecipeFlip(RecipeFlip recipeFlip) {
        this.recipeFlips.add(recipeFlip);
    }

    public Instant getLatestFlipTime() {
        if (this.recipeFlips.isEmpty()) {
            return Instant.EPOCH;
        }
        return this.recipeFlips.get((int)(this.recipeFlips.size() - 1)).timeOfCreation;
    }

    public List<RecipeFlip> getFlipsInInterval(Instant startOfInterval) {
        return this.recipeFlips.stream().filter(recipeFlip -> recipeFlip.getTimeOfCreation().isAfter(startOfInterval)).collect(Collectors.toList());
    }

    public void deleteFlips(Instant startOfInterval) {
        this.recipeFlips.removeIf(rf -> rf.getTimeOfCreation().isAfter(startOfInterval));
    }

    public void deleteFlip(RecipeFlip recipeFlip) {
        this.recipeFlips.removeIf(rf -> rf.equals(recipeFlip));
    }

    public void deleteFlipsWithDeletedOffers(List<OfferEvent> offers) {
        Set offerIds = offers.stream().map(OfferEvent::getUuid).collect(Collectors.toSet());
        this.recipeFlips.removeIf(rf -> rf.getPartialOffers().stream().anyMatch(po -> offerIds.contains(po.offer.getUuid())));
    }

    @Override
    public boolean isInInterval(Instant intervalStart) {
        return this.recipeFlips.stream().anyMatch(recipeFlip -> recipeFlip.getTimeOfCreation().isAfter(intervalStart));
    }

    @Override
    public String getNameForSearch() {
        return this.recipe.getName();
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public List<RecipeFlip> getRecipeFlips() {
        return this.recipeFlips;
    }

    public void setRecipe(Recipe recipe) {
        this.recipe = recipe;
    }

    public void setRecipeFlips(List<RecipeFlip> recipeFlips) {
        this.recipeFlips = recipeFlips;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeFlipGroup)) {
            return false;
        }
        RecipeFlipGroup other = (RecipeFlipGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Recipe this$recipe = this.getRecipe();
        Recipe other$recipe = other.getRecipe();
        if (this$recipe == null ? other$recipe != null : !((Object)this$recipe).equals(other$recipe)) {
            return false;
        }
        List<RecipeFlip> this$recipeFlips = this.getRecipeFlips();
        List<RecipeFlip> other$recipeFlips = other.getRecipeFlips();
        return !(this$recipeFlips == null ? other$recipeFlips != null : !((Object)this$recipeFlips).equals(other$recipeFlips));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipeFlipGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Recipe $recipe = this.getRecipe();
        result = result * 59 + ($recipe == null ? 43 : ((Object)$recipe).hashCode());
        List<RecipeFlip> $recipeFlips = this.getRecipeFlips();
        result = result * 59 + ($recipeFlips == null ? 43 : ((Object)$recipeFlips).hashCode());
        return result;
    }

    public String toString() {
        return "RecipeFlipGroup(recipe=" + this.getRecipe() + ", recipeFlips=" + this.getRecipeFlips() + ")";
    }

    public RecipeFlipGroup(Recipe recipe, List<RecipeFlip> recipeFlips) {
        this.recipe = recipe;
        this.recipeFlips = recipeFlips;
    }
}

