/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.utilities.Recipe;
import com.flippingutilities.utilities.RecipeItem;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RecipeFlip {
    Instant timeOfCreation;
    Map<Integer, Map<String, PartialOffer>> outputs;
    Map<Integer, Map<String, PartialOffer>> inputs;
    long coinCost;

    public RecipeFlip(Recipe recipe, Map<Integer, Map<String, PartialOffer>> allPartialOffers, long coinsCost) {
        Set<Integer> recipeInputIds = recipe.getInputIds();
        Set<Integer> recipeOutputIds = recipe.getOutputIds();
        this.coinCost = coinsCost;
        this.timeOfCreation = Instant.now();
        this.inputs = allPartialOffers.entrySet().stream().filter(e -> recipeInputIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.outputs = allPartialOffers.entrySet().stream().filter(e -> recipeOutputIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public RecipeFlip clone() {
        Instant clonedInstant = Instant.ofEpochSecond(this.timeOfCreation.getEpochSecond());
        Map<Integer, Map<String, PartialOffer>> clonedOutputs = this.cloneComponents(this.outputs);
        Map<Integer, Map<String, PartialOffer>> clonedInputs = this.cloneComponents(this.inputs);
        return new RecipeFlip(clonedInstant, clonedOutputs, clonedInputs, this.coinCost);
    }

    private Map<Integer, Map<String, PartialOffer>> cloneComponents(Map<Integer, Map<String, PartialOffer>> component) {
        return component.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Integer, Map<String, PartialOffer>>((Integer)e.getKey(), ((Map)e.getValue()).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PartialOffer>((String)entry.getKey(), ((PartialOffer)entry.getValue()).clone())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public long getProfit() {
        return this.getRevenue() - this.getExpense();
    }

    private long getIngredientsValue(boolean isBuyOffer) {
        return this.getPartialOffers().stream().filter(po -> po.offer.isBuy() == isBuyOffer).mapToLong(po -> po.amountConsumed * po.getOffer().getPrice()).sum();
    }

    public long getExpense() {
        return this.getIngredientsValue(true) + this.coinCost;
    }

    public long getRevenue() {
        return this.getIngredientsValue(false);
    }

    public long getTaxPaid() {
        return this.getOutputs().values().stream().mapToLong(offerIdToPartialOfferMap -> offerIdToPartialOfferMap.values().stream().mapToInt(po -> po.getOffer().getTaxPaidPerItem() * po.amountConsumed).sum()).sum();
    }

    public static long calculateProfit(Map<Integer, Map<String, PartialOffer>> allPartialOffers) {
        List offers = allPartialOffers.values().stream().flatMap(offerIdToPartialOfferMap -> offerIdToPartialOfferMap.values().stream()).collect(Collectors.toList());
        long revenue = offers.stream().filter(po -> !po.getOffer().isBuy()).mapToLong(po -> po.amountConsumed * po.getOffer().getPrice()).sum();
        long expense = offers.stream().filter(po -> po.getOffer().isBuy()).mapToLong(po -> po.amountConsumed * po.getOffer().getPrice()).sum();
        return revenue - expense;
    }

    public List<PartialOffer> getPartialOffers() {
        ArrayList<PartialOffer> offers = new ArrayList<PartialOffer>();
        this.inputs.values().forEach(map -> offers.addAll(map.values()));
        this.outputs.values().forEach(map -> offers.addAll(map.values()));
        return offers;
    }

    public List<PartialOffer> getPartialOffers(int itemId) {
        ArrayList<PartialOffer> partialOffers = new ArrayList<PartialOffer>();
        if (this.outputs.containsKey(itemId)) {
            partialOffers.addAll(this.outputs.get(itemId).values());
        }
        if (this.inputs.containsKey(itemId)) {
            partialOffers.addAll(this.inputs.get(itemId).values());
        }
        return partialOffers;
    }

    public int getRecipeCountMade(Recipe recipe) {
        RecipeItem randomItemInRecipe = recipe.getOutputs().get(0);
        int quantityOfRandomItemInRecipe = randomItemInRecipe.getQuantity();
        int randomItemIdInRecipe = randomItemInRecipe.getId();
        int amountConsumed = this.getPartialOffers(randomItemIdInRecipe).stream().mapToInt(po -> po.amountConsumed).sum();
        return amountConsumed / quantityOfRandomItemInRecipe;
    }

    public Instant getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public Map<Integer, Map<String, PartialOffer>> getOutputs() {
        return this.outputs;
    }

    public Map<Integer, Map<String, PartialOffer>> getInputs() {
        return this.inputs;
    }

    public long getCoinCost() {
        return this.coinCost;
    }

    public void setTimeOfCreation(Instant timeOfCreation) {
        this.timeOfCreation = timeOfCreation;
    }

    public void setOutputs(Map<Integer, Map<String, PartialOffer>> outputs) {
        this.outputs = outputs;
    }

    public void setInputs(Map<Integer, Map<String, PartialOffer>> inputs) {
        this.inputs = inputs;
    }

    public void setCoinCost(long coinCost) {
        this.coinCost = coinCost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeFlip)) {
            return false;
        }
        RecipeFlip other = (RecipeFlip)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$timeOfCreation = this.getTimeOfCreation();
        Instant other$timeOfCreation = other.getTimeOfCreation();
        if (this$timeOfCreation == null ? other$timeOfCreation != null : !((Object)this$timeOfCreation).equals(other$timeOfCreation)) {
            return false;
        }
        Map<Integer, Map<String, PartialOffer>> this$outputs = this.getOutputs();
        Map<Integer, Map<String, PartialOffer>> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<Integer, Map<String, PartialOffer>> this$inputs = this.getInputs();
        Map<Integer, Map<String, PartialOffer>> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        return this.getCoinCost() == other.getCoinCost();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipeFlip;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $timeOfCreation = this.getTimeOfCreation();
        result = result * 59 + ($timeOfCreation == null ? 43 : ((Object)$timeOfCreation).hashCode());
        Map<Integer, Map<String, PartialOffer>> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<Integer, Map<String, PartialOffer>> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        long $coinCost = this.getCoinCost();
        result = result * 59 + (int)($coinCost >>> 32 ^ $coinCost);
        return result;
    }

    public String toString() {
        return "RecipeFlip(timeOfCreation=" + this.getTimeOfCreation() + ", outputs=" + this.getOutputs() + ", inputs=" + this.getInputs() + ", coinCost=" + this.getCoinCost() + ")";
    }

    public RecipeFlip(Instant timeOfCreation, Map<Integer, Map<String, PartialOffer>> outputs, Map<Integer, Map<String, PartialOffer>> inputs, long coinCost) {
        this.timeOfCreation = timeOfCreation;
        this.outputs = outputs;
        this.inputs = inputs;
        this.coinCost = coinCost;
    }
}

