/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

public class Option {
    public static final String GE_LIMIT = "ge limit";
    public static final String REMAINING_LIMIT = "rem limit";
    public static final String CASHSTACK = "cashstack";
    public static final String LAST_BUY = "last buy";
    public static final String LAST_SELL = "last sell";
    public static final String INSTA_SELL = "insta sell";
    public static final String INSTA_BUY = "insta buy";
    public static final String WIKI_BUY = "wiki buy";
    public static final String WIKI_SELL = "wiki sell";
    public static final String[] QUANTITY_OPTIONS = new String[]{"rem limit", "ge limit", "cashstack"};
    public static final String[] PRICE_OPTIONS = new String[]{"wiki buy", "wiki sell", "insta sell", "insta buy", "last buy", "last sell"};
    String key;
    String property;
    String modifier;
    boolean isQuantityOption = true;

    public static Option defaultQuantityOption() {
        return new Option("", GE_LIMIT, "+0", true);
    }

    public static Option defaultPriceOption() {
        return new Option("", INSTA_BUY, "+0", false);
    }

    public String getKey() {
        return this.key;
    }

    public String getProperty() {
        return this.property;
    }

    public String getModifier() {
        return this.modifier;
    }

    public boolean isQuantityOption() {
        return this.isQuantityOption;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setQuantityOption(boolean isQuantityOption) {
        this.isQuantityOption = isQuantityOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option other = (Option)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        return this.isQuantityOption() == other.isQuantityOption();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Option;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        result = result * 59 + (this.isQuantityOption() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Option(key=" + this.getKey() + ", property=" + this.getProperty() + ", modifier=" + this.getModifier() + ", isQuantityOption=" + this.isQuantityOption() + ")";
    }

    public Option(String key, String property, String modifier, boolean isQuantityOption) {
        this.key = key;
        this.property = property;
        this.modifier = modifier;
        this.isQuantityOption = isQuantityOption;
    }

    public Option() {
    }
}

