/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.utilities.Constants;
import com.flippingutilities.utilities.GeTax;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.events.GrandExchangeOfferChanged;

public class OfferEvent {
    private String uuid;
    @SerializedName(value="b")
    private boolean buy;
    @SerializedName(value="id")
    private int itemId;
    @SerializedName(value="cQIT")
    private int currentQuantityInTrade;
    @SerializedName(value="p")
    private int price;
    @SerializedName(value="t")
    private Instant time;
    @SerializedName(value="s")
    private int slot;
    @SerializedName(value="st")
    private GrandExchangeOfferState state;
    @SerializedName(value="tAA")
    private int tickArrivedAt;
    @SerializedName(value="tSFO")
    private int ticksSinceFirstOffer;
    @SerializedName(value="tQIT")
    private int totalQuantityInTrade;
    private Instant tradeStartedAt;
    private boolean beforeLogin;
    private transient String madeBy;
    private transient String itemName;
    private transient int listedPrice;
    private transient int spent;

    public int getPrice() {
        if (this.buy || this.time.getEpochSecond() < (long)Constants.GE_TAX_START || this.itemId == Constants.BOND_ID) {
            return this.price;
        }
        return GeTax.getPostTaxPrice(this.price);
    }

    public int getPreTaxPrice() {
        return this.price;
    }

    public int getTaxPaid() {
        return (this.getPreTaxPrice() - this.getPrice()) * this.currentQuantityInTrade;
    }

    public int getTaxPaidPerItem() {
        return this.getPreTaxPrice() - this.getPrice();
    }

    public boolean isComplete() {
        return OfferEvent.isComplete(this.state);
    }

    public boolean isCancelled() {
        return this.state == GrandExchangeOfferState.CANCELLED_BUY || this.state == GrandExchangeOfferState.CANCELLED_SELL;
    }

    public static boolean isComplete(GrandExchangeOfferState state) {
        return state == GrandExchangeOfferState.BOUGHT || state == GrandExchangeOfferState.SOLD || state == GrandExchangeOfferState.CANCELLED_BUY || state == GrandExchangeOfferState.CANCELLED_SELL;
    }

    public static boolean isBuy(GrandExchangeOfferState state) {
        return state == GrandExchangeOfferState.BOUGHT || state == GrandExchangeOfferState.CANCELLED_BUY || state == GrandExchangeOfferState.BUYING;
    }

    public boolean isRedundantEventBeforeOfferCompletion() {
        return (this.state == GrandExchangeOfferState.BUYING || this.state == GrandExchangeOfferState.SELLING) && this.currentQuantityInTrade == this.totalQuantityInTrade;
    }

    public boolean isMarginCheck() {
        return (this.state == GrandExchangeOfferState.BOUGHT || this.state == GrandExchangeOfferState.SOLD) && this.totalQuantityInTrade == 1 && this.ticksSinceFirstOffer <= 2;
    }

    public boolean isCausedByEmptySlot() {
        return this.itemId == 0 || this.state == GrandExchangeOfferState.EMPTY;
    }

    public boolean isStartOfOffer() {
        return this.currentQuantityInTrade == 0 && !this.isComplete() && !this.isCausedByEmptySlot();
    }

    public OfferEvent clone() {
        return new OfferEvent(this.uuid, this.buy, this.itemId, this.currentQuantityInTrade, this.price, this.time, this.slot, this.state, this.tickArrivedAt, this.ticksSinceFirstOffer, this.totalQuantityInTrade, this.tradeStartedAt, this.beforeLogin, this.madeBy, this.itemName, this.listedPrice, this.spent);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OfferEvent)) {
            return false;
        }
        OfferEvent otherOffer = (OfferEvent)other;
        return this.isDuplicate(otherOffer) && this.uuid.equals(otherOffer.uuid) && this.tickArrivedAt == otherOffer.tickArrivedAt && this.ticksSinceFirstOffer == otherOffer.ticksSinceFirstOffer && this.time.equals(otherOffer.time);
    }

    public boolean isDuplicate(OfferEvent other) {
        return this.state == other.getState() && this.currentQuantityInTrade == other.getCurrentQuantityInTrade() && this.slot == other.getSlot() && this.totalQuantityInTrade == other.getTotalQuantityInTrade() && this.itemId == other.getItemId() && this.getPrice() == other.getPrice();
    }

    public static OfferEvent fromGrandExchangeEvent(GrandExchangeOfferChanged event) {
        GrandExchangeOffer offer = event.getOffer();
        boolean isBuy = offer.getState() == GrandExchangeOfferState.BOUGHT || offer.getState() == GrandExchangeOfferState.CANCELLED_BUY || offer.getState() == GrandExchangeOfferState.BUYING;
        return new OfferEvent(UUID.randomUUID().toString(), isBuy, offer.getItemId(), offer.getQuantitySold(), offer.getQuantitySold() == 0 ? 0 : offer.getSpent() / offer.getQuantitySold(), Instant.now().truncatedTo(ChronoUnit.SECONDS), event.getSlot(), offer.getState(), 0, 0, offer.getTotalQuantity(), null, false, null, null, offer.getPrice(), offer.getSpent());
    }

    public void setTicksSinceFirstOffer(OfferEvent lastOfferForSlot) {
        int tickDiffFromLastOffer = Math.abs(this.tickArrivedAt - lastOfferForSlot.getTickArrivedAt());
        this.ticksSinceFirstOffer = tickDiffFromLastOffer + lastOfferForSlot.getTicksSinceFirstOffer();
    }

    public String prettyRepr() {
        return String.format("slot=%d, buy=%b, itemId=%d, state=%s, tq=%d", this.slot, this.buy, this.itemId, this.state, this.totalQuantityInTrade);
    }

    public static OfferEvent dummyOffer(boolean buyState, boolean marginCheck, int price, int id, String itemName) {
        return new OfferEvent(UUID.randomUUID().toString(), buyState, id, 0, price, Instant.now(), -1, buyState ? GrandExchangeOfferState.BOUGHT : GrandExchangeOfferState.SOLD, 1, marginCheck ? 1 : 10, 1, null, false, "", itemName, 0, 0);
    }

    public boolean isBuy() {
        return this.buy;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getCurrentQuantityInTrade() {
        return this.currentQuantityInTrade;
    }

    public Instant getTime() {
        return this.time;
    }

    public int getSlot() {
        return this.slot;
    }

    public GrandExchangeOfferState getState() {
        return this.state;
    }

    public int getTickArrivedAt() {
        return this.tickArrivedAt;
    }

    public int getTicksSinceFirstOffer() {
        return this.ticksSinceFirstOffer;
    }

    public int getTotalQuantityInTrade() {
        return this.totalQuantityInTrade;
    }

    public Instant getTradeStartedAt() {
        return this.tradeStartedAt;
    }

    public boolean isBeforeLogin() {
        return this.beforeLogin;
    }

    public String getMadeBy() {
        return this.madeBy;
    }

    public String getItemName() {
        return this.itemName;
    }

    public int getListedPrice() {
        return this.listedPrice;
    }

    public int getSpent() {
        return this.spent;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setCurrentQuantityInTrade(int currentQuantityInTrade) {
        this.currentQuantityInTrade = currentQuantityInTrade;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setState(GrandExchangeOfferState state) {
        this.state = state;
    }

    public void setTickArrivedAt(int tickArrivedAt) {
        this.tickArrivedAt = tickArrivedAt;
    }

    public void setTotalQuantityInTrade(int totalQuantityInTrade) {
        this.totalQuantityInTrade = totalQuantityInTrade;
    }

    public void setTradeStartedAt(Instant tradeStartedAt) {
        this.tradeStartedAt = tradeStartedAt;
    }

    public void setBeforeLogin(boolean beforeLogin) {
        this.beforeLogin = beforeLogin;
    }

    public void setMadeBy(String madeBy) {
        this.madeBy = madeBy;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setListedPrice(int listedPrice) {
        this.listedPrice = listedPrice;
    }

    public void setSpent(int spent) {
        this.spent = spent;
    }

    public String toString() {
        return "OfferEvent(uuid=" + this.getUuid() + ", buy=" + this.isBuy() + ", itemId=" + this.getItemId() + ", currentQuantityInTrade=" + this.getCurrentQuantityInTrade() + ", price=" + this.getPrice() + ", time=" + this.getTime() + ", slot=" + this.getSlot() + ", state=" + this.getState() + ", tickArrivedAt=" + this.getTickArrivedAt() + ", ticksSinceFirstOffer=" + this.getTicksSinceFirstOffer() + ", totalQuantityInTrade=" + this.getTotalQuantityInTrade() + ", tradeStartedAt=" + this.getTradeStartedAt() + ", beforeLogin=" + this.isBeforeLogin() + ", madeBy=" + this.getMadeBy() + ", itemName=" + this.getItemName() + ", listedPrice=" + this.getListedPrice() + ", spent=" + this.getSpent() + ")";
    }

    public OfferEvent(String uuid, boolean buy, int itemId, int currentQuantityInTrade, int price, Instant time, int slot, GrandExchangeOfferState state, int tickArrivedAt, int ticksSinceFirstOffer, int totalQuantityInTrade, Instant tradeStartedAt, boolean beforeLogin, String madeBy, String itemName, int listedPrice, int spent) {
        this.uuid = uuid;
        this.buy = buy;
        this.itemId = itemId;
        this.currentQuantityInTrade = currentQuantityInTrade;
        this.price = price;
        this.time = time;
        this.slot = slot;
        this.state = state;
        this.tickArrivedAt = tickArrivedAt;
        this.ticksSinceFirstOffer = ticksSinceFirstOffer;
        this.totalQuantityInTrade = totalQuantityInTrade;
        this.tradeStartedAt = tradeStartedAt;
        this.beforeLogin = beforeLogin;
        this.madeBy = madeBy;
        this.itemName = itemName;
        this.listedPrice = listedPrice;
        this.spent = spent;
    }

    public OfferEvent() {
    }

    public String getUuid() {
        return this.uuid;
    }
}

