/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.model.Flip;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.utilities.ListUtils;
import com.google.gson.annotations.SerializedName;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryManager {
    private static final Logger log = LoggerFactory.getLogger(HistoryManager.class);
    @SerializedName(value="sO")
    private List<OfferEvent> compressedOfferEvents = new ArrayList<OfferEvent>();
    @SerializedName(value="nGLR")
    private Instant nextGeLimitRefresh;
    @SerializedName(value="iBTLW")
    private int itemsBoughtThisLimitWindow;
    @SerializedName(value="pIB")
    private int itemsBoughtThroughCompleteOffers;

    public HistoryManager clone() {
        List<OfferEvent> clonedCompressedOfferEvents = this.compressedOfferEvents.stream().map(OfferEvent::clone).collect(Collectors.toList());
        Instant clonedGeLimitRefresh = this.nextGeLimitRefresh == null ? null : Instant.ofEpochMilli(this.nextGeLimitRefresh.toEpochMilli());
        return new HistoryManager(clonedCompressedOfferEvents, clonedGeLimitRefresh, this.itemsBoughtThisLimitWindow, this.itemsBoughtThroughCompleteOffers);
    }

    public void updateHistory(OfferEvent newOffer) {
        if (newOffer.getSlot() != -1) {
            this.updateGeLimitProperties(newOffer);
            this.deletePreviousOffersForTrade(newOffer);
        }
        this.compressedOfferEvents.add(newOffer);
    }

    private void updateGeLimitProperties(OfferEvent newOfferEvent) {
        if (!newOfferEvent.isBuy()) {
            return;
        }
        if (this.nextGeLimitRefresh == null || newOfferEvent.getTime().compareTo(this.nextGeLimitRefresh) > 0) {
            this.nextGeLimitRefresh = newOfferEvent.getTime().plus(4L, ChronoUnit.HOURS);
            if (newOfferEvent.isComplete()) {
                this.itemsBoughtThisLimitWindow = this.itemsBoughtThroughCompleteOffers = newOfferEvent.getCurrentQuantityInTrade();
            } else {
                this.itemsBoughtThroughCompleteOffers = 0;
                this.itemsBoughtThisLimitWindow = newOfferEvent.getCurrentQuantityInTrade();
            }
        } else if (newOfferEvent.isComplete()) {
            this.itemsBoughtThroughCompleteOffers += newOfferEvent.getCurrentQuantityInTrade();
            this.itemsBoughtThisLimitWindow = this.itemsBoughtThroughCompleteOffers;
        } else {
            this.itemsBoughtThisLimitWindow = this.itemsBoughtThroughCompleteOffers + newOfferEvent.getCurrentQuantityInTrade();
        }
    }

    public void deletePreviousOffersForTrade(OfferEvent newOfferEvent) {
        for (int i = this.compressedOfferEvents.size() - 1; i > -1; --i) {
            OfferEvent aPreviousOffer = this.compressedOfferEvents.get(i);
            if (aPreviousOffer.getSlot() != newOfferEvent.getSlot() || aPreviousOffer.isBuy() != newOfferEvent.isBuy()) continue;
            if (aPreviousOffer.isComplete()) {
                return;
            }
            this.compressedOfferEvents.remove(i);
        }
    }

    public ArrayList<OfferEvent> getIntervalsHistory(Instant earliestTime) {
        ArrayList<OfferEvent> result = new ArrayList<OfferEvent>();
        for (OfferEvent offer : this.compressedOfferEvents) {
            if (!offer.getTime().isAfter(earliestTime)) continue;
            result.add(offer);
        }
        return result;
    }

    public void validateGeProperties() {
        if (this.nextGeLimitRefresh == null) {
            return;
        }
        if (Instant.now().compareTo(this.nextGeLimitRefresh) >= 0) {
            this.nextGeLimitRefresh = null;
            this.itemsBoughtThisLimitWindow = 0;
        }
    }

    public boolean hasValidOffers() {
        return this.compressedOfferEvents.size() > 0;
    }

    public boolean hasOfferInInterval(Instant earliestTime) {
        if (!this.hasValidOffers()) {
            return false;
        }
        OfferEvent lastOffer = this.compressedOfferEvents.get(this.compressedOfferEvents.size() - 1);
        return lastOffer.getTime().isAfter(earliestTime);
    }

    public void deleteOffers(List<OfferEvent> offerList) {
        if (offerList.isEmpty()) {
            return;
        }
        Set idsOfOffersToBeDeleted = offerList.stream().map(OfferEvent::getUuid).collect(Collectors.toSet());
        this.compressedOfferEvents.removeIf(o -> idsOfOffersToBeDeleted.contains(o.getUuid()));
    }

    public List<OfferEvent> getOfferMatches(OfferEvent offer, int limit) {
        ArrayList<OfferEvent> matches = new ArrayList<OfferEvent>();
        int count = 0;
        for (int i = this.compressedOfferEvents.size() - 1; i > -1; --i) {
            OfferEvent pastOffer = this.compressedOfferEvents.get(i);
            if (offer.getPrice() != pastOffer.getPrice() || offer.getCurrentQuantityInTrade() != pastOffer.getCurrentQuantityInTrade() || offer.isBuy() != pastOffer.isBuy() || !pastOffer.isComplete()) continue;
            matches.add(pastOffer);
            if (++count == limit) break;
        }
        return matches;
    }

    public Optional<OfferEvent> getLatestOfferThatMatchesPredicate(Predicate<OfferEvent> predicate) {
        for (int i = this.compressedOfferEvents.size() - 1; i > -1; --i) {
            if (!predicate.test(this.compressedOfferEvents.get(i))) continue;
            return Optional.of(this.compressedOfferEvents.get(i));
        }
        return Optional.empty();
    }

    public void setOfferNames(String itemName) {
        this.compressedOfferEvents.forEach(o -> o.setItemName(itemName));
    }

    public void setOfferMadeBy(String name) {
        this.compressedOfferEvents.forEach(o -> o.setMadeBy(name));
    }

    public void setOfferIds() {
        this.compressedOfferEvents.forEach(o -> {
            if (o.getUuid() == null) {
                o.setUuid(UUID.randomUUID().toString());
            }
        });
    }

    public static long getProfit(List<OfferEvent> tradeList) {
        return HistoryManager.getValueOfMatchedOffers(tradeList, false) - HistoryManager.getValueOfMatchedOffers(tradeList, true);
    }

    public static long getValueOfMatchedOffers(List<OfferEvent> tradeList, boolean isBuy) {
        return HistoryManager.getValueOfOffersUpToLimit(tradeList.stream().filter(o -> o.isBuy() == isBuy).collect(Collectors.toList()), HistoryManager.countFlipQuantity(tradeList));
    }

    public static long getTotalRevenueOrExpense(List<OfferEvent> tradeList, boolean isBuy) {
        return tradeList.stream().filter(o -> o.isBuy() == isBuy).mapToLong(o -> o.getCurrentQuantityInTrade() * o.getPrice()).sum();
    }

    public static int countFlipQuantity(List<OfferEvent> tradeList) {
        int numBoughtItems = 0;
        int numSoldItems = 0;
        for (OfferEvent offer : tradeList) {
            if (offer.isBuy()) {
                numBoughtItems += offer.getCurrentQuantityInTrade();
                continue;
            }
            numSoldItems += offer.getCurrentQuantityInTrade();
        }
        return Math.min(numBoughtItems, numSoldItems);
    }

    private static long getValueOfOffersUpToLimit(List<OfferEvent> tradeList, long itemLimit) {
        int itemsSeen = 0;
        long moneySpent = 0L;
        itemLimit = itemLimit == -1L ? Long.MAX_VALUE : itemLimit;
        for (OfferEvent offer : tradeList) {
            if ((long)(itemsSeen + offer.getCurrentQuantityInTrade()) >= itemLimit) {
                moneySpent += (itemLimit - (long)itemsSeen) * (long)offer.getPrice();
                break;
            }
            moneySpent += (long)(offer.getCurrentQuantityInTrade() * offer.getPrice());
            itemsSeen += offer.getCurrentQuantityInTrade();
        }
        return moneySpent;
    }

    static List<OfferEvent> getPartialOfferAdjustedView(List<OfferEvent> offers, Map<String, PartialOffer> partialOffers) {
        return offers.stream().map(o -> {
            if (partialOffers.containsKey(o.getUuid())) {
                return ((PartialOffer)partialOffers.get(o.getUuid())).toRemainingOfferEvent();
            }
            return o;
        }).collect(Collectors.toList());
    }

    public static List<Flip> getFlips(List<OfferEvent> tradeList) {
        Map<String, List<OfferEvent>> groupedOffers = tradeList.stream().collect(Collectors.groupingBy(OfferEvent::getMadeBy));
        ArrayList<Flip> flips = new ArrayList<Flip>();
        groupedOffers.values().forEach(offers -> flips.addAll(HistoryManager.createFlips(offers)));
        flips.sort(Comparator.comparing(Flip::getTime));
        return flips;
    }

    public static List<Flip> createFlips(List<OfferEvent> offers) {
        List<T>[] subLists = ListUtils.partition(offers.stream().map(OfferEvent::clone).collect(Collectors.toList()), o -> o.isMarginCheck() && o.isBuy(), o -> o.isMarginCheck() && !o.isBuy(), o -> !o.isMarginCheck() && o.isBuy(), o -> !o.isMarginCheck() && !o.isBuy());
        List<OfferEvent> buyMarginChecks = subLists[0];
        List<OfferEvent> sellMarginChecks = subLists[1];
        List<OfferEvent> nonMarginCheckBuys = subLists[2];
        List<OfferEvent> nonMarginCheckSells = subLists[3];
        ArrayList<Flip> flips = new ArrayList<Flip>();
        ArrayList<OfferEvent> unPairedMarginChecks = new ArrayList<OfferEvent>();
        List<Flip> flipsFromMarginChecks = HistoryManager.pairMarginChecks(buyMarginChecks, sellMarginChecks, unPairedMarginChecks);
        unPairedMarginChecks.forEach(offer -> {
            if (offer.isBuy()) {
                nonMarginCheckBuys.add((OfferEvent)offer);
            } else {
                nonMarginCheckSells.add((OfferEvent)offer);
            }
        });
        nonMarginCheckBuys.sort(Comparator.comparing(OfferEvent::getTime));
        nonMarginCheckSells.sort(Comparator.comparing(OfferEvent::getTime));
        flips.addAll(flipsFromMarginChecks);
        flips.addAll(HistoryManager.combineToFlips(nonMarginCheckBuys, nonMarginCheckSells));
        return flips;
    }

    public static List<Flip> pairMarginChecks(List<OfferEvent> buys, List<OfferEvent> sells, List<OfferEvent> remainder) {
        int buyIdx;
        ArrayList<Flip> flips = new ArrayList<Flip>();
        int sellIdx = 0;
        for (buyIdx = 0; buyIdx < buys.size() && sellIdx != sells.size(); ++buyIdx) {
            OfferEvent buy = buys.get(buyIdx);
            OfferEvent sell = sells.get(sellIdx);
            long millisBetweenBuyAndSell = Duration.between(buy.getTime(), sell.getTime()).toMillis();
            if (millisBetweenBuyAndSell >= 0L && millisBetweenBuyAndSell < 60000L) {
                flips.add(new Flip(buy.getPrice(), sell.getPrice(), sell.getCurrentQuantityInTrade(), sell.getTime(), sell.isMarginCheck(), false));
                ++sellIdx;
                continue;
            }
            if (millisBetweenBuyAndSell >= 0L && millisBetweenBuyAndSell >= 60000L) {
                remainder.add(buy);
                continue;
            }
            if (millisBetweenBuyAndSell >= 0L) continue;
            remainder.add(sell);
            ++sellIdx;
            --buyIdx;
        }
        remainder.addAll(sells.subList(sellIdx, sells.size()));
        remainder.addAll(buys.subList(buyIdx, buys.size()));
        return flips;
    }

    private static ArrayList<Flip> combineToFlips(List<OfferEvent> buys, List<OfferEvent> sells) {
        ArrayList<Flip> flips = new ArrayList<Flip>();
        int buyIdx = 0;
        for (OfferEvent sell : sells) {
            if (sell.getCurrentQuantityInTrade() == 0) continue;
            int numBuysSeen = 0;
            int totalRevenue = 0;
            while (buyIdx < buys.size()) {
                OfferEvent buy = buys.get(buyIdx);
                if ((numBuysSeen += buy.getCurrentQuantityInTrade()) >= sell.getCurrentQuantityInTrade()) {
                    int leftOver = numBuysSeen - sell.getCurrentQuantityInTrade();
                    int amountTaken = buy.getCurrentQuantityInTrade() - leftOver;
                    buy.setCurrentQuantityInTrade(leftOver);
                    flips.add(new Flip((totalRevenue += amountTaken * buy.getPrice()) / sell.getCurrentQuantityInTrade(), sell.getPrice(), sell.getCurrentQuantityInTrade(), sell.getTime(), false, !sell.isComplete()));
                    break;
                }
                totalRevenue += buy.getCurrentQuantityInTrade() * buy.getPrice();
                ++buyIdx;
            }
            if (buyIdx != buys.size() || numBuysSeen == 0) continue;
            flips.add(new Flip(totalRevenue / numBuysSeen, sell.getPrice(), numBuysSeen, sell.getTime(), false, true));
            break;
        }
        return flips;
    }

    public HistoryManager(List<OfferEvent> compressedOfferEvents, Instant nextGeLimitRefresh, int itemsBoughtThisLimitWindow, int itemsBoughtThroughCompleteOffers) {
        this.compressedOfferEvents = compressedOfferEvents;
        this.nextGeLimitRefresh = nextGeLimitRefresh;
        this.itemsBoughtThisLimitWindow = itemsBoughtThisLimitWindow;
        this.itemsBoughtThroughCompleteOffers = itemsBoughtThroughCompleteOffers;
    }

    public HistoryManager() {
    }

    public List<OfferEvent> getCompressedOfferEvents() {
        return this.compressedOfferEvents;
    }

    public void setCompressedOfferEvents(List<OfferEvent> compressedOfferEvents) {
        this.compressedOfferEvents = compressedOfferEvents;
    }

    public Instant getNextGeLimitRefresh() {
        return this.nextGeLimitRefresh;
    }

    public int getItemsBoughtThisLimitWindow() {
        return this.itemsBoughtThisLimitWindow;
    }
}

