/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.model.Flip;
import com.flippingutilities.model.HistoryManager;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.utilities.Constants;
import com.flippingutilities.utilities.GeTax;
import com.flippingutilities.utilities.Searchable;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlippingItem
implements Searchable {
    private static final Logger log = LoggerFactory.getLogger(FlippingItem.class);
    @SerializedName(value="id")
    private int itemId;
    @SerializedName(value="name")
    private String itemName;
    @SerializedName(value="tGL")
    private int totalGELimit;
    @SerializedName(value="h")
    private HistoryManager history = new HistoryManager();
    @SerializedName(value="fB")
    private String flippedBy;
    @SerializedName(value="vFPI")
    private Boolean validFlippingPanelItem;
    private boolean favorite;
    private String favoriteCode = "1";
    private transient Optional<OfferEvent> latestInstaBuy;
    private transient Optional<OfferEvent> latestInstaSell;
    private transient Optional<OfferEvent> latestBuy;
    private transient Optional<OfferEvent> latestSell;
    private transient Instant latestActivityTime;
    private transient Boolean expand;

    public FlippingItem(int itemId, String itemName, int totalGeLimit, String flippedBy) {
        this.latestInstaBuy = Optional.empty();
        this.latestInstaSell = Optional.empty();
        this.latestBuy = Optional.empty();
        this.latestSell = Optional.empty();
        this.itemName = itemName;
        this.itemId = itemId;
        this.totalGELimit = totalGeLimit;
        this.flippedBy = flippedBy;
        this.latestActivityTime = Constants.DUMMY_ITEM.equals(flippedBy) ? Instant.EPOCH : Instant.now();
    }

    public FlippingItem clone() {
        return new FlippingItem(this.itemId, this.itemName, this.totalGELimit, this.history.clone(), this.flippedBy, this.validFlippingPanelItem, this.favorite, this.favoriteCode, this.latestInstaBuy, this.latestInstaSell, this.latestBuy, this.latestSell, this.latestActivityTime, this.expand);
    }

    public void updateHistory(OfferEvent newOffer) {
        newOffer.setItemName(this.itemName);
        this.history.updateHistory(newOffer);
    }

    public void updateLatestProperties(OfferEvent newOffer) {
        if (newOffer.isBuy()) {
            if (newOffer.isMarginCheck()) {
                this.latestInstaBuy = Optional.of(newOffer);
            }
            this.latestBuy = Optional.of(newOffer);
        } else {
            if (newOffer.isMarginCheck()) {
                this.latestInstaSell = Optional.of(newOffer);
            }
            this.latestSell = Optional.of(newOffer);
        }
        this.latestActivityTime = newOffer.getTime();
    }

    public static FlippingItem merge(FlippingItem item1, FlippingItem item2) {
        if (item1 == null) {
            return item2;
        }
        if (item1.getLatestActivityTime().compareTo(item2.getLatestActivityTime()) >= 0) {
            item1.getHistory().getCompressedOfferEvents().addAll(item2.getHistory().getCompressedOfferEvents());
            item1.getHistory().getCompressedOfferEvents().sort(Comparator.comparing(OfferEvent::getTime));
            item1.setFavorite(item1.isFavorite() || item2.isFavorite());
            return item1;
        }
        item2.getHistory().getCompressedOfferEvents().addAll(item1.getHistory().getCompressedOfferEvents());
        item2.getHistory().getCompressedOfferEvents().sort(Comparator.comparing(OfferEvent::getTime));
        item2.setFavorite(item2.isFavorite() || item1.isFavorite());
        return item2;
    }

    public static long getProfit(List<OfferEvent> tradeList) {
        return HistoryManager.getProfit(tradeList);
    }

    public static long getValueOfMatchedOffers(List<OfferEvent> tradeList, boolean isBuy) {
        return HistoryManager.getValueOfMatchedOffers(tradeList, isBuy);
    }

    public static long getTotalRevenueOrExpense(List<OfferEvent> tradeList, boolean isBuy) {
        return HistoryManager.getTotalRevenueOrExpense(tradeList, isBuy);
    }

    public static int countFlipQuantity(List<OfferEvent> tradeList) {
        return HistoryManager.countFlipQuantity(tradeList);
    }

    public static List<Flip> getFlips(List<OfferEvent> tradeList) {
        return HistoryManager.getFlips(tradeList);
    }

    public static List<OfferEvent> getPartialOfferAdjustedView(List<OfferEvent> offers, Map<String, PartialOffer> partialOffers) {
        return HistoryManager.getPartialOfferAdjustedView(offers, partialOffers);
    }

    public ArrayList<OfferEvent> getIntervalHistory(Instant earliestTime) {
        return this.history.getIntervalsHistory(earliestTime);
    }

    public int getRemainingGeLimit() {
        return this.totalGELimit - this.history.getItemsBoughtThisLimitWindow();
    }

    public int getItemsBoughtThisLimitWindow() {
        return this.history.getItemsBoughtThisLimitWindow();
    }

    public Instant getGeLimitResetTime() {
        return this.history.getNextGeLimitRefresh();
    }

    public void validateGeProperties() {
        this.history.validateGeProperties();
    }

    public boolean hasValidOffers() {
        return this.history.hasValidOffers();
    }

    @Override
    public boolean isInInterval(Instant earliestTime) {
        return this.history.hasOfferInInterval(earliestTime);
    }

    public void deleteOffers(List<OfferEvent> offerList) {
        this.history.deleteOffers(offerList);
    }

    public void setValidFlippingPanelItem(boolean isValid) {
        this.validFlippingPanelItem = isValid;
        if (!isValid) {
            this.latestInstaBuy = Optional.empty();
            this.latestInstaSell = Optional.empty();
            this.latestBuy = Optional.empty();
            this.latestSell = Optional.empty();
        }
    }

    public Optional<Integer> getPotentialProfit(boolean includeMarginCheck, boolean shouldUseRemainingGeLimit) {
        if (!this.getLatestInstaBuy().isPresent() || !this.getLatestInstaSell().isPresent()) {
            return Optional.empty();
        }
        int profitEach = this.getCurrentProfitEach().get();
        int remainingGeLimit = this.getRemainingGeLimit();
        int geLimit = shouldUseRemainingGeLimit ? remainingGeLimit : this.totalGELimit;
        int profitTotal = geLimit * profitEach;
        if (includeMarginCheck) {
            profitTotal -= profitEach;
        }
        return Optional.of(profitTotal);
    }

    public List<OfferEvent> getOfferMatches(OfferEvent offerEvent, int limit) {
        return this.history.getOfferMatches(offerEvent, limit);
    }

    public Optional<Float> getCurrentRoi() {
        return this.getCurrentProfitEach().isPresent() ? Optional.of(Float.valueOf((float)this.getCurrentProfitEach().get().intValue() / (float)this.getLatestInstaSell().get().getPrice() * 100.0f)) : Optional.empty();
    }

    public Optional<Integer> getCurrentProfitEach() {
        return this.getLatestInstaBuy().isPresent() && this.getLatestInstaSell().isPresent() ? Optional.of(GeTax.getPostTaxPrice(this.getLatestInstaBuy().get().getPrice()) - this.getLatestInstaSell().get().getPreTaxPrice()) : Optional.empty();
    }

    private void syncState() {
        this.latestBuy = this.history.getLatestOfferThatMatchesPredicate(offer -> offer.isBuy());
        this.latestSell = this.history.getLatestOfferThatMatchesPredicate(offer -> !offer.isBuy());
        this.latestInstaBuy = this.history.getLatestOfferThatMatchesPredicate(offer -> offer.isBuy() & offer.isMarginCheck());
        this.latestInstaSell = this.history.getLatestOfferThatMatchesPredicate(offer -> !offer.isBuy() & offer.isMarginCheck());
        this.latestActivityTime = this.history.getCompressedOfferEvents().size() == 0 ? Instant.EPOCH : this.history.getCompressedOfferEvents().get(this.history.getCompressedOfferEvents().size() - 1).getTime();
    }

    private void setOfferMadeBy() {
        if (this.flippedBy == null) {
            log.info("flipped by is null");
        }
        this.history.setOfferMadeBy(this.flippedBy);
    }

    private void setOfferIds() {
        this.history.setOfferIds();
    }

    private void setOfferNames() {
        this.history.setOfferNames(this.itemName);
    }

    public void hydrate(int geLimit) {
        this.setTotalGELimit(geLimit);
        this.syncState();
        this.setOfferIds();
        this.setOfferNames();
        this.setOfferMadeBy();
        if (this.validFlippingPanelItem == null) {
            this.validFlippingPanelItem = true;
        }
    }

    @Override
    public String getNameForSearch() {
        return this.itemName;
    }

    public FlippingItem(int itemId, String itemName, int totalGELimit, HistoryManager history, String flippedBy, Boolean validFlippingPanelItem, boolean favorite, String favoriteCode, Optional<OfferEvent> latestInstaBuy, Optional<OfferEvent> latestInstaSell, Optional<OfferEvent> latestBuy, Optional<OfferEvent> latestSell, Instant latestActivityTime, Boolean expand) {
        this.itemId = itemId;
        this.itemName = itemName;
        this.totalGELimit = totalGELimit;
        this.history = history;
        this.flippedBy = flippedBy;
        this.validFlippingPanelItem = validFlippingPanelItem;
        this.favorite = favorite;
        this.favoriteCode = favoriteCode;
        this.latestInstaBuy = latestInstaBuy;
        this.latestInstaSell = latestInstaSell;
        this.latestBuy = latestBuy;
        this.latestSell = latestSell;
        this.latestActivityTime = latestActivityTime;
        this.expand = expand;
    }

    public FlippingItem() {
    }

    public int getItemId() {
        return this.itemId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public int getTotalGELimit() {
        return this.totalGELimit;
    }

    public void setTotalGELimit(int totalGELimit) {
        this.totalGELimit = totalGELimit;
    }

    public HistoryManager getHistory() {
        return this.history;
    }

    public void setHistory(HistoryManager history) {
        this.history = history;
    }

    public String getFlippedBy() {
        return this.flippedBy;
    }

    public void setFlippedBy(String flippedBy) {
        this.flippedBy = flippedBy;
    }

    public Boolean getValidFlippingPanelItem() {
        return this.validFlippingPanelItem;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public String getFavoriteCode() {
        return this.favoriteCode;
    }

    public void setFavoriteCode(String favoriteCode) {
        this.favoriteCode = favoriteCode;
    }

    public void setLatestInstaBuy(Optional<OfferEvent> latestInstaBuy) {
        this.latestInstaBuy = latestInstaBuy;
    }

    public Optional<OfferEvent> getLatestInstaBuy() {
        return this.latestInstaBuy;
    }

    public void setLatestInstaSell(Optional<OfferEvent> latestInstaSell) {
        this.latestInstaSell = latestInstaSell;
    }

    public Optional<OfferEvent> getLatestInstaSell() {
        return this.latestInstaSell;
    }

    public void setLatestBuy(Optional<OfferEvent> latestBuy) {
        this.latestBuy = latestBuy;
    }

    public Optional<OfferEvent> getLatestBuy() {
        return this.latestBuy;
    }

    public void setLatestSell(Optional<OfferEvent> latestSell) {
        this.latestSell = latestSell;
    }

    public Optional<OfferEvent> getLatestSell() {
        return this.latestSell;
    }

    public Instant getLatestActivityTime() {
        return this.latestActivityTime;
    }

    public Boolean getExpand() {
        return this.expand;
    }

    public void setExpand(Boolean expand) {
        this.expand = expand;
    }
}

