/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.model.Option;
import com.flippingutilities.model.Section;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountWideData {
    private static final Logger log = LoggerFactory.getLogger(AccountWideData.class);
    List<Option> options = new ArrayList<Option>();
    List<Section> sections = new ArrayList<Section>();
    boolean shouldMakeNewAdditions = true;
    boolean enhancedSlots = true;
    String jwt;

    public boolean setDefaults() {
        boolean didChangeData = this.changeOldPropertyNames();
        if (this.options.isEmpty()) {
            this.setDefaultOptions();
            this.shouldMakeNewAdditions = false;
            didChangeData = true;
        }
        boolean alreadyHasWikiOptions = this.options.stream().anyMatch(o -> o.getProperty().equals("wiki buy") || o.getProperty().equals("wiki sell"));
        if (this.shouldMakeNewAdditions && !alreadyHasWikiOptions) {
            this.options.add(0, new Option("n", "wiki sell", "+0", false));
            this.options.add(0, new Option("j", "wiki buy", "+0", false));
            this.shouldMakeNewAdditions = false;
            didChangeData = true;
        }
        if (this.sections.isEmpty()) {
            didChangeData = true;
            this.setDefaultFlippingItemPanelSections();
        }
        return didChangeData;
    }

    private boolean changeOldPropertyNames() {
        boolean changedOldNames = false;
        for (Option o : this.options) {
            if (o.getProperty().equals("marg sell")) {
                o.setProperty("insta buy");
                changedOldNames = true;
            }
            if (!o.getProperty().equals("marg buy")) continue;
            o.setProperty("insta sell");
            changedOldNames = true;
        }
        return changedOldNames;
    }

    private void setDefaultOptions() {
        this.options.add(new Option("n", "wiki sell", "+0", false));
        this.options.add(new Option("j", "wiki buy", "+0", false));
        this.options.add(new Option("p", "insta buy", "+0", false));
        this.options.add(new Option("l", "insta sell", "+0", false));
        this.options.add(new Option("o", "last buy", "+0", false));
        this.options.add(new Option("u", "last sell", "+0", false));
        this.options.add(new Option("p", "ge limit", "+0", true));
        this.options.add(new Option("l", "rem limit", "+0", true));
        this.options.add(new Option("o", "cashstack", "+0", true));
    }

    private void setDefaultFlippingItemPanelSections() {
        Section importantSection = new Section("Important");
        Section otherSection = new Section("Other");
        importantSection.defaultExpanded = true;
        importantSection.showLabel("wiki buy price", true);
        importantSection.showLabel("wiki sell price", true);
        importantSection.showLabel("latest buy price", true);
        importantSection.showLabel("latest sell price", true);
        importantSection.showLabel("price check buy price", true);
        importantSection.showLabel("price check sell price", true);
        otherSection.showLabel("profit each", true);
        otherSection.showLabel("margin check profit each", true);
        otherSection.showLabel("potential profit", true);
        otherSection.showLabel("remaining ge limit", true);
        otherSection.showLabel("roi", true);
        otherSection.showLabel("ge limit refresh timer", true);
        this.sections.add(importantSection);
        this.sections.add(otherSection);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public boolean isShouldMakeNewAdditions() {
        return this.shouldMakeNewAdditions;
    }

    public boolean isEnhancedSlots() {
        return this.enhancedSlots;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public void setShouldMakeNewAdditions(boolean shouldMakeNewAdditions) {
        this.shouldMakeNewAdditions = shouldMakeNewAdditions;
    }

    public void setEnhancedSlots(boolean enhancedSlots) {
        this.enhancedSlots = enhancedSlots;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountWideData)) {
            return false;
        }
        AccountWideData other = (AccountWideData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        List<Section> this$sections = this.getSections();
        List<Section> other$sections = other.getSections();
        if (this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections)) {
            return false;
        }
        if (this.isShouldMakeNewAdditions() != other.isShouldMakeNewAdditions()) {
            return false;
        }
        if (this.isEnhancedSlots() != other.isEnhancedSlots()) {
            return false;
        }
        String this$jwt = this.getJwt();
        String other$jwt = other.getJwt();
        return !(this$jwt == null ? other$jwt != null : !this$jwt.equals(other$jwt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountWideData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        List<Section> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        result = result * 59 + (this.isShouldMakeNewAdditions() ? 79 : 97);
        result = result * 59 + (this.isEnhancedSlots() ? 79 : 97);
        String $jwt = this.getJwt();
        result = result * 59 + ($jwt == null ? 43 : $jwt.hashCode());
        return result;
    }

    public String toString() {
        return "AccountWideData(options=" + this.getOptions() + ", sections=" + this.getSections() + ", shouldMakeNewAdditions=" + this.isShouldMakeNewAdditions() + ", enhancedSlots=" + this.isEnhancedSlots() + ", jwt=" + this.getJwt() + ")";
    }
}

