/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.model;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.widgets.SlotActivityTimer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.runelite.client.game.ItemManager;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountData {
    private static final Logger log = LoggerFactory.getLogger(AccountData.class);
    private Map<Integer, OfferEvent> lastOffers = new HashMap<Integer, OfferEvent>();
    private List<FlippingItem> trades = new ArrayList<FlippingItem>();
    private Instant sessionStartTime = Instant.now();
    private long accumulatedSessionTimeMillis = 0L;
    private Instant lastSessionTimeUpdate;
    private List<SlotActivityTimer> slotTimers;
    private List<RecipeFlipGroup> recipeFlipGroups = new ArrayList<RecipeFlipGroup>();
    private Instant lastStoredAt = Instant.EPOCH;
    private Instant lastModifiedAt = Instant.now();

    public void startNewSession() {
        this.sessionStartTime = Instant.now();
        this.accumulatedSessionTimeMillis = 0L;
        this.lastSessionTimeUpdate = null;
    }

    public void prepareForUse(FlippingPlugin plugin) {
        this.fixIncorrectItemNames(plugin.getItemManager());
        HashMap<String, OfferEvent> hydratedOffers = new HashMap<String, OfferEvent>();
        for (FlippingItem item : this.trades) {
            int tradeItemId = item.getItemId();
            ItemStats itemStats = plugin.getItemManager().getItemStats(tradeItemId, false);
            int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
            item.hydrate(geLimit);
            item.getHistory().getCompressedOfferEvents().forEach(o -> hydratedOffers.put(o.getUuid(), (OfferEvent)o));
        }
        this.hydratePartialOffers(hydratedOffers);
        this.hydrateSlotTimers(plugin);
    }

    private void hydrateSlotTimers(FlippingPlugin plugin) {
        if (this.slotTimers == null) {
            this.slotTimers = this.setupSlotTimers(plugin);
        } else {
            this.slotTimers.forEach(timer -> {
                timer.setClient(plugin.getClient());
                timer.setPlugin(plugin);
            });
        }
    }

    private void hydratePartialOffers(Map<String, OfferEvent> hydratedOffers) {
        List<PartialOffer> partialOffers = this.recipeFlipGroups.stream().flatMap(rfg -> rfg.getPartialOffers().stream()).collect(Collectors.toList());
        partialOffers.forEach(po -> {
            OfferEvent o = (OfferEvent)hydratedOffers.get(po.offer.getUuid());
            if (o == null) {
                log.warn("partial offer references deleted offer event, this should not happen!");
                return;
            }
            po.hydrateUnderlyingOfferEvent(o.getMadeBy(), o.getItemName());
        });
    }

    public void fixIncorrectItemNames(ItemManager itemManager) {
        this.trades.forEach(item -> {
            if (item.getItemName().equals("Members object")) {
                String actualName = itemManager.getItemComposition(item.getItemId()).getName();
                item.setItemName(actualName);
            }
        });
    }

    private List<SlotActivityTimer> setupSlotTimers(FlippingPlugin plugin) {
        ArrayList<SlotActivityTimer> slotTimers = new ArrayList<SlotActivityTimer>();
        for (int slotIndex = 0; slotIndex < 8; ++slotIndex) {
            slotTimers.add(new SlotActivityTimer(plugin, plugin.getClient(), slotIndex));
        }
        return slotTimers;
    }

    public Map<Integer, OfferEvent> getLastOffers() {
        return this.lastOffers;
    }

    public List<FlippingItem> getTrades() {
        return this.trades;
    }

    public Instant getSessionStartTime() {
        return this.sessionStartTime;
    }

    public long getAccumulatedSessionTimeMillis() {
        return this.accumulatedSessionTimeMillis;
    }

    public Instant getLastSessionTimeUpdate() {
        return this.lastSessionTimeUpdate;
    }

    public List<SlotActivityTimer> getSlotTimers() {
        return this.slotTimers;
    }

    public List<RecipeFlipGroup> getRecipeFlipGroups() {
        return this.recipeFlipGroups;
    }

    public Instant getLastStoredAt() {
        return this.lastStoredAt;
    }

    public Instant getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastOffers(Map<Integer, OfferEvent> lastOffers) {
        this.lastOffers = lastOffers;
    }

    public void setTrades(List<FlippingItem> trades) {
        this.trades = trades;
    }

    public void setSessionStartTime(Instant sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }

    public void setAccumulatedSessionTimeMillis(long accumulatedSessionTimeMillis) {
        this.accumulatedSessionTimeMillis = accumulatedSessionTimeMillis;
    }

    public void setLastSessionTimeUpdate(Instant lastSessionTimeUpdate) {
        this.lastSessionTimeUpdate = lastSessionTimeUpdate;
    }

    public void setSlotTimers(List<SlotActivityTimer> slotTimers) {
        this.slotTimers = slotTimers;
    }

    public void setRecipeFlipGroups(List<RecipeFlipGroup> recipeFlipGroups) {
        this.recipeFlipGroups = recipeFlipGroups;
    }

    public void setLastStoredAt(Instant lastStoredAt) {
        this.lastStoredAt = lastStoredAt;
    }

    public void setLastModifiedAt(Instant lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountData)) {
            return false;
        }
        AccountData other = (AccountData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, OfferEvent> this$lastOffers = this.getLastOffers();
        Map<Integer, OfferEvent> other$lastOffers = other.getLastOffers();
        if (this$lastOffers == null ? other$lastOffers != null : !((Object)this$lastOffers).equals(other$lastOffers)) {
            return false;
        }
        List<FlippingItem> this$trades = this.getTrades();
        List<FlippingItem> other$trades = other.getTrades();
        if (this$trades == null ? other$trades != null : !((Object)this$trades).equals(other$trades)) {
            return false;
        }
        Instant this$sessionStartTime = this.getSessionStartTime();
        Instant other$sessionStartTime = other.getSessionStartTime();
        if (this$sessionStartTime == null ? other$sessionStartTime != null : !((Object)this$sessionStartTime).equals(other$sessionStartTime)) {
            return false;
        }
        if (this.getAccumulatedSessionTimeMillis() != other.getAccumulatedSessionTimeMillis()) {
            return false;
        }
        Instant this$lastSessionTimeUpdate = this.getLastSessionTimeUpdate();
        Instant other$lastSessionTimeUpdate = other.getLastSessionTimeUpdate();
        if (this$lastSessionTimeUpdate == null ? other$lastSessionTimeUpdate != null : !((Object)this$lastSessionTimeUpdate).equals(other$lastSessionTimeUpdate)) {
            return false;
        }
        List<SlotActivityTimer> this$slotTimers = this.getSlotTimers();
        List<SlotActivityTimer> other$slotTimers = other.getSlotTimers();
        if (this$slotTimers == null ? other$slotTimers != null : !((Object)this$slotTimers).equals(other$slotTimers)) {
            return false;
        }
        List<RecipeFlipGroup> this$recipeFlipGroups = this.getRecipeFlipGroups();
        List<RecipeFlipGroup> other$recipeFlipGroups = other.getRecipeFlipGroups();
        if (this$recipeFlipGroups == null ? other$recipeFlipGroups != null : !((Object)this$recipeFlipGroups).equals(other$recipeFlipGroups)) {
            return false;
        }
        Instant this$lastStoredAt = this.getLastStoredAt();
        Instant other$lastStoredAt = other.getLastStoredAt();
        if (this$lastStoredAt == null ? other$lastStoredAt != null : !((Object)this$lastStoredAt).equals(other$lastStoredAt)) {
            return false;
        }
        Instant this$lastModifiedAt = this.getLastModifiedAt();
        Instant other$lastModifiedAt = other.getLastModifiedAt();
        return !(this$lastModifiedAt == null ? other$lastModifiedAt != null : !((Object)this$lastModifiedAt).equals(other$lastModifiedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, OfferEvent> $lastOffers = this.getLastOffers();
        result = result * 59 + ($lastOffers == null ? 43 : ((Object)$lastOffers).hashCode());
        List<FlippingItem> $trades = this.getTrades();
        result = result * 59 + ($trades == null ? 43 : ((Object)$trades).hashCode());
        Instant $sessionStartTime = this.getSessionStartTime();
        result = result * 59 + ($sessionStartTime == null ? 43 : ((Object)$sessionStartTime).hashCode());
        long $accumulatedSessionTimeMillis = this.getAccumulatedSessionTimeMillis();
        result = result * 59 + (int)($accumulatedSessionTimeMillis >>> 32 ^ $accumulatedSessionTimeMillis);
        Instant $lastSessionTimeUpdate = this.getLastSessionTimeUpdate();
        result = result * 59 + ($lastSessionTimeUpdate == null ? 43 : ((Object)$lastSessionTimeUpdate).hashCode());
        List<SlotActivityTimer> $slotTimers = this.getSlotTimers();
        result = result * 59 + ($slotTimers == null ? 43 : ((Object)$slotTimers).hashCode());
        List<RecipeFlipGroup> $recipeFlipGroups = this.getRecipeFlipGroups();
        result = result * 59 + ($recipeFlipGroups == null ? 43 : ((Object)$recipeFlipGroups).hashCode());
        Instant $lastStoredAt = this.getLastStoredAt();
        result = result * 59 + ($lastStoredAt == null ? 43 : ((Object)$lastStoredAt).hashCode());
        Instant $lastModifiedAt = this.getLastModifiedAt();
        result = result * 59 + ($lastModifiedAt == null ? 43 : ((Object)$lastModifiedAt).hashCode());
        return result;
    }

    public String toString() {
        return "AccountData(lastOffers=" + this.getLastOffers() + ", trades=" + this.getTrades() + ", sessionStartTime=" + this.getSessionStartTime() + ", accumulatedSessionTimeMillis=" + this.getAccumulatedSessionTimeMillis() + ", lastSessionTimeUpdate=" + this.getLastSessionTimeUpdate() + ", slotTimers=" + this.getSlotTimers() + ", recipeFlipGroups=" + this.getRecipeFlipGroups() + ", lastStoredAt=" + this.getLastStoredAt() + ", lastModifiedAt=" + this.getLastModifiedAt() + ")";
    }
}

