/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.jobs;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.utilities.WikiDataSource;
import com.flippingutilities.utilities.WikiRequest;
import com.flippingutilities.utilities.WikiRequestWrapper;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.runelite.api.WorldType;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiDataFetcherJob {
    private static final Logger log = LoggerFactory.getLogger(WikiDataFetcherJob.class);
    public static int requestInterval = 60;
    static final String API = "https://prices.runescape.wiki/api/v1/osrs/latest";
    static final String DEADMAN_API = "https://prices.runescape.wiki/api/v1/dmm/latest";
    FlippingPlugin plugin;
    ScheduledExecutorService executor;
    OkHttpClient httpClient;
    List<BiConsumer<WikiRequestWrapper, Instant>> subscribers = new ArrayList<BiConsumer<WikiRequestWrapper, Instant>>();
    Future wikiDataFetchTask;
    Instant timeOfLastRequestCompletion;
    boolean inFlightRequest = false;
    String apiUrl = "https://prices.runescape.wiki/api/v1/osrs/latest";

    public WikiDataFetcherJob(FlippingPlugin plugin, OkHttpClient httpClient) {
        this.plugin = plugin;
        this.httpClient = httpClient;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void subscribe(BiConsumer<WikiRequestWrapper, Instant> subscriber) {
        this.subscribers.add(subscriber);
    }

    public void start() {
        this.wikiDataFetchTask = this.executor.scheduleAtFixedRate(() -> this.attemptToFetchWikiData(false), 5L, 1L, TimeUnit.SECONDS);
        log.info("started wiki fetching job");
    }

    public void stop() {
        if (!this.wikiDataFetchTask.isCancelled() && !this.wikiDataFetchTask.isCancelled()) {
            this.wikiDataFetchTask.cancel(true);
            log.info("shut down wiki fetching job");
        }
    }

    public void onWorldSwitch(EnumSet<WorldType> worldType) {
        if (worldType.contains(WorldType.DEADMAN)) {
            log.info("Switching to requesting deadman api");
            this.apiUrl = DEADMAN_API;
        } else {
            this.apiUrl = API;
        }
        this.attemptToFetchWikiData(true);
    }

    private WikiDataSource getWikiDataSourceType() {
        if (this.apiUrl.equals(DEADMAN_API)) {
            return WikiDataSource.DMM;
        }
        return WikiDataSource.REGULAR;
    }

    private boolean shouldFetch() {
        boolean lastRequestOldEnough = this.timeOfLastRequestCompletion == null || Instant.now().minus(requestInterval, ChronoUnit.SECONDS).isAfter(this.timeOfLastRequestCompletion);
        return (this.plugin.getMasterPanel().isVisible() || this.plugin.getApiAuthHandler().isPremium()) && !this.inFlightRequest && lastRequestOldEnough;
    }

    public void attemptToFetchWikiData(boolean force) {
        if (!force && !this.shouldFetch()) {
            return;
        }
        this.inFlightRequest = true;
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").url(this.apiUrl).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                WikiDataFetcherJob.this.timeOfLastRequestCompletion = Instant.now();
                WikiDataFetcherJob.this.inFlightRequest = false;
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        WikiDataFetcherJob.this.timeOfLastRequestCompletion = Instant.now();
                        WikiDataFetcherJob.this.inFlightRequest = false;
                        return;
                    }
                    try {
                        WikiDataFetcherJob.this.timeOfLastRequestCompletion = Instant.now();
                        WikiDataFetcherJob.this.inFlightRequest = false;
                        WikiRequest wikiRequest = (WikiRequest)WikiDataFetcherJob.this.plugin.gson.fromJson(responseBody.string(), WikiRequest.class);
                        WikiRequestWrapper wikiRequestWrapper = new WikiRequestWrapper(wikiRequest, WikiDataFetcherJob.this.getWikiDataSourceType());
                        WikiDataFetcherJob.this.subscribers.forEach(subscriber -> subscriber.accept(wikiRequestWrapper, WikiDataFetcherJob.this.timeOfLastRequestCompletion));
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

