/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.jobs;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.widgets.SlotActivityTimer;
import com.flippingutilities.utilities.AccountSlotsUpdate;
import com.flippingutilities.utilities.SlotState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.events.GrandExchangeOfferChanged;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSenderJob {
    private static final Logger log = LoggerFactory.getLogger(SlotSenderJob.class);
    FlippingPlugin plugin;
    ScheduledExecutorService executor;
    OkHttpClient httpClient;
    Future slotStateSenderTask;
    AccountSlotsUpdate previouslySentSlotUpdate;
    List<Consumer<Integer>> subscribers = new ArrayList<Consumer<Integer>>();
    public static int PERIOD = 10;
    public boolean justLoggedIn = false;

    public SlotSenderJob(FlippingPlugin plugin, OkHttpClient httpClient) {
        this.plugin = plugin;
        this.httpClient = httpClient;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void subscribe(Consumer<Integer> subscriber) {
        this.subscribers.add(subscriber);
    }

    public void start() {
        this.slotStateSenderTask = this.executor.scheduleAtFixedRate(this::sendSlots, 10L, PERIOD, TimeUnit.SECONDS);
        log.info("started slot sender job");
    }

    public void stop() {
        if (!this.slotStateSenderTask.isCancelled()) {
            this.slotStateSenderTask.cancel(true);
            log.info("shut down slot sender job");
        }
    }

    private void sendSlots() {
        if (!this.plugin.getApiAuthHandler().canCommunicateWithApi(this.plugin.getCurrentlyLoggedInAccount())) {
            return;
        }
        List<SlotState> currentSlotStates = this.getCurrentSlots();
        AccountSlotsUpdate accountSlotsUpdate = new AccountSlotsUpdate(this.plugin.getCurrentlyLoggedInAccount(), currentSlotStates);
        if (accountSlotsUpdate.equals(this.previouslySentSlotUpdate) && !this.justLoggedIn) {
            log.debug("no updates to slots since the last time I sent them, not sending any requests.");
            this.subscribers.forEach(subscriber -> subscriber.accept(0));
            return;
        }
        this.justLoggedIn = false;
        this.plugin.getApiRequestHandler().updateGeSlots(accountSlotsUpdate).whenComplete((response, exception) -> {
            if (exception != null) {
                log.debug("could not send slot update successfully", exception);
                this.subscribers.forEach(subscriber -> subscriber.accept(2));
            } else {
                this.previouslySentSlotUpdate = accountSlotsUpdate;
                this.subscribers.forEach(subscriber -> subscriber.accept(1));
                log.debug("sent slot update successfully!");
            }
        });
    }

    private List<SlotState> getCurrentSlots() {
        Map<Integer, OfferEvent> lastOfferEventForEachSlot = this.plugin.getDataHandler().getAccountData(this.plugin.getCurrentlyLoggedInAccount()).getLastOffers();
        List<SlotActivityTimer> slotActivityTimers = this.plugin.getDataHandler().getAccountData(this.plugin.getCurrentlyLoggedInAccount()).getSlotTimers();
        ArrayList<SlotState> slotStates = new ArrayList<SlotState>();
        for (int i = 0; i < 8; ++i) {
            GrandExchangeOffer grandExchangeOffer = this.plugin.getClient().getGrandExchangeOffers()[i];
            OfferEvent trueOfferInSlot = this.getOfferEventConstructedFromClient(i);
            if (lastOfferEventForEachSlot.containsKey(i)) {
                OfferEvent lastOfferEventForSlotTrackedByPlugin = lastOfferEventForEachSlot.get(i);
                lastOfferEventForSlotTrackedByPlugin.setListedPrice(grandExchangeOffer.getPrice());
                lastOfferEventForSlotTrackedByPlugin.setSpent(grandExchangeOffer.getSpent());
                if (i < slotActivityTimers.size()) {
                    lastOfferEventForSlotTrackedByPlugin.setBeforeLogin(slotActivityTimers.get((int)i).offerOccurredAtUnknownTime);
                    lastOfferEventForSlotTrackedByPlugin.setTradeStartedAt(slotActivityTimers.get((int)i).tradeStartTime);
                }
                if (lastOfferEventForSlotTrackedByPlugin.isDuplicate(trueOfferInSlot)) {
                    slotStates.add(SlotState.fromOfferEvent(lastOfferEventForSlotTrackedByPlugin));
                    continue;
                }
                trueOfferInSlot.setBeforeLogin(true);
                if (trueOfferInSlot.isCausedByEmptySlot()) {
                    slotStates.add(SlotState.createEmptySlot(i));
                    continue;
                }
                slotStates.add(SlotState.fromOfferEvent(trueOfferInSlot));
                continue;
            }
            if (trueOfferInSlot.isCausedByEmptySlot()) {
                slotStates.add(SlotState.createEmptySlot(i));
                continue;
            }
            slotStates.add(SlotState.fromOfferEvent(trueOfferInSlot));
        }
        return slotStates;
    }

    private OfferEvent getOfferEventConstructedFromClient(int slot) {
        GrandExchangeOffer clientOffer = this.plugin.getClient().getGrandExchangeOffers()[slot];
        GrandExchangeOfferChanged grandExchangeOfferChanged = new GrandExchangeOfferChanged();
        grandExchangeOfferChanged.setSlot(slot);
        grandExchangeOfferChanged.setOffer(clientOffer);
        return OfferEvent.fromGrandExchangeEvent(grandExchangeOfferChanged);
    }
}

