/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.db;

import com.flippingutilities.model.AccountData;
import com.flippingutilities.model.AccountWideData;
import com.flippingutilities.model.BackupCheckpoints;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.uiutilities.TimeFormatters;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.client.RuneLite;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradePersister {
    private static final Logger log = LoggerFactory.getLogger(TradePersister.class);
    Gson gson;
    public static final File PARENT_DIRECTORY = new File(RuneLite.RUNELITE_DIR, "flipping");
    public static final File OLD_FILE = new File(PARENT_DIRECTORY, "trades.json");

    public TradePersister(Gson gson) {
        this.gson = gson;
    }

    public static void setupFlippingFolder() throws IOException {
        if (!PARENT_DIRECTORY.exists()) {
            log.info("flipping directory doesn't exist yet so it's being created");
            if (!PARENT_DIRECTORY.mkdir()) {
                throw new IOException("unable to create parent directory!");
            }
        } else {
            log.info("flipping directory already exists so it's not being created");
            if (OLD_FILE.exists()) {
                OLD_FILE.delete();
            }
        }
    }

    public Map<String, AccountData> loadAllAccounts() {
        HashMap<String, AccountData> accountsData = new HashMap<String, AccountData>();
        for (File f : PARENT_DIRECTORY.listFiles()) {
            if (f.getName().equals("accountwide.json") || !f.getName().contains(".json") || f.getName().contains(".backup.json") || f.getName().contains(".special.json")) continue;
            String displayName = f.getName().split("\\.")[0];
            AccountData accountData = this.loadAccount(displayName);
            accountsData.put(displayName, accountData);
        }
        return accountsData;
    }

    public AccountData loadAccount(String displayName) {
        log.info("loading data for {}", (Object)displayName);
        try {
            File accountFile = new File(PARENT_DIRECTORY, displayName + ".json");
            AccountData accountData = this.loadFromFile(accountFile);
            if (accountData == null) {
                log.warn("data for {} is null for some reason. Will try loading from backup", (Object)displayName);
                accountData = this.loadAccountFromBackup(displayName);
            }
            return accountData;
        }
        catch (Exception e) {
            log.warn("Got exception {} while loading data for {}. Will try loading from backup", (Object)e, (Object)displayName);
            return this.loadAccountFromBackup(displayName);
        }
    }

    private AccountData loadAccountFromBackup(String displayName) {
        log.info("loading data for {} from backup", (Object)displayName);
        try {
            File accountFile = new File(PARENT_DIRECTORY, displayName + ".backup.json");
            if (!accountFile.exists()) {
                log.info("backup for {} does not exist, returning empty AccountData", (Object)displayName);
                return new AccountData();
            }
            AccountData accountData = this.loadFromFile(accountFile);
            if (accountData == null) {
                log.info("data loaded from backup for {} is null for some reason, returning an empty AccountData object", (Object)displayName);
                accountData = new AccountData();
            }
            return accountData;
        }
        catch (Exception e) {
            log.info("Couldn't load data for {} from backup due to {}", (Object)displayName, (Object)e);
            return new AccountData();
        }
    }

    private AccountData loadFromFile(File f) throws IOException {
        String accountDataJson = new String(Files.readAllBytes(f.toPath()));
        return (AccountData)this.gson.fromJson(accountDataJson, AccountData.class);
    }

    public AccountWideData loadAccountWideData() throws IOException {
        File accountFile = new File(PARENT_DIRECTORY, "accountwide.json");
        if (accountFile.exists()) {
            String accountWideDataJson = new String(Files.readAllBytes(accountFile.toPath()));
            Type type = new TypeToken<AccountWideData>(){}.getType();
            return (AccountWideData)this.gson.fromJson(accountWideDataJson, type);
        }
        return new AccountWideData();
    }

    public BackupCheckpoints fetchBackupCheckpoints() {
        try {
            log.info("Fetching backup checkpoints");
            File backupCheckpointsFile = new File(PARENT_DIRECTORY, "backupcheckpoints.special.json");
            if (backupCheckpointsFile.exists()) {
                String backupCheckpointsJson = new String(Files.readAllBytes(backupCheckpointsFile.toPath()));
                Type type = new TypeToken<BackupCheckpoints>(){}.getType();
                return (BackupCheckpoints)this.gson.fromJson(backupCheckpointsJson, type);
            }
            return new BackupCheckpoints();
        }
        catch (Exception e) {
            return new BackupCheckpoints();
        }
    }

    public void writeToFile(String displayName, Object data) throws IOException {
        log.info("Writing to file for {}", (Object)displayName);
        File accountFile = new File(PARENT_DIRECTORY, displayName + ".json");
        String json = this.gson.toJson(data);
        Files.write(accountFile.toPath(), json.getBytes(), new OpenOption[0]);
    }

    public static long lastModified(String fileName) {
        return new File(PARENT_DIRECTORY, fileName).lastModified();
    }

    public static void deleteFile(String fileName) {
        File accountFile = new File(PARENT_DIRECTORY, fileName);
        if (accountFile.exists()) {
            if (accountFile.delete()) {
                log.info("{} deleted", (Object)fileName);
            } else {
                log.info("unable to delete {}", (Object)fileName);
            }
        }
    }

    public static void exportToCsv(File file, List<FlippingItem> trades, String startOfIntervalName) throws IOException {
        FileWriter out = new FileWriter(file);
        CSVPrinter csvWriter = new CSVPrinter(out, CSVFormat.DEFAULT.withHeader("name", "date", "quantity", "price", "state").withCommentMarker('#').withHeaderComments("Displaying trades for selected time interval: " + startOfIntervalName));
        for (FlippingItem item : trades) {
            for (OfferEvent offer : item.getHistory().getCompressedOfferEvents()) {
                csvWriter.printRecord(item.getItemName(), TimeFormatters.formatInstantToDate(offer.getTime()), offer.getCurrentQuantityInTrade(), offer.getPrice(), offer.getState());
            }
            csvWriter.printComment(String.format("Total profit: %d", FlippingItem.getProfit(item.getHistory().getCompressedOfferEvents())));
            csvWriter.println();
        }
        csvWriter.close();
    }
}

