/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.model.AccountData;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.utilities.MathUtils;
import com.flippingutilities.utilities.PotionDose;
import com.flippingutilities.utilities.PotionGroup;
import com.flippingutilities.utilities.Recipe;
import com.flippingutilities.utilities.RecipeItem;
import com.flippingutilities.utilities.SORT;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeHandler {
    private static final Logger log = LoggerFactory.getLogger(RecipeHandler.class);
    private Gson gson;
    private final Optional<Map<Integer, List<Recipe>>> idToRecipes;
    private final Optional<Map<Integer, PotionGroup>> idToPotionGroup;
    private OkHttpClient httpClient;

    public RecipeHandler(Gson gson, OkHttpClient httpClient) {
        this.gson = gson;
        this.httpClient = httpClient;
        this.idToRecipes = this.getItemIdToRecipes(this.loadRecipes());
        this.idToPotionGroup = this.getItemIdToPotionGroup(this.loadPotionGroups());
        if (this.idToRecipes.isPresent()) {
            log.info("Successfully loaded recipes");
        }
    }

    public Optional<RecipeFlipGroup> findRecipeFlipGroup(List<RecipeFlipGroup> recipeFlipGroups, Recipe recipe) {
        return recipeFlipGroups.stream().filter(group -> group.getRecipe().equals(recipe)).findFirst();
    }

    public Map<String, PartialOffer> getOfferIdToPartialOffer(List<RecipeFlipGroup> recipeFlipGroups, int itemId) {
        HashMap<String, PartialOffer> offerIdToPartialOffer = new HashMap<String, PartialOffer>();
        for (RecipeFlipGroup recipeFlipGroup : recipeFlipGroups) {
            if (!recipeFlipGroup.isInGroup(itemId)) continue;
            recipeFlipGroup.getOfferIdToPartialOffer(itemId).forEach((offerId, partialOffer) -> {
                if (offerIdToPartialOffer.containsKey(offerId)) {
                    PartialOffer otherPartialOffer = (PartialOffer)offerIdToPartialOffer.get(offerId);
                    PartialOffer cumulativePartialOffer = otherPartialOffer.clone();
                    cumulativePartialOffer.amountConsumed += partialOffer.amountConsumed;
                    offerIdToPartialOffer.put((String)offerId, cumulativePartialOffer);
                } else {
                    offerIdToPartialOffer.put((String)offerId, (PartialOffer)partialOffer);
                }
            });
        }
        return offerIdToPartialOffer;
    }

    public List<RecipeFlipGroup> createAccountWideRecipeFlipGroupList(Collection<AccountData> allAccountData) {
        Map<Recipe, List<RecipeFlipGroup>> groupedItems = allAccountData.stream().flatMap(accountData -> accountData.getRecipeFlipGroups().stream()).map(RecipeFlipGroup::clone).collect(Collectors.groupingBy(RecipeFlipGroup::getRecipe));
        List<RecipeFlipGroup> mergedRecipeFlipGroups = groupedItems.values().stream().map(list -> list.stream().reduce(RecipeFlipGroup::merge)).filter(Optional::isPresent).map(Optional::get).sorted(Collections.reverseOrder(Comparator.comparing(RecipeFlipGroup::getLatestActivityTime))).collect(Collectors.toList());
        return mergedRecipeFlipGroups;
    }

    private boolean isInRegularRecipe(int itemId) {
        if (this.idToRecipes.isPresent()) {
            return this.idToRecipes.get().containsKey(itemId);
        }
        return false;
    }

    private boolean isInDecantRecipe(int itemId) {
        if (this.idToPotionGroup.isPresent()) {
            return this.idToPotionGroup.get().containsKey(itemId);
        }
        return false;
    }

    public Map<Integer, Optional<FlippingItem>> getItemsInRecipe(Recipe recipe, List<FlippingItem> items) {
        Set<Integer> ids = recipe.getIds();
        HashMap<Integer, Optional<FlippingItem>> itemIdToItems = new HashMap<Integer, Optional<FlippingItem>>();
        for (FlippingItem item : items) {
            if (!ids.contains(item.getItemId())) continue;
            itemIdToItems.put(item.getItemId(), Optional.of(item));
        }
        ids.forEach(id -> {
            if (!itemIdToItems.containsKey(id)) {
                itemIdToItems.put((Integer)id, Optional.empty());
            }
        });
        return itemIdToItems;
    }

    public List<Recipe> getApplicableRecipes(int itemId, boolean isBuy) {
        ArrayList<Recipe> applicableRecipes = new ArrayList<Recipe>();
        applicableRecipes.addAll(this.getApplicableDecantRecipes(itemId, isBuy));
        applicableRecipes.addAll(this.getApplicableRegularRecipes(itemId, isBuy));
        return applicableRecipes;
    }

    private List<Recipe> getApplicableRegularRecipes(int itemId, boolean isBuy) {
        if (!this.isInRegularRecipe(itemId)) {
            return new ArrayList<Recipe>();
        }
        ArrayList<Recipe> applicableRegularRecipes = new ArrayList<Recipe>();
        List<Recipe> recipesWithTheItem = this.idToRecipes.get().get(itemId);
        for (Recipe recipe : recipesWithTheItem) {
            boolean isItemInInputs = recipe.isInput(itemId);
            if (isBuy && isItemInInputs) {
                applicableRegularRecipes.add(recipe);
            }
            if (isBuy || isItemInInputs) continue;
            applicableRegularRecipes.add(recipe);
        }
        return applicableRegularRecipes;
    }

    private List<Recipe> getApplicableDecantRecipes(int itemId, boolean isBuy) {
        if (!this.isInDecantRecipe(itemId)) {
            return new ArrayList<Recipe>();
        }
        ArrayList<Recipe> applicableDecantRecipes = new ArrayList<Recipe>();
        PotionGroup potionGroup = this.idToPotionGroup.get().get(itemId);
        PotionDose sourceDose = potionGroup.getDoses().stream().filter(d -> d.getId() == itemId).findAny().get();
        List otherDoses = potionGroup.getDoses().stream().filter(d -> d.getId() != itemId).collect(Collectors.toList());
        for (PotionDose otherDose : otherDoses) {
            PotionDose inputDose = isBuy ? sourceDose : otherDose;
            PotionDose outputDose = isBuy ? otherDose : sourceDose;
            long lcm = MathUtils.lcm(sourceDose.getDose(), otherDose.getDose());
            RecipeItem inputDoseRecipeItem = new RecipeItem(inputDose.getId(), (int)(lcm / (long)inputDose.getDose()));
            RecipeItem outputDoseRecipeItem = new RecipeItem(outputDose.getId(), (int)(lcm / (long)outputDose.getDose()));
            String recipeName = String.format("Decanting %s (%d)->(%d)", potionGroup.getName(), inputDose.getDose(), outputDose.getDose());
            Recipe recipe = new Recipe(new ArrayList<RecipeItem>(Arrays.asList(inputDoseRecipeItem)), new ArrayList<RecipeItem>(Arrays.asList(outputDoseRecipeItem)), recipeName);
            applicableDecantRecipes.add(recipe);
        }
        return applicableDecantRecipes;
    }

    private Optional<Map<Integer, List<Recipe>>> getItemIdToRecipes(Optional<List<Recipe>> optionalRecipes) {
        if (!optionalRecipes.isPresent()) {
            return Optional.empty();
        }
        HashMap idToRecipes = new HashMap();
        List<Recipe> recipes = optionalRecipes.get();
        this.stripElementalRunesFromRecipes(recipes);
        recipes.forEach(r -> r.getIds().forEach(id -> {
            if (idToRecipes.containsKey(id)) {
                ((List)idToRecipes.get(id)).add(r);
            } else {
                idToRecipes.put(id, new ArrayList<Recipe>(Arrays.asList(r)));
            }
        }));
        return Optional.of(idToRecipes);
    }

    private void stripElementalRunesFromRecipes(List<Recipe> recipes) {
        HashSet<Integer> elementalRunes = new HashSet<Integer>(Arrays.asList(555, 557, 554, 556));
        for (Recipe recipe : recipes) {
            List<RecipeItem> inputs = recipe.getInputs();
            recipe.setInputs(inputs.stream().filter(input -> !elementalRunes.contains(input.getId())).collect(Collectors.toList()));
        }
    }

    private Optional<Map<Integer, PotionGroup>> getItemIdToPotionGroup(Optional<List<PotionGroup>> optionalPotionGroups) {
        if (!optionalPotionGroups.isPresent()) {
            return Optional.empty();
        }
        HashMap idToPotionGroup = new HashMap();
        List<PotionGroup> potionGroups = optionalPotionGroups.get();
        potionGroups.forEach(potionGroup -> potionGroup.getIds().forEach(id -> idToPotionGroup.put(id, potionGroup)));
        return Optional.of(idToPotionGroup);
    }

    public Map<Integer, Integer> getTargetValuesForMaxRecipeCount(Recipe recipe, Map<Integer, List<PartialOffer>> itemIdToPartialOffers, boolean useRemainingOffer) {
        Map<Integer, Integer> itemIdToQuantity = recipe.getItemIdToQuantity();
        Map<Integer, Integer> itemIdToMaxRecipesThatCanBeMade = this.getItemIdToMaxRecipesThatCanBeMade(recipe, itemIdToPartialOffers, useRemainingOffer);
        int lowestRecipeCountThatCanBeMade = itemIdToMaxRecipesThatCanBeMade.values().stream().min(Comparator.comparingInt(i -> i)).get();
        if (lowestRecipeCountThatCanBeMade == 0) {
            return itemIdToQuantity;
        }
        return itemIdToQuantity.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Integer, Integer>((Integer)e.getKey(), (Integer)e.getValue() * lowestRecipeCountThatCanBeMade)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<Integer, Integer> getItemIdToMaxRecipesThatCanBeMade(Recipe recipe, Map<Integer, List<PartialOffer>> itemIdToPartialOffers, boolean useRemainingOffer) {
        Map<Integer, Integer> itemIdToQuantity = recipe.getItemIdToQuantity();
        return itemIdToPartialOffers.entrySet().stream().map(e -> {
            int itemId = (Integer)e.getKey();
            if (itemId == 995) {
                return new AbstractMap.SimpleEntry<Integer, Integer>(itemId, Integer.MAX_VALUE);
            }
            long totalQuantity = ((List)e.getValue()).stream().mapToLong(po -> useRemainingOffer ? (long)(po.getOffer().getCurrentQuantityInTrade() - po.amountConsumed) : (long)po.amountConsumed).sum();
            long quantityNeededForRecipe = ((Integer)itemIdToQuantity.get(itemId)).intValue();
            int maxRecipesThatCanBeMade = (int)(totalQuantity / quantityNeededForRecipe);
            return new AbstractMap.SimpleEntry<Integer, Integer>(itemId, maxRecipesThatCanBeMade);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void addRecipeFlip(List<RecipeFlipGroup> recipeFlipGroups, RecipeFlip recipeFlip, Recipe recipe) {
        for (RecipeFlipGroup recipeFlipGroup : recipeFlipGroups) {
            if (!recipe.equals(recipeFlipGroup.getRecipe())) continue;
            recipeFlipGroup.addRecipeFlip(recipeFlip);
            return;
        }
        RecipeFlipGroup recipeFlipGroup = new RecipeFlipGroup(recipe);
        recipeFlipGroup.addRecipeFlip(recipeFlip);
        recipeFlipGroups.add(recipeFlipGroup);
    }

    public List<RecipeFlipGroup> sortRecipeFlipGroups(List<RecipeFlipGroup> items, SORT selectedSort, Instant startOfInterval) {
        ArrayList<RecipeFlipGroup> result = new ArrayList<RecipeFlipGroup>(items);
        if (selectedSort == null || result.isEmpty()) {
            return result;
        }
        switch (selectedSort) {
            case TIME: {
                result.sort(Comparator.comparing(RecipeFlipGroup::getLatestFlipTime));
                break;
            }
            case FLIP_COUNT: {
                result.sort(Comparator.comparing(group -> {
                    List<RecipeFlip> flips = group.getFlipsInInterval(startOfInterval);
                    return flips.stream().mapToInt(rf -> rf.getRecipeCountMade(group.getRecipe())).sum();
                }));
                break;
            }
            case TOTAL_PROFIT: {
                result.sort(Comparator.comparing(group -> {
                    List<RecipeFlip> flips = group.getFlipsInInterval(startOfInterval);
                    return flips.stream().mapToLong(RecipeFlip::getProfit).sum();
                }));
                break;
            }
            case PROFIT_EACH: {
                result.sort(Comparator.comparing(group -> {
                    List<RecipeFlip> flips = group.getFlipsInInterval(startOfInterval);
                    long totalProfit = flips.stream().mapToLong(RecipeFlip::getProfit).sum();
                    long totalRecipesMade = flips.stream().mapToInt(rf -> rf.getRecipeCountMade(group.getRecipe())).sum();
                    return totalProfit / totalRecipesMade;
                }));
                break;
            }
            case ROI: {
                result.sort(Comparator.comparing(group -> {
                    List<RecipeFlip> flips = group.getFlipsInInterval(startOfInterval);
                    long totalProfit = flips.stream().mapToLong(RecipeFlip::getProfit).sum();
                    long totalExpense = flips.stream().mapToLong(RecipeFlip::getExpense).sum();
                    return Float.valueOf((float)totalProfit / (float)totalExpense * 100.0f);
                }));
            }
        }
        Collections.reverse(result);
        return result;
    }

    public void deleteInvalidRecipeFlips(List<OfferEvent> offers, List<RecipeFlipGroup> recipeFlipGroups) {
        if (offers.isEmpty()) {
            return;
        }
        int itemId = offers.get(0).getItemId();
        recipeFlipGroups.stream().filter(rfg -> rfg.isInGroup(itemId)).forEach(rfg -> rfg.deleteFlipsWithDeletedOffers(offers));
    }

    private Optional<List<PotionGroup>> loadPotionGroups() {
        return this.makeRequest("https://raw.githubusercontent.com/Flipping-Utilities/osrs-datasets/master/potions.json", new TypeToken<List<PotionGroup>>(){});
    }

    private Optional<List<Recipe>> loadRecipes() {
        return this.makeRequest("https://raw.githubusercontent.com/Flipping-Utilities/osrs-datasets/master/recipes.json", new TypeToken<List<Recipe>>(){});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Optional<T> makeRequest(String url, TypeToken<T> typeToken) {
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error("Recipe fetch returned unsuccessful response: " + response);
                Optional optional = Optional.empty();
                return optional;
            }
            if (response.body() == null) {
                log.error("Recipe response body was null: " + response);
                Optional optional = Optional.empty();
                return optional;
            }
            Type type = typeToken.getType();
            Optional<Object> optional = Optional.of(this.gson.fromJson(response.body().string(), type));
            return optional;
        }
        catch (IOException e) {
            log.warn("IOException when trying to fetch recipes: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return Optional.empty();
        }
    }
}

