/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.Option;
import com.flippingutilities.utilities.InvalidOptionException;
import com.flippingutilities.utilities.WikiItemMargins;
import com.flippingutilities.utilities.WikiRequest;
import java.util.Optional;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.http.api.item.ItemStats;

public class OptionHandler {
    FlippingPlugin plugin;

    public OptionHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public int calculateOptionValue(Option option, Optional<FlippingItem> highlightedItem, int highlightedItemId) throws InvalidOptionException {
        String propertyString;
        int val = 0;
        switch (propertyString = option.getProperty()) {
            case "ge limit": {
                val = this.geLimitCalculation(highlightedItem, highlightedItemId);
                break;
            }
            case "rem limit": {
                val = this.remainingGeLimitCalculation(highlightedItem, highlightedItemId);
                break;
            }
            case "cashstack": {
                val = this.cashStackCalculation(highlightedItem, highlightedItemId);
                break;
            }
            case "insta sell": {
                val = this.instaSellCalculation(highlightedItem);
                break;
            }
            case "insta buy": {
                val = this.instaBuyCalculation(highlightedItem);
                break;
            }
            case "last buy": {
                val = this.latestBuyCalculation(highlightedItem);
                break;
            }
            case "last sell": {
                val = this.latestSellCalculation(highlightedItem);
                break;
            }
            case "wiki buy": {
                val = this.wikiPriceCalculation(highlightedItemId, true);
                break;
            }
            case "wiki sell": {
                val = this.wikiPriceCalculation(highlightedItemId, false);
            }
        }
        int finalValue = this.applyModifier(option.getModifier(), val);
        if (finalValue < 0) {
            throw new InvalidOptionException("resulting value was negative");
        }
        return finalValue;
    }

    private int wikiPriceCalculation(int itemId, boolean getBuyPrice) throws InvalidOptionException {
        if (this.plugin.getLastWikiRequestWrapper() != null) {
            int wikiPrice;
            WikiRequest wr = this.plugin.getLastWikiRequestWrapper().getWikiRequest();
            WikiItemMargins wikiItemMargins = wr.getData().get(itemId);
            int n = wikiPrice = getBuyPrice ? wikiItemMargins.getHigh() : wikiItemMargins.getLow();
            if (wikiPrice == 0) {
                throw new InvalidOptionException(String.format("no insta %s data for this item", getBuyPrice ? "buy" : "sell"));
            }
            return wikiPrice;
        }
        throw new InvalidOptionException("wiki request has not been made yet");
    }

    private int remainingGeLimitCalculation(Optional<FlippingItem> item, int itemId) throws InvalidOptionException {
        ItemStats itemStats = this.plugin.getItemManager().getItemStats(itemId, false);
        int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
        int totalGeLimit = item.map(FlippingItem::getTotalGELimit).orElse(geLimit);
        if (totalGeLimit <= 0) {
            throw new InvalidOptionException("Item does not have a known limit. Cannot calculate resulting value");
        }
        return item.map(FlippingItem::getRemainingGeLimit).orElse(geLimit);
    }

    private int geLimitCalculation(Optional<FlippingItem> item, int itemId) throws InvalidOptionException {
        ItemStats itemStats = this.plugin.getItemManager().getItemStats(itemId, false);
        int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
        int totalGeLimit = item.map(FlippingItem::getTotalGELimit).orElse(geLimit);
        if (totalGeLimit <= 0) {
            throw new InvalidOptionException("Item does not have a known limit. Cannot calculate resulting value");
        }
        return item.map(FlippingItem::getTotalGELimit).orElse(geLimit);
    }

    private int cashStackCalculation(Optional<FlippingItem> item, int itemId) throws InvalidOptionException {
        if (this.getCashStackInInv() == 0) {
            throw new InvalidOptionException("Player has no cash in inventory");
        }
        int offerPrice = this.plugin.getClient().getVarbitValue(4398);
        if (offerPrice <= 0) {
            throw new InvalidOptionException("Item offer price missing");
        }
        return this.getCashStackInInv() / offerPrice;
    }

    private int instaBuyCalculation(Optional<FlippingItem> item) throws InvalidOptionException {
        if (!item.isPresent()) {
            throw new InvalidOptionException("item was not bought or sold");
        }
        if (item.get().getLatestInstaBuy().isPresent()) {
            return item.get().getLatestInstaBuy().get().getPrice();
        }
        throw new InvalidOptionException("item does not have an insta buy price");
    }

    private int instaSellCalculation(Optional<FlippingItem> item) throws InvalidOptionException {
        if (!item.isPresent()) {
            throw new InvalidOptionException("item was not bought or sold");
        }
        if (item.get().getLatestInstaSell().isPresent()) {
            return item.get().getLatestInstaSell().get().getPreTaxPrice();
        }
        throw new InvalidOptionException("item does not have an insta sell price");
    }

    private int latestSellCalculation(Optional<FlippingItem> item) throws InvalidOptionException {
        if (!item.isPresent()) {
            throw new InvalidOptionException("item was not bought or sold");
        }
        if (item.get().getLatestSell().isPresent()) {
            return item.get().getLatestSell().get().getPreTaxPrice();
        }
        throw new InvalidOptionException("item does not have a sell");
    }

    private int latestBuyCalculation(Optional<FlippingItem> item) throws InvalidOptionException {
        if (!item.isPresent()) {
            throw new InvalidOptionException("item was not bought or sold");
        }
        if (item.get().getLatestBuy().isPresent()) {
            return item.get().getLatestBuy().get().getPrice();
        }
        throw new InvalidOptionException("item does not have a buy");
    }

    private int applyModifier(String modifier, int value) throws InvalidOptionException {
        if (modifier.length() < 2) {
            throw new InvalidOptionException("Modifier has to be one of +,-,*, followed by a positive number. Example: +2, -5, *9");
        }
        float num = 0.0f;
        try {
            num = Float.parseFloat(modifier.substring(1));
            if (num < 0.0f) {
                throw new InvalidOptionException("Modifier has to be one of +,-,*, followed by a positive number. Example: +2, -5, *9");
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionException("Modifier has to be one of +,-,*, followed by a positive number. Example: +2, -5, *9");
        }
        char operator = modifier.charAt(0);
        switch (operator) {
            case '-': {
                return Math.round((float)value - num);
            }
            case '+': {
                return Math.round((float)value + num);
            }
            case '*': {
                return Math.round((float)value * num);
            }
        }
        throw new InvalidOptionException("Modifier has to be one of +,-,*, followed by a positive number. Example: +2, -5, *9");
    }

    private int getCashStackInInv() {
        Item[] inventoryItems;
        ItemContainer inventory = this.plugin.getClient().getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            return 0;
        }
        for (Item item : inventoryItems = inventory.getItems()) {
            if (item.getId() != 995) continue;
            return item.getQuantity();
        }
        return 0;
    }
}

