/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.ui.widgets.SlotActivityTimer;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.runelite.api.WorldType;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewOfferEventPipelineHandler {
    private static final Logger log = LoggerFactory.getLogger(NewOfferEventPipelineHandler.class);
    FlippingPlugin plugin;

    NewOfferEventPipelineHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerChangedEvent) {
        EnumSet<WorldType> excludedWorldTypes;
        EnumSet currentWorldType = this.plugin.getClient().getWorldType();
        if (!Collections.disjoint(currentWorldType, excludedWorldTypes = EnumSet.of(WorldType.SEASONAL))) {
            return;
        }
        if (this.plugin.getCurrentlyLoggedInAccount() == null) {
            OfferEvent newOfferEvent = this.createOfferEvent(offerChangedEvent);
            newOfferEvent.setBeforeLogin(true);
            this.plugin.getEventsReceivedBeforeFullLogin().add(newOfferEvent);
            return;
        }
        OfferEvent newOfferEvent = this.createOfferEvent(offerChangedEvent);
        if (newOfferEvent.getTickArrivedAt() == this.plugin.getLoginTickCount()) {
            newOfferEvent.setBeforeLogin(true);
        }
        this.onNewOfferEvent(newOfferEvent);
    }

    public void onNewOfferEvent(OfferEvent newOfferEvent) {
        Optional<OfferEvent> screenedOfferEvent;
        String currentlyLoggedInAccount = this.plugin.getCurrentlyLoggedInAccount();
        if (currentlyLoggedInAccount != null) {
            newOfferEvent.setMadeBy(currentlyLoggedInAccount);
        }
        if (!(screenedOfferEvent = this.screenOfferEvent(newOfferEvent)).isPresent()) {
            return;
        }
        OfferEvent finalizedOfferEvent = screenedOfferEvent.get();
        List<FlippingItem> currentlyLoggedInAccountsTrades = this.plugin.getDataHandler().getAccountData(currentlyLoggedInAccount).getTrades();
        Optional<FlippingItem> flippingItem = currentlyLoggedInAccountsTrades.stream().filter(item -> item.getItemId() == finalizedOfferEvent.getItemId()).findFirst();
        this.updateTradesList(currentlyLoggedInAccountsTrades, flippingItem, finalizedOfferEvent.clone());
        this.plugin.setUpdateSinceLastItemAccountWideBuild(true);
        this.rebuildDisplayAfterOfferEvent(finalizedOfferEvent);
    }

    private void rebuildDisplayAfterOfferEvent(OfferEvent offerEvent) {
        if (!this.plugin.getAccountCurrentlyViewed().equals(this.plugin.getCurrentlyLoggedInAccount()) && !this.plugin.getAccountCurrentlyViewed().equals("Accountwide")) {
            return;
        }
        this.plugin.getFlippingPanel().onNewOfferEventRebuild(offerEvent);
        this.plugin.getStatPanel().rebuildItemsDisplay(this.plugin.viewItemsForCurrentView());
    }

    public Optional<OfferEvent> screenOfferEvent(OfferEvent newOfferEvent) {
        this.plugin.getSlotsPanel().update(newOfferEvent);
        Map<Integer, OfferEvent> lastOfferEventForEachSlot = this.plugin.getDataHandler().getAccountData(this.plugin.getCurrentlyLoggedInAccount()).getLastOffers();
        List<SlotActivityTimer> slotActivityTimers = this.plugin.getDataHandler().getAccountData(this.plugin.getCurrentlyLoggedInAccount()).getSlotTimers();
        OfferEvent lastOfferEvent = lastOfferEventForEachSlot.get(newOfferEvent.getSlot());
        if (newOfferEvent.isCausedByEmptySlot() && newOfferEvent.isBeforeLogin()) {
            return Optional.empty();
        }
        if (lastOfferEvent == null) {
            if (!newOfferEvent.isCausedByEmptySlot()) {
                lastOfferEventForEachSlot.put(newOfferEvent.getSlot(), newOfferEvent);
                slotActivityTimers.get(newOfferEvent.getSlot()).setCurrentOffer(newOfferEvent);
            }
            if (newOfferEvent.isStartOfOffer()) {
                newOfferEvent.setTradeStartedAt(Instant.now());
            }
            return Optional.empty();
        }
        if (lastOfferEvent.isDuplicate(newOfferEvent)) {
            return Optional.empty();
        }
        if (newOfferEvent.isCausedByEmptySlot()) {
            lastOfferEventForEachSlot.remove(newOfferEvent.getSlot());
            slotActivityTimers.get(newOfferEvent.getSlot()).reset();
            return Optional.empty();
        }
        if (newOfferEvent.isRedundantEventBeforeOfferCompletion()) {
            return Optional.empty();
        }
        newOfferEvent.setTicksSinceFirstOffer(lastOfferEvent);
        newOfferEvent.setTradeStartedAt(lastOfferEvent.getTradeStartedAt());
        lastOfferEventForEachSlot.put(newOfferEvent.getSlot(), newOfferEvent);
        slotActivityTimers.get(newOfferEvent.getSlot()).setCurrentOffer(newOfferEvent);
        return newOfferEvent.getCurrentQuantityInTrade() == 0 ? Optional.empty() : Optional.of(newOfferEvent);
    }

    private OfferEvent createOfferEvent(GrandExchangeOfferChanged newOfferEvent) {
        OfferEvent offer = OfferEvent.fromGrandExchangeEvent(newOfferEvent);
        offer.setTickArrivedAt(this.plugin.getClient().getTickCount());
        offer.setMadeBy(this.plugin.getCurrentlyLoggedInAccount());
        return offer;
    }

    private void updateTradesList(List<FlippingItem> trades, Optional<FlippingItem> flippingItem, OfferEvent newOffer) {
        if (flippingItem.isPresent()) {
            FlippingItem item = flippingItem.get();
            if (!item.getValidFlippingPanelItem().booleanValue()) {
                item.setValidFlippingPanelItem(true);
            }
            item.updateHistory(newOffer);
            item.updateLatestProperties(newOffer);
        } else {
            this.addToTradesList(trades, newOffer);
        }
    }

    private void addToTradesList(List<FlippingItem> tradesList, OfferEvent newOffer) {
        int tradeItemId = newOffer.getItemId();
        String itemName = this.plugin.getItemManager().getItemComposition(tradeItemId).getName();
        ItemStats itemStats = this.plugin.getItemManager().getItemStats(tradeItemId, false);
        int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
        FlippingItem flippingItem = new FlippingItem(tradeItemId, itemName, geLimit, this.plugin.getCurrentlyLoggedInAccount());
        flippingItem.setValidFlippingPanelItem(true);
        flippingItem.updateHistory(newOffer);
        flippingItem.updateLatestProperties(newOffer);
        tradesList.add(0, flippingItem);
    }
}

