/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.ui.flipping.FlippingPanel;
import com.flippingutilities.ui.offereditor.AbstractOfferEditorPanel;
import com.flippingutilities.ui.offereditor.OfferEditorContainerPanel;
import com.flippingutilities.ui.widgets.OfferEditor;
import com.flippingutilities.utilities.Constants;
import com.flippingutilities.utilities.WikiRequest;
import java.util.Optional;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameUiChangesHandler {
    private static final Logger log = LoggerFactory.getLogger(GameUiChangesHandler.class);
    private static final int GE_OFFER_INIT_STATE_CHILD_ID = 18;
    private static final int GE_HISTORY_TAB_WIDGET_ID = 149;
    FlippingPlugin plugin;
    boolean quantityOrPriceChatboxOpen;
    Optional<FlippingItem> highlightedItem = Optional.empty();
    int highlightedItemId;

    GameUiChangesHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public void onVarClientIntChanged(VarClientIntChanged event) {
        Client client = this.plugin.getClient();
        if (event.getIndex() == 5 && client.getVarcIntValue(5) == 14 && client.getWidget(10616882) != null) {
            this.plugin.getClientThread().invokeLater(() -> {
                Widget geSearchResultBox = client.getWidget(10616882);
                Widget child = geSearchResultBox.createChild(-1, 4);
                child.setTextColor(0x800000);
                child.setFontId(1446);
                child.setXPositionMode(1);
                child.setOriginalX(0);
                child.setYPositionMode(1);
                child.setOriginalY(-15);
                child.setOriginalHeight(20);
                child.setXTextAlignment(1);
                child.setYTextAlignment(1);
                child.setWidthMode(1);
                child.setText("Type a quick search code to see all favorited items with that code!");
                child.revalidate();
            });
        }
        if (this.quantityOrPriceChatboxOpen && event.getIndex() == 5 && client.getVarcIntValue(5) == 0) {
            this.quantityOrPriceChatboxOpen = false;
            return;
        }
        if (event.getIndex() != 5 || client.getWidget(10616873) == null || client.getVarcIntValue(5) != 7 || client.getWidget(30474265) == null) {
            return;
        }
        this.quantityOrPriceChatboxOpen = true;
        this.plugin.getClientThread().invokeLater(() -> {
            OfferEditor flippingWidget = new OfferEditor(client.getWidget(10616869), client);
            Optional<FlippingItem> selectedItem = this.plugin.viewItemsForCurrentView().stream().filter(item -> item.getItemId() == client.getVarpValue(1151)).findFirst();
            String chatInputText = client.getWidget(10616873).getText();
            String offerText = client.getWidget(30474265).getChild(18).getText();
            if (chatInputText.equals("How many do you wish to buy?")) {
                this.plugin.getFlippingPanel().getOfferEditorContainerPanel().selectQuantityEditor();
                if (!selectedItem.isPresent()) {
                    ItemStats itemStats = this.plugin.getItemManager().getItemStats(client.getVarpValue(1151), false);
                    int itemGELimit = itemStats != null ? itemStats.getGeLimit() : 0;
                    flippingWidget.showQuantityWidgets(itemGELimit);
                } else {
                    flippingWidget.showQuantityWidgets(selectedItem.get().getRemainingGeLimit());
                }
            } else if (chatInputText.equals("Set a price for each item:")) {
                this.plugin.getFlippingPanel().getOfferEditorContainerPanel().selectPriceEditor();
                WikiRequest wikiRequest = this.plugin.getLastWikiRequestWrapper().getWikiRequest();
                if (offerText.equals("Buy offer")) {
                    int instaSellPrice = 0;
                    int wikiInstaSellPrice = 0;
                    if (selectedItem.isPresent() && selectedItem.get().getLatestInstaSell().isPresent()) {
                        instaSellPrice = selectedItem.get().getLatestInstaSell().get().getPreTaxPrice();
                    }
                    if (wikiRequest != null && wikiRequest.getData().containsKey(this.highlightedItemId) && wikiRequest.getData().get(this.highlightedItemId).getLow() != 0) {
                        wikiInstaSellPrice = wikiRequest.getData().get(this.highlightedItemId).getLow();
                    }
                    flippingWidget.showInstaSellPrices(instaSellPrice, wikiInstaSellPrice);
                } else if (offerText.equals("Sell offer")) {
                    int instaBuyPrice = 0;
                    int wikiInstaBuyPrice = 0;
                    if (selectedItem.isPresent() && selectedItem.get().getLatestInstaBuy().isPresent()) {
                        instaBuyPrice = selectedItem.get().getLatestInstaBuy().get().getPrice();
                    }
                    if (wikiRequest != null && wikiRequest.getData().containsKey(this.highlightedItemId) && wikiRequest.getData().get(this.highlightedItemId).getHigh() != 0) {
                        wikiInstaBuyPrice = wikiRequest.getData().get(this.highlightedItemId).getHigh();
                    }
                    flippingWidget.showInstaBuyPrices(instaBuyPrice, wikiInstaBuyPrice);
                }
            }
        });
    }

    public void onVarbitChanged(VarbitChanged event) {
        Client client = this.plugin.getClient();
        if (event.getVarpId() == 375) {
            this.plugin.getSlotStateDrawer().hideQuickLookPanel();
            this.handleClickOrLeaveOffer();
            return;
        }
        FlippingPanel flippingPanel = this.plugin.getFlippingPanel();
        OfferEditorContainerPanel offerEditorContainerPanel = flippingPanel.getOfferEditorContainerPanel();
        if (event.getVarpId() == 1043 && offerEditorContainerPanel != null) {
            AbstractOfferEditorPanel quantityEditorPanel = offerEditorContainerPanel.quantityEditorPanel;
            quantityEditorPanel.rebuild(quantityEditorPanel.getOptions());
        }
        if (event.getVarpId() == 1151 && client.getVarpValue(1151) != -1 && client.getVarpValue(1151) != 0) {
            this.highlightOffer(this.plugin.getClient().getVarpValue(1151));
        }
        if (event.getVarpId() == 1151 && (client.getVarpValue(1151) == -1 || client.getVarpValue(1151) == 0) && this.highlightedItem.isPresent()) {
            this.deHighlightOffer();
        }
    }

    private void handleClickOrLeaveOffer() {
        Client client = this.plugin.getClient();
        int slot = client.getVarbitValue(4439) - 1;
        if (slot == -1 && this.highlightedItem.isPresent()) {
            this.deHighlightOffer();
            return;
        }
        if (slot != -1 && !this.highlightedItem.isPresent()) {
            int itemId = this.plugin.getClient().getGrandExchangeOffers()[slot].getItemId();
            if (itemId == 0) {
                return;
            }
            this.highlightOffer(itemId);
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 383) {
            this.plugin.showGeHistoryTabPanel();
        }
        if (event.getGroupId() == 465 || event.getGroupId() == 213) {
            this.plugin.getMasterPanel().selectPreviouslySelectedTab();
        }
        if (event.getGroupId() == 149 && this.highlightedItem.isPresent()) {
            this.deHighlightOffer();
        }
        if (event.getGroupId() == 149) {
            this.plugin.getSlotStateDrawer().hideQuickLookPanel();
        }
    }

    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 29) {
            this.plugin.getMasterPanel().selectPreviouslySelectedTab();
        }
        if (event.getScriptId() == 782 || event.getScriptId() == 804) {
            this.plugin.setWidgetsOnSlotStateDrawer();
        }
        if (event.getScriptId() == 804 && this.plugin.getConfig().slotTimersEnabled()) {
            this.plugin.setWidgetsOnSlotTimers();
        }
    }

    private void highlightOffer(int itemId) {
        this.highlightedItemId = itemId;
        Optional<FlippingItem> itemInHistory = this.plugin.viewItemsForCurrentView().stream().filter(item -> item.getItemId() == this.highlightedItemId).findFirst();
        if (itemInHistory.isPresent()) {
            this.highlightedItem = itemInHistory;
        } else {
            String itemName = this.plugin.getItemManager().getItemComposition(this.highlightedItemId).getName();
            ItemStats itemStats = this.plugin.getItemManager().getItemStats(this.highlightedItemId, false);
            int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
            FlippingItem dummyFlippingItem = new FlippingItem(this.highlightedItemId, itemName, geLimit, Constants.DUMMY_ITEM);
            dummyFlippingItem.setValidFlippingPanelItem(true);
            this.highlightedItem = Optional.of(dummyFlippingItem);
        }
        this.plugin.getFlippingPanel().highlightItem(this.highlightedItem.get());
    }

    private void deHighlightOffer() {
        this.highlightedItem = Optional.empty();
        this.plugin.getFlippingPanel().dehighlightItem();
    }
}

