/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.FlippingConfig;
import com.flippingutilities.controller.ApiAuthHandler;
import com.flippingutilities.controller.ApiRequestHandler;
import com.flippingutilities.controller.DataHandler;
import com.flippingutilities.controller.FlippingItemHandler;
import com.flippingutilities.controller.GameUiChangesHandler;
import com.flippingutilities.controller.NewOfferEventPipelineHandler;
import com.flippingutilities.controller.OptionHandler;
import com.flippingutilities.controller.RecipeHandler;
import com.flippingutilities.db.TradePersister;
import com.flippingutilities.jobs.CacheUpdaterJob;
import com.flippingutilities.jobs.SlotSenderJob;
import com.flippingutilities.jobs.WikiDataFetcherJob;
import com.flippingutilities.model.AccountData;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.Option;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.model.RecipeFlip;
import com.flippingutilities.model.RecipeFlipGroup;
import com.flippingutilities.ui.MasterPanel;
import com.flippingutilities.ui.flipping.FlippingPanel;
import com.flippingutilities.ui.gehistorytab.GeHistoryTabPanel;
import com.flippingutilities.ui.login.LoginPanel;
import com.flippingutilities.ui.settings.SettingsPanel;
import com.flippingutilities.ui.slots.SlotsPanel;
import com.flippingutilities.ui.statistics.StatsPanel;
import com.flippingutilities.ui.uiutilities.GeSpriteLoader;
import com.flippingutilities.ui.widgets.SlotActivityTimer;
import com.flippingutilities.ui.widgets.SlotStateDrawer;
import com.flippingutilities.utilities.GeHistoryTabExtractor;
import com.flippingutilities.utilities.InvalidOptionException;
import com.flippingutilities.utilities.Recipe;
import com.flippingutilities.utilities.SORT;
import com.flippingutilities.utilities.WikiRequestWrapper;
import com.google.common.primitives.Shorts;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.GrandExchangeSearched;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemStats;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Flipping Utilities", description="Provides utilities for GE flipping")
public class FlippingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FlippingPlugin.class);
    public static final String CONFIG_GROUP = "flipping";
    public static final String ACCOUNT_WIDE = "Accountwide";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ScheduledExecutorService executor;
    private ScheduledFuture generalRepeatingTasks;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    @Inject
    private ConfigManager configManager;
    @Inject
    private FlippingConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private OkHttpClient httpClient;
    private FlippingPanel flippingPanel;
    private StatsPanel statPanel;
    private SlotsPanel slotsPanel;
    private MasterPanel masterPanel;
    private GeHistoryTabPanel geHistoryTabPanel;
    private SettingsPanel settingsPanel;
    private LoginPanel loginPanel;
    private boolean previouslyLoggedIn;
    private String accountCurrentlyViewed = "Accountwide";
    private String currentlyLoggedInAccount;
    private List<OfferEvent> eventsReceivedBeforeFullLogin = new ArrayList<OfferEvent>();
    boolean updateSinceLastItemAccountWideBuild = true;
    boolean updateSinceLastRecipeFlipGroupAccountWideBuild = true;
    List<FlippingItem> prevBuiltAccountWideItemList;
    List<RecipeFlipGroup> prevBuildAccountWideRecipeFlipGroup;
    private CacheUpdaterJob cacheUpdaterJob;
    private WikiDataFetcherJob wikiDataFetcherJob;
    private SlotSenderJob slotStateSenderJob;
    private ScheduledFuture slotTimersTask;
    private Instant startUpTime = Instant.now();
    private int loginTickCount;
    private OptionHandler optionHandler;
    private DataHandler dataHandler;
    private GameUiChangesHandler gameUiChangesHandler;
    private NewOfferEventPipelineHandler newOfferEventPipelineHandler;
    private ApiAuthHandler apiAuthHandler;
    private ApiRequestHandler apiRequestHandler;
    private WikiRequestWrapper lastWikiRequestWrapper;
    private Instant timeOfLastWikiRequest;
    @Inject
    public Gson gson;
    public TradePersister tradePersister;
    private RecipeHandler recipeHandler;
    private FlippingItemHandler flippingItemHandler;
    private SlotStateDrawer slotStateDrawer;

    protected void startUp() {
        this.accountCurrentlyViewed = ACCOUNT_WIDE;
        this.tradePersister = new TradePersister(this.gson);
        this.recipeHandler = new RecipeHandler(this.gson, this.httpClient);
        this.flippingItemHandler = new FlippingItemHandler(this);
        this.optionHandler = new OptionHandler(this);
        this.dataHandler = new DataHandler(this);
        this.gameUiChangesHandler = new GameUiChangesHandler(this);
        this.newOfferEventPipelineHandler = new NewOfferEventPipelineHandler(this);
        this.apiAuthHandler = new ApiAuthHandler(this);
        this.apiRequestHandler = new ApiRequestHandler(this);
        this.slotStateDrawer = new SlotStateDrawer(this);
        this.flippingPanel = new FlippingPanel(this);
        this.statPanel = new StatsPanel(this);
        this.geHistoryTabPanel = new GeHistoryTabPanel(this);
        this.slotsPanel = new SlotsPanel(this, this.itemManager);
        this.loginPanel = new LoginPanel(this);
        this.masterPanel = new MasterPanel(this, this.flippingPanel, this.statPanel, this.slotsPanel, this.loginPanel);
        this.masterPanel.addView(this.geHistoryTabPanel, "ge history");
        this.navButton = NavigationButton.builder().tooltip("Flipping Utilities").icon(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/graph_icon_green.png")).priority(3).panel((PluginPanel)this.masterPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.keyManager.registerKeyListener(this.offerEditorKeyListener());
        this.clientThread.invokeLater(() -> {
            switch (this.client.getGameState()) {
                case STARTING: 
                case UNKNOWN: {
                    return false;
                }
            }
            this.dataHandler.loadData();
            this.masterPanel.setupAccSelectorDropdown(this.dataHandler.getCurrentAccounts());
            this.generalRepeatingTasks = this.setupRepeatingTasks(1000);
            this.startJobs();
            this.apiAuthHandler.subscribeToPremiumChecking(isPremium -> {
                if (isPremium.booleanValue()) {
                    WikiDataFetcherJob.requestInterval = 30;
                }
            });
            this.apiAuthHandler.checkExistingJwt().thenRun(() -> this.apiAuthHandler.setPremiumStatus());
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                log.info("user is already logged in when they downloaded/enabled the plugin");
                this.onLoggedInGameState();
            }
            GeSpriteLoader.setClientSpriteOverrides(this.client);
            return true;
        });
    }

    protected void shutDown() {
        log.info("shutdown running!");
        if (this.generalRepeatingTasks != null) {
            this.generalRepeatingTasks.cancel(true);
            this.generalRepeatingTasks = null;
        }
        if (this.slotTimersTask != null) {
            this.slotTimersTask.cancel(true);
            this.slotTimersTask = null;
        }
        this.masterPanel.dispose();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe(priority=101.0f)
    public void onClientShutdown(ClientShutdown clientShutdownEvent) {
        if (this.generalRepeatingTasks != null) {
            this.generalRepeatingTasks.cancel(true);
        }
        if (this.slotTimersTask != null) {
            this.slotTimersTask.cancel(true);
            this.slotTimersTask = null;
        }
        this.dataHandler.storeData();
        this.cacheUpdaterJob.stop();
        this.wikiDataFetcherJob.stop();
        this.slotStateSenderJob.stop();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.onLoggedInGameState();
        } else if (event.getGameState() == GameState.LOGIN_SCREEN && this.previouslyLoggedIn && this.currentlyLoggedInAccount != null && this.client.getGameState() != GameState.LOGGED_IN) {
            this.handleLogout();
        }
    }

    private void onLoggedInGameState() {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() != GameState.LOGGED_IN) {
                return true;
            }
            Player player = this.client.getLocalPlayer();
            if (player == null) {
                return false;
            }
            String name = player.getName();
            if (name == null) {
                return false;
            }
            if (name.equals("")) {
                return false;
            }
            this.previouslyLoggedIn = true;
            if (this.currentlyLoggedInAccount == null) {
                this.handleLogin(name);
            }
            return true;
        });
    }

    public void handleLogin(String displayName) {
        this.wikiDataFetcherJob.onWorldSwitch(this.client.getWorldType());
        if (this.client.getAccountType().isIronman()) {
            log.info("account is an ironman, not adding it to the cache");
            return;
        }
        log.info("{} has just logged in!", (Object)displayName);
        if (!this.dataHandler.getCurrentAccounts().contains(displayName)) {
            log.info("data handler does not contain data for {}", (Object)displayName);
            this.dataHandler.addAccount(displayName);
            this.masterPanel.getAccountSelector().addItem(displayName);
        }
        if (this.client.getWorldType().contains(WorldType.MEMBERS)) {
            this.dataHandler.viewAccountData(displayName).fixIncorrectItemNames(this.itemManager);
        }
        this.loginTickCount = this.client.getTickCount();
        this.currentlyLoggedInAccount = displayName;
        this.eventsReceivedBeforeFullLogin.forEach(this.newOfferEventPipelineHandler::onNewOfferEvent);
        this.eventsReceivedBeforeFullLogin.clear();
        if (this.dataHandler.getCurrentAccounts().size() > 1) {
            this.masterPanel.getAccountSelector().setVisible(true);
        }
        this.accountCurrentlyViewed = displayName;
        this.masterPanel.getAccountSelector().setSelectedItem(displayName);
        if (this.slotTimersTask == null && this.config.slotTimersEnabled()) {
            log.info("starting slot timers on login");
            this.slotTimersTask = this.startSlotTimers();
        }
        this.apiAuthHandler.checkRsn(displayName);
        this.slotStateSenderJob.justLoggedIn = true;
    }

    public void handleLogout() {
        log.info("{} is logging out", (Object)this.currentlyLoggedInAccount);
        this.dataHandler.getAccountData(this.currentlyLoggedInAccount).setLastSessionTimeUpdate(null);
        this.dataHandler.storeData();
        if (this.slotTimersTask != null && !this.slotTimersTask.isCancelled()) {
            log.info("cancelling slot timers task on logout");
            this.slotTimersTask.cancel(true);
        }
        this.slotTimersTask = null;
        this.currentlyLoggedInAccount = null;
        this.masterPanel.revertToSafeDisplay();
    }

    public ScheduledFuture setupRepeatingTasks(int msStartDelay) {
        return this.executor.scheduleAtFixedRate(() -> {
            try {
                this.flippingPanel.updateTimerDisplays();
                this.statPanel.updateTimeDisplay();
                this.updateSessionTime();
            }
            catch (ConcurrentModificationException e) {
                log.info("concurrent modification exception. This is fine, will just restart tasks after delay. Cancelling general repeating tasks and starting it again after 5000 ms delay");
                this.generalRepeatingTasks.cancel(true);
                this.generalRepeatingTasks = this.setupRepeatingTasks(5000);
            }
            catch (Exception e) {
                log.info("unknown exception in repeating tasks, error = {}, will cancel and restart them after 5 sec delay", (Throwable)e);
                this.generalRepeatingTasks.cancel(true);
                this.generalRepeatingTasks = this.setupRepeatingTasks(5000);
            }
        }, msStartDelay, 1000L, TimeUnit.MILLISECONDS);
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerChangedEvent) {
        this.newOfferEventPipelineHandler.onGrandExchangeOfferChanged(offerChangedEvent);
    }

    public List<FlippingItem> getItemsForCurrentView() {
        return this.accountCurrentlyViewed.equals(ACCOUNT_WIDE) ? this.createAccountWideFlippingItemList() : this.dataHandler.getAccountData(this.accountCurrentlyViewed).getTrades();
    }

    public List<FlippingItem> viewItemsForCurrentView() {
        return this.accountCurrentlyViewed.equals(ACCOUNT_WIDE) ? this.createAccountWideFlippingItemList() : this.dataHandler.viewAccountData(this.accountCurrentlyViewed).getTrades();
    }

    public List<RecipeFlipGroup> viewRecipeFlipGroupsForCurrentView() {
        return this.accountCurrentlyViewed.equals(ACCOUNT_WIDE) ? this.createAccountWideRecipeFlipGroupList() : this.dataHandler.viewAccountData(this.accountCurrentlyViewed).getRecipeFlipGroups();
    }

    public Duration viewAccumulatedTimeForCurrentView() {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            long millis = this.dataHandler.viewAllAccountData().stream().map(AccountData::getAccumulatedSessionTimeMillis).reduce(0L, (d1, d2) -> d1 + d2);
            return Duration.of(millis, ChronoUnit.MILLIS);
        }
        long millis = this.dataHandler.viewAccountData(this.accountCurrentlyViewed).getAccumulatedSessionTimeMillis();
        return Duration.of(millis, ChronoUnit.MILLIS);
    }

    public Instant viewStartOfSessionForCurrentView() {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            return this.startUpTime;
        }
        return this.dataHandler.viewAccountData(this.accountCurrentlyViewed).getSessionStartTime();
    }

    @Provides
    FlippingConfig provideConfig(ConfigManager configManager) {
        return (FlippingConfig)configManager.getConfig(FlippingConfig.class);
    }

    public void truncateTradeList() {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            this.dataHandler.getAllAccountData().forEach(accountData -> this.flippingItemHandler.deleteRemovedItems(accountData.getTrades()));
        } else {
            this.flippingItemHandler.deleteRemovedItems(this.getItemsForCurrentView());
        }
    }

    public void changeView(String selectedName) {
        log.info("changing view to {}", (Object)selectedName);
        this.accountCurrentlyViewed = selectedName;
        List<FlippingItem> itemsForCurrentView = this.viewItemsForCurrentView();
        this.statPanel.resetPaginators();
        this.flippingPanel.getPaginator().setPageNumber(1);
        this.statPanel.rebuildItemsDisplay(itemsForCurrentView);
        this.statPanel.rebuildRecipesDisplay(this.viewRecipeFlipGroupsForCurrentView());
        this.flippingPanel.rebuild(itemsForCurrentView);
    }

    private void startJobs() {
        this.cacheUpdaterJob = new CacheUpdaterJob();
        this.cacheUpdaterJob.subscribe(this::onDirectoryUpdate);
        this.cacheUpdaterJob.start();
        this.wikiDataFetcherJob = new WikiDataFetcherJob(this, this.httpClient);
        this.wikiDataFetcherJob.subscribe(this::onWikiFetch);
        this.wikiDataFetcherJob.start();
        this.slotStateSenderJob = new SlotSenderJob(this, this.httpClient);
        this.slotStateSenderJob.subscribe(success -> this.loginPanel.onSlotRequest((int)success));
        this.slotStateSenderJob.start();
    }

    private void onWikiFetch(WikiRequestWrapper wikiRequestWrapper, Instant timeOfRequestCompletion) {
        this.lastWikiRequestWrapper = wikiRequestWrapper;
        this.timeOfLastWikiRequest = timeOfRequestCompletion;
        this.flippingPanel.onWikiRequest(wikiRequestWrapper, timeOfRequestCompletion);
        this.slotStateDrawer.onWikiRequest(wikiRequestWrapper.getWikiRequest());
        this.slotsPanel.onWikiRequest(wikiRequestWrapper.getWikiRequest());
    }

    public void onDirectoryUpdate(String fileName) {
        if (!fileName.contains(".json") || fileName.contains(".backup.json") || fileName.contains(".special.json")) {
            return;
        }
        String displayNameOfChangedAcc = fileName.split("\\.")[0];
        if (displayNameOfChangedAcc.equals(this.dataHandler.thisClientLastStored)) {
            log.info("not reloading data for {} into the cache as this client was the last one to store it", (Object)displayNameOfChangedAcc);
            this.dataHandler.thisClientLastStored = null;
            return;
        }
        if (fileName.equals("accountwide.json")) {
            this.executor.schedule(() -> this.dataHandler.loadAccountWideData(), 1000L, TimeUnit.MILLISECONDS);
            return;
        }
        this.executor.schedule(() -> this.clientThread.invokeLater(() -> {
            log.info("second has passed, updating cache for {}", (Object)displayNameOfChangedAcc);
            this.dataHandler.loadAccountData(displayNameOfChangedAcc);
            if (!this.masterPanel.getViewSelectorItems().contains(displayNameOfChangedAcc)) {
                this.masterPanel.getAccountSelector().addItem(displayNameOfChangedAcc);
            }
            if (this.dataHandler.getCurrentAccounts().size() > 1) {
                this.masterPanel.getAccountSelector().setVisible(true);
            }
            this.updateSinceLastItemAccountWideBuild = true;
            if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE) || this.accountCurrentlyViewed.equals(displayNameOfChangedAcc)) {
                List<FlippingItem> tradesForCurrentView = this.viewItemsForCurrentView();
                this.flippingPanel.rebuild(tradesForCurrentView);
                this.statPanel.rebuildItemsDisplay(tradesForCurrentView);
                this.statPanel.rebuildRecipesDisplay(this.viewRecipeFlipGroupsForCurrentView());
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private List<RecipeFlipGroup> createAccountWideRecipeFlipGroupList() {
        if (!this.updateSinceLastRecipeFlipGroupAccountWideBuild) {
            return this.prevBuildAccountWideRecipeFlipGroup;
        }
        if (this.dataHandler.getCurrentAccounts().size() == 0) {
            return new ArrayList<RecipeFlipGroup>();
        }
        this.updateSinceLastRecipeFlipGroupAccountWideBuild = false;
        this.prevBuildAccountWideRecipeFlipGroup = this.recipeHandler.createAccountWideRecipeFlipGroupList(this.dataHandler.viewAllAccountData());
        return this.prevBuildAccountWideRecipeFlipGroup;
    }

    private List<FlippingItem> createAccountWideFlippingItemList() {
        if (!this.updateSinceLastItemAccountWideBuild) {
            return this.prevBuiltAccountWideItemList;
        }
        if (this.dataHandler.getCurrentAccounts().size() == 0) {
            return new ArrayList<FlippingItem>();
        }
        this.updateSinceLastItemAccountWideBuild = false;
        this.prevBuiltAccountWideItemList = this.flippingItemHandler.createAccountWideFlippingItemList(this.dataHandler.viewAllAccountData());
        return this.prevBuiltAccountWideItemList;
    }

    public List<FlippingItem> sortItems(List<FlippingItem> items, SORT sort, Instant startOfInterval) {
        return this.flippingItemHandler.sortItems(items, sort, startOfInterval);
    }

    public List<RecipeFlipGroup> sortRecipeFlipGroups(List<RecipeFlipGroup> recipeFlipGroups, SORT sort, Instant startOfInterval) {
        return this.recipeHandler.sortRecipeFlipGroups(recipeFlipGroups, sort, startOfInterval);
    }

    private boolean currentlyFlipping() {
        if (this.currentlyLoggedInAccount == null) {
            return false;
        }
        Collection<OfferEvent> lastOffers = this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getLastOffers().values();
        return lastOffers.stream().anyMatch(offerInfo -> !offerInfo.isComplete());
    }

    private void updateSessionTime() {
        if (this.currentlyFlipping()) {
            Instant lastSessionTimeUpdate = this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getLastSessionTimeUpdate();
            long accumulatedSessionTime = this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getAccumulatedSessionTimeMillis();
            if (lastSessionTimeUpdate == null) {
                lastSessionTimeUpdate = Instant.now();
            }
            long millisSinceLastSessionTimeUpdate = Instant.now().toEpochMilli() - lastSessionTimeUpdate.toEpochMilli();
            lastSessionTimeUpdate = Instant.now();
            this.dataHandler.getAccountData(this.currentlyLoggedInAccount).setAccumulatedSessionTimeMillis(accumulatedSessionTime += millisSinceLastSessionTimeUpdate);
            this.dataHandler.getAccountData(this.currentlyLoggedInAccount).setLastSessionTimeUpdate(lastSessionTimeUpdate);
            if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE) || this.accountCurrentlyViewed.equals(this.currentlyLoggedInAccount)) {
                this.statPanel.updateSessionTimeDisplay(this.viewAccumulatedTimeForCurrentView());
            }
        } else if (this.currentlyLoggedInAccount != null) {
            this.dataHandler.getAccountData(this.currentlyLoggedInAccount).setLastSessionTimeUpdate(null);
        }
    }

    public void setWidgetsOnSlotStateDrawer() {
        Widget slotWidgets = this.client.getWidget(465, 5);
        if (slotWidgets != null) {
            this.slotStateDrawer.setSlotWidgets(slotWidgets.getStaticChildren());
        }
    }

    public void setWidgetsOnSlotTimers() {
        for (int slotIndex = 0; slotIndex < 8; ++slotIndex) {
            SlotActivityTimer timer = this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getSlotTimers().get(slotIndex);
            Widget offerSlot = this.client.getWidget(465, 5).getStaticChildren()[slotIndex + 1];
            if (offerSlot == null) {
                return;
            }
            if (timer.getSlotWidget() == null) {
                timer.setWidget(offerSlot);
            }
            this.clientThread.invokeLater(timer::updateTimerDisplay);
        }
    }

    public void setFavoriteOnAllAccounts(FlippingItem item, boolean favoriteStatus) {
        for (String accountName : this.dataHandler.getCurrentAccounts()) {
            AccountData account = this.dataHandler.viewAccountData(accountName);
            account.getTrades().stream().filter(accountItem -> accountItem.getItemId() == item.getItemId()).findFirst().ifPresent(accountItem -> {
                accountItem.setFavorite(favoriteStatus);
                this.markAccountTradesAsHavingChanged(accountName);
            });
        }
    }

    public void setFavoriteCodeOnAllAccounts(FlippingItem item, String favoriteCode) {
        for (String accountName : this.dataHandler.getCurrentAccounts()) {
            AccountData account = this.dataHandler.viewAccountData(accountName);
            account.getTrades().stream().filter(accountItem -> accountItem.getItemId() == item.getItemId()).findFirst().ifPresent(accountItem -> {
                accountItem.setFavoriteCode(favoriteCode);
                this.markAccountTradesAsHavingChanged(accountName);
            });
        }
    }

    public void addSelectedGeTabOffers(List<OfferEvent> selectedOffers) {
        for (OfferEvent offerEvent : selectedOffers) {
            this.addSelectedGeTabOffer(offerEvent);
        }
        this.executor.schedule(() -> {
            this.flippingPanel.rebuild(this.viewItemsForCurrentView());
            this.statPanel.rebuildItemsDisplay(this.viewItemsForCurrentView());
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private void addSelectedGeTabOffer(OfferEvent selectedOffer) {
        if (this.currentlyLoggedInAccount == null) {
            return;
        }
        Optional<FlippingItem> flippingItem = this.dataHandler.getAccountData(this.currentlyLoggedInAccount).getTrades().stream().filter(item -> item.getItemId() == selectedOffer.getItemId()).findFirst();
        if (flippingItem.isPresent()) {
            flippingItem.get().updateHistory(selectedOffer);
            flippingItem.get().updateLatestProperties(selectedOffer);
            flippingItem.get().setValidFlippingPanelItem(true);
        } else {
            int tradeItemId = selectedOffer.getItemId();
            FlippingItem item2 = new FlippingItem(tradeItemId, "", -1, this.currentlyLoggedInAccount);
            item2.setValidFlippingPanelItem(true);
            item2.updateLatestProperties(selectedOffer);
            item2.updateHistory(selectedOffer);
            this.dataHandler.getAccountData(this.currentlyLoggedInAccount).getTrades().add(0, item2);
            this.clientThread.invokeLater(() -> {
                String itemName = this.itemManager.getItemComposition(tradeItemId).getName();
                ItemStats itemStats = this.itemManager.getItemStats(tradeItemId, false);
                int geLimit = itemStats != null ? itemStats.getGeLimit() : 0;
                item2.setItemName(itemName);
                item2.setTotalGELimit(geLimit);
            });
        }
    }

    public void showGeHistoryTabPanel() {
        this.clientThread.invokeLater(() -> {
            Widget[] geHistoryTabWidgets = this.client.getWidget(383, 3).getDynamicChildren();
            List<OfferEvent> offerEvents = GeHistoryTabExtractor.convertWidgetsToOfferEvents(geHistoryTabWidgets);
            ArrayList<List<OfferEvent>> matchingOffers = new ArrayList<List<OfferEvent>>();
            offerEvents.forEach(o -> {
                o.setItemName(this.itemManager.getItemComposition(o.getItemId()).getName());
                o.setMadeBy(this.getCurrentlyLoggedInAccount());
                matchingOffers.add(this.findOfferMatches((OfferEvent)o, 5));
            });
            this.geHistoryTabPanel.rebuild(offerEvents, matchingOffers, geHistoryTabWidgets, false);
            this.masterPanel.showView("ge history");
        });
    }

    public List<OfferEvent> findOfferMatches(OfferEvent offerEvent, int limit) {
        Optional<FlippingItem> flippingItem = this.dataHandler.getAccountData(this.currentlyLoggedInAccount).getTrades().stream().filter(item -> item.getItemId() == offerEvent.getItemId()).findFirst();
        if (!flippingItem.isPresent()) {
            return new ArrayList<OfferEvent>();
        }
        return flippingItem.get().getOfferMatches(offerEvent, limit);
    }

    public Font getFont() {
        return FontManager.getRunescapeSmallFont();
    }

    public void deleteOffers(Instant startOfInterval) {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            for (AccountData accountData : this.dataHandler.getAllAccountData()) {
                accountData.getTrades().forEach(item -> this.deleteOffers((List<OfferEvent>)item.getIntervalHistory(startOfInterval), (FlippingItem)item));
            }
        } else {
            this.getItemsForCurrentView().forEach(item -> this.deleteOffers((List<OfferEvent>)item.getIntervalHistory(startOfInterval), (FlippingItem)item));
        }
        this.updateSinceLastItemAccountWideBuild = true;
        this.updateSinceLastRecipeFlipGroupAccountWideBuild = true;
        this.truncateTradeList();
    }

    public void deleteOffers(List<OfferEvent> offers, FlippingItem item) {
        this.deleteOffers(offers, this.viewRecipeFlipGroupsForCurrentView(), item);
    }

    private void deleteOffers(List<OfferEvent> offers, List<RecipeFlipGroup> recipeFlipGroups, FlippingItem item) {
        item.deleteOffers(offers);
        this.recipeHandler.deleteInvalidRecipeFlips(offers, recipeFlipGroups);
        this.markAccountTradesAsHavingChanged(this.accountCurrentlyViewed);
        this.updateSinceLastItemAccountWideBuild = true;
        this.updateSinceLastRecipeFlipGroupAccountWideBuild = true;
    }

    public void setAllFlippingItemsAsHidden() {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            for (AccountData accountData : this.dataHandler.getAllAccountData()) {
                accountData.getTrades().forEach(item -> item.setValidFlippingPanelItem(false));
            }
        } else {
            this.getItemsForCurrentView().forEach(flippingItem -> flippingItem.setValidFlippingPanelItem(false));
        }
        this.updateSinceLastItemAccountWideBuild = true;
        this.truncateTradeList();
    }

    public void exportToCsv(File parentDirectory, Instant startOfInterval, String startOfIntervalName) throws IOException {
        if (parentDirectory.equals(TradePersister.PARENT_DIRECTORY)) {
            throw new RuntimeException("Cannot save csv file in the flipping directory, pick another directory");
        }
        ArrayList<FlippingItem> items = new ArrayList<FlippingItem>();
        for (FlippingItem item : this.viewItemsForCurrentView()) {
            ArrayList<OfferEvent> offersInInterval = item.getIntervalHistory(startOfInterval);
            if (offersInInterval.isEmpty()) continue;
            FlippingItem itemWithOnlySelectedIntervalHistory = new FlippingItem(item.getItemId(), item.getItemName(), item.getTotalGELimit(), item.getFlippedBy());
            itemWithOnlySelectedIntervalHistory.getHistory().setCompressedOfferEvents(offersInInterval);
            items.add(itemWithOnlySelectedIntervalHistory);
        }
        TradePersister.exportToCsv(new File(parentDirectory, this.accountCurrentlyViewed + ".csv"), items, startOfIntervalName);
    }

    public int calculateOptionValue(Option option) throws InvalidOptionException {
        return this.optionHandler.calculateOptionValue(option, this.gameUiChangesHandler.highlightedItem, this.gameUiChangesHandler.highlightedItemId);
    }

    public void markAccountTradesAsHavingChanged(String displayName) {
        this.dataHandler.markDataAsHavingChanged(displayName);
    }

    public Set<String> getCurrentDisplayNames() {
        return this.dataHandler.getCurrentAccounts();
    }

    private KeyListener offerEditorKeyListener() {
        return new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (FlippingPlugin.this.gameUiChangesHandler.quantityOrPriceChatboxOpen && FlippingPlugin.this.gameUiChangesHandler.highlightedItem.isPresent()) {
                    String keyPressed = KeyEvent.getKeyText(e.getKeyCode()).toLowerCase();
                    if (FlippingPlugin.this.flippingPanel.getOfferEditorContainerPanel() == null) {
                        return;
                    }
                    boolean currentlyViewingQuantityEditor = FlippingPlugin.this.flippingPanel.getOfferEditorContainerPanel().currentlyViewingQuantityEditor();
                    Optional<Option> optionExercised = FlippingPlugin.this.dataHandler.viewAccountWideData().getOptions().stream().filter(option -> option.isQuantityOption() == currentlyViewingQuantityEditor && option.getKey().equals(keyPressed)).findFirst();
                    optionExercised.ifPresent(option -> FlippingPlugin.this.clientThread.invoke(() -> {
                        try {
                            int optionValue = FlippingPlugin.this.calculateOptionValue((Option)option);
                            FlippingPlugin.this.client.getWidget(0xA2002A).setText(optionValue + "*");
                            FlippingPlugin.this.client.setVarcStrValue(359, String.valueOf(optionValue));
                            FlippingPlugin.this.flippingPanel.getOfferEditorContainerPanel().highlightPressedOption(keyPressed);
                            e.consume();
                        }
                        catch (InvalidOptionException optionValue) {
                        }
                        catch (Exception ex) {
                            log.info("exception during key press for offer editor", (Throwable)ex);
                        }
                    }));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
    }

    public void deleteAccount(String displayName) {
        this.dataHandler.deleteAccount(displayName);
        if (this.accountCurrentlyViewed.equals(displayName)) {
            this.masterPanel.getAccountSelector().setSelectedItem(this.dataHandler.getCurrentAccounts().toArray()[0]);
        }
        if (this.dataHandler.getCurrentAccounts().size() < 2) {
            this.masterPanel.getAccountSelector().setVisible(false);
        }
        this.masterPanel.getAccountSelector().removeItem(displayName);
    }

    private ScheduledFuture startSlotTimers() {
        return this.executor.scheduleAtFixedRate(() -> this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getSlotTimers().forEach(slotWidgetTimer -> this.clientThread.invokeLater(() -> {
            try {
                this.slotsPanel.updateTimerDisplays(slotWidgetTimer.getSlotIndex(), slotWidgetTimer.createFormattedTimeString());
                slotWidgetTimer.updateTimerDisplay();
            }
            catch (Exception e) {
                log.error("exception when trying to update timer", (Throwable)e);
            }
        })), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public Map<Integer, Optional<FlippingItem>> getItemsInRecipe(Recipe recipe) {
        return this.recipeHandler.getItemsInRecipe(recipe, this.getItemsForCurrentView());
    }

    public List<Recipe> getApplicableRecipes(int parentId, boolean isBuy) {
        return this.recipeHandler.getApplicableRecipes(parentId, isBuy);
    }

    public Map<Integer, Integer> getTargetValuesForMaxRecipeCount(Recipe recipe, Map<Integer, List<PartialOffer>> itemIdToPartialOffers, boolean useRemainingOffer) {
        return this.recipeHandler.getTargetValuesForMaxRecipeCount(recipe, itemIdToPartialOffers, useRemainingOffer);
    }

    public Map<Integer, Integer> getItemIdToMaxRecipesThatCanBeMade(Recipe recipe, Map<Integer, List<PartialOffer>> itemIdToPartialOffers, boolean useRemainingOffer) {
        return this.recipeHandler.getItemIdToMaxRecipesThatCanBeMade(recipe, itemIdToPartialOffers, useRemainingOffer);
    }

    public Map<String, PartialOffer> getOfferIdToPartialOffer(int itemId) {
        return this.recipeHandler.getOfferIdToPartialOffer(this.viewRecipeFlipGroupsForCurrentView(), itemId);
    }

    public void addRecipeFlip(RecipeFlip recipeFlip, Recipe recipe) {
        AccountData account = this.dataHandler.getAccountData(this.accountCurrentlyViewed);
        this.recipeHandler.addRecipeFlip(account.getRecipeFlipGroups(), recipeFlip, recipe);
        this.updateSinceLastRecipeFlipGroupAccountWideBuild = true;
    }

    public void addFavoritedItem(FlippingItem flippingItem) {
        if (this.accountCurrentlyViewed.equals(ACCOUNT_WIDE)) {
            for (String accountName : this.dataHandler.getCurrentAccounts()) {
                this.addFavoritedItem(flippingItem, accountName);
            }
        } else {
            this.addFavoritedItem(flippingItem, this.accountCurrentlyViewed);
        }
    }

    private void addFavoritedItem(FlippingItem flippingItem, String accountName) {
        List<FlippingItem> items = this.dataHandler.getAccountData(accountName).getTrades();
        Optional<FlippingItem> existingItem = items.stream().filter(item -> item.getItemId() == flippingItem.getItemId()).findFirst();
        if (existingItem.isPresent()) {
            existingItem.get().setFavorite(true);
        } else {
            flippingItem.setFlippedBy(accountName);
            items.add(0, flippingItem);
            this.markAccountTradesAsHavingChanged(accountName);
            this.updateSinceLastItemAccountWideBuild = true;
        }
    }

    public void toggleEnhancedSlots(boolean shouldEnhance) {
        this.dataHandler.getAccountWideData().setEnhancedSlots(shouldEnhance);
        this.dataHandler.markDataAsHavingChanged(ACCOUNT_WIDE);
        if (shouldEnhance) {
            this.slotStateDrawer.drawWrapper();
        } else {
            this.getClientThread().invokeLater(() -> this.slotStateDrawer.resetAllSlots());
        }
    }

    public boolean shouldEnhanceSlots() {
        return this.dataHandler.getAccountWideData().isEnhancedSlots();
    }

    @Subscribe
    public void onGrandExchangeSearched(GrandExchangeSearched event) {
        String input = this.client.getVarcStrValue(359);
        Set ids = this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getTrades().stream().filter(item -> item.isFavorite() && input.equals(item.getFavoriteCode())).map(FlippingItem::getItemId).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return;
        }
        this.client.setGeSearchResultIndex(0);
        this.client.setGeSearchResultCount(ids.size());
        this.client.setGeSearchResultIds(Shorts.toArray(ids));
        event.consume();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        this.gameUiChangesHandler.onScriptPostFired(event);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.gameUiChangesHandler.onWidgetLoaded(event);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.gameUiChangesHandler.onVarbitChanged(event);
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged event) {
        this.gameUiChangesHandler.onVarClientIntChanged(event);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (event.getKey().equals("slotTimersEnabled")) {
                if (this.config.slotTimersEnabled()) {
                    this.slotTimersTask = this.startSlotTimers();
                } else {
                    if (this.slotTimersTask != null) {
                        this.slotTimersTask.cancel(true);
                    }
                    this.dataHandler.viewAccountData(this.currentlyLoggedInAccount).getSlotTimers().forEach(SlotActivityTimer::resetToDefault);
                }
            }
            this.statPanel.rebuildItemsDisplay(this.viewItemsForCurrentView());
            this.flippingPanel.rebuild(this.viewItemsForCurrentView());
        }
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public FlippingConfig getConfig() {
        return this.config;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public FlippingPanel getFlippingPanel() {
        return this.flippingPanel;
    }

    public StatsPanel getStatPanel() {
        return this.statPanel;
    }

    public SlotsPanel getSlotsPanel() {
        return this.slotsPanel;
    }

    public MasterPanel getMasterPanel() {
        return this.masterPanel;
    }

    public GeHistoryTabPanel getGeHistoryTabPanel() {
        return this.geHistoryTabPanel;
    }

    public String getAccountCurrentlyViewed() {
        return this.accountCurrentlyViewed;
    }

    public String getCurrentlyLoggedInAccount() {
        return this.currentlyLoggedInAccount;
    }

    public void setCurrentlyLoggedInAccount(String currentlyLoggedInAccount) {
        this.currentlyLoggedInAccount = currentlyLoggedInAccount;
    }

    public List<OfferEvent> getEventsReceivedBeforeFullLogin() {
        return this.eventsReceivedBeforeFullLogin;
    }

    public void setUpdateSinceLastItemAccountWideBuild(boolean updateSinceLastItemAccountWideBuild) {
        this.updateSinceLastItemAccountWideBuild = updateSinceLastItemAccountWideBuild;
    }

    public void setUpdateSinceLastRecipeFlipGroupAccountWideBuild(boolean updateSinceLastRecipeFlipGroupAccountWideBuild) {
        this.updateSinceLastRecipeFlipGroupAccountWideBuild = updateSinceLastRecipeFlipGroupAccountWideBuild;
    }

    public int getLoginTickCount() {
        return this.loginTickCount;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public ApiAuthHandler getApiAuthHandler() {
        return this.apiAuthHandler;
    }

    public ApiRequestHandler getApiRequestHandler() {
        return this.apiRequestHandler;
    }

    public WikiRequestWrapper getLastWikiRequestWrapper() {
        return this.lastWikiRequestWrapper;
    }

    public Instant getTimeOfLastWikiRequest() {
        return this.timeOfLastWikiRequest;
    }

    public SlotStateDrawer getSlotStateDrawer() {
        return this.slotStateDrawer;
    }
}

