/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.model.AccountData;
import com.flippingutilities.model.FlippingItem;
import com.flippingutilities.model.OfferEvent;
import com.flippingutilities.model.PartialOffer;
import com.flippingutilities.utilities.SORT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FlippingItemHandler {
    FlippingPlugin plugin;

    FlippingItemHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public List<FlippingItem> sortItems(List<FlippingItem> items, SORT selectedSort, Instant startOfInterval) {
        ArrayList<FlippingItem> result = new ArrayList<FlippingItem>(items);
        if (selectedSort == null || result.isEmpty()) {
            return result;
        }
        switch (selectedSort) {
            case TIME: {
                result.sort(Comparator.comparing(FlippingItem::getLatestActivityTime));
                break;
            }
            case TOTAL_PROFIT: {
                result.sort(Comparator.comparing(item -> {
                    Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer(item.getItemId());
                    ArrayList<OfferEvent> intervalHistory = item.getIntervalHistory(startOfInterval);
                    List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(intervalHistory, offerIdToPartialOffer);
                    return FlippingItem.getProfit(adjustedOffers);
                }));
                break;
            }
            case PROFIT_EACH: {
                result.sort(Comparator.comparing(item -> {
                    Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer(item.getItemId());
                    ArrayList<OfferEvent> intervalHistory = item.getIntervalHistory(startOfInterval);
                    List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(intervalHistory, offerIdToPartialOffer);
                    long quantity = FlippingItem.countFlipQuantity(adjustedOffers);
                    if (quantity == 0L) {
                        return Long.MIN_VALUE;
                    }
                    long profit = FlippingItem.getProfit(adjustedOffers);
                    return profit / quantity;
                }));
                break;
            }
            case ROI: {
                result.sort(Comparator.comparing(item -> {
                    Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer(item.getItemId());
                    ArrayList<OfferEvent> intervalHistory = item.getIntervalHistory(startOfInterval);
                    List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(intervalHistory, offerIdToPartialOffer);
                    long profit = FlippingItem.getProfit(adjustedOffers);
                    long expense = FlippingItem.getValueOfMatchedOffers(adjustedOffers, true);
                    if (expense == 0L) {
                        return Float.valueOf(Float.MIN_VALUE);
                    }
                    return Float.valueOf((float)profit / (float)expense * 100.0f);
                }));
                break;
            }
            case FLIP_COUNT: {
                result.sort(Comparator.comparing(item -> {
                    Map<String, PartialOffer> offerIdToPartialOffer = this.plugin.getOfferIdToPartialOffer(item.getItemId());
                    ArrayList<OfferEvent> intervalHistory = item.getIntervalHistory(startOfInterval);
                    List<OfferEvent> adjustedOffers = FlippingItem.getPartialOfferAdjustedView(intervalHistory, offerIdToPartialOffer);
                    return FlippingItem.countFlipQuantity(adjustedOffers);
                }));
            }
        }
        Collections.reverse(result);
        return result;
    }

    public void deleteRemovedItems(List<FlippingItem> currItems) {
        currItems.removeIf(item -> {
            if (item.getGeLimitResetTime() != null) {
                Instant startOfRefresh = item.getGeLimitResetTime().minus(4L, ChronoUnit.HOURS);
                return item.getValidFlippingPanelItem() == false && !item.hasValidOffers() && (!Instant.now().isAfter(item.getGeLimitResetTime()) || item.getGeLimitResetTime().isBefore(startOfRefresh));
            }
            return item.getValidFlippingPanelItem() == false && !item.hasValidOffers();
        });
    }

    List<FlippingItem> createAccountWideFlippingItemList(Collection<AccountData> allAccountData) {
        Map<Integer, List<FlippingItem>> groupedItems = allAccountData.stream().flatMap(accountData -> accountData.getTrades().stream()).map(FlippingItem::clone).collect(Collectors.groupingBy(FlippingItem::getItemId));
        List<FlippingItem> mergedItems = groupedItems.values().stream().map(list -> list.stream().reduce(FlippingItem::merge)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        mergedItems.sort(Collections.reverseOrder(Comparator.comparing(FlippingItem::getLatestActivityTime)));
        return mergedItems;
    }
}

