/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.db.TradePersister;
import com.flippingutilities.model.AccountData;
import com.flippingutilities.model.AccountWideData;
import com.flippingutilities.model.BackupCheckpoints;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHandler {
    private static final Logger log = LoggerFactory.getLogger(DataHandler.class);
    FlippingPlugin plugin;
    private AccountWideData accountWideData;
    private BackupCheckpoints backupCheckpoints;
    private Map<String, AccountData> accountSpecificData = new HashMap<String, AccountData>();
    private boolean accountWideDataChanged = false;
    private Set<String> accountsWithUnsavedChanges = new HashSet<String>();
    public String thisClientLastStored;

    public DataHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public AccountWideData viewAccountWideData() {
        return this.accountWideData;
    }

    public AccountWideData getAccountWideData() {
        this.accountWideDataChanged = true;
        return this.accountWideData;
    }

    public void addAccount(String displayName) {
        log.info("adding {} to data handler", (Object)displayName);
        AccountData accountData = new AccountData();
        accountData.prepareForUse(this.plugin);
        this.accountSpecificData.put(displayName, accountData);
    }

    public void deleteAccount(String displayName) {
        log.info("deleting account: {}", (Object)displayName);
        this.accountSpecificData.remove(displayName);
        TradePersister.deleteFile(displayName + ".json");
    }

    public Collection<AccountData> getAllAccountData() {
        this.accountsWithUnsavedChanges.addAll(this.accountSpecificData.keySet());
        return this.accountSpecificData.values();
    }

    public Collection<AccountData> viewAllAccountData() {
        return this.accountSpecificData.values();
    }

    public AccountData getAccountData(String displayName) {
        this.accountsWithUnsavedChanges.add(displayName);
        return this.accountSpecificData.get(displayName);
    }

    public AccountData viewAccountData(String displayName) {
        return this.accountSpecificData.get(displayName);
    }

    public Set<String> getCurrentAccounts() {
        return this.accountSpecificData.keySet();
    }

    public void markDataAsHavingChanged(String displayName) {
        if (displayName.equals("Accountwide")) {
            this.accountWideDataChanged = true;
        } else {
            this.accountsWithUnsavedChanges.add(displayName);
        }
    }

    public void storeData() {
        log.info("storing data");
        if (this.accountsWithUnsavedChanges.size() > 0) {
            log.info("accounts with unsaved changes are {}. Saving them.", this.accountsWithUnsavedChanges);
            this.accountsWithUnsavedChanges.forEach(accountName -> this.storeAccountData((String)accountName));
            this.accountsWithUnsavedChanges.clear();
        }
        if (this.accountWideDataChanged) {
            log.info("accountwide data changed, saving it.");
            this.storeData("accountwide", this.accountWideData);
            this.accountWideDataChanged = false;
        }
    }

    public void loadData() {
        log.info("Loading data on startup");
        try {
            TradePersister.setupFlippingFolder();
        }
        catch (Exception e) {
            log.warn("Couldn't set up flipping folder, setting defaults", (Throwable)e);
            this.accountWideData = new AccountWideData();
            this.accountWideData.setDefaults();
            this.accountSpecificData = new HashMap<String, AccountData>();
            this.accountWideDataChanged = true;
            return;
        }
        this.backupCheckpoints = this.plugin.tradePersister.fetchBackupCheckpoints();
        this.accountWideData = this.fetchAccountWideData();
        this.accountSpecificData = this.fetchAndPrepareAllAccountData();
        this.backupAllAccountData();
    }

    private void backupAllAccountData() {
        log.info("backing up account data");
        boolean backupCheckpointsChanged = false;
        for (String displayName : this.accountSpecificData.keySet()) {
            AccountData accountData = this.accountSpecificData.get(displayName);
            if (!accountData.getTrades().isEmpty() && this.backupCheckpoints.shouldBackup(displayName, accountData.getLastStoredAt())) {
                try {
                    this.plugin.tradePersister.writeToFile(displayName + ".backup", accountData);
                    this.backupCheckpoints.getAccountToBackupTime().put(displayName, accountData.getLastStoredAt());
                    backupCheckpointsChanged = true;
                }
                catch (Exception e) {
                    log.warn("Couldn't backup account data for {} due to {}", (Object)displayName, (Object)e);
                }
                continue;
            }
            log.info("Not backing up data for {} as it's empty or it hasn't changed since last backup", (Object)displayName);
        }
        if (backupCheckpointsChanged) {
            this.storeData("backupCheckpoints.special", this.backupCheckpoints);
        }
    }

    private AccountWideData fetchAccountWideData() {
        try {
            boolean didActuallySetDefaults;
            log.info("Fetching accountwide data");
            AccountWideData accountWideData = this.plugin.tradePersister.loadAccountWideData();
            this.accountWideDataChanged = didActuallySetDefaults = accountWideData.setDefaults();
            return accountWideData;
        }
        catch (Exception e) {
            log.warn("couldn't load accountwide data, setting defaults", (Throwable)e);
            AccountWideData accountWideData = new AccountWideData();
            accountWideData.setDefaults();
            this.accountWideDataChanged = true;
            return accountWideData;
        }
    }

    private Map<String, AccountData> fetchAndPrepareAllAccountData() {
        Map<String, AccountData> accounts = this.fetchAllAccountData();
        this.prepareAllAccountData(accounts);
        return accounts;
    }

    private void prepareAllAccountData(Map<String, AccountData> allAccountData) {
        for (String displayName : allAccountData.keySet()) {
            AccountData accountData = allAccountData.get(displayName);
            try {
                accountData.startNewSession();
                accountData.prepareForUse(this.plugin);
            }
            catch (Exception e) {
                log.warn("Couldn't prepare account data for {} due to {}, setting default", (Object)displayName, (Object)e);
                AccountData newAccountData = new AccountData();
                newAccountData.startNewSession();
                newAccountData.prepareForUse(this.plugin);
                allAccountData.put(displayName, newAccountData);
            }
        }
    }

    private Map<String, AccountData> fetchAllAccountData() {
        try {
            return this.plugin.tradePersister.loadAllAccounts();
        }
        catch (Exception e) {
            log.warn("error propagated from tradePersister.loadAllAccounts() when fetching all account data, returning empty hashmap", (Throwable)e);
            return new HashMap<String, AccountData>();
        }
    }

    public void loadAccountWideData() {
        this.accountWideData = this.fetchAccountWideData();
    }

    public void loadAccountData(String displayName) {
        log.info("loading data for {}", (Object)displayName);
        this.accountSpecificData.put(displayName, this.fetchAccountData(displayName));
    }

    private AccountData fetchAccountData(String displayName) {
        try {
            AccountData accountData = this.plugin.tradePersister.loadAccount(displayName);
            accountData.prepareForUse(this.plugin);
            return accountData;
        }
        catch (Exception e) {
            log.warn("couldn't load trades for {}, e = " + e, (Object)displayName);
            return new AccountData();
        }
    }

    private void storeAccountData(String displayName) {
        try {
            AccountData data = this.accountSpecificData.get(displayName);
            if (data == null) {
                log.info("for an unknown reason the data associated with {} has been set to null. Storingan empty AccountData object instead.", (Object)displayName);
                data = new AccountData();
            }
            this.thisClientLastStored = displayName;
            data.setLastStoredAt(Instant.now());
            this.plugin.tradePersister.writeToFile(displayName, data);
        }
        catch (Exception e) {
            log.info("couldn't store trades, error = " + e);
        }
    }

    private void storeData(String fileName, Object data) {
        try {
            this.plugin.tradePersister.writeToFile(fileName, data);
        }
        catch (Exception e) {
            log.info("couldn't store data to {} bc of {}", (Object)fileName, (Object)e);
        }
    }
}

