/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.ApiResponse;
import com.flippingutilities.controller.BadStatusCodeException;
import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.controller.NullDtoException;
import com.flippingutilities.controller.RequestFailureException;
import com.flippingutilities.controller.ResponseBodyReadingException;
import com.flippingutilities.utilities.AccountSlotsUpdate;
import com.flippingutilities.utilities.OsrsAccount;
import com.flippingutilities.utilities.TokenResponse;
import com.flippingutilities.utilities.User;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiRequestHandler.class);
    FlippingPlugin plugin;
    OkHttpClient httpClient;
    private static String BASE_API_URL = System.getenv("OSRS_CLOUD_API_BASE_URL") != null ? System.getenv("OSRS_CLOUD_API_BASE_URL") : "https://api.osrs.cloud/v1/";
    public static String SLOT_FETCH_URL = BASE_API_URL + "ge/slots";
    public static String SLOT_UPDATE_URL = BASE_API_URL + "ge/slots/update";
    public static String JWT_HEALTH_URL = BASE_API_URL + "auth/jwt/health";
    public static String JWT_REFRESH_URL = BASE_API_URL + "auth/refresh";
    public static String USER_URL = BASE_API_URL + "user/self";
    public static String ACCOUNT_URL = BASE_API_URL + "account/self";
    public static String ACCOUNT_REGISTRATION_URL = BASE_API_URL + "account/register";
    public static String TOKEN_URL = BASE_API_URL + "auth/token";

    public ApiRequestHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.httpClient = plugin.getHttpClient();
    }

    public CompletableFuture<User> getUser() {
        if (!this.plugin.getApiAuthHandler().isHasValidJWT()) {
            return null;
        }
        String jwt = this.plugin.getDataHandler().viewAccountWideData().getJwt();
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").header("Authorization", "bearer " + jwt).url(USER_URL).build();
        return this.getResponseFuture(request, new TypeToken<ApiResponse<User>>(){}).thenApply(r -> (User)r.data);
    }

    public CompletableFuture<List<OsrsAccount>> getUserAccounts() {
        if (!this.plugin.getApiAuthHandler().isHasValidJWT()) {
            return null;
        }
        String jwt = this.plugin.getDataHandler().viewAccountWideData().getJwt();
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").header("Authorization", "bearer " + jwt).url(ACCOUNT_URL).build();
        return this.getResponseFuture(request, new TypeToken<ApiResponse<List<OsrsAccount>>>(){}).thenApply(r -> (List)r.data);
    }

    public CompletableFuture<OsrsAccount> registerNewAccount(String rsn) {
        if (!this.plugin.getApiAuthHandler().isHasValidJWT()) {
            return null;
        }
        String jwt = this.plugin.getDataHandler().viewAccountWideData().getJwt();
        HttpUrl url = HttpUrl.parse((String)ACCOUNT_REGISTRATION_URL).newBuilder().addQueryParameter("rsn", rsn).build();
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").header("Authorization", "bearer " + jwt).url(url).build();
        CompletableFuture<ApiResponse<OsrsAccount>> response = this.getResponseFuture(request, new TypeToken<ApiResponse<OsrsAccount>>(){});
        return response.thenApply(r -> (OsrsAccount)r.data);
    }

    public CompletableFuture<String> refreshJwt(String jwtString) {
        if (!this.plugin.getApiAuthHandler().isHasValidJWT()) {
            return null;
        }
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").header("Authorization", "bearer " + jwtString).url(JWT_REFRESH_URL).build();
        return this.getResponseFuture(request, new TypeToken<ApiResponse<TokenResponse>>(){}).thenApply(r -> ((TokenResponse)r.data).getAccess_token());
    }

    public CompletableFuture<Integer> updateGeSlots(AccountSlotsUpdate accountSlotsUpdate) {
        if (!this.plugin.getApiAuthHandler().isHasValidJWT()) {
            return null;
        }
        String jwt = this.plugin.getDataHandler().viewAccountWideData().getJwt();
        String json = this.plugin.gson.newBuilder().setDateFormat("YYYY-MM-dd'T'HH:mm:ss.sssZ").create().toJson((Object)accountSlotsUpdate);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").header("Authorization", "bearer " + jwt).post(body).url(SLOT_UPDATE_URL).build();
        return this.getResponseFuture(request, new TypeToken<ApiResponse<Integer>>(){}).thenApply(r -> (Integer)r.data);
    }

    public CompletableFuture<String> loginWithToken(String token) {
        String json = this.plugin.gson.toJson(Collections.singletonMap("token", token));
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().header("User-Agent", "FlippingUtilities").post(body).url(TOKEN_URL).build();
        return this.getResponseFuture(request, new TypeToken<ApiResponse<TokenResponse>>(){}).thenApply(r -> ((TokenResponse)r.data).getAccess_token());
    }

    public <T> CompletableFuture<ApiResponse<T>> getResponseFuture(final Request request, final TypeToken<ApiResponse<T>> type) {
        final CompletableFuture<ApiResponse<T>> future = new CompletableFuture<ApiResponse<T>>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new RequestFailureException(request, e));
            }

            public void onResponse(Call call, Response response) {
                if (!response.isSuccessful()) {
                    future.completeExceptionally(new BadStatusCodeException(request, response, ApiRequestHandler.getResponseBody(response)));
                } else {
                    try {
                        String body = response.body().string();
                        ApiResponse apiResponse = (ApiResponse)ApiRequestHandler.this.plugin.gson.fromJson(body, type.getType());
                        if (apiResponse == null) {
                            future.completeExceptionally(new NullDtoException(request, response, type.toString()));
                        } else if (apiResponse.errors.size() > 0) {
                            future.completeExceptionally(new BadStatusCodeException(request, response, body));
                        } else {
                            future.complete(apiResponse);
                        }
                        response.close();
                    }
                    catch (IOException e) {
                        future.completeExceptionally(new ResponseBodyReadingException(request, response, e));
                        response.close();
                    }
                }
            }
        });
        return future;
    }

    public static String getResponseBody(Response response) {
        try {
            return response.body().string();
        }
        catch (Exception e) {
            return "Could not fetch response body";
        }
    }
}

