/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.controller;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.utilities.Jwt;
import com.flippingutilities.utilities.OsrsAccount;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiAuthHandler.class);
    FlippingPlugin plugin;
    private boolean hasValidJWT;
    private Set<String> successfullyRegisteredRsns = new HashSet<String>();
    List<Runnable> validJwtSubscriberActions = new ArrayList<Runnable>();
    List<Consumer<Boolean>> premiumCheckSubscribers = new ArrayList<Consumer<Boolean>>();
    private boolean isPremium;

    public ApiAuthHandler(FlippingPlugin plugin) {
        this.plugin = plugin;
    }

    public void subscribeToLogin(Runnable r) {
        this.validJwtSubscriberActions.add(r);
    }

    public void subscribeToPremiumChecking(Consumer<Boolean> consumer) {
        this.premiumCheckSubscribers.add(consumer);
    }

    public boolean canCommunicateWithApi(String displayName) {
        return this.hasValidJWT && this.successfullyRegisteredRsns.contains(displayName);
    }

    public void setPremiumStatus() {
        if (!this.hasValidJWT) {
            return;
        }
        this.plugin.getApiRequestHandler().getUser().whenComplete((user, exception) -> {
            if (exception != null) {
                log.info("failed to get user, error: ", exception);
                this.isPremium = false;
            } else {
                log.info("got user, premium status: {}", (Object)user.isPremium());
                this.isPremium = user.isPremium();
            }
            this.premiumCheckSubscribers.forEach(c -> c.accept(this.isPremium));
        });
    }

    public CompletableFuture<String> checkExistingJwt() {
        String jwtString = this.plugin.getDataHandler().getAccountWideData().getJwt();
        if (jwtString == null) {
            log.info("no jwt stored locally, not attempting to check existing jwt");
            return CompletableFuture.completedFuture("no jwt");
        }
        try {
            Jwt jwt = Jwt.fromString(jwtString, this.plugin.gson);
            if (jwt.isExpired()) {
                log.info("jwt is expired, prompting user to re log");
                this.hasValidJWT = false;
                return CompletableFuture.completedFuture("expired");
            }
            if (jwt.shouldRefresh()) {
                return this.refreshJwt(jwtString);
            }
            log.info("jwt is valid");
            this.hasValidJWT = true;
            this.validJwtSubscriberActions.forEach(Runnable::run);
            return CompletableFuture.completedFuture("valid jwt");
        }
        catch (Exception e) {
            log.info("failed to check existing jwt, error: ", (Throwable)e);
            return CompletableFuture.completedFuture("error");
        }
    }

    private CompletableFuture<String> refreshJwt(String jwtString) {
        log.info("refresh jwt");
        this.hasValidJWT = true;
        CompletableFuture<String> newJwtFuture = this.plugin.getApiRequestHandler().refreshJwt(jwtString);
        return newJwtFuture.whenComplete((newJwt, exception) -> {
            if (exception != null) {
                log.info("failed to refresh jwt, error: ", exception);
                this.hasValidJWT = false;
            } else {
                this.plugin.getDataHandler().getAccountWideData().setJwt((String)newJwt);
                this.hasValidJWT = true;
                log.info("successfully refreshed jwt");
                this.validJwtSubscriberActions.forEach(Runnable::run);
            }
        });
    }

    public CompletableFuture<Set<String>> checkRsn(String displayName) {
        if (!this.hasValidJWT) {
            log.debug("not checking rsn as we don't have a valid jwt yet");
            return CompletableFuture.completedFuture(this.successfullyRegisteredRsns);
        }
        CompletableFuture<List<OsrsAccount>> userAccountsFuture = this.plugin.getApiRequestHandler().getUserAccounts();
        return ((CompletableFuture)userAccountsFuture.thenCompose(accs -> {
            Set registeredRsns = accs.stream().map(OsrsAccount::getRsn).collect(Collectors.toSet());
            if (registeredRsns.contains(displayName)) {
                this.successfullyRegisteredRsns.add(displayName);
                log.debug("rsn: {} is already registered, not registering again", (Object)displayName);
                return CompletableFuture.completedFuture(this.successfullyRegisteredRsns);
            }
            return ((CompletableFuture)this.plugin.getApiRequestHandler().registerNewAccount(displayName).thenApply(acc -> {
                this.successfullyRegisteredRsns.add(acc.getRsn());
                log.debug("added rsn: {} to successfullyRegisteredRsns", (Object)acc.getRsn());
                return this.successfullyRegisteredRsns;
            })).exceptionally(e -> {
                log.debug("could not register display name: {}, error: {}", (Object)displayName, e);
                return this.successfullyRegisteredRsns;
            });
        })).exceptionally(e -> {
            log.debug("could not check rsn", e);
            return this.successfullyRegisteredRsns;
        });
    }

    public CompletableFuture<String> loginWithToken(String token) {
        log.info("attempting to login with token!");
        CompletableFuture<String> jwtFuture = this.plugin.getApiRequestHandler().loginWithToken(token);
        jwtFuture.whenComplete((jwt, exception) -> {
            if (exception != null) {
                log.info("failed to login with token!", exception);
            } else {
                this.plugin.getDataHandler().getAccountWideData().setJwt((String)jwt);
                this.hasValidJWT = true;
                this.validJwtSubscriberActions.forEach(Runnable::run);
                log.info("successfully logged in with token!");
                if (this.plugin.getCurrentlyLoggedInAccount() != null) {
                    this.checkRsn(this.plugin.getCurrentlyLoggedInAccount());
                }
                this.setPremiumStatus();
            }
        });
        return jwtFuture;
    }

    public boolean isHasValidJWT() {
        return this.hasValidJWT;
    }

    public void setHasValidJWT(boolean hasValidJWT) {
        this.hasValidJWT = hasValidJWT;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public void setPremium(boolean isPremium) {
        this.isPremium = isPremium;
    }
}

